/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.stoichiometry;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SFNumber {
    private boolean isDecimal;
    private boolean hasExponent;
    private String decimalPart;
    private String exponentPart;
    private int sigFigs;
    private boolean exactNumber = false;

    public SFNumber(String input) {
        if (!SFNumber.checkInput(input)) {
            throw new NumberFormatException("Invalid input: " + input);
        }
        this.isDecimal = input.indexOf(".") > -1;
        input = input.toUpperCase();
        this.hasExponent = input.indexOf("E") > -1;
        this.storeNumber(input, this.hasExponent);
        this.sigFigs = this.length();
    }

    public SFNumber(String decPart, String expPart) {
        if (!SFNumber.checkInput(decPart + expPart)) {
            throw new NumberFormatException("Invalid input: " + decPart + "E" + expPart);
        }
        this.isDecimal = decPart.indexOf(".") > -1;
        this.hasExponent = expPart != null && !expPart.equals("0");
        this.decimalPart = decPart;
        this.exponentPart = expPart;
        this.convertToScientificNotation();
        this.sigFigs = this.length();
    }

    public SFNumber(String input, boolean bExact) {
        this(input);
        this.exactNumber = bExact;
    }

    public SFNumber(int number, boolean bExact) {
        this(String.valueOf(number));
        this.exactNumber = bExact;
    }

    public SFNumber(String decPart, String expPart, boolean bExact) {
        this(decPart, expPart);
        this.exactNumber = bExact;
    }

    public static boolean checkInput(String input) {
        if (input.charAt(0) == '0' && input.charAt(1) != '.') {
            return false;
        }
        String regX = "[^0-9+eE.-]";
        Pattern p = Pattern.compile(regX);
        Matcher m = p.matcher(input);
        return !m.find();
    }

    public void storeNumber(String input, boolean hasExp) {
        if (hasExp) {
            int expIndex = input.indexOf("E");
            this.decimalPart = input.substring(0, expIndex);
            this.exponentPart = input.substring(expIndex + 1);
        } else {
            this.decimalPart = input;
            this.exponentPart = "0";
        }
        this.convertToScientificNotation();
    }

    public void convertToScientificNotation() {
        int goalIndex = -1;
        int decIndex = -1;
        int exponentIncrement = 0;
        StringBuffer buffer = new StringBuffer(this.decimalPart);
        if (this.length() == 1) {
            return;
        }
        if (this.isDecimal) {
            decIndex = buffer.indexOf(".");
            if (decIndex == 1 && buffer.charAt(0) != '0') {
                return;
            }
            if (decIndex == 1) {
                for (int i = decIndex + 1; i < buffer.length(); ++i) {
                    --exponentIncrement;
                    if (buffer.charAt(i) == '0') continue;
                    goalIndex = i;
                    break;
                }
            } else if (decIndex > 1) {
                goalIndex = 1;
                exponentIncrement += decIndex - 1;
            }
        } else {
            int j;
            for (j = buffer.length() - 1; j > -1; --j) {
                ++exponentIncrement;
                if (buffer.charAt(j) != '0') {
                    goalIndex = j;
                    exponentIncrement += j - 1;
                    break;
                }
                buffer.deleteCharAt(j);
            }
            j = buffer.length() - 1;
            while (j > 0) {
                goalIndex = j--;
            }
        }
        if (this.isDecimal) {
            buffer.deleteCharAt(decIndex);
            this.isDecimal = false;
        }
        if (buffer.length() != 1) {
            try {
                if (goalIndex != buffer.length()) {
                    buffer.insert(goalIndex, ".");
                    this.isDecimal = true;
                }
                buffer.delete(0, buffer.indexOf(".") - 1);
            }
            catch (StringIndexOutOfBoundsException e) {
                buffer.delete(0, buffer.length() - 1);
            }
        }
        this.decimalPart = buffer.toString();
        int exponentValue = Double.valueOf(this.exponentPart).intValue();
        this.exponentPart = String.valueOf(exponentValue += exponentIncrement);
        this.hasExponent = exponentValue != 0;
    }

    public SFNumber round(int desiredSigFigs) {
        int nextDigit;
        int numSigFigs = this.getSigFigs();
        if (numSigFigs <= desiredSigFigs) {
            this.sigFigs = desiredSigFigs;
            return this;
        }
        boolean foundFirstDigit = false;
        char[] chars = this.decimalPart.toCharArray();
        int precisionIndex = -1;
        ++numSigFigs;
        for (int i = chars.length - 1; i > -1; --i) {
            if (this.isDecimal && chars[i] != '.') {
                --numSigFigs;
            } else if (chars[i] != '.') {
                if (!foundFirstDigit && chars[i] != '0') {
                    --numSigFigs;
                    foundFirstDigit = true;
                } else if (foundFirstDigit) {
                    --numSigFigs;
                }
            }
            if (numSigFigs == desiredSigFigs) {
                precisionIndex = i;
                break;
            }
            if (numSigFigs != 0) continue;
            throw new NumberFormatException("Error rounding " + this);
        }
        int roundedDigit = Character.getNumericValue(chars[precisionIndex]);
        char nextChar = chars[precisionIndex + 1];
        if (nextChar == '.') {
            nextChar = chars[precisionIndex + 2];
        }
        if ((nextDigit = Character.getNumericValue(nextChar)) > 5) {
            ++roundedDigit;
        } else if (nextDigit == 5 && roundedDigit % 2 == 1) {
            ++roundedDigit;
        }
        chars[precisionIndex] = (char)(roundedDigit + 48);
        if (chars[precisionIndex] == '0' && chars[precisionIndex + 1] == '.') {
            ++precisionIndex;
        }
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < precisionIndex + 1; ++j) {
            sb.append(chars[j]);
        }
        if (!this.isDecimal || precisionIndex < this.decimalPart.indexOf(".")) {
            for (int l = precisionIndex + 1; l < chars.length && chars[l] != '.'; ++l) {
                sb.append(0);
            }
        }
        return new SFNumber(sb.toString(), this.exponentPart);
    }

    public SFNumber multiplyBy(SFNumber multiplier, boolean bExact) {
        int numSF = 0;
        if (!bExact) {
            int sfMult = multiplier.getSigFigs();
            int thisSF = this.getSigFigs();
            numSF = Math.min(sfMult, thisSF);
        }
        Double thisDecPart = new Double(this.decimalPart);
        Double multDecPart = new Double(multiplier.getDecimalPart());
        double decProd = thisDecPart * multDecPart;
        Double thisExpPart = this.hasExponent ? new Double(this.exponentPart) : new Double(0.0);
        Double multExpPart = multiplier.getExponent() != null ? new Double(multiplier.getExponent()) : new Double(0.0);
        int sum2 = thisExpPart.intValue() + multExpPart.intValue();
        SFNumber product = new SFNumber(String.valueOf(decProd), String.valueOf(sum2));
        if (!bExact) {
            return product.round(numSF);
        }
        return product;
    }

    public SFNumber divideBy(SFNumber divisor, boolean bExact) {
        int numSF = 0;
        if (!bExact) {
            int sfDiv = divisor.getSigFigs();
            int thisSF = this.getSigFigs();
            numSF = Math.min(sfDiv, thisSF);
        }
        Double thisDecPart = new Double(this.decimalPart);
        Double divDecPart = new Double(divisor.getDecimalPart());
        double decResult = thisDecPart / divDecPart;
        Double thisExpPart = this.hasExponent ? new Double(this.exponentPart) : new Double(0.0);
        Double divExpPart = divisor.getExponent() != null ? new Double(divisor.getExponent()) : new Double(0.0);
        int sum2 = thisExpPart.intValue() - divExpPart.intValue();
        SFNumber result = new SFNumber(String.valueOf(decResult), String.valueOf(sum2));
        if (!bExact) {
            return result.round(numSF);
        }
        return result;
    }

    public int getSigFigs() {
        if (this.exactNumber) {
            return Integer.MAX_VALUE;
        }
        return this.sigFigs;
    }

    public String getDecimalPart() {
        return this.decimalPart;
    }

    public String getExponent() {
        return this.exponentPart;
    }

    public int length() {
        if (this.isDecimal) {
            return this.decimalPart.length() - 1;
        }
        return this.decimalPart.length();
    }

    public String toString() {
        if (this.hasExponent) {
            if (this.getSigFigs() == 1) {
                return Integer.valueOf(this.decimalPart) + "e" + Integer.valueOf(this.exponentPart);
            }
            return Double.valueOf(this.decimalPart) + "e" + Integer.valueOf(this.exponentPart);
        }
        return this.decimalPart;
    }
}

