/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;

public class ValidationLogAnalyzer {
    public final String CT_FILE_NAME = "contingency-table.txt";
    public final String SUCCESS = "SUCCESS";
    public final int TRUE_POSITIVE = 1;
    public final int TRUE_NEGATIVE = 2;
    public final int FALSE_POSITIVE = 3;
    public final int FALSE_NEGATIVE = 4;
    private String validationLogFileName;
    private int cutOff = 0;
    Vector ctList = new Vector();

    void addCT(ContingencyTable ct) {
        this.ctList.add(ct);
    }

    Vector getCT() {
        return this.ctList;
    }

    public ValidationLogAnalyzer(String[] args) {
        this.setValidationLogFileName(args[0]);
        if (args.length == 2) {
            this.setCutOff(Integer.parseInt(args[1]));
        }
    }

    public static void main(String[] args) {
        if (args.length < 1 || 2 < args.length) {
            System.out.println("Usage: ValidationLogAnalyzer <log_file> {<cut_off>}");
            System.out.println("<log_file> must be the validation log file generated by SimSt.");
            System.out.println("An optional <cut_off> specifies # of problems for pre-learning.");
        }
        ValidationLogAnalyzer validationLogAnalyzer = new ValidationLogAnalyzer(args);
        validationLogAnalyzer.runAnalysis();
    }

    void runAnalysis() {
        try {
            this.contingencyTableAnalysis(this.getCutOff());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void contingencyTableAnalysis(int cutOff) throws IOException {
        String previousCondition = null;
        ContingencyTable contingencyTable = null;
        BufferedReader in = this.openInputFile(this.getValidationLogFileName());
        String record = in.readLine();
        while ((record = in.readLine()) != null) {
            Validation validation = new Validation(record);
            if (validation.modelRule.indexOf("auto-") > 0) continue;
            if (!validation.condition.equals(previousCondition)) {
                contingencyTable = new ContingencyTable(validation.condition, cutOff);
                this.addCT(contingencyTable);
                previousCondition = validation.condition;
            }
            if (validation.numTraining + 1 <= cutOff) continue;
            contingencyTable.addTally(validation);
        }
        this.writeCTtoFile();
    }

    private void writeCTtoFile() throws IOException {
        for (int i = 0; i < this.getCT().size(); ++i) {
            ContingencyTable ct = (ContingencyTable)this.getCT().get(i);
            ct.writeToFile();
        }
    }

    BufferedReader openInputFile(String fileName) throws IOException {
        return new BufferedReader(new FileReader(fileName));
    }

    private int getCutOff() {
        return this.cutOff;
    }

    private void setCutOff(int cutOff) {
        this.cutOff = cutOff;
    }

    private String getValidationLogFileName() {
        return this.validationLogFileName;
    }

    private void setValidationLogFileName(String validationLogFileName) {
        this.validationLogFileName = validationLogFileName;
    }

    class Validation {
        int numTraining;
        String condition;
        String model;
        String actual;
        String modelRule;

        public Validation(String record) {
            String[] field = record.split("\t");
            this.numTraining = Integer.parseInt(field[2]);
            this.condition = field[1];
            this.model = field[12];
            this.actual = field[14];
            this.modelRule = field[9];
        }

        public int fitType() {
            int fitType = -1;
            fitType = this.actual.equals("SUCCESS") ? (this.model.equals("SUCCESS") ? 1 : 3) : (this.model.equals("SUCCESS") ? 4 : 2);
            return fitType;
        }

        public String toString() {
            return "<" + this.condition + " " + this.numTraining + " " + this.model + " " + this.actual + ">";
        }
    }

    class ContingencyTable {
        String condition;
        int cutOff;
        int numTruePositive = 0;
        int numTrueNegative = 0;
        int numFalsePositive = 0;
        int numFalseNegative = 0;

        private String getCondition() {
            return this.condition;
        }

        private void setCondition(String condition) {
            this.condition = condition;
        }

        private int getCutOff() {
            return this.cutOff;
        }

        private void setCutOff(int cutOff) {
            this.cutOff = cutOff;
        }

        public ContingencyTable(String condition, int cutOff) {
            this.setCondition(condition);
            this.setCutOff(cutOff);
        }

        public void addTally(Validation validation) {
            switch (validation.fitType()) {
                case 1: {
                    ++this.numTruePositive;
                    break;
                }
                case 2: {
                    ++this.numTrueNegative;
                    break;
                }
                case 3: {
                    ++this.numFalsePositive;
                    break;
                }
                case 4: {
                    ++this.numFalseNegative;
                }
            }
        }

        int total() {
            return this.numTruePositive + this.numTrueNegative + this.numFalsePositive + this.numFalseNegative;
        }

        float accuracy() {
            int trueCount = this.numTruePositive + this.numTrueNegative;
            return (float)trueCount / (float)this.total();
        }

        float error() {
            int falseCount = this.numFalsePositive + this.numFalseNegative;
            return (float)falseCount / (float)this.total();
        }

        float precision() {
            return (float)this.numTruePositive / (float)(this.numTruePositive + this.numFalsePositive);
        }

        float recall() {
            return (float)this.numTruePositive / (float)(this.numTruePositive + this.numFalseNegative);
        }

        float F1() {
            float precision = this.precision();
            float recall = this.recall();
            return 2.0f * precision * recall / (precision + recall);
        }

        public void writeToFile() throws IOException {
            if (!new File("contingency-table.txt").exists()) {
                this.createNewContingencyAnalysisLog();
            }
            FileWriter fileWriter = new FileWriter("contingency-table.txt", true);
            BufferedWriter out = new BufferedWriter(fileWriter);
            String log = this.getCondition() + "\t" + this.getCutOff() + "\t";
            log = log + this.numTruePositive + "\t";
            log = log + this.numFalseNegative + "\t";
            log = log + this.numFalsePositive + "\t";
            log = log + this.numTrueNegative + "\t";
            log = log + this.accuracy() + "\t";
            log = log + this.error() + "\t";
            log = log + this.precision() + "\t";
            log = log + this.recall() + "\t";
            log = log + this.F1() + "\t";
            log = log + "\n";
            out.write(log);
            out.close();
            System.out.println("logged... " + log);
        }

        private void createNewContingencyAnalysisLog() throws IOException {
            FileWriter fileWriter = new FileWriter("contingency-table.txt");
            BufferedWriter out = new BufferedWriter(fileWriter);
            out.write("Condition\tCut-off\tTP\tFN\tFP\tTN\tAccuracy\tError\tPrecision\tRecall\tF1\n");
            out.close();
        }
    }
}

