/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.SocketProxy.SocketProxy;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class InquiryRaTutoringService {
    private static final String SELECTION = "Selection";
    private static final String VALUE = "value";
    private static final String ACTION = "Action";
    private static final String INPUT = "Input";
    private static final String MESSAGE_TYPE = "MessageType";
    private static final String INTERFACE_ACTION = "InterfaceAction";
    private static final String PROPERTIES = "properties";
    private static final String VERB = "verb";
    private static final String NOTE_PROPERTY_SET = "NotePropertySet";
    private static final String MESSAGE = "message";
    private static final String ASSOCIATED_RULES = "AssociatedRules";
    private static final String CORRECT_ACTION = "CorrectAction";
    private static final String START_STATE_END = "StartStateEnd";
    private static final String INDICATOR = "Indicator";
    private static final String CORRECT = "Correct";
    private static final String HIGHLIGHT = "HighlightMsg";
    private static final String[] legalTutorResponseList = new String[]{"CorrectAction", "InCorrectAction"};
    private int SERVER_PORT = 1502;
    private String SERVER_HOST = "localhost";
    private int COMM_PORT = 1503;
    private int POLICY_PORT = 1504;
    private Socket serverSocket = null;
    PrintWriter out = null;
    BufferedReader in = null;
    String msgInterfaceID = "<message><verb>NotePropertySet</verb><properties><MessageType>InterfaceIdentification</MessageType><Guid>0E33AF97-8289-A9D4-E14E-C56E57133286</Guid></properties></message>";
    String msgProblemDescription = "<message><verb>NotePropertySet</verb><properties><MessageType>SetPreferences</MessageType><school_name>CMU</school_name><log_service_url>http://pslc-qa.andrew.cmu.edu/log/serverdd</log_service_url><problem_name>myGraphName</problem_name><session_id>mySessionID</session_id><user_guid>myUniqueUserIdentifier</user_guid><auth_token>myAuth_token</auth_token><source_id>PACT_CTAT_FLASH</source_id><question_file>PROBLEM_NAME</question_file><ProblemName>PROBLEM_NAME</ProblemName></properties></message>";
    String msgGoToState = "<message><verb>NotePropertySet</verb><properties><MessageType>GoToState</MessageType><StateName><value>STATE_NAME</value></StateName></properties></message>";

    private Socket getServerSocket() {
        return this.serverSocket;
    }

    private void setServerSocket(Socket socket) {
        this.serverSocket = socket;
    }

    public void init(String problemName) {
        this.initServerSocket();
        this.initIO();
        this.sendInterfaceIdentification();
        this.sendProblemDescription(problemName);
    }

    private void initServerSocket() {
        Socket socket = null;
        try {
            socket = new Socket(this.SERVER_HOST, this.SERVER_PORT);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setServerSocket(socket);
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "InquiryRaTutoringService: initServerSocket() done...");
        }
    }

    private void initIO() {
        try {
            this.out = new PrintWriter(this.getServerSocket().getOutputStream(), true);
            this.in = new BufferedReader(new InputStreamReader(this.getServerSocket().getInputStream()));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void shutdown() {
        try {
            this.in.close();
            this.out.close();
            this.getServerSocket().close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendMsgToTutoringService(String msg) {
        if (msg.charAt(msg.length() - 1) != '\u0000') {
            msg = msg + "\u0000";
        }
        this.out.println(msg.toString());
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "sendMsgToTutoringService sent -> " + msg);
        }
    }

    private String readMsgFromTutoringService() {
        String msg = null;
        try {
            msg = SocketProxy.readToEom(this.in, 0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return msg;
    }

    private void waitMsgTypeFromTutoringService(String targetType) {
        String msg = this.readMsgFromTutoringService();
        while (!this.isMessageType(msg, targetType)) {
            msg = this.readMsgFromTutoringService();
        }
    }

    private void sendInterfaceIdentification() {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "InquiryRaTutoringService: sending interface ID");
        }
        this.sendMsgToTutoringService(this.msgInterfaceID);
    }

    private void sendProblemDescription(String problemName) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "InquiryRaTutoringService: sending problem description for " + problemName);
        }
        this.sendMsgToTutoringService(this.msgProblemDescription.replaceAll("PROBLEM_NAME", problemName));
        System.out.println("passed sendMsgToTutoringService");
        this.waitMsgTypeFromTutoringService(START_STATE_END);
        System.out.println("finished sendProblemDescription");
    }

    public void sendGoToStateMsg(String stateName) {
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "sendGoToStateMsg(" + stateName + ")");
        }
        this.sendMsgToTutoringService(this.msgGoToState.replaceAll("STATE_NAME", stateName));
    }

    private String getMessageElement(String msg, String name) {
        return msg.split("<" + name + ">")[1].split("</" + name + ">")[0];
    }

    private String getMessageType(String msg) {
        return this.getMessageElement(msg, MESSAGE_TYPE);
    }

    private boolean isMessageType(String msg, String type) {
        return this.getMessageType(msg).equals(type);
    }

    public boolean testSAI(String selection, String action, String input) {
        System.out.println("entered testSAI");
        boolean testSAI = false;
        this.sendInterfaceAction(selection, action, input);
        System.out.println("passed sendInterfaceAction");
        String tutorResponse = this.getTutorAckOnCorrectness();
        System.out.println("passed tutorResponse");
        if (tutorResponse.equals(CORRECT)) {
            testSAI = true;
        }
        if (trace.getDebugCode("miss")) {
            trace.out("miss", "testSAI(" + selection + ", " + action + ", " + input + ") = " + testSAI);
        }
        return testSAI;
    }

    private void sendInterfaceAction(String selection, String action, String input) {
        String xmlMsg = this.generateXmlForSAI(selection, action, input);
        this.sendMsgToTutoringService(xmlMsg);
    }

    private String generateXmlForSAI(String selection, String action, String input) {
        Element selectionElement = new Element(SELECTION);
        selectionElement.addContent((Content)new Element(VALUE).setText(selection));
        Element actionElement = new Element(ACTION);
        actionElement.addContent((Content)new Element(VALUE).setText(action));
        Element inputElement = new Element(INPUT);
        inputElement.addContent((Content)new Element(VALUE).setText(input));
        Element messageTypeElement = new Element(MESSAGE_TYPE);
        messageTypeElement.setText(INTERFACE_ACTION);
        Element propertiesElement = new Element(PROPERTIES);
        propertiesElement.addContent((Content)messageTypeElement);
        propertiesElement.addContent((Content)selectionElement);
        propertiesElement.addContent((Content)actionElement);
        propertiesElement.addContent((Content)inputElement);
        Element verbElement = new Element(VERB);
        verbElement.setText(NOTE_PROPERTY_SET);
        Element rootElement = new Element(MESSAGE);
        rootElement.addContent((Content)verbElement);
        rootElement.addContent((Content)propertiesElement);
        XMLOutputter output = new XMLOutputter();
        return output.outputString(rootElement);
    }

    private String getTutorAckOnCorrectness() {
        String tutorAckOnCorrectness = null;
        boolean tutorResponseRead = false;
        boolean associatedRulesRead = false;
        while (!tutorResponseRead || !associatedRulesRead) {
            String msg = this.readMsgFromTutoringService();
            if (this.isMessageType(msg, ASSOCIATED_RULES)) {
                associatedRulesRead = true;
                tutorAckOnCorrectness = this.getMessageElement(msg, INDICATOR);
                continue;
            }
            if (this.isMessageType(msg, HIGHLIGHT)) continue;
            if (this.isLegalTutorResponse(this.getMessageType(msg))) {
                tutorResponseRead = true;
                continue;
            }
            System.out.println("getMessageType(msg) = " + this.getMessageType(msg));
            new Exception("Unknown tutor responce: " + msg).printStackTrace();
        }
        return tutorAckOnCorrectness;
    }

    private boolean isLegalTutorResponse(String messageType) {
        boolean legalTutorResponse = false;
        for (int i = 0; i < legalTutorResponseList.length; ++i) {
            if (!legalTutorResponseList[i].equals(messageType)) continue;
            legalTutorResponse = true;
            break;
        }
        return legalTutorResponse;
    }

    private void testTutoringService() {
        this.init("ChemPT_1T_01_IU.brd");
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        boolean step1 = this.testSAI("Term0Definition", "UpdateComboBox", "Given Value");
        System.out.println("step1 = " + step1);
        while (true) {
            // Infinite loop
        }
    }

    public static void main(String[] args) {
        trace.addDebugCode("testTS");
        trace.addDebugCode("sp");
        trace.addDebugCode("miss");
        InquiryRaTutoringService ira = new InquiryRaTutoringService();
        ira.testTutoringService();
        System.exit(1);
    }

    class CommChannel
    extends Thread {
        BufferedReader in;
        PrintWriter out;

        public CommChannel(BufferedReader in, PrintWriter out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            System.out.println("waiting msg from the server...");
            while (true) {
                try {
                    while (true) {
                        String msgFromServer = SocketProxy.readToEom(this.in, 0);
                        System.out.println("MSG -> " + msgFromServer);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

