/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintPanel;
import edu.cmu.pact.CommManager.RemoteCommMessageHandler;
import edu.cmu.pact.Log.Transaction;
import edu.cmu.pact.SocketProxy.MsgSource;
import edu.cmu.pact.Utilities.Logger;
import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class HintPanelProxy {
    private static final DateFormat dateWithDashes = new SimpleDateFormat("yyyy-MM-dd");
    private static final String FLASH_LOG = "/afs/cs.cmu.edu/project/iwt/Trunk/AuthoringTools/java/tmp/sewall_20071116114341975.xml";
    private Thread listener = null;
    private boolean stopping = false;
    private String host = "localhost";
    private int listenerPort = 1501;
    private int clientPort = 1500;
    private boolean oneAtATime = false;
    private String inputFile = null;
    private int msgFormat = 0;
    private int eom = -1;
    private boolean oneMsgPerSocket = true;
    private boolean convertLog = false;
    private boolean showFrame = false;
    private Socket outSock = null;
    private Socket inSock = null;
    private PrintWriter outStream = null;
    private BufferedReader inStream = null;
    private String userId = "";
    private String sessionId = "";
    private String dateTime = "1970/01/01 00:00:00";
    private String timeZone = "UTC";
    private boolean waitForResponse = false;
    private Transaction.TransactionSet transactionSet = new Transaction.TransactionSet();
    private static int nSenders = 0;
    private Method m;
    private HintPanel hp;
    private RemoteCommMessageHandler handler;
    public static final String usageMsg = "Usage:\n  HintPanelProxy [-c clientPort] [-d] [-e eom] [-L listenerPort] [-h host] \\\n    [-o] [-w] [-b] [-m] [-x|-X|-F] [-t testName] [inputFile]\nwhere--\n  clientPort is the port number to which to send to; default\n    1500;\n  -d means turn on debugging;\n  eom is an end-of-message character, expressed as a hex integer;\n  host  DNS hostname where server is listening; default localhost;\n  -o means prompt before sending each msg;\n  -w means wait for tutor's response before sending next msg;\n  listenerPort is the port number on which to listen; default\n    1501;\n  inputFile is a file of messages (1 per line) to send to the\n    clientPort;\n  -x means to expect a log file in OLI XML (DataShop DTD) format;\n  -X means to expect messages in OLI XML format;\n  -F means to expect messages in XML-ized Comm format;\n  testName is one of {readMsgFileTest, sendToolMessages}.\n";

    synchronized void stopListener() {
        this.stopping = true;
        this.listener.interrupt();
    }

    private synchronized boolean isStopping() {
        return this.stopping;
    }

    public HintPanelProxy() {
        this(null, 1000);
    }

    public void setHintPanel(HintPanel panel) {
        this.hp = panel;
    }

    public void setHandler(RemoteCommMessageHandler h) {
        this.handler = h;
    }

    public HintPanelProxy(String arg, int listenerPort) {
        try {
            this.m = this.getClass().getMethod(arg, new Class[0]);
        }
        catch (Exception e) {
            try {
                this.m = this.getClass().getMethod("readMsgFileTest", new Class[0]);
            }
            catch (Exception e2) {
                this.m = null;
            }
        }
    }

    public void run() {
        try {
            this.m.invoke((Object)this, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Element getToolMessageElement(Element elt) {
        if ("log_session_start".equals(elt.getName())) {
            this.setUserId(elt.getAttributeValue("user_guid"));
            return null;
        }
        if ("tutor_related_message_sequence".equals(elt.getName())) {
            return elt;
        }
        if ("tool_message".equals(elt.getName())) {
            return elt;
        }
        if (!"log_action".equals(elt.getName())) {
            return null;
        }
        this.setUserId(elt.getAttributeValue("user_guid"));
        this.setSessionId(elt.getAttributeValue("sess_ref"));
        this.setDateTime(elt.getAttributeValue("date_time"));
        this.setTimeZone(elt.getAttributeValue("timezone"));
        String actionId = elt.getAttributeValue("action_id");
        if (!"tool_message".equals(actionId)) {
            return null;
        }
        Element child = elt.getChild("tutor_related_message_sequence");
        if (child == null) {
            return null;
        }
        if (child.getChild("tool_message") == null) {
            trace.err("Log entry inconsistent: action_id is tool_message, but no tool_message element in content");
            return null;
        }
        return child;
    }

    public String getUserId() {
        return this.userId;
    }

    private void setUserId(String attributeValue) {
        if (attributeValue == null || attributeValue.length() < 1) {
            return;
        }
        this.userId = attributeValue;
    }

    public void readMsgFileTest() {
        if (this.inputFile == null) {
            return;
        }
        MsgSource msgSrc = null;
        try {
            FileReader reader = new FileReader(this.inputFile);
            final BufferedReader bRdr = new BufferedReader(reader);
            msgSrc = this.msgFormat == 2 || this.msgFormat == 1 ? new MsgSource(){

                @Override
                public String next() {
                    try {
                        String line;
                        if (HintPanelProxy.this.handler.hasMessage()) {
                            return HintPanelProxy.this.handler.nextMessage();
                        }
                        StringBuffer result = new StringBuffer(4096);
                        while (null != (line = bRdr.readLine())) {
                            if (line.trim().length() < 1) {
                                if (result.length() <= 0) continue;
                                return result.toString();
                            }
                            result.append(line);
                            result.append('\n');
                        }
                        if (result.length() > 0) {
                            return result.toString();
                        }
                        return null;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        return null;
                    }
                }
            } : new MsgSource(){

                @Override
                public String next() {
                    try {
                        if (HintPanelProxy.this.handler.hasMessage()) {
                            return HintPanelProxy.this.handler.nextMessage();
                        }
                        return bRdr.readLine();
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        return null;
                    }
                }
            };
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Error opening msg file " + this.inputFile + ": " + e);
        }
        this.runClient(this.host, this.clientPort, msgSrc, this.oneAtATime);
    }

    private static void createAndShowGUI(HintPanel hp) {
        JFrame frame = new JFrame("FrameDemo");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add((Component)hp, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        int i;
        String testName = "readMsgFileTest";
        boolean debugOn = false;
        boolean waitForResponse = false;
        boolean showFrame = false;
        boolean oneAtATime = false;
        String host = "localhost";
        int eom = -1;
        int listenerPort = 1501;
        int clientPort = 1500;
        boolean convertLog = false;
        int msgFormat = 0;
        String inputFile = null;
        block21: for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            char opt = args[i].charAt(1);
            switch (opt) {
                case 'w': {
                    waitForResponse = true;
                    continue block21;
                }
                case 'f': {
                    showFrame = true;
                    continue block21;
                }
                case 'd': {
                    debugOn = true;
                    continue block21;
                }
                case 'o': {
                    oneAtATime = true;
                    continue block21;
                }
                case 'e': {
                    try {
                        if (args.length < ++i) {
                            throw new Exception("Missing end-of-message argument");
                        }
                        eom = Integer.parseInt(args[i], 16);
                    }
                    catch (Exception e) {
                        System.err.println("Bad argument after -" + opt + ": " + e + ". " + usageMsg);
                        System.exit(1);
                    }
                    continue block21;
                }
                case 'h': {
                    try {
                        if (args.length < ++i) {
                            throw new Exception("Missing host argument");
                        }
                        host = args[i];
                    }
                    catch (Exception e) {
                        System.err.println("Bad argument after -" + opt + ": " + e + ". " + usageMsg);
                        System.exit(1);
                    }
                    continue block21;
                }
                case 'L': 
                case 'c': 
                case 'l': {
                    try {
                        if (args.length < ++i) {
                            throw new Exception("Missing port number");
                        }
                        if (opt == 'c') {
                            clientPort = Integer.parseInt(args[i]);
                            continue block21;
                        }
                        listenerPort = Integer.parseInt(args[i]);
                    }
                    catch (Exception e) {
                        System.err.println("Bad argument after -" + opt + ": " + e + ". " + usageMsg);
                        System.exit(1);
                    }
                    continue block21;
                }
                case 'x': {
                    convertLog = true;
                    msgFormat = 2;
                    continue block21;
                }
                case 'X': {
                    msgFormat = 2;
                    continue block21;
                }
                case 'F': {
                    msgFormat = 1;
                    continue block21;
                }
                case 't': {
                    try {
                        if (args.length < ++i) {
                            throw new Exception("Missing test name");
                        }
                        testName = args[i];
                    }
                    catch (Exception e) {
                        System.err.println("Bad argument after -" + opt + ": " + e + ". " + usageMsg);
                        System.exit(1);
                    }
                    continue block21;
                }
                default: {
                    System.err.println("Undefined command-line option " + opt + ". " + usageMsg);
                    System.exit(1);
                }
            }
        }
        nSenders = args.length - i;
        while (i < args.length) {
            inputFile = args[i];
            if (debugOn) {
                trace.addDebugCode("sp");
            }
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "command-line args: listenerPort " + listenerPort + ", clientPort " + clientPort + ", inputFile " + inputFile);
            }
            final HintPanelProxy tst = new HintPanelProxy(testName, listenerPort);
            tst.waitForResponse = waitForResponse;
            tst.showFrame = showFrame;
            tst.oneAtATime = oneAtATime;
            tst.eom = eom;
            tst.host = host;
            tst.clientPort = clientPort;
            tst.convertLog = convertLog;
            tst.msgFormat = msgFormat;
            tst.inputFile = inputFile;
            RemoteCommMessageHandler handler = new RemoteCommMessageHandler();
            final HintPanel hp = new HintPanel(handler);
            tst.setHintPanel(hp);
            tst.setHandler(handler);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HintPanelProxy.createAndShowGUI(hp);
                }
            });
            if (nSenders < 2) {
                tst.run();
            } else {
                Thread sender = new Thread(){

                    @Override
                    public void run() {
                        tst.run();
                    }
                };
                sender.start();
            }
            ++i;
        }
    }

    private void runClient(String host, int clientPort, MsgSource msgSrc, boolean oneAtATime) {
        try {
            String msg;
            BufferedReader promptRdr = new BufferedReader(new InputStreamReader(System.in));
            if (nSenders < 2) {
                System.out.println("\nStart HintPanelProxy, open interface and graph in the Behavior Recorder,\nand then press Enter here to start sending.\n");
                promptRdr.readLine();
            }
            while (null != (msg = msgSrc.next())) {
                if (msg.trim().length() < 1) continue;
                if (msg.trim().charAt(0) == '#') {
                    System.out.println("\nComment: " + msg + "\n");
                    continue;
                }
                if (trace.getDebugCode("sp")) {
                    trace.out("sp", "runClient waitForResponse " + this.waitForResponse + ", to send:\n" + msg);
                }
                if (this.waitForResponse) {
                    this.sendAndWaitForTutorResponse(host, clientPort, msg);
                } else {
                    this.sendString(host, clientPort, msg);
                }
                if (!oneAtATime) continue;
                System.out.println("\n___press Enter to send next msg");
                promptRdr.readLine();
            }
            if (nSenders < 2) {
                do {
                    System.out.print("\n___enter 'q' to stop listener: ");
                } while (!promptRdr.readLine().toLowerCase().startsWith("q"));
            }
            this.resetOutputStream(true);
            this.stopListener();
        }
        catch (IOException ioe) {
            System.err.println("error on prompt reader");
            ioe.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAndWaitForTutorResponse(String host, int clientPort, String msg) {
        if (msg.contains("InterfaceIdentification")) {
            this.sendString(host, clientPort, msg);
            return;
        }
        Transaction tx = new Transaction(msg, false);
        this.transactionSet.add(tx);
        Transaction transaction = tx;
        synchronized (transaction) {
            this.sendString(host, clientPort, msg);
            while (!tx.isResponseComplete()) {
                try {
                    tx.wait();
                }
                catch (InterruptedException ie) {
                    trace.err("Exception during waitForTutorResponse(" + msg + "):\n " + ie + "; cause " + ie.getCause());
                }
            }
        }
    }

    private boolean responseReceived(String msg) {
        return false;
    }

    private void sendString(String host, int clientPort, String str) {
        block5: {
            try {
                PrintWriter out = this.getOutputStream(host, clientPort);
                if (trace.getDebugCode("sp")) {
                    trace.out("sp", "sendString() out=" + out + " str=\n " + str);
                }
                if (out == null) {
                    return;
                }
                out.println(str);
                if (this.eom >= 0) {
                    out.write(this.eom);
                }
                out.flush();
                this.resetOutputStream(false);
            }
            catch (Exception e) {
                if (!trace.getDebugCode("sp")) break block5;
                trace.out("sp", "SocketToolProxy failed to connect outgoing socket to Tutor Interface: " + e.toString());
            }
        }
    }

    private PrintWriter getOutputStream(String host, int clientPort) throws Exception {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "getOutputStream() outSock=" + this.outSock + " outStream=" + this.outStream);
        }
        if (this.outSock == null) {
            InetAddress addr = InetAddress.getLocalHost();
            if (host != null && host.length() > 0) {
                addr = InetAddress.getByName(host);
            }
            this.outSock = new Socket(addr, clientPort);
            this.outStream = null;
            this.inSock = this.outSock;
            this.listener = new SocketReader2();
            this.listener.start();
        }
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "getOutputStream() outSock=" + this.outSock + " outStream=" + this.outStream);
        }
        if (this.outStream == null) {
            this.outStream = new PrintWriter(this.outSock.getOutputStream(), false);
        }
        return this.outStream;
    }

    private void resetOutputStream(boolean closeUnconditionally) throws IOException {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "resetOutputStream() closeUnconditionally=" + closeUnconditionally);
        }
        if (!closeUnconditionally) {
            return;
        }
        if (closeUnconditionally) {
            this.stopListener();
        }
        if (this.outStream != null) {
            this.outStream.close();
        }
        this.outStream = null;
        if (this.inStream != null) {
            this.inStream.close();
            this.inStream = null;
        }
        this.outSock.close();
        this.outSock = null;
        this.inSock = null;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    private void setTimeZone(String attributeValue) {
        if (attributeValue == null || attributeValue.length() < 1) {
            return;
        }
        this.timeZone = attributeValue;
    }

    public String getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(String attributeValue) {
        if (attributeValue == null || attributeValue.length() < 1) {
            return;
        }
        this.dateTime = attributeValue;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String attributeValue) {
        if (attributeValue == null) {
            return;
        }
        this.sessionId = attributeValue;
    }

    class ToolMsgSource
    implements MsgSource {
        private final XMLOutputter xmlout = new XMLOutputter();
        private final List logEntries;

        ToolMsgSource(List logEntries) {
            this.logEntries = new ArrayList(logEntries);
        }

        @Override
        public String next() {
            while (!this.logEntries.isEmpty()) {
                Element elt = (Element)this.logEntries.remove(0);
                Element toolMsgElt = HintPanelProxy.this.getToolMessageElement(elt);
                if (toolMsgElt == null) continue;
                return this.xmlout.outputString(toolMsgElt);
            }
            return null;
        }
    }

    class SocketReader2
    extends Thread {
        SocketReader2() {
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(HintPanelProxy.this.inSock.getInputStream(), "UTF-8");
                HintPanelProxy.this.inStream = new BufferedReader(isr);
                if (trace.getDebugCode("sp")) {
                    trace.out("sp", "inSock=" + HintPanelProxy.this.inSock + " inStream=" + HintPanelProxy.this.inStream);
                }
                while (!HintPanelProxy.this.isStopping()) {
                    String msg;
                    String string = msg = HintPanelProxy.this.eom >= 0 ? SocketReader.readToEom(HintPanelProxy.this.inStream, HintPanelProxy.this.eom) : SocketReader.readAll(HintPanelProxy.this.inStream);
                    if (trace.getDebugCode("sp")) {
                        trace.out("sp", "\nHintPanelProxy.listener received:\n" + msg);
                    }
                    MessageObject mo = Logger.actionLogToMessageObject(msg, true);
                    if (trace.getDebugCode("sp")) {
                        trace.out("sp", "\n message object:\n" + (mo == null ? null : mo.toXML()));
                    }
                    HintPanelProxy.this.hp.handleMessageObject(mo);
                    if (msg.length() < 1) {
                        if (HintPanelProxy.this.transactionSet == null) break;
                        HintPanelProxy.this.transactionSet.cancelIncompleteTransactions();
                        break;
                    }
                    if (!HintPanelProxy.this.waitForResponse) continue;
                    HintPanelProxy.this.transactionSet.addResponse(msg);
                }
                if (HintPanelProxy.this.inStream != null) {
                    HintPanelProxy.this.inStream.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

