/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences;

import edu.cmu.pact.Log.LogDifferences.Content.ActionEvaluationContent;
import edu.cmu.pact.Log.LogDifferences.Content.Content;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import edu.cmu.pact.Log.LogDifferences.Content.CustomContent;
import edu.cmu.pact.Log.LogDifferences.Content.NameContent;
import edu.cmu.pact.Log.LogDifferences.Content.SAIContent;
import edu.cmu.pact.Log.LogDifferences.Content.SkillContent;
import edu.cmu.pact.Log.LogDifferences.Content.TutorAdviceContent;
import edu.cmu.pact.Log.LogDifferences.Contents;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.ActionEvaluationElement;
import edu.cmu.pslc.logging.element.CustomFieldElement;
import edu.cmu.pslc.logging.element.EventDescriptorElement;
import edu.cmu.pslc.logging.element.SkillElement;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class TutorMessageContents
implements Iterable<ContentCell>,
Contents {
    private final NameContent name;
    private final SAIContent sai;
    private final ActionEvaluationContent actionEval;
    private final List<TutorAdviceContent> tutorAdvices;
    private final List<SkillContent> skills;
    private final List<CustomContent> customs;
    private final String transactionId;

    public TutorMessageContents(TutorActionLogV4 actionLog) {
        TutorMessage logMsg = (TutorMessage)actionLog.getMsg();
        this.transactionId = this.getMessageTransactionId(actionLog);
        this.name = this.getMessageName(logMsg.getProblemName());
        this.sai = this.getMessageSAI(logMsg.getEventDescriptorElement());
        this.actionEval = this.getMessageActionEvaluation(logMsg.getActionEvaluationElement());
        this.tutorAdvices = this.getMessageTutorAdviceList(logMsg.getTutorAdviceList());
        this.skills = this.getMessageSkillList(logMsg.getSkillList());
        this.customs = this.getMessageCustomList(logMsg.getCustomFieldList());
    }

    protected String getMessageTransactionId(TutorActionLogV4 actionLog) {
        return actionLog.getTransactionId();
    }

    protected NameContent getMessageName(String newName) {
        if (newName == null) {
            return null;
        }
        return new NameContent(newName);
    }

    protected SAIContent getMessageSAI(EventDescriptorElement event) {
        if (event == null) {
            return null;
        }
        Element newSAI = this.parseXML(event.toString());
        List newSAIChildren = newSAI.getChildren();
        SAIContent messageSAI = new SAIContent();
        for (Element element2 : newSAIChildren) {
            messageSAI.addOneSAI(element2.getName(), element2.getText());
        }
        return messageSAI;
    }

    protected ActionEvaluationContent getMessageActionEvaluation(ActionEvaluationElement newActionEval) {
        if (newActionEval == null) {
            return null;
        }
        String newEval = newActionEval.getEvaluation();
        String newHintNum = newActionEval.getCurrentHintNumber();
        String newHintsAvailable = newActionEval.getTotalHintsAvailable();
        String newHintId = newActionEval.getHintId();
        String newClassification = newActionEval.getClassification();
        return new ActionEvaluationContent(newEval, newHintNum, newHintsAvailable, newHintId, newClassification);
    }

    protected List<TutorAdviceContent> getMessageTutorAdviceList(List<String> newTutorAdvice) {
        if (newTutorAdvice == null) {
            return null;
        }
        ArrayList<TutorAdviceContent> adviceList = new ArrayList<TutorAdviceContent>();
        for (int i = 0; i < newTutorAdvice.size(); ++i) {
            String advice = newTutorAdvice.get(i);
            adviceList.add(new TutorAdviceContent(advice, i));
        }
        return Collections.unmodifiableList(adviceList);
    }

    protected List<SkillContent> getMessageSkillList(List<SkillElement> newSkillsElements) {
        if (newSkillsElements == null) {
            return null;
        }
        ArrayList<SkillContent> skillList = new ArrayList<SkillContent>();
        for (int i = 0; i < newSkillsElements.size(); ++i) {
            SkillElement advice = newSkillsElements.get(i);
            ArrayList<String> model_names = new ArrayList<String>();
            for (String model_name : advice.getModelNameList()) {
                model_names.add(model_name);
            }
            SkillContent newSkill = new SkillContent(i, advice.getProbability(), advice.getName(), advice.getCategory(), model_names, advice.getBuggyFlag());
            skillList.add(newSkill);
        }
        return Collections.unmodifiableList(skillList);
    }

    protected List<CustomContent> getMessageCustomList(List<CustomFieldElement> customElementsList) {
        if (customElementsList == null) {
            return null;
        }
        ArrayList<CustomContent> customList = new ArrayList<CustomContent>();
        for (int i = 0; i < customElementsList.size(); ++i) {
            CustomFieldElement customFieldElement = customElementsList.get(i);
            CustomContent newCustom = new CustomContent(i, customFieldElement.getName(), customFieldElement.getValue());
            customList.add(newCustom);
        }
        return Collections.unmodifiableList(customList);
    }

    protected Element parseXML(String xml) {
        SAXBuilder saxBuilder = new SAXBuilder();
        Element element2 = null;
        try {
            Document doc = saxBuilder.build((Reader)new StringReader(xml));
            element2 = doc.getRootElement();
        }
        catch (JDOMException e) {
            trace.out("log", "LogComparison parseXML JDOMException");
            e.printStackTrace();
        }
        catch (IOException e) {
            trace.out("log", "LogComparison parseXML IOException");
            e.printStackTrace();
        }
        return element2;
    }

    @Override
    public Iterator<ContentCell> iterator() {
        ArrayList<ContentCell> allContentCells = new ArrayList<ContentCell>();
        this.addContentCells(allContentCells, this.name);
        this.addContentCells(allContentCells, this.sai);
        this.addContentCells(allContentCells, this.actionEval);
        this.addListOfContentCells(allContentCells, this.tutorAdvices);
        this.addListOfContentCells(allContentCells, this.skills);
        this.addListOfContentCells(allContentCells, this.customs);
        return Collections.unmodifiableList(allContentCells).iterator();
    }

    private void addContentCells(List<ContentCell> allContentCells, Content content) {
        if (content == null) {
            return;
        }
        for (ContentCell cell : content) {
            allContentCells.add(cell);
        }
    }

    private void addListOfContentCells(List<ContentCell> allContentCells, List<? extends Content> contentList) {
        if (contentList == null) {
            return;
        }
        for (Content content : contentList) {
            this.addContentCells(allContentCells, content);
        }
    }

    @Override
    public NameContent getName() {
        return this.name;
    }

    @Override
    public SAIContent getSAI() {
        return this.sai;
    }

    @Override
    public ActionEvaluationContent getActionEval() {
        return this.actionEval;
    }

    @Override
    public List<TutorAdviceContent> getTutorAdvices() {
        return this.tutorAdvices;
    }

    @Override
    public List<SkillContent> getSkills() {
        return this.skills;
    }

    @Override
    public List<CustomContent> getCustomFields() {
        return this.customs;
    }

    @Override
    public String getTransactionId() {
        return this.transactionId;
    }
}

