/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.LinkInspector;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorException;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorPanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NewProblemEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraph;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.BR_JGraphEdge;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.JGraphPanel;
import edu.cmu.pact.Utilities.CTAT_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctatview.CtatviewException;
import edu.cmu.pact.ctatview.DockManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.View;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.event.GraphSelectionEvent;
import org.jgraph.event.GraphSelectionListener;

public class LinkInspectorManager
extends DockingWindowAdapter
implements ProblemModelListener,
GraphSelectionListener,
GraphModelListener,
ComponentListener,
MouseListener {
    private final Color[] colors = new Color[]{Color.green, Color.ORANGE, Color.blue};
    private LinkInspectorPanelContainer ActivePanelList = null;
    private LinkInspectorPanelContainer BinnedPanelList = null;
    private long ActivePanelCount = 0L;
    private long BinnedPanelCount = 0L;
    private long NumPanels = 0L;
    public static long DEFAULT_PANEL_COUNT = 3L;
    private static String VIEWMENU_TEXT = "Link Inspector";
    private DockManager CurrentDockManager;
    private JMenuItem ViewMenuItem = null;
    private BR_Controller Controller;
    private BR_JGraph JGraph;

    public LinkInspectorManager(DockManager Manager, CTAT_Controller Controller) throws LinkInspectorException {
        this(-1L, Manager, Controller);
    }

    public LinkInspectorManager(long PanelCount, DockManager Manager, CTAT_Controller Controller) throws LinkInspectorException {
        if (trace.getDebugCode("linkinspectorManager")) {
            trace.outNT("linkinspectorManager", "Generating LinkInspectorManager.");
        }
        if (!(Controller instanceof BR_Controller)) {
            throw new LinkInspectorException("Non BR_Controller supplied.");
        }
        this.NumPanels = PanelCount > -1L ? PanelCount : DEFAULT_PANEL_COUNT;
        this.CurrentDockManager = Manager;
        this.Controller = (BR_Controller)Controller;
        ProblemModel Problem2 = ((BR_Controller)Controller).getProblemModel();
        Problem2.addProblemModelListener(this);
        JGraphPanel JGPanel = this.Controller.getJGraphWindow();
        this.JGraph = JGPanel.getJGraph();
        this.JGraph.addMouseListener(this);
        this.JGraph.addGraphSelectionListener(this);
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Generating: Installing ViewMenu Item.");
        }
        this.ViewMenuItem = new JMenuItem();
        this.ViewMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (trace.getDebugCode("LI_Manager")) {
                    trace.outNT("LI_Manager", "ViewMenu action called.");
                }
                LinkInspectorManager.this.viewMenuEvent();
            }
        });
        this.CurrentDockManager.addExperimentalViewMenuItem(this.ViewMenuItem);
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Generating: Adding Panels.");
        }
        int i = 0;
        while ((long)i < this.NumPanels) {
            this.addPanel(i);
            ++i;
        }
        this.ViewMenuItem.setText(VIEWMENU_TEXT + this.BinnedPanelCount);
        this.displayStatus();
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Generating: Done.");
        }
    }

    public void postWindowingUpdate() throws CtatviewException {
        this.CurrentDockManager.addListenerToRootWindow(this);
        this.checkViewStatus();
    }

    private void checkViewStatus() {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Checking view status.");
        }
        LinkInspectorPanelContainer C2 = null;
        LinkInspectorPanelContainer Cp = null;
        LinkInspectorPanelContainer A = this.ActivePanelList == null ? null : this.getLastActivePanel();
        C2 = this.BinnedPanelList;
        while (C2 != null) {
            C2.displayStatus();
            if (C2.isClosable()) {
                if (A == null) {
                    this.ActivePanelList = C2;
                } else {
                    A.setNext(C2);
                }
                A = C2;
                C2 = C2.getNext();
                if (Cp == null) {
                    this.BinnedPanelList = C2;
                } else {
                    Cp.setNext(C2);
                }
                if (C2 == null) {
                    System.out.println("End of list");
                } else {
                    System.out.println(C2.getView().getTitle());
                }
                A.setNext(null);
                ++this.ActivePanelCount;
                --this.BinnedPanelCount;
                continue;
            }
            Cp = C2;
            C2 = C2.getNext();
        }
        this.displayStatus();
    }

    private void displayStatus() {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "LinkManager Status");
        }
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Num Panels:        " + this.NumPanels);
        }
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Num Active Panels: " + this.ActivePanelCount);
        }
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Num Binned Panels: " + this.BinnedPanelCount);
        }
    }

    public void addPanel(int numPanel) {
        numPanel %= this.colors.length;
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Adding blank panel.");
        }
        DockManager Manager = this.CurrentDockManager;
        LinkInspectorPanel NewPanel = new LinkInspectorPanel(this, this.Controller, this.colors[numPanel]);
        NewPanel.addComponentListener(this);
        String ViewName = "Link Inspector (beta): " + this.BinnedPanelCount;
        View NewView = Manager.addDynamicView(NewPanel, ViewName);
        LinkInspectorPanelContainer Container2 = new LinkInspectorPanelContainer(NewPanel, this, NewView, numPanel);
        this.addToBin(Container2);
    }

    private LinkInspectorPanelContainer getLastActivePanel() {
        LinkInspectorPanelContainer C2 = this.ActivePanelList;
        if (C2 == null) {
            return null;
        }
        while (C2.getNext() != null) {
            C2 = C2.getNext();
        }
        return C2;
    }

    private LinkInspectorPanelContainer getLastBinnedPanel() {
        LinkInspectorPanelContainer C2 = this.BinnedPanelList;
        if (C2 == null) {
            return null;
        }
        while (C2.getNext() != null) {
            C2 = C2.getNext();
        }
        return C2;
    }

    private boolean activateBlankPanel() {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Activating blank panel.");
        }
        return this.addToActive() != null;
    }

    private boolean activateEdgePanel(ProblemEdge Edge) {
        LinkInspectorPanelContainer C2 = this.addToActive();
        if (C2 == null) {
            return false;
        }
        return C2.setEdge(Edge);
    }

    private LinkInspectorPanelContainer addToActive() {
        LinkInspectorPanelContainer Container2;
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Adding active panel.");
        }
        if ((Container2 = this.BinnedPanelList) == null) {
            if (trace.getDebugCode("LI_Manager")) {
                trace.outNT("LI_Manager", "Warning: no more panels to activate.");
            }
            return null;
        }
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Moving from Bin.");
        }
        if (this.ActivePanelList != null) {
            this.ActivePanelList.makeSecondary();
        }
        this.BinnedPanelList = Container2.getNext();
        --this.BinnedPanelCount;
        Container2.setNext(this.ActivePanelList);
        this.ActivePanelList = Container2;
        ++this.ActivePanelCount;
        Container2.makePrimary();
        Container2.makeVisible();
        this.displayStatus();
        if (this.BinnedPanelCount == 0L) {
            this.ViewMenuItem.setEnabled(false);
        }
        this.ViewMenuItem.setText(VIEWMENU_TEXT + this.BinnedPanelCount);
        return Container2;
    }

    void activateThisPanel(LinkInspectorPanel Panel2) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Activating supplied panel.");
        }
        if (Panel2 != this.ActivePanelList.getPanel()) {
            if (this.ActivePanelCount > 0L && this.chainActivatePanel(Panel2, this.ActivePanelList)) {
                return;
            }
            if (this.BinnedPanelCount > 0L && this.chainActivatePanel(Panel2, this.BinnedPanelList)) {
                return;
            }
        }
    }

    private boolean chainActivatePanel(LinkInspectorPanel Panel2, LinkInspectorPanelContainer Parent) {
        LinkInspectorPanelContainer Curr = null;
        LinkInspectorPanelContainer Next = null;
        Curr = Parent.getNext();
        while (Curr != null) {
            Next = Curr.getNext();
            if (Panel2 == Curr.getPanel()) {
                this.activatePanel(Parent, Curr, Next);
                return true;
            }
            Parent = Curr;
            Curr = Next;
        }
        return false;
    }

    private void activatePanel(LinkInspectorPanelContainer Parent, LinkInspectorPanelContainer Container2, LinkInspectorPanelContainer Next) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Activating from Bin: " + Container2.toString());
        }
        if (Parent == null) {
            this.BinnedPanelList = Next;
        } else {
            Parent.setNext(Next);
        }
        --this.BinnedPanelCount;
        if (this.ActivePanelList != null) {
            this.ActivePanelList.makeSecondary();
        }
        Container2.setNext(this.ActivePanelList);
        this.ActivePanelList = Container2;
        ++this.ActivePanelCount;
        Container2.makePrimary();
        if (this.BinnedPanelCount == 0L) {
            this.ViewMenuItem.setEnabled(false);
        }
        this.ViewMenuItem.setText(VIEWMENU_TEXT + this.BinnedPanelCount);
        this.displayStatus();
    }

    private void binPanel(LinkInspectorPanelContainer Parent, LinkInspectorPanelContainer Container2, LinkInspectorPanelContainer Next) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Binning active panel: " + Container2.toString());
        }
        if (Parent == null) {
            this.ActivePanelList = Next;
        } else {
            Parent.setNext(Next);
        }
        --this.ActivePanelCount;
        if (this.ActivePanelList != null) {
            this.ActivePanelList.makePrimary();
        }
        this.addToBin(Container2);
    }

    private void addToBin(LinkInspectorPanelContainer Container2) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Adding panel to bin.");
        }
        Container2.setNext(this.BinnedPanelList);
        this.BinnedPanelList = Container2;
        Container2.makeBinned();
        ++this.BinnedPanelCount;
        if (!this.ViewMenuItem.isEnabled()) {
            this.ViewMenuItem.setEnabled(true);
        }
        this.ViewMenuItem.setText(VIEWMENU_TEXT + this.BinnedPanelCount);
        this.displayStatus();
    }

    private boolean setActivePanelEdge(ProblemEdge Edge) {
        if (this.ActivePanelList != null) {
            if (trace.getDebugCode("LI_Manager")) {
                trace.outNT("LI_Manager", "setActivePanelEdge.");
            }
            this.ActivePanelList.setEdge(Edge);
            return true;
        }
        return false;
    }

    public void viewMenuEvent() {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "ViewMenu event called.->");
        }
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "ViewMenu generating panel.");
        }
        this.activateBlankPanel();
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "ViewMenu event called.<-");
        }
    }

    public void windowShown(DockingWindow Window2) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Shown Event" + Window2.toString());
        }
        this.displayStatus();
        LinkInspectorPanelContainer Container2 = this.ActivePanelList;
        while (Container2 != null) {
            if (Container2.notifyShown(Window2) && trace.getDebugCode("LI_Manager")) {
                trace.outNT("LI_Manager", "Active Panel Shown.");
            }
            Container2 = Container2.getNext();
        }
        LinkInspectorPanelContainer Parent = null;
        Container2 = this.BinnedPanelList;
        while (Container2 != null) {
            LinkInspectorPanelContainer Next = Container2.getNext();
            if (Container2.notifyShown(Window2)) {
                if (trace.getDebugCode("LI_Manager")) {
                    trace.outNT("LI_Manager", "Binned Panel Shown.");
                }
                this.activatePanel(Parent, Container2, Next);
                Container2 = Next;
                continue;
            }
            Parent = Container2;
            Container2 = Next;
        }
    }

    public void windowHidden(DockingWindow Window2) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "Hide Event:" + Window2.toString());
        }
        LinkInspectorPanelContainer C2 = this.ActivePanelList;
        while (C2 != null) {
            if (C2.notifyHidden(Window2) && trace.getDebugCode("LI_Manager")) {
                trace.outNT("LI_Manager", "Panel Hidden.");
            }
            C2 = C2.getNext();
        }
    }

    public void windowRemoved(DockingWindow removedFromWindow, DockingWindow removedWindow) {
        if (removedWindow != null) {
            if (trace.getDebugCode("LI_Manager")) {
                trace.outNT("LI_Manager", "From: [" + removedFromWindow.toString() + "] Removed: [" + removedWindow.toString() + "]");
            }
            LinkInspectorPanelContainer Parent = null;
            LinkInspectorPanelContainer Container2 = this.ActivePanelList;
            while (Container2 != null) {
                LinkInspectorPanelContainer Next = Container2.getNext();
                if (Container2.notifyRemoved(removedWindow)) {
                    this.binPanel(Parent, Container2, Next);
                    Container2 = Next;
                    continue;
                }
                Parent = Container2;
                Container2 = Next;
            }
        }
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent E) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "ProblemModelEvent: " + E.toString());
        }
        LinkInspectorPanelContainer C2 = this.ActivePanelList;
        if (E instanceof NewProblemEvent) {
            while (C2 != null) {
                C2.clearEdge();
                C2 = C2.getNext();
            }
        } else {
            while (C2 != null) {
                C2.handleProblemModelEvent(E);
                C2 = C2.getNext();
            }
        }
    }

    public void valueChanged(GraphSelectionEvent SelEvent) {
    }

    public void graphChanged(GraphModelEvent GraphEvent) {
        if (trace.getDebugCode("LI_Manager")) {
            trace.outNT("LI_Manager", "GraphChanged: " + GraphEvent.toString());
        }
    }

    @Override
    public void componentHidden(ComponentEvent arg0) {
    }

    @Override
    public void componentMoved(ComponentEvent arg0) {
    }

    @Override
    public void componentResized(ComponentEvent arg0) {
        Component temp = arg0.getComponent();
        temp.setPreferredSize(new Dimension(temp.getWidth(), temp.getHeight()));
        temp.validate();
        temp.repaint();
    }

    @Override
    public void componentShown(ComponentEvent arg0) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
        if (BR_JGraph.wasRightClick(arg0)) {
            return;
        }
        Object cell = this.JGraph.getFirstCellForLocation(arg0.getX(), arg0.getY());
        if (cell instanceof BR_JGraphEdge) {
            this.setActivePanelEdge(((BR_JGraphEdge)cell).getProblemEdge());
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private class LinkInspectorPanelContainer {
        private LinkInspectorPanel MyPanel;
        private LinkInspectorManager MyManager;
        private View MyView;
        private LinkInspectorPanelContainer Next;

        protected LinkInspectorPanelContainer(LinkInspectorPanel NewPanel, LinkInspectorManager Manager, View NewView, long ViewCount) {
            this.MyPanel = NewPanel;
            this.MyManager = Manager;
            this.MyView = NewView;
            this.Next = null;
            NewPanel.setIdentifier(ViewCount);
        }

        private JPanel getPanel() {
            return this.MyPanel;
        }

        private View getView() {
            return this.MyView;
        }

        private LinkInspectorPanelContainer getNext() {
            return this.Next;
        }

        private void setNext(LinkInspectorPanelContainer NextContainer) {
            this.Next = NextContainer;
        }

        private void clearNext() {
            this.Next = null;
        }

        private long getIdentifier() {
            return this.MyPanel.getIdentifier();
        }

        private void setIdentifier(long Identifier) {
            this.MyPanel.setIdentifier(Identifier);
        }

        private void clearEdge() {
            this.MyPanel.clearEdge();
        }

        private boolean setEdge(ProblemEdge Edge) {
            try {
                this.MyPanel.setEdge(Edge);
                this.MyView.repaint();
                return true;
            }
            catch (LinkInspectorException E) {
                trace.err("exception " + E + " on setEdge" + Edge + ")");
                E.printStackTrace();
                return false;
            }
        }

        private void lockPanel() {
            this.MyPanel.lock();
        }

        private void unlockPanel() {
            this.MyPanel.unlock();
        }

        private void handleProblemModelEvent(ProblemModelEvent Ev) {
            this.MyPanel.handleProblemModelEvent(Ev);
        }

        private void makePrimary() {
            this.MyPanel.makePrimary();
        }

        private void makeSecondary() {
            this.MyPanel.makeSecondary();
        }

        private void makeBinned() {
            this.MyPanel.makeBinned();
        }

        private void makeVisible() {
            this.MyView.restore();
        }

        private boolean isClosable() {
            return this.MyView.isClosable();
        }

        boolean notifyShown(DockingWindow Window2) {
            if (this.MyView == Window2) {
                if (trace.getDebugCode("LI_Container")) {
                    trace.outNT("LI_Container", "I'm shown: " + this.MyView.toString());
                }
                this.unlockPanel();
                return true;
            }
            if (Window2.isAncestorOf((Component)this.MyView)) {
                if (trace.getDebugCode("LI_Container")) {
                    trace.outNT("LI_Container", "Ancestor shown: " + this.MyView.toString());
                }
                this.unlockPanel();
                return true;
            }
            return false;
        }

        boolean notifyHidden(DockingWindow Window2) {
            if (this.MyView == Window2) {
                if (trace.getDebugCode("LI_Container")) {
                    trace.outNT("LI_Container", "I'm hidden: " + this.MyView.toString());
                }
                this.MyPanel.restoreEdgeColor();
                this.lockPanel();
                return true;
            }
            if (Window2.isAncestorOf((Component)this.MyView)) {
                if (trace.getDebugCode("LI_Container")) {
                    trace.outNT("LI_Container", "Ancestor hidden: " + this.MyView.toString());
                }
                this.lockPanel();
                return true;
            }
            return false;
        }

        boolean notifyRemoved(DockingWindow Window2) {
            if (this.MyView == Window2) {
                if (trace.getDebugCode("LI_Container")) {
                    trace.outNT("LI_Container", "I'm removed: " + this.MyView.toString());
                }
                this.lockPanel();
                return true;
            }
            if (Window2.isAncestorOf((Component)this.MyView)) {
                if (trace.getDebugCode("LI_Container")) {
                    trace.outNT("LI_Container", "Ancestor removed: " + this.MyView.toString());
                }
                this.lockPanel();
                return true;
            }
            return false;
        }

        private void displayStatus() {
            String ViewStatus = "View Status:\n";
            String Title = "Title: " + this.MyView.getTitle() + "\n";
            String Minimized = "Minimized: " + this.MyView.isMinimized() + "\n";
            String Maximized = "Maximized: " + this.MyView.isMaximized() + "\n";
            String Restorable = "Restorabe: " + this.MyView.isRestorable() + "\n";
            String Closable = "Closable: " + this.MyView.isClosable() + "\n";
            if (trace.getDebugCode("LI_Container")) {
                trace.outNT("LI_Container", ViewStatus + Title + Minimized + Maximized + Restorable + Closable);
            }
        }

        public String toString() {
            String VS = "LinkInspectorPanelContainer: " + this.MyView.getTitle();
            return VS;
        }
    }
}

