/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.collections.TransactionRunner;
import com.sleepycat.collections.TransactionWorker;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDBInstance;
import java.io.File;
import java.util.ArrayList;

public class CTATBerkeleyDB
extends CTATBase
implements TransactionWorker {
    private EnvironmentConfig envConfig = null;
    private Environment env = null;
    private boolean dbDisabled = false;
    private boolean create = true;
    private String dbDir = "./db";
    public boolean dumpDatabase = false;
    private TransactionRunner runner = null;
    private CTATBerkeleyDBInstance mainDB = null;
    private CTATBerkeleyDBInstance catalogDb = null;
    private StoredClassCatalog javaCatalog = null;
    private ArrayList<CTATBerkeleyDBInstance> databases = null;

    public CTATBerkeleyDB() {
        this.setClassName("CTATBerkeleyDB");
        this.debug("CTATBerkeleyDB ()");
        this.databases = new ArrayList();
    }

    public boolean isDbDisabled() {
        return this.dbDisabled;
    }

    public void setDbDisabled(boolean dbDisabled) {
        this.dbDisabled = dbDisabled;
    }

    public String getDbDir() {
        return this.dbDir;
    }

    public void setDbDir(String dbDir) {
        this.dbDir = dbDir;
    }

    public long getCacheMisses() {
        long cacheMisses = this.env.getStats(null).getNCacheMiss();
        return cacheMisses;
    }

    public Boolean startDBService() {
        this.debug("startDBService ()");
        this.envConfig = new EnvironmentConfig();
        this.envConfig.setTransactional(true);
        if (this.create) {
            this.debug("EnvironmentConfig.setAllowCreate(true);");
            this.envConfig.setAllowCreate(true);
        }
        this.env = new Environment(new File(this.dbDir), this.envConfig);
        try {
            this.open();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.debug("Caught a database exception whilst opening the db, aborting main server ...");
            this.env.toString();
            return false;
        }
        if (this.dbDisabled) {
            this.debug("Error: database is not open or disabled, aborting");
            return false;
        }
        try {
            this.catalogDb = this.accessDB("java_class_catalog");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.javaCatalog = new StoredClassCatalog(this.catalogDb.getDB());
        return true;
    }

    public final StoredClassCatalog getClassCatalog() {
        return this.javaCatalog;
    }

    public boolean startDBThread() {
        this.debug("startDBThread ()");
        if (this.runner != null) {
            try {
                this.runner.run((TransactionWorker)this);
            }
            catch (DatabaseException e) {
                e.printStackTrace();
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    public void doWork() {
        this.debug("doWork ()");
        if (this.dumpDatabase) {
            this.dumpDB();
        }
    }

    public CTATBerkeleyDBInstance findDB(String aDB) {
        this.debug("findDB (" + aDB + ")");
        for (int i = 0; i < this.databases.size(); ++i) {
            CTATBerkeleyDBInstance db = this.databases.get(i);
            if (!db.getInstanceName().toLowerCase().equals(aDB)) continue;
            return db;
        }
        return null;
    }

    public CTATBerkeleyDBInstance open() throws Exception {
        this.debug("open ()");
        this.mainDB = this.findDB("TSMonitor");
        if (this.mainDB == null) {
            this.mainDB = new CTATBerkeleyDBInstance();
            this.mainDB.setInstanceName("TSMonitor");
            this.mainDB.setEnvironment(this.env);
            this.mainDB.openDB("TSMonitor");
            this.databases.add(this.mainDB);
        }
        this.debug("Database should be open and available");
        return this.mainDB;
    }

    public CTATBerkeleyDBInstance accessDB(String aDB) throws Exception {
        this.debug("openDB (" + aDB + ")");
        CTATBerkeleyDBInstance db = this.findDB(aDB);
        if (db == null) {
            this.debug("Database does not exist yet, creating ...");
            db = new CTATBerkeleyDBInstance();
            db.setInstanceName(aDB);
            db.setEnvironment(this.env);
            db.openDB(aDB);
            this.databases.add(db);
            this.debug("Database should be open and available");
        }
        return db;
    }

    public void close() throws Exception {
        this.debug("close ()");
        this.dbDisabled = true;
        this.debug("Closing databases ...");
        for (int i = 0; i < this.databases.size(); ++i) {
            CTATBerkeleyDBInstance db = this.databases.get(i);
            if (db == null) continue;
            this.debug("Closing: " + db.getInstanceName());
            db.close();
        }
        this.debug("Closing class catalog ...");
        if (this.javaCatalog != null) {
            this.javaCatalog.close();
            this.javaCatalog = null;
        }
        this.debug("Closing database environment ...");
        if (this.env != null) {
            this.env.close();
            this.env = null;
        }
        this.debug("Resetting map ...");
        this.debug("Database successfully shutdown");
    }

    public String getStatus() {
        if (this.env == null) {
            return "No database environment available";
        }
        return this.env.getStats(null).toString();
    }

    public ArrayList<String> getDatabases() {
        if (this.env == null) {
            return null;
        }
        return (ArrayList)this.env.getDatabaseNames();
    }

    public void dumpDB() {
        this.debug("dumpDB ()");
        System.out.print(this.env.getStats(null).toString());
    }
}

