/*
 * Decompiled with CFR 0.152.
 */
package pact.EconGraph;

import edu.cmu.pact.Utilities.trace;
import java.applet.Applet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JPanel;
import pact.EconGraph.Grid;
import pact.EconGraph.Line;
import pact.EconGraph.ParameterProvider;
import pact.EconGraph.Parseappletstring;
import pact.EconGraph.Point;

public class GraphPanel
extends JPanel
implements Runnable {
    Color backgroundColor = Color.yellow;
    boolean dragLine = false;
    String copyright = "v1.0 (c)2000, J.H. Miller, All Rights Reserved";
    boolean maximizeSize = true;
    Thread runner;
    ParameterProvider parameterProvider;
    Image offim;
    Graphics offg;
    int width;
    int height;
    Point pointToMove = null;
    public Grid plot;
    public Line[] line;
    Vector lineDrawOrder = new Vector();
    String temp;
    private Applet applet;
    public Hashtable hashtable = new Hashtable();

    public boolean getDragLine() {
        return this.dragLine;
    }

    @Override
    public void run() {
        this.makeGraph(this.offg, this.plot);
    }

    public void setApplet(Applet applet) {
        trace.out(5, this, "setApplet: appet = " + applet);
        this.applet = applet;
    }

    public void setParameterProvider(ParameterProvider p) {
        this.parameterProvider = p;
    }

    public void reset() {
        try {
            for (int i = 0; i < this.line.length; ++i) {
                this.line[i].reset();
            }
            this.makeGraph(this.offg, this.plot);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public Point convertPixelBack(Point p) {
        return this.plot.convertPixelBack(p);
    }

    public void dragLine(Point cpoint, Point ptm, boolean BRD) {
        Point newpoint = cpoint;
        Point pointToMove = ptm;
        if (!BRD) {
            newpoint = this.plot.convertPixel(cpoint);
        }
        if (pointToMove != null) {
            if (this.dragLine) {
                int j;
                int i;
                int oldX = pointToMove.getx();
                int oldY = pointToMove.gety();
                int Xdif = newpoint.x - oldX;
                int Ydif = newpoint.y - oldY;
                String linename = pointToMove.lineName;
                int lineIndex = 0;
                if (Xdif != 0) {
                    for (i = 0; i < this.line.length; ++i) {
                        if (!this.line[i].name.equals(linename)) continue;
                        lineIndex = i;
                        for (j = 0; j < this.line[i].point.length; ++j) {
                            this.line[i].point[j].x += Xdif;
                        }
                    }
                }
                if (Ydif != 0) {
                    for (i = 0; i < this.line.length; ++i) {
                        if (!this.line[i].name.equals(linename)) continue;
                        for (j = 0; j < this.line[i].point.length; ++j) {
                            this.line[i].point[j].y += Ydif;
                        }
                    }
                }
            } else if (this.plot.inBounds(newpoint) && !pointToMove.isGreen()) {
                pointToMove.move(newpoint);
            }
        }
    }

    public void init() {
        this.readInParams();
        for (int ln = 0; ln < this.line.length; ++ln) {
            this.lineDrawOrder.addElement(this.line[ln]);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                Point downpt = new Point(x, y);
                if (GraphPanel.this.pointToMove != null) {
                    GraphPanel.this.pointToMove = null;
                }
                int index = GraphPanel.this.lineDrawOrder.size() - 1;
                do {
                    Line line = (Line)GraphPanel.this.lineDrawOrder.elementAt(index);
                    GraphPanel.this.pointToMove = GraphPanel.this.plot.closeMoveablePoint(downpt, line);
                    if (GraphPanel.this.pointToMove == null) continue;
                    GraphPanel.this.lineDrawOrder.removeElement(line);
                    GraphPanel.this.lineDrawOrder.addElement(line);
                } while (GraphPanel.this.pointToMove == null && --index >= 0);
                GraphPanel.this.makeGraph(GraphPanel.this.offg, GraphPanel.this.plot);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                Point cpoint = new Point(x, y);
                GraphPanel.this.dragLine(cpoint, GraphPanel.this.pointToMove, false);
                GraphPanel.this.makeGraph(GraphPanel.this.offg, GraphPanel.this.plot);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                Point cpoint = new Point(x, y);
                if (GraphPanel.this.pointToMove != null) {
                    GraphPanel.this.pointToMove.updateListeners();
                }
            }
        });
        trace.out(5, this, "this.getSize().width " + this.getSize().width);
        trace.out(5, this, "width = " + this.getSize().width + " height " + this.getSize().height);
        trace.out(5, this, "applet = " + this.applet);
        if (this.applet != null) {
            trace.out(5, this, "applet width: " + this.applet.getWidth());
            this.offim = this.createImage(this.applet.getSize().width, this.applet.getSize().height);
        } else {
            this.offim = this.createImage(this.getSize().width, this.getSize().height);
        }
        trace.out(5, this, "image width = " + this.offim.getWidth(this));
        trace.out(5, this, "image height = " + this.offim.getHeight(this));
        trace.out(5, this, "this size = " + this.getSize());
        this.offg = this.offim.getGraphics();
        String lineAA = this.getParameter("lineAntiAliasing");
        String fontAA = this.getParameter("fontAntiAliasing");
        try {
            if (lineAA != null && lineAA.equalsIgnoreCase("true")) {
                ((Graphics2D)this.offg).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (fontAA != null && fontAA.equalsIgnoreCase("true")) {
                ((Graphics2D)this.offg).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
        }
        catch (NoClassDefFoundError e) {
            trace.out(5, this, "sorry, no anti-aliaising");
        }
        if (this.maximizeSize) {
            this.plot.maximizeGrid(this.offg, this.width, this.height);
        }
        this.makeGraph(this.offg, this.plot);
    }

    public void start() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
        this.clearSurface(this.offg);
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.stop();
            this.runner = null;
        }
    }

    public void clearSurface(Graphics g) {
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
    }

    public void makeGraph() {
        this.makeGraph(this.offg, this.plot);
    }

    void makeGraph(Graphics g, Grid gp) {
        this.clearSurface(g);
        gp.showCopyright(g, this.copyright);
        gp.drawGraphPaper(g);
        for (int ln = 0; ln < this.lineDrawOrder.size(); ++ln) {
            Line l = (Line)this.lineDrawOrder.elementAt(ln);
            gp.plotLine(g, l);
            for (int i = 0; i < l.point.length; ++i) {
                gp.plotPoint(g, l.point[i]);
            }
        }
        if (this.pointToMove != null) {
            gp.plotPoint(g, this.pointToMove);
            gp.labelPoint(g, this.pointToMove);
        }
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (g != null) {
            if (this.offim != null) {
                g.drawImage(this.offim, 0, 0, this);
            } else {
                int width = this.getFontMetrics(g.getFont()).stringWidth("GraphTool");
                g.drawString("GraphTool", this.getSize().width / 2 - width / 2, this.getSize().height / 2);
            }
        }
    }

    public String getParameter(String name) {
        if (this.applet == null && this.parameterProvider == null) {
            throw new Error("Graph.java: Can't find parameters.");
        }
        return this.parameterProvider.getParameter(name);
    }

    public void readInParams() {
        int[] ints = new int[100];
        String[] strs = new String[20];
        String s = this.getParameter("setup");
        Parseappletstring.parseString(s, ints, strs);
        try {
            trace.out("mps", " value for setup = " + s);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        for (int j = 0; j < 20; ++j) {
            trace.out(5, "mps", "parameter = " + strs[j]);
        }
        this.backgroundColor = Parseappletstring.makeColor(strs[0]);
        this.dragLine = strs[3] != null && strs[3].equalsIgnoreCase("line");
        this.plot = new Grid(ints[0], ints[1], ints[2], ints[3], ints[4], ints[5], ints[6], strs[1], ints[7], ints[8], ints[9], strs[2]);
        this.width = ints[2];
        this.height = ints[3];
        s = this.getParameter("nl");
        Parseappletstring.parseString(s, ints, strs);
        int numberoflines = ints[0];
        this.line = new Line[numberoflines];
        BasicStroke a = new BasicStroke();
        for (int i = 0; i < numberoflines; ++i) {
            switch (i) {
                case 0: {
                    a = new BasicStroke(3.0f, 2, 0, 10.0f, new float[]{2.0f, 5.0f}, 0.0f);
                    break;
                }
                case 1: {
                    a = new BasicStroke(3.0f, 2, 0, 10.0f, new float[]{10.0f, 5.0f}, 0.0f);
                    break;
                }
                case 2: {
                    a = new BasicStroke(3.0f);
                }
            }
            s = this.getParameter("ln" + (i + 1));
            Parseappletstring.parseString(s, ints, strs);
            this.line[i] = new Line(strs[0], new Point(ints[0], ints[1], strs[0], 0), new Point(ints[2], ints[3], strs[0], ints[4] - 1), ints[4], Parseappletstring.makeColor(strs[1]), ints[7] == 1, a);
            this.hashtable.put(strs[0], this.line[i]);
            if (ints[8] != 1) continue;
            int tpts = ints[4];
            s = this.getParameter("ln" + (i + 1) + "init");
            Parseappletstring.parseString(s, ints, strs);
            for (int pt = 0; pt < tpts; ++pt) {
                this.line[i].point[pt].move(new Point(ints[pt * 2], ints[pt * 2 + 1]));
                this.line[i].point[pt].saveResetState();
            }
        }
    }

    @Override
    public String toString() {
        String name = this.getParameter("label");
        name = name == null ? "G" : "G" + name;
        for (int ln = 0; ln < this.line.length; ++ln) {
            if (!this.line[ln].getMoving()) continue;
            name = name + "@" + this.line[ln].summary(ln + 1, "@");
        }
        return name;
    }

    public String report() {
        int ln;
        String name = this.getParameter("label");
        name = name == null ? "A0@" : name + "@";
        int ml = 0;
        for (ln = 0; ln < this.line.length; ++ln) {
            if (!this.line[ln].getMoving()) continue;
            ++ml;
        }
        name = name + ml + ",";
        for (ln = 0; ln < this.line.length; ++ln) {
            if (!this.line[ln].getMoving()) continue;
            name = name + this.line[ln].summary(ln + 1, ",") + ",";
        }
        if (name.charAt(name.length() - 1) == ',') {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public void restore(String s) {
        int[] ints = new int[100];
        String[] strs = new String[10];
        Parseappletstring.parseString(s, ints, strs);
        int numberoflines = ints[0];
        int c = 1;
        for (int i = 0; i < numberoflines; ++i) {
            int ln = ints[c++];
            int tpts = ints[c++];
            for (int pt = 0; pt < tpts; ++pt) {
                this.line[ln - 1].point[pt].move(new Point(ints[c], ints[c + 1]));
                c += 2;
            }
        }
        this.makeGraph(this.offg, this.plot);
    }
}

