/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.userDef.algebra;

import cl.utilities.sm.Expression;
import cl.utilities.sm.HSParser;
import cl.utilities.sm.ParseException;
import cl.utilities.sm.SMParserSettings;
import cl.utilities.sm.function.DomainException;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;

public abstract class ArithmeticOperator
extends EqFeaturePredicate {
    public Expression parse(String expString) {
        HSParser parser = new HSParser();
        SMParserSettings settings = SMParserSettings.MIXED_NUMBERS_E_AS_VAR;
        String[] vars = this.getVars(expString);
        try {
            return parser.parse(expString, vars, settings).expand(3);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (DomainException e) {
            e.printStackTrace();
        }
        return null;
    }

    public String[] getVars(String expString) {
        for (int x = 0; x < expString.length(); ++x) {
            if (!Character.isLetter(expString.charAt(x))) continue;
            String var = "";
            var = var + expString.charAt(x);
            String[] vars = new String[]{var};
            return vars;
        }
        return null;
    }

    public boolean isDecimal(String exp) {
        for (int i = 0; i < exp.length(); ++i) {
            if (exp.charAt(i) != '.') continue;
            return true;
        }
        return false;
    }

    public boolean isFraction(String exp) {
        for (int i = 0; i < exp.length(); ++i) {
            if (exp.charAt(i) != '/') continue;
            return true;
        }
        return false;
    }

    public String typecheck(String expString1, String expString2, Expression exp) {
        if (this.isDecimal(expString1) && !this.isFraction(expString2) || this.isDecimal(expString2) && !this.isFraction(expString1)) {
            return exp.expand(3).simplify().fractionToDecimal(false).toString();
        }
        return exp.expand(3).simplify().decimalToFraction().toString();
    }
}

