/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemGraph;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStEdge;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStEdgeData;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStNode;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class SimStProblemGraph
extends ProblemGraph {
    private SimStNode startNode;
    private SimStNode firstNode;
    private SimStEdge firstEdge;
    private int numSSNodes = 0;
    private int nodeUniqueIDGenerator = 0;

    public SimStProblemGraph(SimStNode startStateNode) {
        this.startNode = startStateNode;
        this.firstNode = null;
        this.firstEdge = null;
        ++this.numSSNodes;
    }

    public SimStProblemGraph() {
        this.startNode = null;
        this.firstNode = null;
        this.firstEdge = null;
        this.numSSNodes = 0;
    }

    public SimStNode addSSNode(SimStNode ssNode) {
        if (this.firstNode != null) {
            this.firstNode.setPrevNode(ssNode);
        }
        ssNode.setPrevNode(null);
        ssNode.setNextNode(this.firstNode);
        this.firstNode = ssNode;
        ++this.numSSNodes;
        return this.firstNode;
    }

    public SimStEdge addSSEdge(SimStNode node0, SimStNode node1, SimStEdgeData edgeData) {
        SimStNode source = node0;
        SimStNode destination = node1;
        SimStEdge edge = new SimStEdge(source, destination, edgeData);
        if (this.firstEdge != null) {
            this.firstEdge.previousEdge = edge;
        }
        edge.previousEdge = null;
        edge.nextEdge = this.firstEdge;
        this.firstEdge = edge;
        source.setOutDegree(source.getOutDegree() + 1);
        return edge;
    }

    public boolean containsEdge(SimStNode node0, SimStNode node1) {
        SimStEdge e = this.firstEdge;
        while (e != null) {
            if (e.source == node0 && e.dest == node1) {
                return true;
            }
            e = this.firstEdge.nextEdge;
        }
        return false;
    }

    public int getNodeUniqueIDGenerator() {
        ++this.nodeUniqueIDGenerator;
        return this.nodeUniqueIDGenerator;
    }

    public int outDegree(SimStNode node) {
        if (node == null) {
            return 0;
        }
        return node.getOutDegree();
    }

    @Override
    public int getNodeCount() {
        return this.numSSNodes;
    }

    @Override
    public SimStNode getFirstNode() {
        return this.firstNode;
    }

    public SimStNode getStartNode() {
        return this.startNode;
    }

    public void setStartNode(SimStNode startNode) {
        this.startNode = startNode;
    }

    public void resetGraph() {
        this.firstEdge = null;
        this.firstNode = null;
        this.numSSNodes = 0;
    }

    public void removeNode(SimStNode node) {
        SimStNode currentNode = node;
        SimStEdge e = this.firstEdge;
        while (e != null) {
            if (e.source == currentNode || e.dest == currentNode) {
                this.removeEdge(e);
            }
            e = e.nextEdge;
        }
        SimStNode prevNode = currentNode.getPrevNode();
        SimStNode nextNode = currentNode.getNextNode();
        if (prevNode == null) {
            this.firstNode = nextNode;
        } else {
            prevNode.setNextNode(nextNode);
        }
        if (nextNode != null) {
            nextNode.setPrevNode(prevNode);
        }
        --this.numSSNodes;
    }

    public void removeEdge(SimStEdge edge) {
        SimStEdge prevEdge = edge.previousEdge;
        SimStEdge nextEdge = edge.nextEdge;
        if (prevEdge == null) {
            this.firstEdge = nextEdge;
        } else {
            prevEdge.nextEdge = nextEdge;
        }
        if (nextEdge != null) {
            nextEdge.previousEdge = prevEdge;
        }
        edge.getSource().setOutDegree(edge.getSource().getOutDegree() - 1);
    }

    public SimStEdge lookUpSSEdge(SimStNode parentNode, SimStNode targetNode) {
        Enumeration<SimStEdge> connectingEdges = this.getConnectingEdges(parentNode);
        while (connectingEdges.hasMoreElements()) {
            SimStEdge edge = connectingEdges.nextElement();
            if (edge.getDest() != targetNode) continue;
            return edge;
        }
        return null;
    }

    public boolean isLeaf(SimStNode node) {
        return node.getOutDegree() == 0;
    }

    public Enumeration<SimStEdge> getIncomingEdges(SimStNode node) {
        return new EdgeEnumeration(node, true, false);
    }

    public Enumeration<SimStEdge> getOutgoingEdges(SimStNode node) {
        return new EdgeEnumeration(node, false, true);
    }

    public Enumeration<SimStEdge> getConnectingEdges(SimStNode node) {
        return new EdgeEnumeration(node, true, true);
    }

    public Enumeration<SimStNode> parents(SimStNode node) {
        return new ParentsEnumeration(node);
    }

    private class AllEdgeEnumeration
    implements Enumeration<SimStEdge> {
        SimStEdge currEdge;

        private AllEdgeEnumeration() {
            this.currEdge = SimStProblemGraph.this.firstEdge;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currEdge != null;
        }

        @Override
        public SimStEdge nextElement() {
            SimStEdge result = this.currEdge;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currEdge = this.currEdge.nextEdge;
            return result;
        }

        public void remove() {
            if (this.currEdge == null) {
                throw new IllegalStateException();
            }
            SimStProblemGraph.this.removeEdge(this.currEdge);
        }
    }

    private class ParentsEnumeration
    implements Enumeration<SimStNode> {
        private Enumeration<SimStEdge> allEdges;
        private SimStNode currNode;
        private SimStNode targetNode;

        private ParentsEnumeration(SimStNode ssNode) {
            this.targetNode = ssNode;
            this.allEdges = new AllEdgeEnumeration();
            this.currNode = this.scanNextNode();
        }

        SimStNode scanNextNode() {
            while (this.allEdges.hasMoreElements()) {
                SimStEdge edge = this.allEdges.nextElement();
                if (edge.dest != this.targetNode) continue;
                return edge.source;
            }
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currNode != null;
        }

        @Override
        public SimStNode nextElement() {
            SimStNode result = this.currNode;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currNode = this.scanNextNode();
            return result;
        }

        public void remove() {
            if (this.currNode == null) {
                throw new IllegalStateException();
            }
            SimStProblemGraph.this.removeNode(this.currNode);
        }
    }

    private class EdgeEnumeration
    implements Enumeration<SimStEdge> {
        private Enumeration<SimStEdge> allEdges;
        SimStEdge currEdge;
        private SimStNode targetNode;
        private boolean incoming;
        private boolean outgoing;

        private EdgeEnumeration(SimStNode node, boolean incoming, boolean outgoing) {
            this.allEdges = new AllEdgeEnumeration();
            this.targetNode = node;
            this.outgoing = outgoing;
            this.incoming = incoming;
            this.currEdge = this.scanNextEdge();
        }

        SimStEdge scanNextEdge() {
            while (this.allEdges.hasMoreElements()) {
                SimStEdge edge = this.allEdges.nextElement();
                if (this.incoming && edge.dest == this.targetNode) {
                    return edge;
                }
                if (!this.outgoing || edge.source != this.targetNode) continue;
                return edge;
            }
            return null;
        }

        @Override
        public boolean hasMoreElements() {
            return this.currEdge != null;
        }

        @Override
        public SimStEdge nextElement() {
            SimStEdge result = this.currEdge;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.currEdge = this.scanNextEdge();
            return result;
        }

        public void remove() {
            if (this.currEdge == null) {
                throw new IllegalStateException();
            }
            SimStProblemGraph.this.removeEdge(this.currEdge);
        }
    }
}

