/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.JessOracleRete;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.miss.InquiryClSolverTutor;
import edu.cmu.pact.miss.JessOracle;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStNode;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import java.util.List;
import java.util.Vector;
import jess.JessException;

public class InquiryJessOracle
extends InquiryClSolverTutor {
    JessOracleRete oracleRete;
    BR_Controller brController = null;
    SimSt simSt;
    ProblemNode currentNode;
    private JessOracle jessOracle;
    RuleActivationNode nextStepRuleActivationNode = null;
    boolean isAgendaEmpty = true;
    public Vector<RuleActivationNode> altSug = null;
    boolean filesloaded = false;

    private void setJessOracleRete(JessOracleRete oracleRete) {
        this.oracleRete = oracleRete;
    }

    public JessOracleRete getJessOracleRete() {
        return this.oracleRete;
    }

    private void setBrController(BR_Controller brController) {
        this.brController = brController;
    }

    private BR_Controller getBrController() {
        return this.brController;
    }

    private void setSimSt(SimSt simSt) {
        this.simSt = simSt;
    }

    private SimSt getSimSt() {
        return this.simSt;
    }

    private void setCurrentNode(ProblemNode currentNode) {
        this.currentNode = currentNode;
    }

    private ProblemNode getCurrentNode() {
        return this.currentNode;
    }

    public JessOracle getJessOracle() {
        return this.jessOracle;
    }

    public void setJessOracle(JessOracle jessOracle) {
        this.jessOracle = jessOracle;
    }

    void setNextStepRuleActivationNode(RuleActivationNode nextStepRuleActivationNode) {
        this.nextStepRuleActivationNode = nextStepRuleActivationNode;
    }

    RuleActivationNode getNextStepRuleActivationNode() {
        return this.nextStepRuleActivationNode;
    }

    private void setIsAgendaEmpty(boolean flag) {
        this.isAgendaEmpty = flag;
    }

    public boolean getIsAgendaEmpty() {
        return this.isAgendaEmpty;
    }

    public InquiryJessOracle(SimSt simSt, BR_Controller brController) {
        this.setJessOracleRete(new JessOracleRete(brController));
        this.setSimSt(simSt);
        this.setBrController(brController);
        this.altSug = new Vector();
    }

    public void init(String problemName) {
        try {
            this.oracleRete.init(problemName, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Sai askNexStep() {
        this.altSug.clear();
        Vector<RuleActivationNode> oracleAgenda = this.getJessOracleAgenda();
        oracleAgenda = this.removeDuplicateSai(oracleAgenda);
        if (oracleAgenda.size() == 0) {
            return null;
        }
        this.altSug = oracleAgenda;
        this.setNextStepRuleActivationNode(oracleAgenda.get(0));
        String sel = oracleAgenda.get(0).getActualSelection();
        String act = oracleAgenda.get(0).getActualAction();
        String inp = oracleAgenda.get(0).getActualInput();
        Sai hintSai = new Sai(sel, act, inp);
        return hintSai;
    }

    @Override
    public boolean isCorrectStep(String selection, String action, String input) {
        boolean isCorrectStep = false;
        Vector<RuleActivationNode> oracleAgenda = this.getJessOracleAgenda();
        Vector suggestions = new Vector();
        if (oracleAgenda.isEmpty()) {
            this.setIsAgendaEmpty(true);
        }
        for (RuleActivationNode ran : oracleAgenda) {
            Sai temp = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
            if (!this.simSt.isStepModelTraced(selection, action, input, temp.getS(), temp.getA(), temp.getI())) continue;
            this.simSt.setSaiCache(new Sai(selection, action, input));
            isCorrectStep = true;
        }
        return isCorrectStep;
    }

    public String[] getHintMessages() {
        if (this.getNextStepRuleActivationNode() == null) {
            return null;
        }
        return this.getHintMessages(this.getNextStepRuleActivationNode());
    }

    private String[] getHintMessages(RuleActivationNode ran) {
        Vector hintMessages = ran.getHintMessages();
        for (int i = 0; i < hintMessages.size(); ++i) {
            hintMessages.set(i, this.convertInterfaceElementNames((String)hintMessages.get(i)));
        }
        return hintMessages.toArray(new String[hintMessages.size()]);
    }

    private String convertInterfaceElementNames(String msg) {
        String[] words = msg.split(" ");
        String newMsg = "";
        for (String word : words) {
            String convertedComponentName = this.brController.getMissController().getSimStPLE().getComponentName(word);
            if (convertedComponentName != null) {
                word = convertedComponentName;
            }
            newMsg = newMsg + word + " ";
        }
        return newMsg;
    }

    public Vector<RuleActivationNode> getJessOracleAgenda() {
        Vector<RuleActivationNode> activationList = new Vector<RuleActivationNode>();
        try {
            RuleActivationTree tree = this.brController.getRuleActivationTree();
            RuleActivationTree.TreeTableModel ttm = tree.getActivationModel();
            RuleActivationNode root = (RuleActivationNode)ttm.getRoot();
            root.saveState(this.oracleRete);
            List wholeAgenda = this.oracleRete.getAgendaAsList(null);
            root.createChildren(wholeAgenda, false);
            List children = root.getChildren();
            JessModelTracing jmt = this.oracleRete.getJmt();
            for (int i = 0; i < children.size(); ++i) {
                RuleActivationNode child = (RuleActivationNode)children.get(i);
                root.setUpStateOracle(this.oracleRete, i);
                jmt.setNodeNowFiring(child);
                child.fireOracle(this.oracleRete);
                jmt.setNodeNowFiring(null);
                activationList.add(child);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        activationList = this.removeDuplicateSai(activationList);
        return activationList;
    }

    @Override
    public int goToState(BR_Controller brController, ProblemNode problemNode) {
        this.setCurrentNode(problemNode);
        this.setBrController(brController);
        try {
            if (this.getSimSt().getSsInteractiveLearning() != null && this.getSimSt().getSsInteractiveLearning().isTakingQuiz()) {
                SimStNode currentNode = this.getSimSt().getcurrentSsNode();
                if (currentNode != null) {
                    if (currentNode.getParents().isEmpty()) {
                        this.oracleRete.reset();
                        this.oracleRete.restoreInitialWMState(currentNode, true);
                    } else {
                        SimStNode startNode = currentNode.getProblemGraph().getStartNode();
                        Vector vec = currentNode.findPathToNode(currentNode);
                        this.oracleRete.reset();
                        this.oracleRete.goToWMState(startNode, vec, true);
                    }
                }
            } else if (problemNode != null && !problemNode.getParents().isEmpty()) {
                if (this.simSt.isValidationMode()) {
                    SimStNode startNode = this.getSimSt().getValidationGraph().getStartNode();
                    Vector vec = InquiryJessOracle.findPathDepthFirst(startNode, problemNode);
                    this.oracleRete.reset();
                    this.oracleRete.goToWMState(startNode, vec, true);
                } else {
                    ProblemNode startNode = brController.getProblemModel().getStartNode();
                    Vector vec = InquiryJessOracle.findPathDepthFirst(startNode, problemNode);
                    this.oracleRete.reset();
                    this.oracleRete.goToWMState(startNode, vec, true);
                }
            }
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        return 0;
    }

    Vector<RuleActivationNode> removeDuplicateSai(Vector<RuleActivationNode> activationList) {
        Vector<Sai> goodSais = new Vector<Sai>();
        Vector<RuleActivationNode> goodActivationList = new Vector<RuleActivationNode>();
        for (RuleActivationNode ran : activationList) {
            Sai sai = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
            if (goodSais.contains(sai)) continue;
            goodSais.add(sai);
            goodActivationList.add(ran);
        }
        return goodActivationList;
    }
}

