/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.PredictObservableAction;
import edu.cmu.pact.jess.SimStJessModelTracing;
import jess.Context;
import jess.Funcall;
import jess.JessException;
import jess.Value;
import jess.ValueVector;

public class PredictStoichInput
extends PredictObservableAction {
    private static final String PREDICT_STOICH_INPUT = "predict-stoich-input";

    public PredictStoichInput() {
    }

    public PredictStoichInput(JessModelTracing jmt) {
    }

    @Override
    public String getName() {
        return PREDICT_STOICH_INPUT;
    }

    @Override
    public Value call(ValueVector vv, Context context) throws JessException {
        this.context = context;
        if (!vv.get(0).stringValue(context).equals(PREDICT_STOICH_INPUT)) {
            throw new JessException(PREDICT_STOICH_INPUT, "called but ValueVector head differs", vv.get(0).stringValue(context));
        }
        String predictedSelection = "NotSpecified";
        String predictedAction = "NotSpecified";
        String predictedInput = "NotSpecified";
        if (this.getJmt() == null || !this.getJmt().isModelTracing()) {
            return Funcall.TRUE;
        }
        if (vv.size() > 1) {
            predictedSelection = vv.get(1).resolveValue(context).stringValue(context);
            if (vv.size() > 2) {
                predictedAction = vv.get(2).resolveValue(context).stringValue(context);
                if (vv.size() > 3) {
                    predictedInput = vv.get(3).resolveValue(context).stringValue(context);
                }
            }
        }
        if (predictedSelection == "NotSpecified" && predictedAction == "NotSpecified" && predictedInput == "NotSpecified") {
            throw new JessException(PREDICT_STOICH_INPUT, "at least one selection, action or input argument must be specified", "NotSpecified");
        }
        int matchResult = 3;
        this.jmt.setRuleSAI(predictedSelection, predictedAction, predictedInput);
        if (!this.jmt.isHintTrace()) {
            try {
                matchResult = ((SimStJessModelTracing)this.jmt).testFiringNodeSAI_StoMatcher(predictedSelection, predictedAction, predictedInput);
            }
            catch (ClassCastException cce) {
                throw new ClassCastException("(" + this.getName() + ") requires the Sim Student version of CTAT; the current version is " + VersionInformation.getReleaseString() + ", which " + (VersionInformation.includesSimSt() ? "should" : "does not") + " include Sim Student; nested exception: " + cce);
            }
        } else {
            matchResult = this.jmt.testFiringNodeSelection(predictedSelection, context);
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "(predict-stoich-input " + predictedSelection + " " + predictedAction + " " + predictedInput + ") returns " + matchResult);
        }
        Value result = Funcall.TRUE;
        if (!this.jmt.isHintTrace() && matchResult == 2) {
            this.jmt.haltRete(this.getName());
            result = Funcall.FALSE;
        }
        if (trace.getDebugCode("mt")) {
            trace.out("mt", "predict-stoich-input returning " + result.stringValue(context));
        }
        return result;
    }
}

