/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences.Content;

import edu.cmu.pact.Log.LogDifferences.Content.ColumnFormatter;

public class ContentCell {
    private final String fieldType;
    private final int index;
    private final String propertyName;
    private final String content;
    private final ColumnFormatter formatter;

    ContentCell(String fieldType, int index, String propertyName, String content, ColumnFormatter formatter) {
        this.fieldType = fieldType;
        this.index = index;
        this.propertyName = propertyName;
        this.content = content;
        this.formatter = formatter;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public int getIndex() {
        return this.index;
    }

    public String getContent() {
        return this.content;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getColumnName() {
        return this.formatter.makeColumnName(this.fieldType, this.index, this.propertyName);
    }

    public static class ContentCellBuilder {
        private String fieldType = null;
        private int index = -1;
        private String propertyName = null;
        private String content = null;
        private ColumnFormatter formatter = null;

        public ContentCellBuilder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public ContentCellBuilder index(int index) {
            this.index = index;
            return this;
        }

        public ContentCellBuilder propertyName(String propertyName) {
            this.propertyName = propertyName;
            return this;
        }

        public ContentCellBuilder content(String content) {
            this.content = content;
            return this;
        }

        public ContentCellBuilder formatter(ColumnFormatter formatter) {
            this.formatter = formatter;
            return this;
        }

        public ContentCell buildCell() {
            if (this.fieldType == null) {
                throw new IllegalStateException("Missing required field type");
            }
            if (this.content == null) {
                throw new IllegalStateException("Missing required content");
            }
            if (this.formatter == null) {
                throw new IllegalStateException("Missing required ColumnFormatter");
            }
            return new ContentCell(this.fieldType, this.index, this.propertyName, this.content, this.formatter);
        }
    }
}

