/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.CommManager;

import edu.cmu.pact.BehaviorRecorder.Controller.HintMessagesManagerImpl;
import edu.cmu.pact.BehaviorRecorder.View.HintWindow.HintWindowInterface;
import edu.cmu.pact.CommManager.CommMessageHandler;
import edu.cmu.pact.CommManager.RemoteTutor;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.client.HintMessagesManager;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MsgType;
import java.util.concurrent.ConcurrentLinkedQueue;

public class RemoteCommMessageHandler
implements CommMessageHandler {
    private HintMessagesManager _mgr;
    private HintWindowInterface _panel;
    private ConcurrentLinkedQueue<MessageObject> _msgQueue;
    private RemoteTutor _remoteTutor;

    public RemoteCommMessageHandler(HintMessagesManager manager) {
        this._mgr = manager;
    }

    public RemoteCommMessageHandler() {
        this(new HintMessagesManagerImpl(null));
    }

    public void setRemoteTutor(RemoteTutor remoteTutor) {
        this._remoteTutor = remoteTutor;
    }

    private RemoteTutor remoteTutor() {
        if (this._remoteTutor == null) {
            this._remoteTutor = new RemoteTutor(){

                @Override
                public String getLatestFocus() {
                    return "table1_C5R1";
                }
            };
        }
        return this._remoteTutor;
    }

    public void setHintInterface(HintWindowInterface panel) {
        this._panel = panel;
    }

    public HintMessagesManager messagesManager() {
        return this._mgr;
    }

    @Override
    public boolean getShowWidgetInfo() {
        return false;
    }

    private ConcurrentLinkedQueue<MessageObject> msgQueue() {
        if (this._msgQueue == null) {
            this._msgQueue = new ConcurrentLinkedQueue();
        }
        return this._msgQueue;
    }

    public boolean hasMessage() {
        return !this.msgQueue().isEmpty();
    }

    public String nextMessage() {
        if (!this.hasMessage()) {
            return null;
        }
        MessageObject mo = (MessageObject)this.msgQueue().remove();
        try {
            trace.out("sp", "selection: " + mo.getProperty("Selection"));
            trace.out("sp", "mo before: " + mo);
            trace.out("sp", "mo before: " + mo.toXML());
            if (mo.matchProperty("Selection", "hint")) {
                String latestFocus = this.remoteTutor().getLatestFocus();
                trace.out("sp", "latestFocus = " + latestFocus);
                if (latestFocus != null) {
                    mo.addPropertyElement("Action", "PreviousFocus");
                    mo.addPropertyElement("Selection", latestFocus);
                }
                trace.out("sp", "mo after: " + mo);
                trace.out("sp", "mo after: " + mo.toXML());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return mo.toXML();
    }

    private boolean isHintRelated(MessageObject mo) {
        return MsgType.hasTextFeedback(mo);
    }

    @Override
    public void sendMessage(MessageObject mo) {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", this.getClass().getName() + ".sendCommMessage(" + mo + ")");
        }
        this.msgQueue().add(mo);
    }

    public void handleCommMessage(MessageObject messageObject) {
    }

    @Override
    public boolean lockWidget() {
        return false;
    }

    @Override
    public void handleMessage(MessageObject messageObject) {
        this.sendMessage(messageObject);
    }
}

