/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.CommManager;

import edu.cmu.old_pact.dormin.MissingParameterException;
import edu.cmu.old_pact.dormin.ObjectProxy;
import edu.cmu.pact.CommManager.CommMessageReceiver;
import edu.cmu.pact.SocketProxy.XMLConverter;
import edu.cmu.pact.Utilities.VersionInformation;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.TutorController;
import java.util.Hashtable;
import pact.CommWidgets.JCommWidgetsToolProxy;

public class CommManager {
    private static CommManager instance;
    private Hashtable receivers = new Hashtable();

    private CommManager() {
    }

    public void addMessageReceiver(CommMessageReceiver rcvr, String componentName, TutorController controller) {
        if (!VersionInformation.includesCL()) {
            return;
        }
        if (controller.getUniversalToolProxy() == null) {
            return;
        }
        JCommWidgetsToolProxy childProxy = new JCommWidgetsToolProxy("Component", componentName, (ObjectProxy)controller.getUniversalToolProxy().getToolProxy(), componentName);
        this.registerMessageReceiver(rcvr, childProxy.toString());
    }

    public void registerMessageReceiver(CommMessageReceiver m, String objectDescription) {
        this.receivers.put(objectDescription, m);
    }

    public void sendJavaMessage(edu.cmu.old_pact.dormin.MessageObject o) {
        String object = "";
        try {
            object = o.getParameter("OBJECT").toString();
        }
        catch (MissingParameterException e) {
            return;
        }
        CommMessageReceiver dmr = (CommMessageReceiver)this.receivers.get(object);
        MessageObject mo = XMLConverter.commToNewMO(o);
        if (dmr != null) {
            dmr.receiveMessage(mo);
        }
    }

    public void sendJavaMessage(MessageObject o) {
        String object = "";
        object = (String)o.getProperty("OBJECT");
        CommMessageReceiver dmr = (CommMessageReceiver)this.receivers.get(object);
        if (dmr != null) {
            dmr.receiveMessage(o);
        }
    }

    public static void addCommListener(String componentName, CommMessageReceiver rcvr, TutorController ctlr) {
        if (!VersionInformation.includesCL()) {
            return;
        }
        if (ctlr == null || ctlr.getUniversalToolProxy() == null || ctlr.getUniversalToolProxy().getToolProxy() == null) {
            return;
        }
        JCommWidgetsToolProxy childProxy = new JCommWidgetsToolProxy("Component", componentName, (ObjectProxy)ctlr.getUniversalToolProxy().getToolProxy(), componentName);
        CommManager.instance().registerMessageReceiver(rcvr, childProxy.toString());
    }

    public static String extractComponentName(MessageObject mo) {
        Object object = mo.getProperty("OBJECT");
        if (object == null) {
            return null;
        }
        String commComponentName = ((JCommWidgetsToolProxy)((Object)object)).getWidgetName();
        return commComponentName;
    }

    public static CommManager instance() {
        if (instance == null) {
            instance = new CommManager();
        }
        return instance;
    }
}

