/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.View.BRPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.border.Border;

public class BR_Label
extends JLabel {
    private static final long serialVersionUID = -1589866493382948539L;
    private int uniqueID;
    Border lineBorder;
    FontMetrics fontMetrics;
    final Font largeFont = null;
    protected int padX = 10;
    protected int padY = 4;
    protected final int MAX_WIDTH = 100;
    protected final int widthPad = 25;

    public BR_Label() {
        this("unnamed", null);
    }

    public BR_Label(String labelTextP, EdgeData edgeData) {
        super(labelTextP);
        this.setFont(BRPanel.SMALL_FONT);
        this.setHorizontalAlignment(0);
        this.setVisible(true);
        if (edgeData != null) {
            this.uniqueID = edgeData.getUniqueID();
        }
        this.lineBorder = BorderFactory.createLineBorder(Color.black);
        this.setBorder(this.lineBorder);
        this.doSize();
        this.setOpaque(true);
    }

    public void doSize() {
        if (this.getFont() == null) {
            return;
        }
        this.fontMetrics = this.getFontMetrics(this.getFont());
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        Font font = this.getFont();
        if (font != null) {
            this.fontMetrics = this.getFontMetrics(font);
            int width = Math.min(100, this.fontMetrics.stringWidth(text));
            int height = this.fontMetrics.getHeight();
            this.setSize(new Dimension(width + 25, height + this.padX));
        }
    }

    public void resetSize() {
        Font font = this.getFont();
        if (font == null) {
            font = BRPanel.SMALL_FONT;
        }
        this.fontMetrics = this.getFontMetrics(font);
        int width = this.fontMetrics.stringWidth(this.getText());
        if (this.getIcon() != null) {
            width += this.getIcon().getIconWidth() + 2;
        }
        int height = this.fontMetrics.getHeight();
        this.setSize(new Dimension(width + this.padX, height + this.padY));
    }

    public boolean equals(BR_Label label) {
        return this.uniqueID == label.uniqueID;
    }

    public int getUniqueID() {
        return this.uniqueID;
    }

    public void setUniqueID(int uniqueIDValue) {
        this.uniqueID = uniqueIDValue;
    }
}

