/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Functions;

import java.util.HashSet;

public class plural {
    private static char[] Consonants = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'z'};
    private static final HashSet<Character> consonantSet = new HashSet();

    private static boolean isConsonant(String word, int index) {
        if (word == null || word.length() <= index) {
            return false;
        }
        char c = Character.toLowerCase(word.charAt(index));
        return consonantSet.contains(new Character(c));
    }

    public String plural(int count, String word) {
        if (word == null || word.length() < 1) {
            return word;
        }
        if (count < 2) {
            return word;
        }
        String wordL = word.toLowerCase();
        if (wordL.endsWith("s")) {
            return this.plural(count, word, "", "es");
        }
        if (wordL.endsWith("y") && plural.isConsonant(wordL, wordL.length() - 2)) {
            return this.plural(count, word, "y", "ies");
        }
        return word + "s";
    }

    public String plural(int count, String word, String suffixToStrip, String suffixToAdd) {
        int index;
        int len;
        StringBuffer result;
        if (word == null || word.length() < 1) {
            return word;
        }
        if (count < 2) {
            return word;
        }
        String wordL = word.toLowerCase();
        String toStripL = (suffixToStrip == null ? "" : suffixToStrip).toLowerCase();
        if (suffixToAdd == null) {
            suffixToAdd = "";
        }
        if (Character.isUpperCase((result = new StringBuffer(word)).charAt((len = result.length()) - 1))) {
            suffixToAdd = suffixToAdd.toUpperCase();
        }
        if ((index = wordL.lastIndexOf(toStripL)) > 0) {
            result.replace(index, len, suffixToAdd);
        } else {
            result.append(suffixToAdd);
        }
        return result.toString();
    }

    public static void usageExit(String intro) {
        if (intro != null && intro.length() > 0) {
            System.err.printf("%s. ", intro);
        }
        System.err.println("Usage:\n  java -cp classpath " + plural.class.getName() + " count word [toStrip toAdd]\nwhere--\n  count   should be an integer showing the number;\n  word    is the singular form of the word to modify;\n  toStrip is the suffix to delete;\n  toAdd   is the plural suffix to append.\n");
        System.exit(2);
    }

    public static void main(String[] args) {
        int count = 0;
        if (args.length < 2) {
            plural.usageExit("Missing argument(s)");
        }
        try {
            count = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException nfe) {
            plural.usageExit("First argument '" + args[0] + "' must be an integer");
        }
        String word = args[1];
        plural p = new plural();
        if (args.length < 3) {
            System.out.printf("%2d %-15s => %s\n", count, word, p.plural(count, word));
        } else {
            String toStrip = args[2];
            String toAdd = args.length < 4 ? null : args[3];
            System.out.printf("%2d %-15s => %s\n", count, word, p.plural(count, word, toStrip, toAdd));
        }
    }

    static {
        for (char c : Consonants) {
            consonantSet.add(new Character(c));
        }
    }
}

