/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.hcii.ctat.CTATRandom;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CtatModeEvent;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageBuilder;
import edu.cmu.pact.BehaviorRecorder.Controller.PseudoTutorMessageHandler;
import edu.cmu.pact.BehaviorRecorder.Controller.RuleLabelHandler;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.DialogueSystemInfo;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.CTATFunctions;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherFactory;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.CheckLispLabel;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.Skill;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.jdom.Content;
import org.jdom.Element;
import pact.CommWidgets.JCommButton;
import pact.CommWidgets.JCommRadioButton;
import pact.CommWidgets.JCommWidget;
import pact.CommWidgets.UniversalToolProxy;

public class EdgeData
implements Serializable {
    private static final long serialVersionUID = 7752570842488326993L;
    private ActionLabel actionLabel;
    private CheckLispLabel preLispCheckLabel;
    private ProblemEdge edge;
    private boolean updatedInSkillometer = false;
    private int traversalCount;
    private int minTraversals = 1;
    private String minTraversalsStr = Integer.toString(this.minTraversals);
    private int maxTraversals = 1;
    private String maxTraversalsStr = Integer.toString(this.maxTraversals);
    private String dialogueName = "";
    private boolean step_Succesful_Completion = false;
    private boolean step_Student_Error = false;
    private DialogueSystemInfo dialogueSystemInfo;
    private Vector<RuleLabel> ruleLabels = null;
    private Vector<String> ruleNames;
    private ProblemModel problemModel;
    private MessageObject demoMsgObj;
    private String actionType = "Correct Action";
    private String oldActionType;
    private String buggyMsg = "";
    private String successMsg;
    private Vector<String> interpolatedHints;
    private Vector<String> hints = new Vector();
    private String interpolateSelection;
    private String interpolateAction;
    private String interpolateInput;
    private boolean isPreferredEdge;
    private String callbackFn = "";
    private Object studentInput;
    private Object studentAction;
    private Object studentSelection;
    private String actor = "Student";
    protected Matcher matcher;
    private Vector associatedElements = new Vector();
    private Vector associatedElementsValues = new Vector();
    private String checkedStatus;
    private int localUniqueID = -1;
    public static final String CORRECT_ACTION = "Correct Action";
    public static final String CLT_ERROR_ACTION = "Error Action";
    public static final String UNTRACEABLE_ERROR = "Untraceable Error";
    public static final String BUGGY_ACTION = "Buggy Action";
    public static final String FIREABLE_BUGGY_ACTION = "Fireable Buggy Action";
    private static EdgeData _copyData;
    public static final String HINT_ACTION = "Hint Action";
    public static final String GIVEN_ACTION = "Given Action";
    public static final String SKIP_ACTION = "Skip Action";
    public static final String UNKNOWN_ACTION = "Unknown Action";
    public static final String NEVER_CHECKED = "Never Checked";
    public static final String FIREABLE_BUG = "FIREABLE-BUG";
    public static final String SUCCESS = "SUCCESS";
    public static final String NO_MODEL = "NO-MODEL";
    public static final String UNEVALUATED = "UNEVALUATED";
    public static final String NOTAPPLICABLE = "No-Applicable";
    public static final String BUGGY = "BUG";
    public static final String TABLE_FRONT = "Please enter '";
    public static final String TABLE_REAR = "' in the highlighted cell.";
    public static final String COMBOBOX_FRONT = "Please select '";
    public static final String COMBOBOX_REAR = "' from the highlighted menu.";
    public static final String CHOOSER_FRONT = "Please select '";
    public static final String CHOOSER_REAR = "' from the left one of the two highlighted lists. Then click on '>>' to move the value over to the list on the right.";
    public static final String LIST_FRONT = "Please select '";
    public static final String LIST_REAR = "' from the highlighted list.";
    public static final String TEXTFIELD_FRONT = "Please enter '";
    public static final String TEXTFIELD_REAR = "' in the highlighted field.";
    public static final String TEXTAREA_FRONT = "Please enter '";
    public static final String TEXTAREA_REAR = "' in the highlighted field.";
    public static final String BUTTON_DEFAULT = "Please click on the highlighted button.";
    public static final String BUTTON_FRONT = "Please click on the highlighted button ('";
    public static final String BUTTON_REAR = "').";
    public static final String DONE_BUTTON_FRONT = "You have answered all the questions. Please click on the ";
    public static final String DONE_BUTTON_REAR = " button to proceed to the next problem.";
    public static final String RADIOBUTTON_DEFAULT = "Please choose among the highlighted radio buttons.";
    public static final String RADIOBUTTON_FRONT = "Please select '";
    public static final String RADIOBUTTON_REAR = "' from the highlighted items.";
    public static final String COMPOSER_FRONT = "Please use the highlighted menus to input '";
    public static final String COMPOSER_REAR = "' -  click on 'Add' once you have made the right menu selections.";
    public static final String DEFAULT_HINT_FRONT = "Please provide your answer '";
    public static final String DEFAULT_HINT_REAR = "' in the highlighted element.";
    public static final Color PlainColor;
    public static final Color TPAColor;
    private int[] modifiedHintOrder = null;
    private static final Pattern UniqueIDInXML;

    public void restoreTransients(BR_Controller controller) {
        if (this.actionLabel != null) {
            this.actionLabel.restoreTransients(controller);
        }
        if (this.preLispCheckLabel != null) {
            this.preLispCheckLabel.restoreTransients(controller);
        }
        if (this.dialogueSystemInfo != null) {
            this.dialogueSystemInfo.restoreTransients(controller);
        }
        if (this.ruleLabels != null) {
            for (RuleLabel rl : this.ruleLabels) {
                rl.restoreTransients(controller);
            }
        }
    }

    public EdgeData() {
    }

    public EdgeData(ProblemModel problemModel) {
        this(problemModel, null, null, null);
    }

    public EdgeData(ProblemModel problemModel, Vector selection, Vector action, Vector input) {
        BR_Controller ctlr;
        this.problemModel = problemModel;
        this.setUniqueID(problemModel.getNextEdgeUniqueIDGenerator());
        if (!Utils.isRuntime()) {
            this.setActionLabel(new ActionLabel(this, problemModel));
        }
        if ((ctlr = problemModel.getController()) != null && !Utils.isRuntime()) {
            this.setPreLispCheckLabel(new CheckLispLabel(this, ctlr));
        }
        this.setCheckedStatus(NEVER_CHECKED);
        this.setActionType(CORRECT_ACTION);
        this.setOldActionType(CORRECT_ACTION);
        this.setBuggyMsg("No, this is not correct.");
        this.setSuccessMsg("");
        this.setHints(new Vector());
        this.setPreferredEdge(false);
        this.setMatcher(selection == null ? new ExactMatcher() : this.createVectorMatcher(selection, action, input));
        if (ctlr != null) {
            this.dialogueSystemInfo = new DialogueSystemInfo(ctlr);
        }
    }

    private VectorMatcher createVectorMatcher(Vector selection, Vector action, Vector input) {
        boolean concat2 = true;
        List<Matcher> sList = this.createChildMatcher(selection, 0, concat2);
        List<Matcher> aList = this.createChildMatcher(action, 1, concat2);
        List<Matcher> iList = this.createChildMatcher(input, 2, concat2);
        String actor = "Student";
        VectorMatcher vm = new VectorMatcher(concat2, sList, aList, iList, actor);
        return vm;
    }

    private List<Matcher> createChildMatcher(Vector<String> saiElement, int role, boolean concat2) {
        if (saiElement == null) {
            saiElement = new Vector();
        }
        StringBuilder saiEltConcat = new StringBuilder();
        if (concat2) {
            for (String s : saiElement) {
                saiEltConcat.append(s);
            }
        } else {
            saiEltConcat.append(saiElement.size() > 0 ? saiElement.get(0) : "");
        }
        Matcher m = null;
        String mType = "ExactMatcher";
        try {
            m = MatcherFactory.buildSingleMatcher(mType, concat2, role);
        }
        catch (Exception e) {
            String errMsg = "EdgeData.createChildMatcher() error from MatcherFactory creating " + mType;
            trace.errStack(errMsg, e);
            throw new RuntimeException(errMsg, e);
        }
        m.setSingle(saiEltConcat.toString());
        if (trace.getDebugCode("demo")) {
            trace.out("demo", "created matcher " + m.getClass() + " for SAI element " + saiElement);
        }
        if (this.getController() != null) {
            m.setSessionStorage(this.getController().getSessionStorage());
        }
        LinkedList<Matcher> result = new LinkedList<Matcher>();
        result.add(m);
        return result;
    }

    public ProblemModel getProblemModel() {
        return this.problemModel;
    }

    public DialogueSystemInfo getDialogueSystemInfo() {
        return this.dialogueSystemInfo;
    }

    public EdgeData cloneEdgeData() {
        return this.cloneEdgeData(this.problemModel);
    }

    public EdgeData cloneEdgeData(ProblemModel problemModel) {
        EdgeData newEdgeData = new EdgeData(problemModel);
        newEdgeData.setActor(this.getActor());
        newEdgeData.setSelection(this.copyVector(this.getSelection()));
        newEdgeData.setAction(this.copyVector(this.getAction()));
        newEdgeData.setInput(this.copyVector(this.getInput()));
        newEdgeData.setDemoMsgObj(this.getDemoMsgObj().copy());
        newEdgeData.setActionType(this.getActionType());
        newEdgeData.setHints(this.copyVector(this.getAllHints()));
        newEdgeData.setBuggyMsg(this.getBuggyMsg());
        newEdgeData.setSuccessMsg(this.getSuccessMsg());
        newEdgeData.setPreferredEdge(this.isPreferredEdge());
        newEdgeData.setOldActionType(this.getOldActionType());
        newEdgeData.setMatcher((Matcher)this.getMatcher().clone());
        newEdgeData.setMinTraversalsStr(this.getMinTraversalsStr());
        newEdgeData.setMaxTraversalsStr(this.getMaxTraversalsStr());
        newEdgeData.getPreLispCheckLabel().resetCheckedStatus(this.getPreLispCheckLabel() == null ? NOTAPPLICABLE : this.getPreLispCheckLabel().getCheckedStatus());
        newEdgeData.ruleNames = (Vector)this.ruleNames.clone();
        newEdgeData.ruleLabels = null;
        return newEdgeData;
    }

    public Vector copyVector(Vector fromVector) {
        Vector toVector = new Vector();
        if (fromVector == null) {
            return toVector;
        }
        for (int i = 0; i < fromVector.size(); ++i) {
            toVector.addElement(fromVector.elementAt(i));
        }
        return toVector;
    }

    public boolean getUpdatedInSkillometer() {
        return this.updatedInSkillometer;
    }

    public void setUpdatedInSkillometer(boolean updated) {
        this.updatedInSkillometer = updated;
    }

    public ProblemNode getSourceProblemNode() {
        if (this.edge == null) {
            return null;
        }
        return this.edge.getNodes()[0];
    }

    public void incrementTraversalCount() {
        ++this.traversalCount;
        if (this.actionLabel != null) {
            this.actionLabel.update();
        }
    }

    public int getTraversalCount() {
        return this.traversalCount;
    }

    public void setTraversalCount(int newCount) {
        this.traversalCount = newCount;
    }

    public ActionLabel getActionLabel() {
        return this.actionLabel;
    }

    public ProblemNode getEndProblemNode() {
        if (this.edge == null) {
            return null;
        }
        return this.edge.getNodes()[1];
    }

    public void setEdge(ProblemEdge e) {
        this.edge = e;
    }

    public ProblemEdge getEdge() {
        return this.edge;
    }

    public boolean isDone() {
        Vector s = this.getSelection();
        Vector a = this.getAction();
        if (s.size() > 0 && a.size() > 0) {
            return "Done".equalsIgnoreCase((String)s.get(0)) && "ButtonPressed".equalsIgnoreCase((String)a.get(0));
        }
        return false;
    }

    public Vector<RuleLabel> getRuleLabels() {
        if (this.ruleLabels == null) {
            this.createRuleLabels();
        }
        return this.ruleLabels;
    }

    private void createRuleLabels() {
        this.ruleLabels = new Vector();
        if (this.getRuleNames() == null) {
            return;
        }
        for (String ruleName : this.getRuleNames()) {
            RuleLabel ruleLabel = new RuleLabel(ruleName, this.getController());
            this.ruleLabels.addElement(ruleLabel);
            ruleLabel.addMouseListener(new RuleLabelHandler(ruleLabel, this.getEdge(), this.getController()));
        }
    }

    public Vector<String> getSkills() {
        if (this.getRuleNames() == null) {
            return new Vector<String>();
        }
        return (Vector)this.getRuleNames().clone();
    }

    public boolean hasRealRule() {
        if (this.getRuleNames() == null) {
            return false;
        }
        for (String ruleName : this.getRuleNames()) {
            if (ruleName.indexOf(" ") <= 0) continue;
            return true;
        }
        return false;
    }

    public int getMinTraversals() {
        return this.minTraversals;
    }

    public String getMinTraversalsStr() {
        return this.minTraversalsStr;
    }

    public void setMinTraversals(int minTraversals) {
        this.minTraversals = minTraversals;
        this.minTraversalsStr = Integer.toString(minTraversals);
    }

    public void setMinTraversalsStr(String minTraversals) {
        if (minTraversals == null || minTraversals.length() < 1) {
            this.minTraversalsStr = "1";
            this.minTraversals = 1;
        } else {
            try {
                this.minTraversalsStr = minTraversals;
                this.minTraversals = Integer.parseInt(minTraversals.trim());
            }
            catch (Exception e) {
                this.minTraversals = 1;
            }
        }
    }

    public int getMaxTraversals() {
        return this.maxTraversals;
    }

    public String getMaxTraversalsStr() {
        return this.maxTraversalsStr;
    }

    public void setMaxTraversals(int maxTraversals) {
        this.maxTraversals = maxTraversals;
        this.maxTraversalsStr = Integer.toString(maxTraversals);
    }

    public void setMaxTraversalsStr(String maxTraversals) {
        if (maxTraversals == null || maxTraversals.length() < 1) {
            this.maxTraversalsStr = this.minTraversalsStr;
            this.maxTraversals = this.minTraversals;
        } else {
            try {
                this.maxTraversalsStr = maxTraversals;
                this.maxTraversals = Integer.parseInt(maxTraversals.trim());
            }
            catch (Exception e) {
                this.maxTraversals = this.minTraversals;
            }
        }
    }

    public void setSuccessMsg(String successMsg) {
        this.successMsg = successMsg;
    }

    public String getSuccessMsg() {
        return this.successMsg;
    }

    public void setOldActionType(String oldActionType) {
        this.oldActionType = oldActionType;
    }

    public String getOldActionType() {
        return this.oldActionType;
    }

    public void setPreferredEdge(boolean isPreferredEdge) {
        this.isPreferredEdge = isPreferredEdge;
    }

    public boolean isPreferredEdge() {
        return this.isPreferredEdge;
    }

    public String getCallbackFn() {
        return this.callbackFn;
    }

    public void setCallbackFn(String newValue) {
        this.callbackFn = newValue;
    }

    public void setAction(Vector action) {
        this.getMatcher().setDefaultAction(action.elementAt(0) == null ? "" : action.elementAt(0).toString());
    }

    public void setSelection(Vector selection) {
        if (trace.getDebugCode("mps")) {
            trace.out("mps", " matcher = " + this.getMatcher() + " selection = " + selection);
        }
        this.getMatcher().setDefaultSelection(selection.elementAt(0) == null ? "" : selection.elementAt(0).toString());
    }

    public void setActor(String actor) {
        this.getMatcher().setDefaultActor(actor);
    }

    public Vector getSelection() {
        return this.getMatcher().getDefaultSelectionVector();
    }

    public String getActor() {
        return this.getMatcher().getDefaultActor();
    }

    public Vector getAction() {
        return this.getMatcher().getDefaultActionVector();
    }

    public void setInput(Vector input) {
        this.getMatcher().setDefaultInput(input.elementAt(0) == null ? "" : input.elementAt(0).toString());
    }

    public Vector getInput() {
        return this.getMatcher().getDefaultInputVector();
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        if (!(actionType != null && (actionType.equals(CORRECT_ACTION) || actionType.equals(FIREABLE_BUGGY_ACTION) || actionType.equals(BUGGY_ACTION) || actionType.equals(HINT_ACTION) || actionType.equals(UNTRACEABLE_ERROR) || actionType.equals(CLT_ERROR_ACTION) || actionType.equals(GIVEN_ACTION)))) {
            throw new IllegalArgumentException("invalid action type " + actionType);
        }
        this.actionType = actionType;
        if (this.actionLabel != null) {
            this.actionLabel.resetForeground();
        }
    }

    public String getCheckedStatus() {
        return this.checkedStatus;
    }

    public void setCheckedStatus(String checkedStatus) {
        this.checkedStatus = checkedStatus;
    }

    public String getInterpolatedSuccessOrBuggyMsg(boolean success) {
        String msg;
        String string = msg = success ? this.successMsg : this.buggyMsg;
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "interpolating " + msg);
        }
        if (msg == null || msg.length() == 0) {
            return "";
        }
        CTATFunctions functions = new CTATFunctions(this.getProblemModel().getVariableTable(), this.getProblemModel(), this.getProblemModel().getFormulaParser());
        String interpolatedMsg = functions.interpolate(msg.trim(), this.interpolateSelection, this.interpolateAction, this.interpolateInput);
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "interpolated: " + interpolatedMsg);
        }
        return interpolatedMsg;
    }

    public String getBuggyMsg() {
        return this.buggyMsg;
    }

    public void setBuggyMsg(String buggyMsg) {
        this.buggyMsg = buggyMsg;
    }

    public void setInterpolateSAI(String s, String a, String i) {
        this.interpolateSelection = s;
        this.interpolateAction = a;
        this.interpolateInput = i;
    }

    void setInterpolatedHints(List<String> reportableHints) {
        this.interpolatedHints = new Vector<String>(reportableHints);
    }

    private Vector<String> interpolatedHints() {
        if (this.interpolatedHints == null || this.interpolatedHints.size() == 0) {
            this.interpolateHints(null);
        }
        return this.interpolatedHints;
    }

    public Vector<String> getHints() {
        Vector<String> v = new Vector<String>();
        for (String hint : this.interpolatedHints()) {
            if (hint.equals("")) continue;
            v.addElement(hint);
        }
        return v;
    }

    public Vector<String> getAllHints() {
        return this.hints;
    }

    public List<String> getAllNonEmptyHints() {
        ArrayList<String> NonEmptyHints = new ArrayList<String>();
        for (String hint : this.hints) {
            if (hint.trim().equals("")) continue;
            NonEmptyHints.add(hint);
        }
        return NonEmptyHints;
    }

    public void setHints(Vector hints) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "setting hints " + hints);
        }
        this.interpolatedHints = null;
        this.hints = hints;
        this.updateToolTip();
    }

    public void addHint(String newHint) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "adding hint " + newHint);
        }
        if (newHint != null && !newHint.equals("")) {
            this.hints.addElement(newHint);
            this.interpolatedHints = null;
        }
        this.updateToolTip();
    }

    public void interpolateHints(VariableTable vt, String s, String a, String i) {
        this.setInterpolateSAI(s, a, i);
        this.interpolateHints(vt);
    }

    public void interpolateHints(VariableTable vt) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "interpolating " + this.hints);
        }
        this.interpolatedHints = new Vector();
        if (this.hints == null || this.hints.size() == 0) {
            return;
        }
        if (vt == null) {
            vt = this.getProblemModel().getVariableTable();
        }
        CTATFunctions functions = new CTATFunctions(vt, this.getProblemModel(), this.getProblemModel().getFormulaParser());
        for (String hint : this.hints) {
            this.interpolatedHints.add(functions.interpolate(hint, this.interpolateSelection, this.interpolateAction, this.interpolateInput));
        }
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "hints interpolated: " + this.interpolatedHints);
        }
    }

    public void setStudentInput(Object object) {
        this.studentInput = object;
    }

    public Vector getStudentInput() {
        if (this.getMatcher() != null && this.studentInput == null) {
            return this.getMatcher().getDefaultInputVector();
        }
        Vector<Object> studentInputVector = new Vector<Object>();
        studentInputVector.addElement(this.studentInput);
        return studentInputVector;
    }

    public void setStudentSelection(Object object) {
        this.studentSelection = object;
    }

    public Vector getStudentSelection() {
        if (this.studentSelection == null) {
            return this.getMatcher().getDefaultSelectionVector();
        }
        Vector<Object> studentSelectionVector = new Vector<Object>();
        studentSelectionVector.addElement(this.studentSelection);
        return studentSelectionVector;
    }

    public void setStudentAction(Object object) {
        this.studentAction = object;
    }

    public Vector getStudentAction() {
        if (this.studentAction == null) {
            return this.getMatcher().getDefaultActionVector();
        }
        Vector<Object> studentActionVector = new Vector<Object>();
        studentActionVector.addElement(this.studentAction);
        return studentActionVector;
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public void setMatcher(Matcher m) {
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "setMatcher(" + m.getClass().getName() + ")");
        }
        this.matcher = m;
        m.setExternalResources(this.getProblemModel().getVariableTable(), this.getProblemModel(), this.getProblemModel().getFormulaParser());
    }

    public Vector getAssociatedElements() {
        return this.associatedElements;
    }

    public Vector getAssociatedElementsValues() {
        return this.associatedElementsValues;
    }

    public void setAssociatedElements(Vector vector) {
        this.getAssociatedElements().removeAllElements();
        this.getAssociatedElements().addAll(vector);
    }

    public void setAssociatedElementsValues(Vector vector) {
        this.getAssociatedElementsValues().removeAllElements();
        this.getAssociatedElementsValues().addAll(vector);
    }

    public void clearAssociatedElements() {
        this.getAssociatedElements().removeAllElements();
        this.getAssociatedElementsValues().removeAllElements();
    }

    public String getDialogueName() {
        return this.dialogueName;
    }

    public void setDialogueName(String dialogueName) {
        this.dialogueName = dialogueName;
    }

    public boolean getStep_Succesful_Completion() {
        return this.step_Succesful_Completion;
    }

    public boolean getStep_Student_Error() {
        return this.step_Student_Error;
    }

    public boolean defaultHintOnly() {
        String currentHint;
        boolean defaultHintOnlyFlag = false;
        if (this.getHints() == null) {
            return true;
        }
        if (this.getHints().size() == 1 && (currentHint = this.getHints().elementAt(0)).equals(this.formDefaultHint())) {
            defaultHintOnlyFlag = true;
        }
        return defaultHintOnlyFlag;
    }

    public boolean haveNoneDefaultHint() {
        if (this.getHints().size() == 0) {
            return false;
        }
        if (this.getHints().size() == 1) {
            return !this.defaultHintOnly();
        }
        return true;
    }

    public String formDefaultHint() {
        String defaultHint = "";
        Vector inputs = this.getInput();
        if (inputs.size() == 0) {
            return defaultHint;
        }
        String inputText = (String)inputs.elementAt(0);
        Vector actions = this.getAction();
        if (actions.size() == 0) {
            return defaultHint;
        }
        String actionName = (String)actions.elementAt(0);
        if (this.getMatcher() != null && this.getMatcher().getClass().getName().equals("pact.BehaviorRecorder.Matcher.AnyMatcher")) {
            inputText = "Any Value";
        }
        defaultHint = DEFAULT_HINT_FRONT + inputText + DEFAULT_HINT_REAR;
        BR_Controller controller = this.problemModel.getController();
        if (actionName.equals("UpdateTable")) {
            defaultHint = "Please enter '" + inputText + TABLE_REAR;
        } else if (actionName.equals("UpdateComboBox")) {
            defaultHint = "Please select '" + inputText + COMBOBOX_REAR;
        } else if (actionName.equals("UpdateChooser")) {
            defaultHint = "Please select '" + inputText + CHOOSER_REAR;
        } else if (actionName.equals("UpdateList")) {
            defaultHint = "Please select '" + inputText + LIST_REAR;
        } else if (actionName.equals("UpdateTextField")) {
            defaultHint = "Please enter '" + inputText + "' in the highlighted field.";
        } else if (actionName.equals("UpdateTextArea")) {
            defaultHint = "Please enter '" + inputText + "' in the highlighted field.";
        } else if (actionName.equals("ButtonPressed")) {
            Vector selections = this.getSelection();
            String firstSelection = (String)selections.elementAt(0);
            if (!firstSelection.equalsIgnoreCase("Help") && !firstSelection.equalsIgnoreCase("Hint")) {
                defaultHint = BUTTON_DEFAULT;
            }
            if (firstSelection.equalsIgnoreCase("Done")) {
                JCommWidget d = null;
                try {
                    if (controller != null) {
                        d = controller.getCommWidget(firstSelection);
                    }
                }
                catch (RuntimeException re) {
                    d = null;
                }
                if (d != null) {
                    JCommButton dd = (JCommButton)d;
                    inputText = dd.getText();
                    defaultHint = DONE_BUTTON_FRONT + inputText + DONE_BUTTON_REAR;
                }
            }
        } else if (actionName.equals("UpdateRadioButton")) {
            defaultHint = RADIOBUTTON_DEFAULT;
            if (controller != null && !controller.getInterfaceLoaded()) {
                return defaultHint;
            }
            Vector selections = this.getSelection();
            String selectionName = (String)selections.elementAt(0);
            JCommWidget d = null;
            if (controller != null) {
                d = controller.getCommWidget(selectionName);
            }
            if (d != null) {
                JCommRadioButton dd = (JCommRadioButton)d;
                inputText = dd.getText();
                defaultHint = "Please select '" + inputText + RADIOBUTTON_REAR;
            }
        } else if (actionName.equals("UpdateComposer")) {
            defaultHint = COMPOSER_FRONT + inputText + COMPOSER_REAR;
        }
        return defaultHint;
    }

    public void updateDefaultHint() {
        String defaultHint;
        if (this.getAction().size() == 0 || this.getInput().size() == 0 || this.hints.size() != 0) {
            return;
        }
        boolean addDefaultHintFlag = false;
        if (this.hints == null) {
            addDefaultHintFlag = true;
        }
        if (this.hints.size() == 0) {
            addDefaultHintFlag = true;
        }
        if (addDefaultHintFlag && !(defaultHint = this.formDefaultHint()).equals("")) {
            this.hints.addElement(defaultHint);
        }
    }

    public String getActionLabelText(boolean mouseEntered, int classView) {
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getName() + ".getActionLabelText()");
        }
        StringBuffer text = new StringBuffer();
        text.append(this.getUniqueID()).append(". ");
        if (trace.getDebugCode("functions")) {
            trace.out("functions", this.getClass().getName() + " matcher: " + this.getMatcher());
        }
        text.append(this.getMatcher().getActionLabelText(ActionLabel.classView));
        return text.toString();
    }

    private static String truncateNumericStr(String numStr) {
        try {
            int t = Integer.parseInt(numStr);
            return Integer.toString(t);
        }
        catch (NumberFormatException nfe) {
            return numStr.substring(0, Math.min(numStr.length(), 2));
        }
    }

    private boolean displayTraversalCount() {
        BR_Controller ctlr = this.getController();
        return ctlr != null && ctlr.getTraversalCountEnabled();
    }

    public void resetCommMessage() {
        this.demoMsgObj.setProperty("Selection", this.getMatcher().getDefaultSelectionVector());
        this.demoMsgObj.setProperty("Action", this.getMatcher().getDefaultActionVector());
        this.demoMsgObj.setProperty("Input", this.getMatcher().getDefaultInputVector());
    }

    private int getIndex(Vector vector, String string) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void setDemoMsgObj(MessageObject demoMsgObj) {
        if (demoMsgObj == null) {
            trace.printStack("mo");
        }
        this.demoMsgObj = demoMsgObj;
    }

    public MessageObject getDemoMsgObj() {
        return this.demoMsgObj;
    }

    public String toString() {
        try {
            return this.getSourceProblemNode().getNodeView().getText();
        }
        catch (NullPointerException nullPointerException) {
            return "This EdgeData has no source node";
        }
    }

    public void setActionLabel(ActionLabel actionLabel) {
        this.actionLabel = actionLabel;
    }

    public void setPreLispCheckLabel(CheckLispLabel preLispCheckLabel) {
        this.preLispCheckLabel = preLispCheckLabel;
    }

    public CheckLispLabel getPreLispCheckLabel() {
        return this.preLispCheckLabel;
    }

    public BR_Controller getController() {
        return this.problemModel.getController();
    }

    public int getUniqueID() {
        return this.localUniqueID;
    }

    public void setUniqueID(int uniqueIDValue) {
        this.localUniqueID = uniqueIDValue;
        if (this.problemModel != null) {
            this.problemModel.updateEdgeUniqueIDGenerator(this.localUniqueID);
        }
    }

    public String getName() {
        return "link" + this.getUniqueID();
    }

    public static String checkResultToActionType(String checkResult) {
        if (checkResult == null) {
            return "";
        }
        if (checkResult.equalsIgnoreCase(SUCCESS)) {
            return CORRECT_ACTION;
        }
        if (checkResult.equalsIgnoreCase(BUGGY)) {
            return BUGGY_ACTION;
        }
        if (checkResult.equalsIgnoreCase(FIREABLE_BUG)) {
            return FIREABLE_BUGGY_ACTION;
        }
        return "";
    }

    public String getTooltipText() {
        String tooltipText = "<html><b>Click to edit.<br>";
        tooltipText = tooltipText + "Link number:</b> " + this.getUniqueID() + ", " + this.getActionType() + "<br>";
        tooltipText = tooltipText + "<b>Selection (" + this.matcher.getSelectionMatcherType();
        tooltipText = tooltipText + "):</b>  " + this.matcher.getSelectionToolTipText() + "<br>";
        tooltipText = tooltipText + "<b>Action (" + this.matcher.getActionMatcherType();
        tooltipText = tooltipText + "):</b>  " + this.matcher.getActionToolTipText() + "<br>";
        tooltipText = tooltipText + "<b>Input (" + this.matcher.getInputMatcherType();
        tooltipText = tooltipText + "):</b>  " + this.matcher.getInputToolTipText() + "<br>";
        tooltipText = tooltipText + "<b>Allowed Traversals (min-max):</b>  " + this.minTraversalsStr + "-" + this.maxTraversalsStr + "<br>";
        if (this.displayTraversalCount()) {
            tooltipText = tooltipText + "<b>Actual Traversals:</b>  " + this.getTraversalCount() + "<br>";
        }
        tooltipText = tooltipText + "<b>Actor:</b>  " + this.getActor() + "<br>";
        if (this.getHints().size() == 0) {
            tooltipText = tooltipText + "No hints defined.<br>";
        } else {
            for (int i = 0; i < this.getHints().size(); ++i) {
                String hint = this.getHints().elementAt(i);
                if (hint.equals("")) continue;
                if (hint.length() > 75) {
                    hint = hint.substring(0, 74);
                    hint = hint + "...";
                }
                tooltipText = this.defaultHintOnly() ? tooltipText + "<b>Default Hint:</b> " + hint + "<br>" : tooltipText + "<b>Hint:</b> " + hint + "<br>";
            }
        }
        if (this.getSuccessMsg() != "") {
            tooltipText = tooltipText + "<b>Success Message:</b>  " + this.getInterpolatedSuccessOrBuggyMsg(true) + "<br>";
        }
        if (this.getBuggyMsg() != "") {
            tooltipText = tooltipText + "<b>Bug Message:</b>  " + this.getInterpolatedSuccessOrBuggyMsg(false) + "<br>";
        }
        tooltipText = tooltipText + "</html>";
        return tooltipText;
    }

    public void updateSkills(String transactionResult) {
        ProblemModel pm;
        if (trace.getDebugCode("ps")) {
            trace.out("ps", "updateSkills[" + this.getUniqueID() + "](" + transactionResult + ") for ruleNames " + this.getRuleNames());
        }
        if ((pm = this.getProblemModel()) == null) {
            return;
        }
        pm.updateSkills(transactionResult, this.getRuleNames(), Skill.makeStepID(this.getMatcher().getDefaultSelectionVector(), this.getMatcher().getDefaultActionVector()));
    }

    public Vector<String> getRuleNames() {
        if (this.ruleNames == null) {
            this.ruleNames = new Vector();
        }
        return this.ruleNames;
    }

    public void addRuleName(String ruleLabelText) {
        if (this.ruleNames == null) {
            this.ruleNames = new Vector();
        }
        if (this.ruleNames.contains(ruleLabelText)) {
            return;
        }
        this.ruleNames.add(ruleLabelText);
        this.ruleLabels = null;
    }

    public void insertRuleName(String oldRuleLabelText, String newRuleLabelText, boolean after) {
        if (this.ruleNames == null) {
            this.ruleNames = new Vector();
        }
        if (this.ruleNames.contains(newRuleLabelText)) {
            return;
        }
        for (int i = 0; i < this.ruleNames.size(); ++i) {
            if (!this.ruleNames.get(i).equals(newRuleLabelText)) continue;
            this.ruleNames.insertElementAt(newRuleLabelText, after ? i + 1 : i);
            return;
        }
        this.ruleNames.add(newRuleLabelText);
    }

    public void replaceRuleName(String oldRuleLabelText, String newRuleLabelText) {
        if (this.ruleNames == null) {
            this.addRuleName(newRuleLabelText);
        } else {
            int rnIndex = this.ruleNames.indexOf(oldRuleLabelText);
            if (rnIndex < 0) {
                this.ruleNames.add(newRuleLabelText);
            } else {
                this.ruleNames.set(rnIndex, newRuleLabelText);
            }
        }
        this.ruleLabels = null;
    }

    public void removeRuleName(String ruleNameProductionSet) {
        int i = this.ruleNames.indexOf(ruleNameProductionSet);
        if (i >= 0) {
            this.ruleNames.remove(i);
        }
    }

    private void handleInterfaceActionEditing(Vector selection, Vector action, Vector input, MessageObject messageObject, String actionType) {
        if (trace.getDebugCode("demolink")) {
            trace.out("demolink", "EdgeData.handleInterfaceActionEditing(" + selection + ", " + action + ", " + input + ", " + messageObject.summary() + ", " + actionType);
        }
        this.setMatcher(selection == null ? new ExactMatcher() : this.createVectorMatcher(selection, action, input));
        if (selection != null) {
            this.setSelection((Vector)selection.clone());
        }
        this.setAction((Vector)action.clone());
        this.setInput((Vector)input.clone());
        this.setDemoMsgObj(messageObject);
        this.setActionType(actionType);
    }

    public void handleDemonstrateThisLinkInput(Vector selectionD, Vector actionD, Vector inputD, MessageObject messageObjectD, String actionTypeD) {
        if (!this.edge.dest.isLeaf()) {
            for (int i = 0; i < selectionD.size(); ++i) {
                String tempSelectionString = (String)selectionD.elementAt(i);
                if (!tempSelectionString.equalsIgnoreCase("Done")) continue;
                JOptionPane.showMessageDialog(this.problemModel.getController().getActiveWindow(), "You may not demonstrate a done step in the middle of this graph", "Warning", 2);
                return;
            }
        }
        this.handleInterfaceActionEditing(selectionD, actionD, inputD, messageObjectD, actionTypeD);
        this.problemModel.getController().getCtatModeModel().exitDemonstrateThisLinkMode();
        EdgeUpdatedEvent euEvt = new EdgeUpdatedEvent(this, this.getEdge(), this.isPreferredEdge);
        this.getProblemModel().fireProblemModelEvent(euEvt);
        PseudoTutorMessageHandler psTMH = this.getController().getPseudoTutorMessageHandler();
        psTMH.getExampleTracer().extendPaths();
        if (this.getEdge().isCorrectorFireableBuggy()) {
            psTMH.traverseEdge(this, selectionD, actionD, inputD, this.getActor());
        }
        this.getController().setCurrentNode(this.getEdge().getDest());
        ActionLabel thisActionLabel = this.getActionLabel();
        thisActionLabel.resetForeground();
        thisActionLabel.update();
        this.getController().fireCtatModeEvent(CtatModeEvent.REPAINT);
        ActionEvent ae = new ActionEvent(this, 0, "Demonstrate this Link");
        this.getController().getUndoPacket().getCheckpointAction().actionPerformed(ae);
    }

    public void updateMovedFromEdgeView() {
        this.getActionLabel().update();
        this.getPreLispCheckLabel().update(this.getUniqueID(), this.getSourceProblemNode(), this.getEndProblemNode());
        int ruleCount = this.getRuleLabels().size();
        for (int i = 0; i < ruleCount; ++i) {
            RuleLabel l = this.getRuleLabels().elementAt(i);
            l.update(this.getSourceProblemNode(), this.getEndProblemNode(), i, ruleCount);
        }
    }

    public boolean replaceInput() {
        if (!CORRECT_ACTION.equalsIgnoreCase(this.getActionType()) && !FIREABLE_BUGGY_ACTION.equalsIgnoreCase(this.getActionType())) {
            return false;
        }
        return this.getMatcher().replaceInput();
    }

    public Vector evaluateReplacement(Vector selection, Vector action, Vector input, VariableTable vt) {
        return this.getMatcher().evaluateReplacement(selection, action, input, vt, this.getProblemModel());
    }

    public Element getActionLabelElement() {
        Element elt = new Element("actionLabel");
        elt.setAttribute("preferPathMark", Boolean.toString(this.isPreferredEdge()));
        DialogueSystemInfo dialogueSystemInfo = this.getDialogueSystemInfo();
        elt.addContent((Content)new Element("studentHintRequest").setText(dialogueSystemInfo.getStudent_Hint_Request()));
        elt.addContent((Content)new Element("stepSuccessfulCompletion").setText(dialogueSystemInfo.getStep_Successful_Completion()));
        elt.addContent((Content)new Element("stepStudentError").setText(dialogueSystemInfo.getStep_Student_Error()));
        elt.addContent((Content)new Element("uniqueID").setText(Integer.toString(this.getUniqueID())));
        if (this.getDemoMsgObj() != null) {
            elt.addContent((Content)this.getDemoMsgObj().toElement());
        }
        elt.addContent((Content)new Element("buggyMessage").setText(this.getBuggyMsg()));
        elt.addContent((Content)new Element("successMessage").setText(this.getSuccessMsg()));
        for (String hint : this.getAllNonEmptyHints()) {
            elt.addContent((Content)new Element("hintMessage").setText(hint));
        }
        elt.addContent((Content)new Element("callbackFn").setText(this.getCallbackFn()));
        elt.addContent((Content)new Element("actionType").setText(this.getActionType()));
        elt.addContent((Content)new Element("oldActionType").setText(this.getOldActionType()));
        elt.addContent((Content)new Element("checkedStatus").setText(this.getCheckedStatus()));
        elt.setAttribute("minTraversals", this.getMinTraversalsStr());
        elt.setAttribute("maxTraversals", this.getMaxTraversalsStr());
        elt.addContent((Content)this.getMatcher().toElement());
        return elt;
    }

    public void randomizeHintOrder() {
        int i;
        CTATRandom random = new CTATRandom();
        this.modifiedHintOrder = random.randomOrder(this.hints.size());
        String[] copyHints = this.hints.toArray(new String[this.modifiedHintOrder.length]);
        if (trace.getDebugCode("hints")) {
            trace.outNT("hints", "ED.randomizeHintOrder() before reordering:");
            for (i = 0; i < copyHints.length; ++i) {
                System.out.printf("  [%d] %.40s;\n", i, copyHints[i]);
            }
        }
        for (i = 0; i < this.modifiedHintOrder.length; ++i) {
            this.hints.set(i, copyHints[this.modifiedHintOrder[i]]);
        }
        if (trace.getDebugCode("hints")) {
            trace.outNT("hints", "ED.randomizeHintOrder() after " + Arrays.toString(this.modifiedHintOrder));
            for (i = 0; i < this.hints.size(); ++i) {
                System.out.printf("  [%d] %.40s;\n", this.modifiedHintOrder[i], this.hints.get(i));
            }
        }
        if (this.interpolatedHints != null) {
            if (this.interpolatedHints.size() != this.modifiedHintOrder.length) {
                throw new IllegalStateException("randomizeHintOrder(): no. of interpolated hints " + this.interpolatedHints.size() + " does not match no. of Hints " + this.modifiedHintOrder.length);
            }
            copyHints = this.interpolatedHints.toArray(new String[this.modifiedHintOrder.length]);
            for (i = 0; i < this.modifiedHintOrder.length; ++i) {
                this.interpolatedHints.set(i, copyHints[this.modifiedHintOrder[i]]);
            }
        }
        this.updateToolTip();
    }

    public int[] getModifiedHintOrder() {
        if (this.modifiedHintOrder == null) {
            return null;
        }
        int[] result = new int[this.modifiedHintOrder.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.modifiedHintOrder[i] + 1;
        }
        return result;
    }

    public void updateToolTip() {
        if (this.getActionLabel() != null) {
            this.getActionLabel().updateToolTip();
        }
    }

    public void resetLabelFont() {
        if (this.getActionLabel() != null) {
            this.getActionLabel().setFont(this.getController().getOriginalEdgeFont());
        }
    }

    public void resetLabelSize() {
        if (this.getActionLabel() != null) {
            this.getActionLabel().resetSize();
        }
    }

    public Vector appendHintOrder(Vector texts) {
        int[] mho = this.getModifiedHintOrder();
        if (mho == null || mho.length < 1) {
            return texts;
        }
        Vector<String> result = texts == null ? new Vector<String>() : new Vector(texts);
        result.add("HintOrder" + Arrays.toString(mho));
        if (trace.getDebugCode("hints")) {
            trace.outNT("hints", "EdgeData.appendHintOrder() result[" + (result.size() - 1) + "]: " + result.get(result.size() - 1));
        }
        return result;
    }

    public static void setCopyData(EdgeData copyData) {
        _copyData = copyData;
    }

    public static EdgeData getCopyData() {
        return _copyData;
    }

    public boolean isTutorPerformed(Boolean linkTriggered) {
        if (!CORRECT_ACTION.equalsIgnoreCase(this.getActionType())) {
            return false;
        }
        Matcher m = this.getMatcher();
        if (m == null) {
            return false;
        }
        if (linkTriggered != null && linkTriggered.booleanValue() != m.isLinkTriggered()) {
            return false;
        }
        String actor = this.getActor();
        return Matcher.isTutorActor(actor, true);
    }

    public void testTPA() {
        String[] revisedAction;
        MessageObject mo = PseudoTutorMessageBuilder.buildToolInterfaceAction(this.getSelection(), this.getAction(), this.getInput(), "DATA", "tutor-performed");
        String action = mo.getFirstAction();
        int delay = UniversalToolProxy.isDelayedAction(action, revisedAction = new String[1]);
        if (delay > 0) {
            mo.setAction(revisedAction[0]);
        }
        if (trace.getDebugCode("br")) {
            trace.out("br", "EdgeData.testTPA() removed delay " + delay + ", to send " + mo.summary());
        }
        this.getController().handleMessageUTP(mo);
    }

    public Color getDefaultColor() {
        return this.isTutorPerformed(null) ? TPAColor : PlainColor;
    }

    public static boolean sameSettings(EdgeData ed0, EdgeData ed1) {
        EdgeData[] eds = new EdgeData[]{ed0, ed1};
        String[] elts = new String[2];
        for (int i = 0; i < eds.length; ++i) {
            if (eds[i].getEdge() == null) {
                ProblemEdge pe = new ProblemEdge();
                eds[i].setEdge(pe);
                pe.setEdgeData(eds[i]);
            }
            elts[i] = eds[i].getEdge().toXMLString();
            if (!trace.getDebugCode("editstudentinput")) continue;
            trace.out("editstudentinput", "ED.hasSameSettings[" + i + "] " + eds[i].getEdge().toXMLString());
        }
        return EdgeData.sameExceptForID(elts[0], elts[1]);
    }

    private static boolean sameExceptForID(String xml0, String xml1) {
        String c0 = UniqueIDInXML.matcher(xml0).replaceFirst("\\1 \\3");
        String c1 = UniqueIDInXML.matcher(xml1).replaceFirst("\\1 \\3");
        return c0.equals(c1);
    }

    static {
        PlainColor = Color.black;
        TPAColor = new Color(41, 152, 255);
        UniqueIDInXML = Pattern.compile("(<uniqueID>)([0-9]+)(</uniqueID>)");
    }
}

