/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel;

public enum FeedbackEnum {
    SHOW_ALL_FEEDBACK("Show All Feedback"),
    DELAY_FEEDBACK("Delay Feedback"),
    HIDE_ALL_FEEDBACK("Hide All Feedback"),
    HIDE_BUT_COMPLETE("Hide feedback but require all steps"),
    HIDE_BUT_ENFORCE("Hide feedback but enforce constraints");

    public static final FeedbackEnum DEFAULT;
    private String description;

    private FeedbackEnum(String description) {
        this.description = description;
    }

    public boolean exitOnIncorrectDone() {
        return this == HIDE_ALL_FEEDBACK || this == HIDE_BUT_ENFORCE;
    }

    public boolean tutorSuppresses() {
        return this == HIDE_ALL_FEEDBACK || this == HIDE_BUT_COMPLETE || this == HIDE_BUT_ENFORCE;
    }

    public boolean relaxOrderConstraints() {
        return this == HIDE_ALL_FEEDBACK || this == HIDE_BUT_COMPLETE || this == DELAY_FEEDBACK;
    }

    public boolean gradeLastStepAttempt() {
        return this != SHOW_ALL_FEEDBACK && this != DELAY_FEEDBACK;
    }

    public String toString() {
        return this.description;
    }

    public final String identifier() {
        return super.toString();
    }

    public static FeedbackEnum fromString(String text) {
        if (text == null) {
            return DEFAULT;
        }
        text = text.trim();
        for (FeedbackEnum fe : FeedbackEnum.values()) {
            if (text.equalsIgnoreCase(fe.toString())) {
                return fe;
            }
            if (!text.equalsIgnoreCase(fe.identifier())) continue;
            return fe;
        }
        if (text.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return HIDE_ALL_FEEDBACK;
        }
        if (text.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return SHOW_ALL_FEEDBACK;
        }
        return DEFAULT;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            FeedbackEnum fe = FeedbackEnum.fromString(args[i]);
            System.out.printf("[%d] %-5s %-18s => %s\n", new Object[]{i, fe.gradeLastStepAttempt(), args[i], fe});
        }
    }

    public boolean hideButRequireSteps() {
        return this == HIDE_BUT_COMPLETE;
    }

    static {
        DEFAULT = SHOW_ALL_FEEDBACK;
    }
}

