/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.RuleProduction;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.View.RuleLabel;
import edu.cmu.pact.Utilities.trace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;

public class HelpSuccessPanel
extends JDialog
implements ActionListener {
    JScrollPane helpScrollPanel;
    JPanel moreOptionsPanel = new JPanel();
    JPanel helpPanel = new JPanel();
    JPanel southPanel = new JPanel();
    JPanel optionPanel = new JPanel();
    JPanel okCancelPanel = new JPanel();
    JLabel successJLabel = new JLabel("Please Edit Success Message:");
    JTextArea successArea = new JTextArea();
    int numberHelps;
    int numberHelpsInputArea;
    JTextArea[] helpArea;
    JLabel[] helpJLabel;
    final int helpPaneHeight = 550;
    final int helpPaneWidth = 500;
    JCheckBox checkOption1;
    JCheckBox checkOption2;
    JCheckBox checkOption3;
    JLabel edgesJLabel;
    JComboBox edgesJComboBox;
    Vector myEdgesWithHints;
    JLabel rulesJLabel;
    JComboBox rulesJComboBox;
    Vector<RuleProduction> rulesWithHints;
    JButton doneJButton;
    JButton cancelJButton;
    JButton moreJButton;
    JButton clearJButton;
    JButton showMoreOptionsButton;
    boolean clearFlag;
    String ruleLabelText;
    Vector stateEdges;
    String title;
    EdgeData edgeData;
    ProblemEdge problemEdge;
    JPanel showOptionsPanel;
    boolean showingOptions;
    String defaultHint;
    private BR_Controller controller;
    private final String serializedBeforeEdit;
    private boolean partOfLargerEdit;

    public HelpSuccessPanel(BR_Controller controller, EdgeData edgeData, boolean partOfLargerEdit) {
        super(controller.getActiveWindow(), "", true);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.successArea);
        this.numberHelps = 0;
        this.numberHelpsInputArea = 3;
        this.helpPaneHeight = 550;
        this.helpPaneWidth = 500;
        this.checkOption1 = new JCheckBox("Copy to all links with the same Selection/Action/Input.");
        this.checkOption2 = new JCheckBox("Copy to all links with the same Prodution Rule.");
        this.checkOption3 = new JCheckBox("Copy hints to the Prodution Rule.");
        this.edgesJLabel = new JLabel(" Copy hints from the following link:");
        this.edgesJComboBox = new JComboBox();
        this.myEdgesWithHints = new Vector();
        this.rulesJLabel = new JLabel(" Copy hints from the following rule:");
        this.rulesJComboBox = new JComboBox();
        this.rulesWithHints = new Vector();
        this.doneJButton = new JButton("Done");
        this.cancelJButton = new JButton("Cancel");
        this.moreJButton = new JButton("Add Hint Level");
        this.clearJButton = new JButton("Clear Hints");
        this.showMoreOptionsButton = new JButton("More Options");
        this.clearFlag = false;
        this.title = "Edit Hint and Success Messages";
        this.defaultHint = "";
        this.partOfLargerEdit = false;
        this.partOfLargerEdit = partOfLargerEdit;
        this.serializedBeforeEdit = edgeData.getEdge().toXMLString();
        this.controller = controller;
        this.setResizable(false);
        this.edgeData = edgeData;
        this.defaultHint = edgeData.formDefaultHint();
        this.problemEdge = edgeData.getEdge();
        NodeView tempVertex = this.problemEdge.getNodes()[0].getNodeView();
        this.title = this.title + " from " + tempVertex.getText();
        tempVertex = this.problemEdge.getNodes()[1].getNodeView();
        this.title = this.title + " to " + tempVertex.getText();
        this.setTitle(this.title);
        this.setLocation(new Point(300, 100));
        this.setSize(500, 550);
        this.moreOptionsPanel.setLayout(new BorderLayout());
        this.moreOptionsPanel.add((Component)this.successJLabel, "North");
        this.successArea = new JTextArea(3, 30);
        JUndo.JTextUndoPacket jTextUndoPacket2 = JUndo.makeTextUndoable(this.successArea);
        this.successArea.setLineWrap(true);
        this.successArea.setWrapStyleWord(true);
        this.successArea.setText(edgeData.getSuccessMsg());
        this.moreOptionsPanel.add((Component)this.successArea, "Center");
        this.numberHelps = edgeData.getAllHints().size();
        if (this.numberHelps > this.numberHelpsInputArea) {
            this.numberHelpsInputArea = this.numberHelps;
        }
        this.sethelpPanel(edgeData.getActionLabel());
        this.helpScrollPanel = new JScrollPane(this.helpPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.helpScrollPanel, "Center");
        JPanel clearMorePanel = new JPanel();
        clearMorePanel.add(this.clearJButton);
        clearMorePanel.add(this.moreJButton);
        centerPanel.add((Component)clearMorePanel, "South");
        if (this.numberHelpsInputArea > 3) {
            Rectangle rect = new Rectangle(this.helpPanel.getSize().width - 10, this.helpPanel.getSize().height - 10, 5, 20);
            JViewport jViewport = this.helpScrollPanel.getViewport();
            jViewport.scrollRectToVisible(rect);
        }
        JPanel checkOptionsPanel = new JPanel(new GridLayout(3, 1));
        checkOptionsPanel.add(this.checkOption1);
        checkOptionsPanel.add(this.checkOption2);
        checkOptionsPanel.add(this.checkOption3);
        this.moreOptionsPanel.add((Component)checkOptionsPanel, "South");
        boolean checkFlag = false;
        boolean checkOption3Flag = false;
        EdgeData thisMyEdge = this.problemEdge.getEdgeData();
        int thisNumberOfRules = thisMyEdge.getRuleLabels().size();
        for (int i = 0; i < thisNumberOfRules; ++i) {
            RuleLabel thisRuleLabel = thisMyEdge.getRuleLabels().elementAt(i);
            if (!thisRuleLabel.isNameSet()) continue;
            this.ruleLabelText = thisRuleLabel.getText();
            this.checkOption2.setText("Copy to all links with Prodution Rule: " + this.ruleLabelText);
            this.checkOption3.setText("Copy hints to the Prodution Rule: " + this.ruleLabelText);
            RuleProduction tempESE_RuleProduction = controller.getRuleProduction(this.ruleLabelText);
            if (tempESE_RuleProduction != null) {
                checkOption3Flag = true;
                if (tempESE_RuleProduction.getHints().size() == 0) {
                    this.checkOption3.setSelected(true);
                } else {
                    this.checkOption3.setSelected(false);
                }
            } else {
                checkOption3Flag = false;
            }
            checkFlag = true;
            break;
        }
        this.checkOption2.setEnabled(checkFlag);
        this.checkOption3.setEnabled(checkFlag && checkOption3Flag);
        this.optionPanel.setLayout(new GridLayout(4, 1));
        this.optionPanel.add(this.edgesJLabel);
        int lastItem = 0;
        Enumeration<ProblemEdge> iter = controller.getProblemModel().getProblemGraph().edges();
        this.stateEdges = new Vector();
        while (iter.hasMoreElements()) {
            EdgeData tempMyEdge;
            ProblemEdge tempEdge = iter.nextElement();
            if (this.problemEdge == tempEdge || (tempMyEdge = tempEdge.getEdgeData()).getAllHints().size() <= 1 && (tempMyEdge.getAllHints().size() != 1 || !tempMyEdge.haveNoneDefaultHint())) continue;
            this.myEdgesWithHints.addElement(tempMyEdge);
            NodeView tempParentVertex = tempEdge.getNodes()[0].getNodeView();
            NodeView tempChildVertex = tempEdge.getNodes()[1].getNodeView();
            this.edgesJComboBox.addItem(tempParentVertex.getText() + " to " + tempChildVertex.getText());
            ++lastItem;
        }
        if (((DefaultComboBoxModel)this.edgesJComboBox.getModel()).getSize() == 0) {
            this.edgesJComboBox.addItem("None");
        } else {
            this.edgesJComboBox.addItem("Select one");
        }
        this.edgesJComboBox.setSelectedIndex(lastItem);
        this.optionPanel.add(this.edgesJComboBox);
        this.edgesJComboBox.addActionListener(this);
        this.optionPanel.add(this.rulesJLabel);
        for (RuleProduction rp : controller.getRuleProductionCatalog().values()) {
            if (rp.getHints().size() < 1) continue;
            if (trace.getDebugCode("br")) {
                trace.out("br", "rule " + rp.getDisplayName() + " has hints:\n" + rp.dumpHints());
            }
            this.rulesWithHints.addElement(rp);
            this.rulesJComboBox.addItem(rp.getDisplayName());
        }
        if (((DefaultComboBoxModel)this.rulesJComboBox.getModel()).getSize() == 0) {
            this.rulesJComboBox.addItem("None");
        }
        this.optionPanel.add(this.rulesJComboBox);
        this.rulesJComboBox.addActionListener(this);
        this.okCancelPanel.setLayout(new FlowLayout(1));
        this.doneJButton.setSize(this.cancelJButton.getSize());
        this.moreJButton.setSize(this.cancelJButton.getSize());
        this.clearJButton.setSize(this.cancelJButton.getSize());
        this.okCancelPanel.add(this.doneJButton);
        this.okCancelPanel.add(this.cancelJButton);
        this.southPanel.setLayout(new BorderLayout());
        this.showOptionsPanel = new JPanel(new FlowLayout());
        this.showMoreOptionsButton.setSize(this.showMoreOptionsButton.getPreferredSize());
        this.showOptionsPanel.add(this.showMoreOptionsButton);
        this.showOptionsPanel.add(this.moreOptionsPanel);
        this.moreOptionsPanel.setVisible(false);
        this.moreOptionsPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.southPanel.add((Component)this.showOptionsPanel, "North");
        JPanel anotherPanel = new JPanel(new BorderLayout());
        anotherPanel.add((Component)this.optionPanel, "North");
        anotherPanel.add((Component)this.okCancelPanel, "South");
        this.southPanel.add((Component)anotherPanel, "South");
        Container c = this.getContentPane();
        JPanel contentPane = new JPanel();
        c.add(contentPane);
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)centerPanel, "Center");
        contentPane.add((Component)this.southPanel, "South");
        contentPane.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.clearJButton.addActionListener(this);
        this.moreJButton.addActionListener(this);
        this.doneJButton.addActionListener(this);
        this.cancelJButton.addActionListener(this);
        this.showMoreOptionsButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                HelpSuccessPanel.this.thisWindowClosing();
            }
        });
    }

    void sethelpPanel(ActionLabel referActionLabel) {
        int numberHelpsReferActionLabel = referActionLabel.getEdge().getAllHints().size();
        this.helpArea = new JTextArea[this.numberHelpsInputArea];
        this.helpJLabel = new JLabel[this.numberHelpsInputArea];
        this.helpPanel.setLayout(new GridLayout(this.numberHelpsInputArea, 1));
        for (int i = 0; i < this.numberHelpsInputArea; ++i) {
            JPanel innerPanel = new JPanel(new BorderLayout());
            String tempString = "Please Edit Hint Message " + (i + 1) + ":";
            this.helpJLabel[i] = new JLabel(tempString);
            this.helpJLabel[i].setBackground(Color.darkGray.darker());
            innerPanel.add((Component)this.helpJLabel[i], "North");
            this.helpArea[i] = new JTextArea(3, 30);
            JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.helpArea[i]);
            this.helpArea[i].setLineWrap(true);
            this.helpArea[i].setWrapStyleWord(true);
            this.helpArea[i].setVisible(true);
            innerPanel.add((Component)this.helpArea[i], "Center");
            this.helpPanel.add(innerPanel);
        }
        if (!this.clearFlag) {
            String currentHint = "";
            for (int i = 0; i < numberHelpsReferActionLabel - 1; ++i) {
                currentHint = referActionLabel.getEdge().getAllHints().elementAt(i);
                if (trace.getDebugCode("hint")) {
                    trace.out("hint", "HelpSuccessPanel.sethelpPanel() currentHint " + currentHint);
                }
                this.helpArea[i].setText(currentHint);
            }
            if (numberHelpsReferActionLabel > 0) {
                currentHint = referActionLabel.getEdge().getAllHints().elementAt(numberHelpsReferActionLabel - 1);
                if (trace.getDebugCode("hint")) {
                    trace.out("hint", "HelpSuccessPanel.sethelpPanel() currentHint " + currentHint);
                }
                if (currentHint.equalsIgnoreCase(this.defaultHint)) {
                    this.helpArea[this.numberHelpsInputArea - 1].setText(currentHint);
                } else {
                    this.helpArea[numberHelpsReferActionLabel - 1].setText(currentHint);
                }
            }
        } else {
            this.successArea.setText("");
        }
        Rectangle rect = new Rectangle(this.helpPanel.getSize().width - 10, this.helpPanel.getSize().height - 10, 5, 20);
        this.helpPanel.scrollRectToVisible(rect);
        this.clearFlag = false;
    }

    public void thisWindowClosing() {
        this.setVisible(false);
        this.dispose();
        this.checkpoint();
    }

    private void checkpoint() {
        if (this.partOfLargerEdit) {
            return;
        }
        String serializedAfterEdit = this.edgeData.getEdge().toXMLString();
        if (!this.serializedBeforeEdit.equals(serializedAfterEdit)) {
            if (trace.getDebugCode("undo")) {
                trace.out("undo", "EditStudentInputDialog.close() XML before:\n" + this.serializedBeforeEdit + "\nXML after:\n" + serializedAfterEdit);
            }
            ActionEvent ae = new ActionEvent(this, 0, "Edit Hint and Success Messages");
            this.controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            if (trace.getDebugCode("undo")) {
                System.out.println("Checkpoint: Change Hint/Success (1)");
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.edgesJComboBox) {
            String selectedItem;
            int slectedEdgeIndex = this.edgesJComboBox.getSelectedIndex();
            if (slectedEdgeIndex >= 0 && slectedEdgeIndex < this.edgesJComboBox.getItemCount() - 1 && !(selectedItem = (String)this.edgesJComboBox.getSelectedItem()).equals("None")) {
                Object[] options;
                String[] message;
                int capValue;
                boolean flag = true;
                for (int i = 0; i < this.numberHelpsInputArea; ++i) {
                    String temtText = this.helpArea[i].getText();
                    if (temtText == null || (temtText = temtText.trim()).length() == 0) continue;
                    flag = false;
                    break;
                }
                if (!flag && (capValue = JOptionPane.showOptionDialog(null, message = new String[]{"Do you want to replace the current hints with", "the hints from the edge you just selected?"}, "Warning", -1, 2, null, options = new Object[]{"OK", "Cancel"}, options[0])) == 0) {
                    flag = true;
                }
                if (flag) {
                    EdgeData selectedMyEdge = (EdgeData)this.myEdgesWithHints.elementAt(slectedEdgeIndex);
                    this.helpPanel.removeAll();
                    this.numberHelpsInputArea = Math.max(3, selectedMyEdge.getAllHints().size());
                    this.sethelpPanel(selectedMyEdge.getActionLabel());
                }
            }
        } else if (ae.getSource() == this.rulesJComboBox) {
            int slectedEdgeIndex = this.rulesJComboBox.getSelectedIndex();
            if (slectedEdgeIndex >= 0) {
                Object[] options;
                String[] message;
                int capValue;
                String selectedItem = (String)this.rulesJComboBox.getSelectedItem();
                if (selectedItem.equals("None")) {
                    return;
                }
                boolean flag = true;
                for (int i = 0; i < this.numberHelpsInputArea; ++i) {
                    String temtText = this.helpArea[i].getText();
                    if (temtText == null || (temtText = temtText.trim()).length() == 0) continue;
                    flag = false;
                    break;
                }
                if (!flag && (capValue = JOptionPane.showOptionDialog(null, message = new String[]{"Do you want to replace the current hints with", "the hints from the rule you just selected?"}, "Warning", -1, 2, null, options = new Object[]{"OK", "Cancel"}, options[0])) == 0) {
                    flag = true;
                }
                if (flag) {
                    ActionLabel referActionLabel = new ActionLabel(this.edgeData, this.controller.getProblemModel());
                    RuleProduction selectedRule = this.rulesWithHints.elementAt(slectedEdgeIndex);
                    referActionLabel.getEdge().setHints(selectedRule.getHints());
                    this.helpPanel.removeAll();
                    this.numberHelpsInputArea = Math.max(3, referActionLabel.getEdge().getAllHints().size());
                    this.sethelpPanel(referActionLabel);
                }
            }
        } else if (ae.getSource() == this.moreJButton) {
            EdgeData referEdgeData = new EdgeData(this.controller.getProblemModel());
            ActionLabel referActionLabel = referEdgeData.getActionLabel();
            this.updateTextAreas(referActionLabel);
            this.helpPanel.removeAll();
            ++this.numberHelpsInputArea;
            this.sethelpPanel(referActionLabel);
            if (this.numberHelpsInputArea > 3) {
                Rectangle rect = new Rectangle(this.helpPanel.getSize().width - 10, this.helpPanel.getSize().height - 10, 5, 20);
                JViewport jViewport = this.helpScrollPanel.getViewport();
                jViewport.scrollRectToVisible(rect);
            }
        } else if (ae.getSource() == this.clearJButton) {
            Object[] options = new Object[]{"Yes", "No"};
            int capValue = JOptionPane.showOptionDialog(this, "<html>Do you want to clear ALL of the hints in this window?</html>", "Clear Hints", -1, 2, null, options, options[0]);
            if (capValue == 0) {
                this.helpPanel.removeAll();
                this.numberHelpsInputArea = 3;
                this.clearFlag = true;
                this.sethelpPanel(this.edgeData.getActionLabel());
            }
        } else if (ae.getSource() == this.doneJButton) {
            RuleProduction rp;
            this.updateTextAreas(this.edgeData.getActionLabel());
            if (this.checkOption1.isSelected() && this.edgeData.getAllHints().size() > 0) {
                Vector sameValuesStates = this.controller.getProblemModel().findSameTripleEdges(this.edgeData.getSelection(), this.edgeData.getAction(), this.edgeData.getInput());
                this.copySuccessHintMsgs(this.edgeData.getActionLabel(), sameValuesStates);
            }
            if (this.checkOption2.isSelected() && this.edgeData.getAllHints().size() > 0) {
                Vector sameProductionSetsStates = this.controller.getProblemModel().findSameProductionSetsEdge(this.ruleLabelText);
                this.copySuccessHintMsgs(this.edgeData.getActionLabel(), sameProductionSetsStates);
            }
            Vector<String> myHints = this.edgeData.getAllHints();
            if (this.checkOption3.isSelected() && myHints.size() > 0 && (rp = this.controller.getRuleProduction(this.ruleLabelText)) != null && !myHints.equals(rp.getHints())) {
                rp.setHints(myHints);
                if (trace.getDebugCode("undo")) {
                    trace.out("undo", "HelpSuccessPanel copied myHints " + myHints + " to rule " + rp);
                }
            }
            this.controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this, this.problemEdge, true));
            this.setVisible(false);
            this.dispose();
            this.checkpoint();
        } else if (ae.getSource() == this.showMoreOptionsButton) {
            if (this.showingOptions) {
                this.moreOptionsPanel.setVisible(false);
                this.showingOptions = false;
                this.showMoreOptionsButton.setText("More Options");
            } else {
                this.moreOptionsPanel.setVisible(true);
                this.showingOptions = true;
                this.showMoreOptionsButton.setText("Hide Options");
            }
        } else {
            this.setVisible(false);
            this.dispose();
            this.checkpoint();
        }
    }

    void copySuccessHintMsgs(ActionLabel fromactionLabel, Vector toStatesVector) {
        if (toStatesVector == null) {
            return;
        }
        int numberOfStates = toStatesVector.size();
        boolean noEdgesChanged = true;
        String tempBeforeEdit = null;
        for (int i = 0; i < numberOfStates; ++i) {
            ProblemEdge tempEdge = (ProblemEdge)toStatesVector.elementAt(i);
            EdgeData tempMyEdge = tempEdge.getEdgeData();
            if (noEdgesChanged) {
                tempBeforeEdit = tempEdge.toXMLString();
            }
            tempMyEdge.setSuccessMsg(fromactionLabel.getEdge().getSuccessMsg());
            tempMyEdge.setHints((Vector)fromactionLabel.getEdge().getAllHints().clone());
            if (!noEdgesChanged) continue;
            noEdgesChanged = tempBeforeEdit.equals(tempEdge.toXMLString());
        }
        if (!noEdgesChanged && trace.getDebugCode("undo")) {
            trace.out("undo", "HelpSuccessPanel.copySuccessHintMsgs() 1st changed edge was\n" + tempBeforeEdit);
        }
    }

    void updateTextAreas(ActionLabel referActionLabel) {
        String newText = this.successArea.getText();
        if (newText != null) {
            newText = newText.trim();
            referActionLabel.getEdge().setSuccessMsg(newText);
        } else {
            referActionLabel.getEdge().setSuccessMsg("");
        }
        Vector<String> newHints = new Vector<String>();
        for (int i = 0; i < this.numberHelpsInputArea; ++i) {
            newText = this.helpArea[i].getText();
            if (newText != null) {
                newText = newText.trim();
                newHints.addElement(newText);
                continue;
            }
            newHints.addElement("");
        }
        this.logHintChange(referActionLabel.getEdge().getHints(), newHints, referActionLabel.getEdge().getSkills().toString());
        referActionLabel.getEdge().setHints(newHints);
    }

    private void logHintChange(Vector oldHints, Vector newHints, String logArgument) {
        try {
            if (oldHints.size() == newHints.size()) {
                int i;
                for (i = 0; i < oldHints.size() && oldHints.get(i).equals(newHints.get(i)); ++i) {
                }
                if (i >= oldHints.size()) {
                    return;
                }
            }
            StringBuffer oldHintsBuffer = new StringBuffer();
            for (int i = 0; i < oldHints.size(); ++i) {
                oldHintsBuffer.append("Hint " + (i + 1) + ": " + oldHints.get(i) + "\n");
            }
            StringBuffer newHintsBuffer = new StringBuffer();
            for (int i = 0; i < newHints.size(); ++i) {
                newHintsBuffer.append("Hint " + (i + 1) + ": " + newHints.get(i) + "\n");
            }
            this.controller.getLoggingSupport().authorActionLog("BEHAVIOR_RECORDER", "EDIT_HINTS", logArgument, "Old: " + oldHintsBuffer.toString() + "New: " + newHintsBuffer.toString(), (Object)"");
        }
        catch (Exception e) {
            trace.err("Error " + e + " logging hint change");
            e.printStackTrace();
        }
    }
}

