/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherFactory;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStEdge;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStEdgeData;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStNode;
import edu.cmu.pact.miss.ProblemModel.Graph.SimStProblemGraph;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SimStBrdGraphReader {
    private SimStProblemGraph simStGraph;

    public SimStProblemGraph getProblemGraph() {
        return this.simStGraph;
    }

    public boolean openBRDFile(String filename) {
        InputStream is;
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        String absolutePath = null;
        String title = "Error loading graph file";
        try {
            trace.out("br", "READ FILE WITH JDOM: " + filename);
            File f = null;
            URL url = new URL(filename);
            is = url.openStream();
            f = Utils.getFileAsResource(url);
            try {
                absolutePath = f.getCanonicalPath();
            }
            catch (Exception d) {
                absolutePath = filename;
            }
        }
        catch (Exception e1) {
            try {
                File f = new File(filename);
                is = new FileInputStream(f);
                absolutePath = f.getCanonicalPath();
            }
            catch (Exception e2) {
                String message = "<html>Error opening file " + filename + ":<br/>" + e2 + (e2.getCause() == null ? "" : ".<br/>Cause: " + e2.getCause());
                e2.printStackTrace();
                return false;
            }
        }
        boolean result = this.loadBRDFileIntoSimStGraph(is);
        return result;
    }

    boolean loadBRDFileIntoSimStGraph(InputStream inputStream) {
        this.simStGraph = new SimStProblemGraph();
        try {
            if (trace.getDebugCode("br")) {
                trace.out("br", "READ InputStream WITH JDOM");
            }
            Document doc = this.parse(inputStream);
            this.processDocument(doc, this.simStGraph);
        }
        catch (Exception e) {
            if (trace.getDebugCode("pm")) {
                trace.out("pm", "error reading inputStream: " + e);
            }
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private Document parse(InputStream is) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        InputStreamReader isr = new InputStreamReader(is, "ISO-8859-1");
        Document doc = builder.build((Reader)isr);
        isr.close();
        return doc;
    }

    private void processDocument(Document document, SimStProblemGraph graph) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Element parentElt = document.getRootElement();
        List elts = parentElt.getChildren();
        for (Element e : elts) {
            if (e.getName().equals("node")) {
                this.processNode(e, graph);
                continue;
            }
            if (!e.getName().equals("edge")) continue;
            this.processEdge(e, graph);
        }
    }

    private void processNode(Element elt, SimStProblemGraph graph) {
        Element text = elt.getChild("text");
        String nodeidStr = elt.getChild("uniqueID").getValue();
        int nodeid = new Integer(nodeidStr);
        String name = text.getValue();
        SimStNode problemNode = new SimStNode(name, graph);
        problemNode.setUniqueID(nodeid);
        if (elt.getAttributeValue("doneState") != null) {
            boolean doneState = elt.getAttributeValue("doneState").equals("true");
            problemNode.setDoneState(doneState);
        }
        SimStNode tempNode = graph.addSSNode(problemNode);
        if (graph.getStartNode() == null) {
            graph.setStartNode(tempNode);
        }
    }

    private void processEdge(Element edgeElement, SimStProblemGraph graph) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Element sourceElement = edgeElement.getChild("sourceID");
        Element destinationElement = edgeElement.getChild("destID");
        Element traversalCountElt = edgeElement.getChild("traversalCount");
        Element actionLabelElement = edgeElement.getChild("actionLabel");
        Element actionLabelUniqueIDElement = actionLabelElement.getChild("uniqueID");
        Element messageElement = actionLabelElement.getChild("message");
        MessageObject messageObject = this.getMessageObject(messageElement);
        int ID = Integer.parseInt(actionLabelUniqueIDElement.getValue());
        int sourceID = Integer.parseInt(sourceElement.getValue());
        int destID = Integer.parseInt(destinationElement.getValue());
        int traversalCount = Integer.parseInt(traversalCountElt == null ? "-1" : traversalCountElt.getValue());
        String buggymsg = actionLabelElement.getChildText("buggyMessage");
        String success = actionLabelElement.getChildText("successMessage");
        String actionType = actionLabelElement.getChildText("actionType");
        String checked = actionLabelElement.getChildText("checkedStatus");
        boolean isPreferPath = actionLabelElement.getAttributeValue("preferPathMark").equals("true");
        SimStEdgeData edgeData = this.createEdgeDataForEdge(graph, actionLabelElement, ID, buggymsg, success, actionType, checked, isPreferPath);
        this.addMatcherForEdge(actionLabelElement, messageObject, edgeData);
        edgeData.setMinTraversalsStr(actionLabelElement.getAttributeValue("minTraversals"));
        edgeData.setMaxTraversalsStr(actionLabelElement.getAttributeValue("maxTraversals"));
        this.addRulesForEdge(edgeElement, edgeData);
        SimStNode sourceNode = SimStBrdGraphReader.getNodeForVertexUniqueID(sourceID, graph);
        SimStNode destinationNode = SimStBrdGraphReader.getNodeForVertexUniqueID(destID, graph);
        if (destinationNode == null) {
            throw new RuntimeException("Could not locate destination node for UniqueID " + destID);
        }
        if (sourceNode == null) {
            throw new RuntimeException("Could not locate source node for UniqueID " + sourceID);
        }
        edgeData.setTraversalCount(traversalCount);
        SimStEdge newEdge = graph.addSSEdge(sourceNode, destinationNode, edgeData);
        if (newEdge == null) {
            throw new RuntimeException("Error occuring adding edge between source " + sourceNode + " and destination " + destinationNode);
        }
    }

    private SimStEdgeData createEdgeDataForEdge(SimStProblemGraph graph, Element actionLabelElement, int ID, String buggymsg, String success, String actionType, String checked, boolean isPreferPath) {
        SimStEdgeData edgeData = new SimStEdgeData();
        List hintList = actionLabelElement.getChildren("hintMessage");
        for (Element hint : hintList) {
            String hintMessage = hint.getText();
            if (trace.getDebugCode("jdomreader")) {
                trace.out("jdomreader", "hint message = " + hintMessage);
            }
            edgeData.addHint(hintMessage);
        }
        edgeData.setBuggyMsg(buggymsg);
        edgeData.setCheckedStatus(checked);
        if (actionType != null) {
            edgeData.setActionType(actionType);
        }
        edgeData.setSuccessMsg(success);
        edgeData.setPreferredEdge(isPreferPath);
        edgeData.setUniqueID(ID);
        return edgeData;
    }

    private MessageObject getMessageObject(Element messageElement) {
        return MessageObject.fromElement(messageElement);
    }

    private void addRulesForEdge(Element edgeElement, SimStEdgeData edgeData) {
        List ruleElements = edgeElement.getChildren("rule");
        for (Element ruleElement : ruleElements) {
            String ruleLabelText = ruleElement.getChildText("text");
            edgeData.addRuleName(ruleLabelText);
        }
    }

    public static SimStNode getNodeForVertexUniqueID(int vertexUniqueID, SimStProblemGraph problemGraph) {
        for (SimStNode node = problemGraph.getFirstNode(); node != null; node = node.getNextNode()) {
            if (node.getUniqueID() != vertexUniqueID) continue;
            return node;
        }
        return null;
    }

    private void addMatcherForEdge(Element actionLabelElement, MessageObject messageObject, SimStEdgeData edgeData) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, IllegalArgumentException, NoSuchMethodException, InvocationTargetException {
        Element matcherElement = actionLabelElement.getChild("matcher");
        Vector<String> currentSelection = messageObject.getSelection();
        Vector<String> currentAction = messageObject.getAction();
        Vector<String> currentInput = messageObject.getInput();
        if (matcherElement != null) {
            Matcher m = this.createMatcher(matcherElement);
            edgeData.setMatcher(m);
            m.setDefaultSelectionVector(currentSelection);
            m.setDefaultActionVector(currentAction);
            m.setDefaultInputVector(currentInput);
        } else {
            ExactMatcher m = this.buildDefaultExactMatcher(messageObject, edgeData);
            if (m != null) {
                edgeData.setMatcher(m);
            }
        }
        edgeData.setSelection(currentSelection.get(0));
        edgeData.setAction(currentAction.get(0));
        edgeData.setInput(currentInput.get(0));
    }

    private Matcher createMatcher(Element matcherElement) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        return this.createMatcher(matcherElement, false, false, -1);
    }

    private Matcher createMatcher(Element matcherElement, boolean single, boolean concat2, int vector) throws SecurityException, IllegalArgumentException, InstantiationException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException {
        if (matcherElement == null) {
            return null;
        }
        String matcherType = matcherElement.getChildText("matcherType");
        Matcher m = null;
        m = single ? MatcherFactory.buildSingleMatcher(matcherType, concat2, vector) : MatcherFactory.buildMatcher(matcherType);
        if (trace.getDebugCode("functions")) {
            trace.outln("functions", "created matcher " + m.getClass() + " for type " + matcherType);
        }
        List paramList = matcherElement.getChildren("matcherParameter");
        int count = 0;
        for (Element e : paramList) {
            m.setParameter(e, count);
            ++count;
        }
        m.setReplacementFormula(matcherElement.getAttributeValue("replacementFormula"));
        return m;
    }

    private ExactMatcher buildDefaultExactMatcher(MessageObject messageObject, SimStEdgeData edgeData) {
        Vector<String> selection = messageObject.getSelection();
        Vector<String> action = messageObject.getAction();
        Vector<String> input = messageObject.getInput();
        ExactMatcher m = new ExactMatcher(selection, action, input);
        edgeData.setMatcher(m);
        return m;
    }
}

