/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.ctat;

import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.CommException;
import edu.cmu.pact.ctat.DataFormatException;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.MultiTarget;
import edu.cmu.pact.ctat.NoSuchObjectException;
import edu.cmu.pact.ctat.ObjectSpecifier;
import edu.cmu.pact.ctat.PaintSharable;
import edu.cmu.pact.ctat.ProxyHashtable;
import edu.cmu.pact.ctat.Sharable;
import edu.cmu.pact.ctat.Target;
import edu.cmu.pact.ctat.TargetRegistry;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class ObjectProxy
extends ObjectSpecifier {
    Vector parents;
    Object realObject = null;
    protected Hashtable Properties = new Hashtable();
    public ProxyHashtable Children;
    MultiTarget reply_targets;
    public static int objectID;
    public static ObjectProxy topObjectProxy;

    public ObjectProxy() {
        this.parents = new Vector();
        this.Children = new ProxyHashtable();
    }

    public ObjectProxy(String type, String name, ObjectProxy parent) {
        this(type, name, parent, null, -9999);
    }

    public ObjectProxy(String type, ObjectProxy parent, String id) {
        this(type, null, parent, id, -9999);
    }

    public ObjectProxy(String type, ObjectProxy parent, int position) {
        this(type, null, parent, null, position);
    }

    public ObjectProxy(ObjectProxy parent, String type) {
        this(type, null, parent, null, -9999);
    }

    public ObjectProxy(String type) {
        this(type, null, null, null, -9999);
    }

    public ObjectProxy(String type, String name, ObjectProxy parent, String id, int position) {
        this();
        this.init(type, name, parent, id, position);
    }

    public void init(String type, String name, ObjectProxy parent, String id, int position) {
        super.init(type);
        this.Properties.put("TYPE", type);
        this.setContainer(parent);
        String def = "";
        if (name != null) {
            def = "NAME";
        } else if (name == null) {
            name = type + "0";
        }
        this.Properties.put("NAME", name);
        if (position != -9999) {
            this.Properties.put("POSITION", String.valueOf(position));
            def = "POSITION";
        } else if (position == -9999) {
            this.setPosition();
        }
        if (id == null) {
            id = String.valueOf(objectID);
            ++objectID;
        }
        this.Properties.put("UNIQUEID", id);
        if (def.equalsIgnoreCase("")) {
            def = "POSITION";
        }
        this.Properties.put("Default", def);
        if (parent == null) {
            topObjectProxy = this;
        }
    }

    public void init(String type, String name, ObjectProxy parent) {
        this.init(type, name, parent, null, -9999);
    }

    public void init(String type, ObjectProxy parent, String id) {
        this.init(type, null, parent, id, -9999);
    }

    public void init(String type, ObjectProxy parent, int position) {
        this.init(type, null, parent, null, position);
    }

    public void init(ObjectProxy parent, String type) {
        this.init(type, null, parent, null, -9999);
    }

    @Override
    public void init(String type) {
        this.init(type, null, null, null, -9999);
    }

    public String getProxyTree() {
        return this.getTree("");
    }

    public String getTree(String toret) {
        toret = "||" + toret + this.getStrDescription();
        int s = this.Children.size();
        if (s > 0) {
            Enumeration e = this.Children.keys();
            while (e.hasMoreElements()) {
                Vector el = (Vector)this.Children.get(e.nextElement());
                int es = el.size();
                if (es <= 0) continue;
                for (int k = 0; k < es; ++k) {
                    toret = toret + ((ObjectProxy)el.elementAt(k)).getTree("") + "\n";
                }
            }
        }
        return toret;
    }

    public void mailToProxy(MessageObject mo) throws CommException {
        this.mailToProxy(mo, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mailToProxy(MessageObject mo, Vector description) throws CommException {
        int size = 0;
        if (description != null) {
            size = description.size();
        }
        if (size == 0) {
            this.treatMessage(mo, mo.getVerb());
            return;
        }
        if (((String)description.elementAt(0)).equalsIgnoreCase(this.type)) {
            if (!this.isThisProxy(description)) throw new NoSuchObjectException(NoSuchObjectException.getObjectDesc(mo));
            for (int i = 0; i < 3; ++i) {
                description.removeElementAt(0);
            }
            this.mailToProxy(mo, description);
            return;
        }
        if (((String)description.elementAt(0)).equalsIgnoreCase(this.type)) throw new NoSuchObjectException(NoSuchObjectException.getObjectDesc(mo));
        this.constructChildProxy(mo, description);
        return;
    }

    public void constructChildProxy(MessageObject mo, Vector description) throws CommException {
        Vector<String> childDesc = new Vector<String>(3);
        for (int i = 0; i < 3; ++i) {
            childDesc.addElement((String)description.elementAt(i));
        }
        ObjectProxy child = this.getContainedProxy(childDesc);
        if (child != null) {
            child.mailToProxy(mo, description);
        }
        this.constructNewChild(mo, description);
    }

    public void treatMessage(MessageObject mo, String verb) throws CommException {
        trace.out("treatMessage called in ObjectProxy");
    }

    public void constructNewChild(MessageObject mo, Vector description) throws NoSuchObjectException {
        throw new NoSuchObjectException(NoSuchObjectException.getObjectDesc(mo));
    }

    public void setRealObject(Object realObject) {
        this.realObject = realObject;
    }

    private void setContainer(ObjectProxy parent) {
        this.parents.addElement(parent);
        if (parent != null) {
            parent.contain(this);
            this.reply_targets = parent.getTarget();
        }
    }

    public ObjectProxy getContainer() {
        return (ObjectProxy)this.parents.elementAt(0);
    }

    public ObjectProxy getTopContainer() {
        ObjectProxy root = null;
        for (ObjectProxy parent = this.getContainer(); parent != null; parent = parent.getContainer()) {
            root = parent;
        }
        return root;
    }

    public boolean isInside(int pos, String type) {
        int childrenSize;
        boolean inside = false;
        ObjectProxy parent = this.getContainer();
        if (parent != null && pos < (childrenSize = parent.Children.size(type))) {
            return true;
        }
        return inside;
    }

    public void resetPosition(ObjectProxy ch_obj, int pos) {
        int movePos = 0;
        int removePos = 0;
        boolean moveIt = false;
        int curPos = this.Children.indexOf(ch_obj);
        if (curPos < pos) {
            movePos = pos;
            removePos = curPos;
            moveIt = true;
        } else if (curPos > pos) {
            movePos = pos;
            removePos = curPos + 1;
            moveIt = true;
        }
        if (moveIt) {
            this.Children.insertElementAt(ch_obj, movePos);
            ch_obj.Properties.put("POSITION", String.valueOf(movePos + 1));
            this.Children.removeElementAt(ch_obj, removePos);
        }
    }

    public void setName(String name) {
        this.Properties.put("NAME", name);
    }

    public void setType(String t) {
        this.getContainer().Children.removeElement(this);
        this.type = t.toUpperCase();
        this.Properties.put("TYPE", t);
        this.getContainer().contain(this);
    }

    public void setPosition() {
        ObjectProxy parent = this.getContainer();
        if (parent != null) {
            int pos = parent.Children.indexOf(this) + 1;
            this.Properties.put("POSITION", String.valueOf(pos));
        } else {
            this.Properties.put("POSITION", String.valueOf(1));
        }
    }

    public void setPosition(int pos) {
        if (this.isInside(pos, this.type)) {
            this.resetPosition(this, pos);
            this.Properties.put("POSITION", String.valueOf(pos));
        }
    }

    public void setPosition(String posS) {
        try {
            int pos = Integer.parseInt(posS);
            this.setPosition(pos);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void setID(String id) {
        this.Properties.put("UNIQUEID", id);
        this.Properties.put("Default", "UNIQUEID");
    }

    public ObjectProxy[] getRange(int stPos, int endPos, String type) {
        if (this.isInside(stPos, type) && this.isInside(endPos, type)) {
            int siz = endPos - stPos + 1;
            ObjectProxy[] toret = new ObjectProxy[siz];
            for (int i = 0; i < siz; ++i) {
                toret[i] = this.Children.elementAt(type, stPos + i);
            }
            return toret;
        }
        return null;
    }

    public void defaultNameDescription() {
        this.Properties.put("Default", "NAME");
    }

    public void defaultPosDescription() {
        this.Properties.put("Default", "POSITION");
    }

    public void defaultIDDescription() {
        this.Properties.put("Default", "UNIQUEID");
    }

    public String getDefaultDescriptor() {
        if (this.Properties == null) {
            trace.out(10, this, "ERROR: properties is null");
            return new String("");
        }
        if (this.Properties.isEmpty()) {
            trace.out(10, this, "ERROR: properties is empty");
            return new String("");
        }
        String desc = (String)this.Properties.get("Default");
        if (desc == null) {
            trace.out("NullPointer in ObjectProxy getDefaultDescriptor for " + this.type + " position = " + this.getPosition());
            this.Properties.put("DEFAULT", "POSITION");
            desc = "POSITION";
        }
        return desc;
    }

    public String getName() {
        return (String)this.Properties.get("NAME");
    }

    public int getPosition() {
        String pos = (String)this.Properties.get("POSITION");
        return Integer.parseInt(pos);
    }

    public String getID() {
        return (String)this.Properties.get("UNIQUEID");
    }

    public void setOwnProperty(String name, Object prop) {
        this.Properties.put(name, prop);
    }

    public Object getOwnProperty(String name) {
        return this.Properties.get(name.toUpperCase());
    }

    public String getDefaultIdentificator() {
        String defDesc = (String)this.getOwnProperty("Default");
        if (defDesc != null && defDesc.equalsIgnoreCase("NAME")) {
            return (String)this.getOwnProperty("NAME");
        }
        return this.type;
    }

    public Hashtable getOwnProperties() {
        return this.Properties;
    }

    public void contain(ObjectProxy con) {
        if (!this.Children.contains(con)) {
            this.Children.addElement(con);
        }
    }

    @Override
    public String toString() {
        return this.getStrDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProxy() {
        ObjectProxy objectProxy = this;
        synchronized (objectProxy) {
            int s;
            ObjectProxy parent;
            if (this.realObject != null && this.realObject instanceof Sharable) {
                try {
                    ((Sharable)this.realObject).setProperty("isVisible", Boolean.valueOf("false"));
                }
                catch (CommException commException) {
                    // empty catch block
                }
                ((Sharable)this.realObject).delete();
                this.realObject = null;
            }
            if ((parent = this.getContainer()) != null) {
                parent.Children.removeElement(this);
                parent.refreshChildrenPositions(this.type);
            }
            if ((s = this.Children.size()) > 0) {
                Enumeration e = this.Children.keys();
                while (e.hasMoreElements()) {
                    Vector el = (Vector)this.Children.get(e.nextElement());
                    int es = el.size();
                    if (es <= 0) continue;
                    for (int k = 0; k < es; ++k) {
                        ((ObjectProxy)el.elementAt(0)).deleteProxy();
                    }
                }
            }
            this.parents = null;
            this.Properties = null;
            this.reply_targets = null;
            this.deleteSpecifier();
        }
    }

    protected void refreshChildrenPositions(String type) {
        Vector childrenByType = (Vector)this.Children.get(type);
        int s = childrenByType.size();
        if (s > 0) {
            for (int i = 0; i < s; ++i) {
                this.resetPosition((ObjectProxy)childrenByType.elementAt(i), i);
            }
        }
    }

    protected void finalize() throws Throwable {
        this.Children = null;
        super.finalize();
    }

    public void addTarget(Target ot) {
        if (this.reply_targets == null) {
            this.reply_targets = new MultiTarget("Targets");
        }
        trace.out("m", "****  add target: " + ot);
        this.reply_targets.addTarget(ot);
    }

    public MultiTarget getTarget() {
        return this.reply_targets;
    }

    public Object getObjectByName(Vector desc) {
        return this.getDescribedObject(desc);
    }

    public Object getRealParent() {
        ObjectProxy obj_pro = this.getContainer();
        return obj_pro.getObject();
    }

    public void changeParent(String parentName) {
        ObjectProxy obj_parent = this.getContainer();
        String parent_type = (String)obj_parent.getOwnProperty("TYPE");
        ObjectProxy parent_parent = obj_parent.getContainer();
        if (parent_parent != null) {
            Vector chV = parent_parent.getChildrenByType(parent_type);
            int s = chV.size();
            if (s == 0) {
                obj_parent.setName(parentName);
                return;
            }
            boolean found = false;
            for (int i = 0; i < s; ++i) {
                ObjectProxy op = (ObjectProxy)chV.elementAt(i);
                if (!((String)op.getOwnProperty("NAME")).equalsIgnoreCase(parentName)) continue;
                found = true;
                obj_parent.Children.removeElement(this);
                this.parents.removeElementAt(0);
                this.setContainer(op);
                this.setPosition();
                break;
            }
            if (!found) {
                obj_parent.setName(parentName);
            }
        }
    }

    public Object getDescribedObject(Vector description) {
        ObjectProxy top = this.getTopContainer();
        Vector topDesc = top.getDescription();
        for (int i = 0; i < 3; ++i) {
            description.setElementAt((String)topDesc.elementAt(i), i);
        }
        ObjectProxy stop = this.getObjectProxyBy(description);
        if (stop != null) {
            return stop.getObject();
        }
        return this.getObject();
    }

    public Object getDescribedObject(String description) {
        Vector<String> desc = new Vector<String>();
        StringTokenizer st = new StringTokenizer(description, ",");
        while (st.hasMoreElements()) {
            desc.addElement(st.nextToken());
        }
        return this.getDescribedObject(desc);
    }

    public Vector getChildrenByType(String typ) {
        Vector toret = null;
        try {
            Vector typeChildren = (Vector)this.Children.get(typ);
            return typeChildren;
        }
        catch (NullPointerException e) {
            trace.out(e.toString());
            return toret;
        }
    }

    public ObjectProxy getChildByType(String typ) {
        ObjectProxy toret = null;
        try {
            Vector allChildren = this.getChildrenByType(typ);
            if (allChildren != null && allChildren.size() != 0) {
                toret = (ObjectProxy)allChildren.elementAt(0);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return toret;
    }

    public ObjectProxy getContainedProxyByType(String typ) {
        ObjectProxy toret = null;
        try {
            Vector typeChildren = (Vector)this.Children.get(typ);
            int chs = typeChildren.size();
            if (chs == 1) {
                return (ObjectProxy)typeChildren.elementAt(0);
            }
        }
        catch (NullPointerException e) {
            trace.out(e.toString());
        }
        return toret;
    }

    protected boolean isThisProxy(Vector description) {
        boolean isThis = false;
        String format = ((String)description.elementAt(1)).toUpperCase();
        try {
            if (((String)this.Properties.get(format)).equalsIgnoreCase((String)description.elementAt(2)) && ((String)this.Properties.get("TYPE")).equalsIgnoreCase((String)description.elementAt(0))) {
                description.removeAllElements();
                description = null;
                return true;
            }
        }
        catch (NullPointerException e) {
            description.removeAllElements();
            description = null;
            return isThis;
        }
        description.removeAllElements();
        description = null;
        return isThis;
    }

    public ObjectProxy getObjectProxyBy(Vector description) {
        ObjectProxy toret = null;
        boolean upperFound = false;
        try {
            int st = description.size() / 3 - 1;
            String format = ((String)description.elementAt(1)).toUpperCase();
            if (((String)this.Properties.get(format)).equalsIgnoreCase((String)description.elementAt(2)) && ((String)this.Properties.get("TYPE")).equalsIgnoreCase((String)description.elementAt(0))) {
                upperFound = true;
                if (st == 0) {
                    return this;
                }
            }
            if (st > 0 && upperFound) {
                description.removeElementAt(0);
                description.removeElementAt(0);
                description.removeElementAt(0);
                ObjectProxy temp = this.getContainedObjectBy((String)description.elementAt(0), (String)description.elementAt(1), (String)description.elementAt(2));
                if (temp != null) {
                    toret = temp.getObjectProxyBy(description);
                }
                if (temp == null) {
                    return this;
                }
            }
        }
        catch (NullPointerException e) {
            trace.out(e.toString());
        }
        return toret;
    }

    public ObjectProxy getContainedProxy(Vector desc) {
        return this.getContainedObjectBy((String)desc.elementAt(0), (String)desc.elementAt(1), (String)desc.elementAt(2));
    }

    public ObjectProxy getContainedObjectBy(String type, String format, String value) {
        ObjectProxy toret = null;
        try {
            Vector typeChildren = (Vector)this.Children.get(type);
            int chs = typeChildren.size();
            if (chs > 0) {
                for (int i = 0; i < chs; ++i) {
                    if (!((String)((ObjectProxy)typeChildren.elementAt(i)).getOwnProperty(format)).equalsIgnoreCase(value)) continue;
                    return (ObjectProxy)typeChildren.elementAt(i);
                }
            }
        }
        catch (NullPointerException e) {
            toret = null;
        }
        return toret;
    }

    public Object getObject() {
        return this.realObject;
    }

    private MessageObject constructMessage(MessageObject outEvent) {
        return outEvent;
    }

    public synchronized void send(MessageObject outEvent) {
        outEvent = this.constructMessage(outEvent);
        outEvent.send(this.reply_targets);
    }

    public synchronized void send(MessageObject outEvent, String targetName) {
        outEvent = this.constructMessage(outEvent);
        Target sendTo = TargetRegistry.targets.getTarget(targetName);
        outEvent.send(sendTo);
    }

    public Vector getDescriptionBy(String desc) {
        return this.getDescription();
    }

    public String getLowerObjectType(String desc) {
        Vector vec = this.getDescriptionBy(desc);
        int s = vec.size();
        if (s < 3) {
            return null;
        }
        return (String)vec.elementAt(s - 3);
    }

    public Vector getDescription() {
        String description = this.getStrDescription();
        return this.getDescription(description);
    }

    private String internalStrDescription() {
        String describeBy = this.getDefaultDescriptor();
        StringBuffer toret = new StringBuffer();
        if (describeBy.equalsIgnoreCase("NAME")) {
            toret.append("S:");
        } else {
            toret.append("I:");
        }
        toret.append(((String)this.Properties.get(describeBy)).length());
        toret.append(":");
        toret.append((String)this.Properties.get(describeBy));
        toret.append(",");
        toret.append("S:");
        toret.append(describeBy.length());
        toret.append(":");
        toret.append(describeBy);
        toret.append(",");
        toret.append("S:");
        toret.append(((String)this.Properties.get("TYPE")).length());
        toret.append(":");
        toret.append((String)this.Properties.get("TYPE"));
        toret.append(",");
        try {
            ObjectProxy parent = (ObjectProxy)this.parents.elementAt(0);
            toret.append(parent.internalStrDescription());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return toret.toString();
    }

    public String reverseDescription(String description) {
        int buffSize;
        StringBuffer toret = new StringBuffer();
        Vector buff = this.getDescription(description);
        int s = buff.size();
        if (s == 0) {
            return "";
        }
        toret.append(s / 3);
        toret.append(":");
        for (int i = buffSize = buff.size() - 1; i > 0; --i) {
            toret.append((String)buff.elementAt(i));
            toret.append(",");
        }
        toret.append(buff.elementAt(0));
        return toret.toString();
    }

    public Vector getDescription(String description) {
        Vector<String> buff = new Vector<String>();
        StringTokenizer st = new StringTokenizer(description, ",");
        int cou = st.countTokens();
        for (int i = 0; i < cou; ++i) {
            if (i != cou - 1) {
                buff.addElement(st.nextToken());
                continue;
            }
            String lastToken = st.nextToken();
            int rem = cou % 3;
            if (rem == 1) {
                String last2 = (String)buff.lastElement();
                buff.removeElementAt(i - 1);
                lastToken = last2 + "," + lastToken;
            }
            buff.addElement(lastToken);
        }
        return buff;
    }

    public String getLocalStrDesc(Vector v) {
        String toret = "";
        for (int i = 0; i < 2; ++i) {
            toret = toret + (String)v.elementAt(i) + ",";
        }
        toret = toret + (String)v.elementAt(2);
        return toret;
    }

    public String getStrDescription() {
        String toret = this.internalStrDescription();
        return this.reverseDescription(toret);
    }

    public void setRealObjectProperties(Sharable realObj, MessageObject inEvent) throws CommException {
        Vector propertyNames = (Vector)inEvent.getPropertyNames();
        Vector propertyValues = (Vector)inEvent.getPropertyValues();
        int s = propertyNames.size();
        if (s == 0) {
            return;
        }
        if (s != propertyValues.size()) {
            throw new DataFormatException("Not equal sizes of propertyNames : " + s + " and propertyValues : " + propertyValues.size() + "\npropertyNames = " + propertyNames + "\npropertyValues = " + propertyValues);
        }
        for (int i = 0; i < s; ++i) {
            String currName = (String)propertyNames.elementAt(i);
            if (currName.equalsIgnoreCase("NAMINGPREFERENCE") || currName.equalsIgnoreCase("NAMINGPREFERENCES")) {
                this.Properties.put("Default", ((String)propertyValues.elementAt(i)).toUpperCase());
                continue;
            }
            if (realObj == null) continue;
            realObj.setProperty(currName, propertyValues.elementAt(i));
        }
        if (realObj != null && realObj instanceof PaintSharable) {
            ((PaintSharable)realObj).repaintObject();
        }
    }
}

