/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Utilities;

import edu.cmu.old_pact.dormin.MessageObject;
import edu.cmu.old_pact.dormin.ObjectProxy;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Log.TutorActionLog;
import edu.cmu.pact.Log.TutorActionLogV4;
import edu.cmu.pact.Utilities.OLIMessageConverters;
import edu.cmu.pact.Utilities.OLIMessageObject;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.LogWorkingMemory;
import edu.cmu.pslc.logging.ContextMessage;
import edu.cmu.pslc.logging.LogContext;
import edu.cmu.pslc.logging.Message;
import edu.cmu.pslc.logging.PlainMessage;
import edu.cmu.pslc.logging.ToolMessage;
import edu.cmu.pslc.logging.TutorMessage;
import edu.cmu.pslc.logging.element.SkillElement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jdom.Element;

public class OLIMessageObjectV4
extends OLIMessageObject {
    public static final String WMIAGESS_PNAME = "WMImages";
    public static final String STEP_ID = "step_id";
    public static ConvertersV4 converters;

    public OLIMessageObjectV4(Element elt, ObjectProxy top, LogContext logger) {
        super(elt, top, logger);
    }

    public OLIMessageObjectV4(MessageObject mo, boolean tutorToTool, LogContext logger) {
        super(mo, tutorToTool, logger);
    }

    public OLIMessageObjectV4(String xmlStr, LogContext logger) {
        super(xmlStr, "4", null, logger);
    }

    public OLIMessageObjectV4(String xmlStr, ObjectProxy top, BR_Controller controller) {
        super(xmlStr, "4", top, controller == null ? null : controller.getLogger());
    }

    public OLIMessageObjectV4(TutorActionLog logMsg, ObjectProxy top, BR_Controller controller) {
        super(logMsg, top, controller);
    }

    @Override
    protected TutorActionLog createTutorActionLog(Element elt) {
        return new TutorActionLogV4(elt, null);
    }

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected OLIMessageConverters initConvs(LogContext logger) {
        if (logger == null) {
            if (OLIMessageObjectV4.getConvs() == null) {
                this.setConvs(new ConvertersV4(logger));
            }
            return OLIMessageObjectV4.getConvs();
        }
        LogContext logContext = logger;
        synchronized (logContext) {
            TutorActionLog msg = this.getLogMsg();
            if (OLIMessageObjectV4.getConvs() == null) {
                if (msg != null) {
                    int versNum = Integer.parseInt(msg.getDTDVersionNumber());
                    if (trace.getDebugCode("log")) {
                        trace.out("log", "OLIMsgObjV4.initConvs() msg " + ((Object)((Object)msg)).getClass() + ", versNum " + versNum);
                    }
                    if (versNum > 2) {
                        this.setConvs(new ConvertersV4(logger));
                    } else {
                        this.setConvs(new OLIMessageObject.ConvertersV2(logger));
                    }
                } else {
                    this.setConvs(new ConvertersV4(logger));
                }
            }
            return OLIMessageObjectV4.getConvs();
        }
    }

    @Override
    public OLIMessageConverters.Conv getOLI2NativeConverter(String oli, String oliEval) {
        if (oli == null || OLIMessageObjectV4.getConvs() == null) {
            return null;
        }
        String key = oli;
        if (oliEval != null) {
            key = key + " " + oliEval;
        }
        key = key.toUpperCase();
        OLIMessageConverters.Conv conv = (OLIMessageConverters.Conv)OLIMessageObjectV4.getConvs().getMapOLI2Native().get(key);
        if (conv == null || conv.getCommMsgType() == null) {
            conv = (OLIMessageConverters.Conv)OLIMessageObjectV4.getConvs().getMapOLI2Native().get(oli);
        }
        if (conv == null || conv.getCommMsgType() == null) {
            System.err.println("no native mapping for OLI event " + oli + ", actionEvaluation " + oliEval);
            conv = new OtherMsgConvV4(this.logger);
            OLIMessageObjectV4.getConvs().getMapOLI2Native().put(key, conv);
        }
        return conv;
    }

    public String getContextMessageId() {
        return ((TutorActionLogV4)this.getLogMsg()).getContextMessageId();
    }

    public String getTransactionId() {
        if (this.getLogMsg() == null) {
            return null;
        }
        return ((TutorActionLogV4)this.getLogMsg()).getTransactionId();
    }

    public String UTCTimeStamp(Date result) {
        TimeZone tz = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        df.setTimeZone(tz);
        String now = df.format(result);
        System.err.printf("Convert from \"%27s\" == %s\n\n", result, now);
        return now;
    }

    static class ConvertersV4
    extends OLIMessageConverters {
        ConvertersV4(LogContext logger) {
            super(new OtherMsgConvV4(logger), new ConvV4("HINT_REQUEST", null, "InterfaceAction", null, Boolean.FALSE, logger), new HashMap(), new HashMap());
            Boolean F = Boolean.FALSE;
            Boolean T = Boolean.TRUE;
            OLIMessageConverters.Conv[] conv = new OLIMessageConverters.Conv[]{new ConvV4("ATTEMPT", null, "InterfaceAction", null, F, logger), new ConvV4("GLOSSARY", null, "Glossary", null, F, logger), new ConvV4("COGNITIVE_LOAD", null, "CognitiveLoad", null, F, logger), new SkillsConvV4("RESULT", "AssociatedRules", T, logger), new StartProblemConvV4("START_TUTOR", null, "StartProblem", logger), new StartProblemConvV4("START_PROBLEM", null, "StartProblem", logger), new ConvV4("HINT_MSG", "HINT_NEXT", "NextHintMessage", "HintsMessage", T, logger), new ConvV4("HINT_MSG", "HINT_PREVIOUS", "PreviousHintMessage", "HintsMessage", T, logger), new StartProblemConvV4("START_TUTOR", null, "LoadBRDFileSuccess", logger)};
            this.initConvMaps(conv);
        }
    }

    static class ConvV4
    extends OLIMessageConverters.Conv {
        private static final Pattern HintPattern = Pattern.compile(".*[hH][iI][nN][tT].*");

        public ConvV4(String semanticEvt, String actionEvaluation, String commMsgType, String advicePname, Boolean tutorToToolRestriction, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, advicePname, tutorToToolRestriction, logger);
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            OLIMessageConverters convs = OLIMessageObject.getConvs();
            TutorActionLog result = null;
            String replay = (String)mo.getProperty("replay");
            String indicator = (String)mo.getProperty("Indicator");
            if (trace.getDebugCode("log")) {
                trace.out("log", "indicator " + indicator + ", actionEval " + this.getActionEvaluation());
            }
            if (indicator != null && indicator.length() > 0) {
                this.setActionEvaluation(indicator);
            }
            if (this.getTutorToToolRestriction() != null && this.getTutorToToolRestriction() != tutorToTool && (result = convs.getOtherMsgConv().native2OLI(propertyNames, propertyValues, mo, tutorToTool, logger)) instanceof TutorActionLogV4) {
                ((TutorActionLogV4)result).setReplay(replay);
            }
            if (tutorToTool) {
                ToolMessage lastToolMessage = this.getLastToolMessage(logger);
                lastToolMessage.setTransactionId(mo.getTransactionId());
                TutorMessage msg = TutorMessage.create((ToolMessage)lastToolMessage);
                String actionEvaluation = this.getActionEvaluation();
                this.setResponseType(actionEvaluation, msg);
                result = new TutorActionLogV4(msg);
                result.setProblemName(logger.getProblemName());
                this.createEventDesc(propertyNames, propertyValues, result);
                if (replay != null) {
                    ((TutorActionLogV4)result).setReplay(replay);
                }
                if (actionEvaluation != null && actionEvaluation.toUpperCase().contains("HINT")) {
                    this.populateHintElements(propertyNames, propertyValues, result);
                    this.addTimeStamp((TutorActionLogV4)result);
                    this.addStepId(propertyNames, propertyValues, (TutorActionLogV4)result);
                    return result;
                }
            } else {
                ToolMessage msg = ToolMessage.create((ContextMessage)logger.getContextMessage());
                if (OLIMessageConverters.HintConv.isUIEventMsg(mo)) {
                    this.setAsUIEvent(msg, mo.getTransactionId());
                } else {
                    if (OLIMessageConverters.HintConv.isHintMsg(mo)) {
                        msg.setAsHintRequest();
                    } else {
                        msg.setAsAttempt();
                    }
                    msg.setTransactionId(mo.getTransactionId());
                    logger.setLastToolMessage(msg);
                }
                result = new TutorActionLogV4(msg);
                result.setProblemName(logger.getProblemName());
                this.createEventDesc(propertyNames, propertyValues, result);
                if (replay != null) {
                    ((TutorActionLogV4)result).setReplay(replay);
                }
                if (OLIMessageConverters.HintConv.isUIEventMsg(mo) || OLIMessageConverters.HintConv.isHintMsg(mo)) {
                    this.addTimeStamp((TutorActionLogV4)result);
                    return result;
                }
            }
            if (this.getActionEvaluation() != null) {
                result.addActionEvaluation(this.getActionEvaluation());
            }
            this.createTutorAdvices(propertyNames, propertyValues, result);
            this.createSkills(propertyNames, propertyValues, result);
            if (replay != null) {
                ((TutorActionLogV4)result).setReplay(replay);
            }
            this.addTimeStamp((TutorActionLogV4)result);
            this.addWMImages(propertyNames, propertyValues, (TutorActionLogV4)result);
            this.addStepId(propertyNames, propertyValues, (TutorActionLogV4)result);
            return result;
        }

        private void addStepId(Vector propertyNames, Vector propertyValues, TutorActionLogV4 logMsg) {
            Message msg = logMsg.getMsg();
            String stepId = (String)OLIMessageObject.getValue(propertyNames, propertyValues, "StepID");
            if (stepId == null || stepId.length() < 1) {
                return;
            }
            if (msg instanceof TutorMessage) {
                ((TutorMessage)msg).addCustomField(OLIMessageObjectV4.STEP_ID, stepId);
            } else if (msg instanceof ToolMessage) {
                ((ToolMessage)msg).addCustomField(OLIMessageObjectV4.STEP_ID, stepId);
            }
        }

        protected int addWMImages(Vector propertyNames, Vector propertyValues, TutorActionLogV4 logMsg) {
            Message msg = logMsg.getMsg();
            int count = 0;
            Vector wmImages = (Vector)OLIMessageObject.getValue(propertyNames, propertyValues, OLIMessageObjectV4.WMIAGESS_PNAME);
            if (wmImages != null) {
                Iterator it = wmImages.iterator();
                while (it.hasNext()) {
                    String[] parsedImage = LogWorkingMemory.parseImage((String)it.next());
                    if (msg instanceof TutorMessage) {
                        ((TutorMessage)msg).addCustomField(parsedImage[0], parsedImage[1]);
                    } else if (msg instanceof ToolMessage) {
                        ((ToolMessage)msg).addCustomField(parsedImage[0], parsedImage[1]);
                    }
                    ++count;
                }
            }
            return count;
        }

        public void addTimeStamp(TutorActionLogV4 result) {
            Message msg = result.getMsg();
            TimeZone tz = TimeZone.getTimeZone("UTC");
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            df.setTimeZone(tz);
            String now = df.format(result.getTimeStamp());
            if (msg instanceof TutorMessage) {
                ((TutorMessage)msg).addCustomField("tutor_event_time", now);
            } else if (msg instanceof ToolMessage) {
                ((ToolMessage)msg).addCustomField("tool_event_time", now);
            }
        }

        @Override
        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            TutorActionLogV4 logV4 = null;
            if (logMsg instanceof TutorActionLogV4 && (logV4 = (TutorActionLogV4)logMsg).getReplay() != null) {
                mo.addPropertyElement("replay", logV4.getReplay());
            }
            if (this.getSemanticEvt().equals("HINT_REQUEST")) {
                this.createPropertyList(logMsg, mo);
                OLIMessageObject.setProperty(mo, "MessageType", "InterfaceAction");
                String action0 = (String)OLIMessageObject.getPropertyElement(mo, "Action", 0);
                if (!"ButtonPressed".equalsIgnoreCase(action0)) {
                    OLIMessageObject.insertPropertyElement(mo, "Action", 0, "ButtonPressed");
                    OLIMessageObject.insertPropertyElement(mo, "Selection", 0, "Hint");
                    OLIMessageObject.insertPropertyElement(mo, "Input", 0, "-1");
                }
                return;
            }
            if (trace.getDebugCode("log")) {
                trace.out("log", "OLIMsgObjV4.ConvV4.OLI2Native(" + (Object)((Object)logMsg) + ")");
            }
            this.createPropertyList(logMsg, mo);
        }

        private ToolMessage getLastToolMessage(LogContext logger) {
            ToolMessage result = logger.getLastToolMessage();
            if (result != null) {
                return result;
            }
            result = ToolMessage.create((ContextMessage)logger.getContextMessage());
            result.setAsAttempt();
            return result;
        }

        @Override
        protected int createSkills(Vector propertyNames, Vector propertyValues, TutorActionLog logMsg) {
            int result = 0;
            Vector skills = (Vector)OLIMessageObject.getValue(propertyNames, propertyValues, "Skills");
            if (skills != null) {
                Iterator it = skills.iterator();
                while (it.hasNext()) {
                    this.parseAndAddSkill((String)it.next(), (TutorActionLogV4)logMsg);
                    ++result;
                }
                return result;
            }
            Vector rules = (Vector)OLIMessageObject.getValue(propertyNames, propertyValues, "Rules");
            if (rules != null) {
                Iterator it = rules.iterator();
                while (it.hasNext()) {
                    this.parseAndAddSkill((String)it.next(), (TutorActionLogV4)logMsg);
                    ++result;
                }
            }
            return result;
        }

        private void parseAndAddSkill(String text, TutorActionLogV4 logMsg) {
            int categoryIndex;
            String category = "";
            String probability = null;
            String[] parts = text.split("=");
            if (parts.length > 1) {
                probability = parts[1];
            }
            if ((categoryIndex = text.lastIndexOf(32) + 1) > 0) {
                category = parts[0].substring(categoryIndex);
                text = parts[0].substring(0, categoryIndex - 1);
            } else {
                text = parts[0];
            }
            logMsg.addSkill(text, category, probability);
        }

        protected void setResponseType(String actionEvaluation, TutorMessage msg) {
            if (actionEvaluation == null) {
                trace.err("ConvV4: null action evaluation in tutor msg");
                return;
            }
            if ("CORRECT".equalsIgnoreCase(actionEvaluation) || "SUCCESS".equalsIgnoreCase(actionEvaluation)) {
                msg.setAsCorrectAttemptResponse();
            } else if ("INCORRECT".equalsIgnoreCase(actionEvaluation) || "BUG".equalsIgnoreCase(actionEvaluation) || "NO-MODEL".equalsIgnoreCase(actionEvaluation) || "FIREABLE-BUG".equalsIgnoreCase(actionEvaluation)) {
                msg.setAsIncorrectAttemptResponse();
            } else if (HintPattern.matcher(actionEvaluation).matches()) {
                msg.setAsHintResponse(actionEvaluation);
            } else {
                trace.err("ConvV4: no response type for action evaluation " + actionEvaluation);
            }
        }
    }

    static class StartProblemConvV4
    extends OLIMessageConverters.StartProblemConv {
        StartProblemConvV4(String semanticEvt, String actionEvaluation, String commMsgType, LogContext logger) {
            super(semanticEvt, actionEvaluation, commMsgType, logger);
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            Object pnObj = OLIMessageObject.getValue(propertyNames, propertyValues, "ProblemName");
            String localProblemName = pnObj == null ? "null" : pnObj.toString();
            ContextMessage msg = logger.getContextMessage(this.getSemanticEvt());
            TutorActionLogV4 result = new TutorActionLogV4(msg);
            return result;
        }
    }

    static class OtherMsgConvV4
    extends ConvV4 {
        OtherMsgConvV4(LogContext logger) {
            super("unused1", "unused2", "unused3", null, null, logger);
        }

        @Override
        protected TutorActionLog native2OLI(Vector propertyNames, Vector propertyValues, MessageObject mo, boolean tutorToTool, LogContext logger) {
            PlainMessage msg = PlainMessage.create((ContextMessage)logger.getContextMessage());
            TutorActionLogV4 result = new TutorActionLogV4(msg);
            this.populateProperties(propertyNames, propertyValues, mo, result);
            return result;
        }
    }

    static class SkillsConvV4
    extends ConvV4 {
        public SkillsConvV4(String semanticEvt, String commMsgType, Boolean tutorToToolRestriction, LogContext logger) {
            super(semanticEvt, null, commMsgType, "TutorAdvice", tutorToToolRestriction, logger);
        }

        @Override
        protected void OLI2Native(TutorActionLog logMsg, OLIMessageObject mo) {
            Message msg;
            super.OLI2Native(logMsg, mo);
            Iterator it = logMsg.actionEvaluationsIterator();
            if (it.hasNext()) {
                TutorActionLog.ActionEvaluation ae = (TutorActionLog.ActionEvaluation)it.next();
                mo.setProperty("Indicator", ae.getText().trim());
            }
            if ((msg = ((TutorActionLogV4)logMsg).getMsg()) instanceof TutorMessage) {
                Vector<String> skills = new Vector<String>();
                Vector<String> ruleNames = new Vector<String>();
                List skillList = ((TutorMessage)msg).getSkillList();
                for (SkillElement skill : skillList) {
                    String category;
                    String name = skill.getName();
                    if (name == null || name.length() < 1) {
                        name = "unnamed";
                    }
                    if ((category = skill.getCategory()) != null && category.length() > 0) {
                        name = name + " " + category;
                    }
                    if (name == null || name.trim().length() < 1) {
                        name = "unnamed";
                    }
                    ruleNames.add(name);
                    if ("unnamed".equalsIgnoreCase(name)) continue;
                    try {
                        String probability = skill.getProbability();
                        float p = Float.parseFloat(probability);
                        skills.add(name + "=" + probability + "=" + "0");
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (ruleNames.size() > 0) {
                    mo.setProperty("Rules", ruleNames);
                }
                if (skills.size() > 0) {
                    mo.setProperty("Skills", ruleNames);
                }
            }
        }
    }
}

