/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EditListItemDialog
extends JDialog
implements ListSelectionListener,
FocusListener {
    private JList listsBuffer;
    private DefaultListModel listModel;
    private static final String DeleteString = "Delete";
    private static final String EditString = "Edit";
    private static final String ReplaceString = "Replace";
    private static final String MoveUpString = "Move Up";
    private static final String MoveDownString = "Move Down";
    private static final String AddString = "Add";
    private static final String CancelString = "Cancel";
    private static final String DoneString = "Done";
    private JCheckBox InvisibleCheckBox;
    private JButton DeleteButton;
    private JButton EditReplaceButton;
    private JButton AddButton;
    private JButton MoveUpButton;
    private JButton MoveDownButton;
    private JButton CancelButton;
    private JButton DoneButton;
    private JTextField itemLineEditor;
    private String[] BackupitemList;
    private boolean invisible;

    public EditListItemDialog(JFrame parent, String title, boolean modal, String[] itemList, boolean invisible) {
        super(parent, title, modal);
        JPanel mainPane = new JPanel(new BorderLayout());
        this.listModel = new DefaultListModel();
        this.BackupitemList = new String[itemList.length];
        for (int i = 0; i < itemList.length; ++i) {
            this.listModel.addElement(itemList[i]);
            this.BackupitemList[i] = itemList[i];
        }
        this.listsBuffer = new JList(this.listModel);
        this.listsBuffer.setSelectionMode(0);
        this.listsBuffer.setSelectedIndex(0);
        this.listsBuffer.addListSelectionListener(this);
        this.listsBuffer.setVisibleRowCount(10);
        this.listsBuffer.setMinimumSize(new Dimension(500, 500));
        mainPane.add(this.listsBuffer);
        mainPane.setOpaque(true);
        JScrollPane listScrollPane = new JScrollPane(this.listsBuffer);
        mainPane.add((Component)listScrollPane, "First");
        this.EditReplaceButton = new JButton(EditString);
        EditReplaceListener EditReplaceListener2 = new EditReplaceListener(this.EditReplaceButton);
        this.EditReplaceButton.setActionCommand(EditString);
        this.EditReplaceButton.addActionListener(EditReplaceListener2);
        this.DeleteButton = new JButton(DeleteString);
        this.DeleteButton.setActionCommand(DeleteString);
        this.DeleteButton.addActionListener(new DeleteListener());
        this.CancelButton = new JButton(CancelString);
        this.CancelButton.setActionCommand(CancelString);
        this.CancelButton.addActionListener(new CancelListener());
        this.DoneButton = new JButton(DoneString);
        this.DoneButton.setActionCommand(DoneString);
        this.DoneButton.addActionListener(new DoneListener());
        this.AddButton = new JButton(AddString);
        AddListener AddListener2 = new AddListener(this.AddButton);
        this.AddButton.setActionCommand(AddString);
        this.AddButton.addActionListener(AddListener2);
        this.AddButton.setEnabled(false);
        this.MoveUpButton = new JButton(MoveUpString);
        this.MoveUpButton.setActionCommand(MoveUpString);
        this.MoveUpButton.addActionListener(new MoveListener(this.MoveUpButton));
        this.MoveUpButton.setEnabled(true);
        this.MoveDownButton = new JButton(MoveDownString);
        this.MoveDownButton.setActionCommand(MoveDownString);
        this.MoveDownButton.addActionListener(new MoveListener(this.MoveDownButton));
        this.MoveDownButton.setEnabled(true);
        this.itemLineEditor = new JTextField(10);
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.itemLineEditor);
        this.itemLineEditor.addActionListener(AddListener2);
        this.itemLineEditor.addFocusListener(this);
        this.itemLineEditor.getDocument().addDocumentListener(AddListener2);
        this.itemLineEditor.getDocument().addDocumentListener(EditReplaceListener2);
        String name = this.listsBuffer.getSelectedIndex() > -1 ? this.listModel.getElementAt(this.listsBuffer.getSelectedIndex()).toString() : "";
        this.InvisibleCheckBox = new JCheckBox("Invisible", null, invisible);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(this.InvisibleCheckBox);
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(new JSeparator(1));
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(this.DeleteButton);
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(new JSeparator(1));
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(this.EditReplaceButton);
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(new JSeparator(1));
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(this.itemLineEditor);
        buttonPane.add(this.AddButton);
        buttonPane.add(new JSeparator(1));
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(this.MoveUpButton);
        buttonPane.add(Box.createVerticalStrut(5));
        buttonPane.add(this.MoveDownButton);
        buttonPane.add(new JSeparator(1));
        buttonPane.add(Box.createHorizontalStrut(5));
        buttonPane.add(this.CancelButton);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(this.DoneButton);
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel itemPane = new JPanel(new BorderLayout());
        this.itemLineEditor.setMinimumSize(new Dimension(200, 200));
        itemPane.add(this.itemLineEditor);
        itemPane.setOpaque(true);
        JScrollPane lineScrollPane = new JScrollPane(this.itemLineEditor);
        mainPane.add((Component)lineScrollPane, "Last");
        this.add((Component)mainPane, "North");
        this.add(new JSeparator(0));
        this.add((Component)buttonPane, "South");
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", " focusGained");
        }
        if (e.getComponent() instanceof JTextField && trace.getDebugCode("inter")) {
            trace.out("inter", "itemLineEditor focusGained");
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (trace.getDebugCode("inter")) {
            trace.out("inter", " focusLost");
        }
        if (e.getComponent() instanceof JTextField && trace.getDebugCode("inter")) {
            trace.out("inter", "itemLineEditor focusLost");
        }
    }

    public void swapItems(int prevIndex, int currentIndex) {
        Object temp = this.listModel.getElementAt(prevIndex);
        this.listModel.setElementAt(this.listModel.getElementAt(currentIndex), prevIndex);
        this.listModel.setElementAt(temp, currentIndex);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            if (this.listsBuffer.getSelectedIndex() == -1) {
                this.DeleteButton.setEnabled(false);
            } else {
                this.DeleteButton.setEnabled(true);
            }
        }
        this.EditReplaceButton.setText(EditString);
    }

    public JList getList() {
        return this.listsBuffer;
    }

    public void setList(JList list) {
        this.listsBuffer = list;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setInvisible(boolean invisible) {
        this.invisible = invisible;
    }

    class MoveListener
    implements ActionListener,
    ListSelectionListener {
        private JButton button;
        int nextIndex;

        public MoveListener(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int index;
            int prevIndex = index = EditListItemDialog.this.listsBuffer.getSelectedIndex();
            index = index == -1 ? 0 : (this.button.getText().equals(EditListItemDialog.MoveDownString) ? ++index : --index);
            EditListItemDialog.this.swapItems(prevIndex, index);
            EditListItemDialog.this.listsBuffer.setSelectedIndex(index);
            EditListItemDialog.this.listsBuffer.ensureIndexIsVisible(index);
            EditListItemDialog.this.listsBuffer.requestFocusInWindow();
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
        }
    }

    class AddListener
    implements ActionListener,
    DocumentListener {
        private boolean alreadyEnabled = false;
        private JButton button;

        public AddListener(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String name = EditListItemDialog.this.itemLineEditor.getText();
            if (name.equals("") || this.alreadyInList(name)) {
                Toolkit.getDefaultToolkit().beep();
                EditListItemDialog.this.itemLineEditor.requestFocusInWindow();
                EditListItemDialog.this.itemLineEditor.selectAll();
                return;
            }
            int index = EditListItemDialog.this.listsBuffer.getSelectedIndex();
            index = index == -1 ? 0 : ++index;
            EditListItemDialog.this.listModel.insertElementAt(EditListItemDialog.this.itemLineEditor.getText(), index);
            EditListItemDialog.this.itemLineEditor.requestFocusInWindow();
            EditListItemDialog.this.itemLineEditor.setText("");
            EditListItemDialog.this.listsBuffer.setSelectedIndex(index);
            EditListItemDialog.this.listsBuffer.ensureIndexIsVisible(index);
        }

        protected boolean alreadyInList(String name) {
            return EditListItemDialog.this.listModel.contains(name);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.enableButton();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.handleEmptyTextField(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (!this.handleEmptyTextField(e)) {
                this.enableButton();
            }
        }

        private void enableButton() {
            if (!this.alreadyEnabled) {
                this.button.setEnabled(true);
            }
        }

        private boolean handleEmptyTextField(DocumentEvent e) {
            if (e.getDocument().getLength() <= 0) {
                this.button.setEnabled(false);
                this.alreadyEnabled = false;
                return true;
            }
            return false;
        }
    }

    class EditReplaceListener
    implements ActionListener,
    DocumentListener {
        private boolean alreadyEnabled = true;
        private JButton button;

        public EditReplaceListener(JButton button) {
            this.button = button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EditListItemDialog.this.EditReplaceButton.getText().equals(EditListItemDialog.EditString)) {
                EditListItemDialog.this.itemLineEditor.setText(EditListItemDialog.this.listModel.getElementAt(EditListItemDialog.this.listsBuffer.getSelectedIndex()).toString());
            } else {
                String name = EditListItemDialog.this.itemLineEditor.getText();
                if (name.equals("") || this.alreadyInList(name)) {
                    Toolkit.getDefaultToolkit().beep();
                    EditListItemDialog.this.itemLineEditor.requestFocusInWindow();
                    EditListItemDialog.this.itemLineEditor.selectAll();
                    return;
                }
                int index = EditListItemDialog.this.listsBuffer.getSelectedIndex();
                if (index == -1) {
                    return;
                }
                if (trace.getDebugCode("inter")) {
                    trace.out("inter", "index = " + index);
                }
                EditListItemDialog.this.listModel.removeElementAt(index);
                EditListItemDialog.this.listModel.insertElementAt(EditListItemDialog.this.itemLineEditor.getText(), index);
                EditListItemDialog.this.itemLineEditor.requestFocusInWindow();
                EditListItemDialog.this.itemLineEditor.setText("");
                EditListItemDialog.this.listsBuffer.setSelectedIndex(index);
                EditListItemDialog.this.listsBuffer.ensureIndexIsVisible(index);
                EditListItemDialog.this.listsBuffer.repaint();
                EditListItemDialog.this.repaint();
            }
        }

        protected boolean alreadyInList(String name) {
            return EditListItemDialog.this.listModel.contains(name);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "EditReplaceListener insertUpdate");
            }
            this.switchButton(EditListItemDialog.ReplaceString);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "EditReplaceListener removeUpdate");
            }
            this.handleEmptyTextField(e);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            if (trace.getDebugCode("inter")) {
                trace.out("inter", "EditReplaceListener changedUpdate");
            }
            if (!this.handleEmptyTextField(e)) {
                this.switchButton(EditListItemDialog.ReplaceString);
            }
        }

        private void enableButton() {
            if (!this.alreadyEnabled) {
                this.button.setEnabled(true);
            }
        }

        private void switchButton(String buttonName) {
            if (this.alreadyEnabled) {
                this.button.setText(buttonName);
            }
        }

        private boolean handleEmptyTextField(DocumentEvent e) {
            if (e.getDocument().getLength() <= 0) {
                this.switchButton(EditListItemDialog.EditString);
                return true;
            }
            return false;
        }
    }

    class DeleteListener
    implements ActionListener {
        DeleteListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "Delete " + EditListItemDialog.this.BackupitemList.length);
            }
            int index = EditListItemDialog.this.listsBuffer.getSelectedIndex();
            EditListItemDialog.this.listModel.remove(index);
            int size = EditListItemDialog.this.listModel.getSize();
            if (size == 0) {
                EditListItemDialog.this.DeleteButton.setEnabled(false);
            } else {
                if (index == EditListItemDialog.this.listModel.getSize()) {
                    --index;
                }
                EditListItemDialog.this.listsBuffer.setSelectedIndex(index);
                EditListItemDialog.this.listsBuffer.ensureIndexIsVisible(index);
                EditListItemDialog.this.listsBuffer.repaint();
                EditListItemDialog.this.repaint();
            }
        }
    }

    class CancelListener
    implements ActionListener {
        CancelListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "Cancel Backupitem length =" + EditListItemDialog.this.BackupitemList.length);
            }
            EditListItemDialog.this.listModel.setSize(EditListItemDialog.this.BackupitemList.length);
            for (int i = 0; i < EditListItemDialog.this.BackupitemList.length; ++i) {
                EditListItemDialog.this.listModel.setElementAt(EditListItemDialog.this.BackupitemList[i], i);
                if (!trace.getDebugCode("dw")) continue;
                trace.out("dw", "BackupitemList[" + i + "] =" + EditListItemDialog.this.getList().getModel().getElementAt(i));
            }
            EditListItemDialog.this.setVisible(false);
            EditListItemDialog.this.dispose();
        }
    }

    class DoneListener
    implements ActionListener {
        DoneListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (trace.getDebugCode("dw")) {
                trace.out("dw", "Done " + EditListItemDialog.this.BackupitemList.length);
            }
            EditListItemDialog.this.setInvisible(EditListItemDialog.this.InvisibleCheckBox.isSelected());
            EditListItemDialog.this.setVisible(false);
            EditListItemDialog.this.dispose();
        }
    }
}

