/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.HintWindow;

import edu.cmu.pact.ctat.view.AvoidsBackGrading;
import java.awt.Component;
import java.util.List;
import javax.swing.JButton;

public class Hints {
    public static final String HELP = "Help";
    private static final String help = "Help".toLowerCase();
    public static final String HINT = "hint";
    private static final String hint = "hint".toLowerCase();

    private Hints() {
    }

    public static boolean isHintLabel(String text) {
        if (HELP.equalsIgnoreCase(text)) {
            return true;
        }
        return HINT.equalsIgnoreCase(text);
    }

    public static boolean isHintLabel(Object obj) {
        if (obj == null) {
            return false;
        }
        return Hints.isHintLabel(obj.toString());
    }

    public static boolean isHintSelection(Object v) {
        if (v instanceof List) {
            return ((List)v).size() < 1 ? false : Hints.isHintLabel(((List)v).get(0));
        }
        return Hints.isHintLabel((String)v);
    }

    public static boolean isHintButton(JButton b) {
        return b instanceof HintJButton;
    }

    public static boolean isHintComponent(Component c) {
        if (c == null) {
            return false;
        }
        if (c instanceof JButton && Hints.isHintButton((JButton)c)) {
            return true;
        }
        String name = c.getName();
        if (Hints.isHintLabel(name)) {
            return true;
        }
        if (name == null) {
            return false;
        }
        if ((name = name.toLowerCase()).startsWith(hint)) {
            return true;
        }
        return name.startsWith(help);
    }

    public static class HintJButton
    extends JButton
    implements AvoidsBackGrading {
        public HintJButton() {
        }

        public HintJButton(String text) {
            super(text);
        }
    }
}

