/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.ExactMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.MatcherPanels.MatcherPanel;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.WindowUtils;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class ExactMatcherPanel
extends MatcherPanel {
    private JTextField inputField;
    private JRadioButton anyButton;

    public ExactMatcherPanel(EdgeData edgeData, boolean allowToolReportedActions, int max_students) {
        this(edgeData, allowToolReportedActions, max_students, 0);
    }

    public ExactMatcherPanel(EdgeData edgeData, boolean allowToolReportedActions, int max_students, int selectionIndex) {
        super(edgeData, allowToolReportedActions, max_students, "<html>Exact Matcher will match the exact selection, action, and input<br>specified below.", new Box(0));
        JLabel inputLabel = new JLabel("Input: ");
        inputLabel.setName("inputLabel");
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.SAIPane.add((Component)inputLabel, this.c);
        this.inputField = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.inputField);
        this.inputField.setName("inputField");
        this.inputField.setColumns(30);
        this.c.gridx = 1;
        this.SAIPane.add((Component)this.inputField, this.c);
        Box actorBox = (Box)this.postComponent;
        if (allowToolReportedActions) {
            JLabel actorLabel = new JLabel("Actor: ");
            this.toolButton = new JRadioButton("Tutor");
            this.ungradedButton = new JRadioButton("Tutor (unevaluated)");
            this.studentButton = new JRadioButton("Student");
            this.anyButton = new JRadioButton("Any");
            this.toolButton.setToolTipText("Tutor will perform and evaluate this step.");
            this.ungradedButton.setToolTipText("Tutor will perform this step but leave it unevaluated.");
            this.studentButton.setToolTipText("Only the student can perform this step.");
            this.anyButton.setToolTipText("The student or the tutor may perform this step.");
            ButtonGroup tvs = new ButtonGroup();
            tvs.add(this.toolButton);
            tvs.add(this.ungradedButton);
            tvs.add(this.studentButton);
            tvs.add(this.anyButton);
            JScrollPane Students = new JScrollPane(this.sOptions);
            actorBox = new Box(0);
            actorBox.add(actorLabel);
            actorBox.add(this.toolButton);
            actorBox.add(this.ungradedButton);
            actorBox.add(this.studentButton);
            actorBox.add(this.anyButton);
            this.add(WindowUtils.wrapLeft(actorBox));
        }
        if (edgeData.getMatcher() == null || !(edgeData.getMatcher() instanceof ExactMatcher)) {
            this.actionField.setText(edgeData.getAction().get(0).toString());
            this.selectionField.setText(edgeData.getSelection().get(selectionIndex).toString());
            this.inputField.setText(edgeData.getInput().get(0).toString());
            if (this.studentButton != null) {
                this.studentButton.setSelected(true);
            }
        } else {
            ExactMatcher em = (ExactMatcher)edgeData.getMatcher();
            this.actionField.setText(em.getAction());
            this.selectionField.setText(em.getSelection());
            this.inputField.setText(em.getInput());
            if (allowToolReportedActions) {
                if (em.getActor().equals("Tutor")) {
                    this.toolButton.setSelected(true);
                } else if (em.getActor().equals("Tutor (unevaluated)")) {
                    this.ungradedButton.setSelected(true);
                } else if (em.getActor().equals("Any")) {
                    this.anyButton.setSelected(true);
                } else {
                    this.studentButton.setSelected(true);
                }
            }
        }
    }

    @Override
    public Matcher createMatcher() {
        ExactMatcher am = new ExactMatcher();
        am.setDefaultAction(this.actionField.getText());
        am.setDefaultSelection(this.selectionField.getText());
        am.setDefaultInput(this.inputField.getText());
        if (this.toolButton != null && this.toolButton.isSelected()) {
            am.setDefaultActor("Tutor");
        } else if (this.ungradedButton != null && this.ungradedButton.isSelected()) {
            am.setDefaultActor("Tutor (unevaluated)");
        } else if (this.anyButton != null && this.anyButton.isSelected()) {
            am.setDefaultActor("Any");
        } else if (this.studentButton != null && this.studentButton.isSelected()) {
            am.setDefaultActor("Student");
        } else {
            am.setDefaultActor("Student");
        }
        return am;
    }

    @Override
    public String getMatcherType() {
        return "Exact Match";
    }
}

