/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorException;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.LinkInspectorPanel;
import edu.cmu.pact.BehaviorRecorder.LinkInspector.Subpanels.LI_Subpanel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import edu.cmu.pact.Utilities.trace;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LI_TraversalSubpanel
extends LI_Subpanel {
    private static final String REUSEABLE_LINKS = "Set min/max traversals";
    private JLabel PanelLabel = null;
    private JLabel TraversalCountArea = null;
    private TraversalTextArea MinTextArea = null;
    private TraversalTextArea MaxTextArea = null;
    private static int PREF_HEIGHT = 110;

    public LI_TraversalSubpanel(BR_Controller Controller, ProblemEdge Edge, int CurrWidth, LinkInspectorPanel Panel2) throws LinkInspectorException {
        this.Panel = Panel2;
        if (trace.getDebugCode("LI_TraversalSubpanel")) {
            trace.outNT("LI_TraversalSubpanel", "Generating Panel");
        }
        this.setController(Controller);
        this.setEdge(Edge);
        this.setName("LI_TraversalSubpanel");
        this.setPreferredSize(new Dimension(CurrWidth, PREF_HEIGHT));
        this.setBackground(Color.WHITE);
        this.setBorder(BorderFactory.createEtchedBorder(1));
        GridLayout temp = new GridLayout();
        temp.setColumns(1);
        temp.setRows(4);
        this.setLayout(temp);
        String LabelText = "<html><u>Traversals:</u></html>";
        this.PanelLabel = new JLabel(LabelText, 0);
        this.MaxTextArea = new TraversalTextArea(this, false);
        this.MinTextArea = new TraversalTextArea(this, true);
        this.TraversalCountArea = new JLabel("Traversals: " + String.valueOf(Edge.getEdgeData().getTraversalCount()), 0);
        this.add(this.PanelLabel);
        this.add(this.MinTextArea);
        this.add(this.MaxTextArea);
        this.add(this.TraversalCountArea);
        this.setContents();
    }

    private void setContents() {
        if (this.CurrEdgeData == null) {
            return;
        }
        this.MinTextArea.setText(this.CurrEdgeData.getMinTraversalsStr());
        this.MaxTextArea.setText(this.CurrEdgeData.getMaxTraversalsStr());
        this.TraversalCountArea.setText("Traversals: " + String.valueOf(this.CurrEdgeData.getTraversalCount()));
    }

    @Override
    public void refreshData(EdgeEvent Ev) {
        this.setContents();
    }

    @Override
    protected int getMinHeight(int WidthLimit) {
        return PREF_HEIGHT;
    }

    class TraversalTextArea
    extends JPanel
    implements FocusListener {
        LI_TraversalSubpanel panel;
        int oldValue;
        EdgeData edgeData;
        boolean isMinTraversal;
        JTextField inputArea;
        JLabel inputLabel;

        public TraversalTextArea(LI_TraversalSubpanel panel, boolean isMinTraversal) {
            this.setBackground(Color.white);
            this.panel = panel;
            this.edgeData = panel.CurrEdgeData;
            this.isMinTraversal = isMinTraversal;
            if (isMinTraversal) {
                this.oldValue = this.edgeData.getMinTraversals();
                this.inputLabel = new JLabel("Min Traversals: ");
            } else {
                this.inputLabel = new JLabel("Max Traversals: ");
                this.oldValue = this.edgeData.getMaxTraversals();
            }
            this.inputArea = new JTextField();
            this.inputArea.setName("LI_TraversalTextField");
            JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.inputArea);
            this.setLayout(new BoxLayout(this, 0));
            this.inputArea.addFocusListener(this);
            this.add(this.inputLabel);
            this.add(this.inputArea);
        }

        public void setText(String newText) {
            this.inputArea.setText(newText);
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            int newValue;
            String newText = this.inputArea.getText();
            if (newText == null) {
                this.setText(String.valueOf(this.oldValue));
                return;
            }
            newText = newText.trim();
            try {
                newValue = Integer.parseInt(newText);
            }
            catch (NumberFormatException exception) {
                this.setText(String.valueOf(this.oldValue));
                return;
            }
            if (newValue >= 0 && newValue != this.oldValue) {
                if (this.isMinTraversal) {
                    this.edgeData.setMinTraversals(newValue);
                } else {
                    this.edgeData.setMaxTraversals(newValue);
                }
                this.setText(String.valueOf(newValue));
                this.oldValue = newValue;
                LI_TraversalSubpanel.this.Controller.getProblemModel().fireProblemModelEvent(new EdgeUpdatedEvent(this.panel.Panel, this.edgeData.getEdge(), true));
            } else {
                this.setText(String.valueOf(this.oldValue));
            }
        }
    }
}

