/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.miss.PeerLearning.GameShow;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessModelTracing;
import edu.cmu.pact.jess.MTRete;
import edu.cmu.pact.jess.RuleActivationNode;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.miss.AskHint;
import edu.cmu.pact.miss.Instruction;
import edu.cmu.pact.miss.PeerLearning.GameShow.Contestant;
import edu.cmu.pact.miss.PeerLearning.SimStLogger;
import edu.cmu.pact.miss.Sai;
import edu.cmu.pact.miss.SimSt;
import edu.cmu.pact.miss.SimStInteractiveLearning;
import edu.cmu.pact.miss.WebStartFileDownloader;
import edu.cmu.pact.miss.console.controller.MissController;
import edu.cmu.pact.miss.userDef.algebra.EqFeaturePredicate;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Vector;
import javax.swing.JOptionPane;
import jess.JessException;

public class ContestExecution
extends SimStInteractiveLearning {
    BR_Controller controller;
    SimSt simSt;
    File prodRules;
    String studentName;
    SimStLogger logger;
    int numProblems = 0;
    Contestant contestant;
    public static final String DEFAULT_PRODRULES_FILE = "productionRules1.pr";

    public ContestExecution(SimSt ss, String prodRules, Contestant contestant) {
        super(ss);
        this.simSt = ss;
        this.controller = this.simSt.getBrController();
        this.loadProdRules(prodRules);
        this.logger = new SimStLogger(this.controller);
        this.contestant = contestant;
    }

    public void loadProdRules(String prodRuleFile) {
        trace.out("miss", "loadProdRules: " + prodRuleFile);
        if (prodRuleFile != null) {
            trace.out("miss", "prodRuleFile is not null");
            this.prodRules = new File(prodRuleFile);
        } else {
            trace.out("miss", "prodRuleFile is null");
            prodRuleFile = DEFAULT_PRODRULES_FILE;
            this.prodRules = new File(prodRuleFile);
        }
        if (!this.prodRules.exists()) {
            if (!this.getSimSt().isWebStartMode()) {
                trace.out("miss", "Local: Using the default prodRule file");
                this.prodRules = new File(DEFAULT_PRODRULES_FILE);
            } else {
                try {
                    trace.out("miss", "WebStart: Downloading the default prodRule file");
                    boolean fileDownloaded = ((MissController)this.controller.getMissController()).getStorageClient().retrieveFile(DEFAULT_PRODRULES_FILE, DEFAULT_PRODRULES_FILE, WebStartFileDownloader.SimStWebStartDir);
                    if (fileDownloaded) {
                        this.prodRules = new File(WebStartFileDownloader.SimStWebStartDir + DEFAULT_PRODRULES_FILE);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        String wmeTypefile = "wmeTypes.clp";
        File prDir = this.prodRules.getParentFile();
        if (prDir != null) {
            wmeTypefile = prDir.getPath() + System.getProperty("file.separator") + wmeTypefile;
        }
        trace.out("miss", "wmeTypeFile: " + wmeTypefile);
        try {
            this.controller.getModelTracer().getRete().removeAllRules();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.controller.getModelTracer().getRete().batch(wmeTypefile);
        }
        catch (JessException e) {
            JOptionPane.showMessageDialog(null, "Could not batch wmeTypes " + wmeTypefile);
            e.printStackTrace();
        }
        this.reload();
    }

    private void reload() {
        boolean result = this.controller.getModelTracer().getRete().reloadProductionRulesFile(this.prodRules, false);
        trace.out("ss", "Production rule file " + this.prodRules + " loaded: " + result);
    }

    public void reset() {
        this.numProblems = 0;
    }

    public Solution contestOnWholeProblem(String problemName) {
        this.createStartStateOnProblem(problemName);
        this.logger.simStLog("SSGAME_CONTEST", "New Problem Started", "problem" + (this.numProblems + 1), "", (Object)"", 0, "", this.contestant.rating);
        long startTime = new Date().getTime();
        Solution solution = this.solveWholeProblem();
        ProblemNode startState = brController.getProblemModel().getStartNode();
        Vector<ProblemEdge> solution2 = this.simSt.getProblemAssessor().findSolutionPath(startState);
        String solutionString = this.getSimSt().getProblemAssessor().formatSolution(solution2, problemName);
        solutionString = solutionString.replace("LHS", "");
        solutionString = solutionString.replace("RHS", "");
        solution.solutionPath = "<html>" + solutionString + "</html>";
        trace.out("ss", solution.solutionPath);
        solution.correctness = this.getSimSt().getProblemAssessor().isSolution(problemName, solution.answer);
        long endTime = new Date().getTime();
        long duration = endTime - startTime;
        this.logger.simStLog("SSGAME_CONTEST", "Answer Submitted", solution.answer, solution.answer, (Object)"", solution.correctness, (int)duration, this.contestant.rating);
        ++this.numProblems;
        return solution;
    }

    @Override
    public void createStartStateOnProblem(String problemName) {
        this.controller.startNewProblem();
        try {
            if (this.controller.getProblemModel().getStartNode() == null) {
                String[] sp = problemName.split("=");
                String c1r1Value = sp[0].trim();
                String c2r1Value = sp[1].trim();
                SimStInteractiveLearning.simulateCellTextEntry("dorminTable1_C1R1", c1r1Value);
                SimStInteractiveLearning.simulateCellTextEntry("dorminTable2_C1R1", c2r1Value);
                String normalProblemName = SimSt.convertToSafeProblemName(problemName);
                trace.out("ss", "Problem Name created: " + normalProblemName);
                this.controller.createStartState(normalProblemName);
                this.reload();
            } else {
                ProblemNode node = this.controller.getProblemModel().getStartNode();
                trace.out("miss", "ssContest: startNode = " + node);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected ProblemNode advanceNode(ProblemNode currentNode, RuleActivationNode ran, boolean correct) {
        ProblemNode nextCurrentNode = null;
        this.secureCurrentNode(currentNode);
        Sai sai = this.getSai(ran);
        ProblemNode successiveNode = this.simulatePerformingStep(currentNode, sai);
        ProblemNode startNode = brController.getProblemModel().getStartNode();
        String step = startNode.getName();
        if (this.simSt.getProblemAssessor() != null) {
            step = this.simSt.getProblemAssessor().findLastStep(startNode, currentNode);
        }
        this.simSt.setProblemStep(step);
        if (successiveNode != null) {
            String skillName = this.removeAmpersand(ran.getName()) + " simStIL";
            ProblemEdge edge = this.updateEdgeSkillName(currentNode, successiveNode, skillName);
            if (correct) {
                edge.getEdgeData().setActionType("Correct Action");
            } else {
                edge.getEdgeData().setActionType("Error Action");
            }
            nextCurrentNode = successiveNode;
        }
        return nextCurrentNode;
    }

    public PriorityQueue<Answer> gatherActivationList(ProblemNode problemNode) {
        PriorityQueue<Answer> results = new PriorityQueue<Answer>();
        Vector<RuleActivationNode> activationList = new Vector<RuleActivationNode>();
        this.showActivationList();
        try {
            int i;
            if (problemNode != this.controller.getSolutionState().getCurrentNode()) {
                trace.out("miss", "gatherActivationList: problemNode ==>> " + problemNode);
                trace.out("miss", "gatherActivationList: currentNode ==>> " + this.controller.getSolutionState().getCurrentNode());
                this.controller.setCurrentNode2(problemNode);
            }
            ProblemNode currentNode = this.controller.getSolutionState().getCurrentNode();
            trace.out("miss", "gatherActivationList: currentNode ==>> " + currentNode);
            if (problemNode.getParents().isEmpty()) {
                trace.out("ss", "Entered problemNode.getParents().isEmpty()");
                this.controller.goToStartStateForRuleTutors();
            } else {
                trace.out("ss", "In the else part as getParents.isEmpty()is false");
                boolean useInterfaceTemplate = MTRete.getUseInterfaceTemplates();
                MTRete.setUseInterfaceTemplates(false);
                boolean loadJessFilesSucceeded = false;
                while (!loadJessFilesSucceeded) {
                    this.controller.checkProductionRulesChainNew(currentNode);
                    if (!MTRete.loadInterfacetemplatesFailed()) {
                        loadJessFilesSucceeded = true;
                        continue;
                    }
                    trace.out("miss", "gatherActivationList: RETRYING checkProductionRulesChainNew...");
                }
                MTRete.setUseInterfaceTemplates(useInterfaceTemplate);
            }
            this.reload();
            this.showActivationList();
            RuleActivationTree tree = this.controller.getRuleActivationTree();
            RuleActivationTree.TreeTableModel ttm = tree.getActivationModel();
            RuleActivationNode root = (RuleActivationNode)ttm.getRoot();
            MTRete mtRete = this.controller.getModelTracer().getRete();
            root.saveState(mtRete);
            this.showActivationList();
            List wholeAgenda = mtRete.getAgendaAsList(null);
            boolean omitBuggyRules = false;
            root.createChildren(wholeAgenda, omitBuggyRules);
            List children = root.getChildren();
            JessModelTracing jmt = mtRete.getJmt();
            trace.out("ss", "Children: " + children.size() + " Whole Agenda: " + wholeAgenda.size());
            for (i = 0; i < children.size(); ++i) {
                RuleActivationNode child = (RuleActivationNode)children.get(i);
                root.setUpState(mtRete, i);
                jmt.fireNode(child);
                activationList.add(child);
            }
            activationList = this.removeDuplicateActivations(activationList);
            for (i = 0; i < activationList.size(); ++i) {
                if (activationList.get(i).getActualInput().equals("FALSE")) continue;
                results.add(new Answer(this.studentName, i, activationList.get(i)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return results;
    }

    private Vector<RuleActivationNode> removeDuplicateActivations(Vector<RuleActivationNode> activationList) {
        Vector<Sai> goodSais = new Vector<Sai>();
        Vector<RuleActivationNode> goodActivationList = new Vector<RuleActivationNode>();
        for (RuleActivationNode ran : activationList) {
            Sai sai = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
            if (goodSais.contains(sai)) continue;
            goodSais.add(sai);
            goodActivationList.add(ran);
        }
        return goodActivationList;
    }

    private void showActivationList() {
        MTRete rete = this.controller.getModelTracer().getRete();
        RuleActivationTree rat = this.controller.getRuleActivationTree();
        RuleActivationTree.TreeTableModel ttm = rat.getActivationModel();
        RuleActivationNode ran = (RuleActivationNode)ttm.getRoot();
        List wholeAgenda = rete.getAgendaAsList(null);
        ran.createChildren(wholeAgenda, false);
        List children = ran.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            RuleActivationNode child = (RuleActivationNode)children.get(i);
            trace.out("miss", "Child #" + i + " = " + child.getName());
        }
    }

    private Solution solveWholeProblem() {
        ProblemNode currentNode = this.controller.getProblemModel().getStartNode();
        boolean killMessageReceived = false;
        Solution solution = new Solution();
        solution.answer = SimSt.convertFromSafeProblemName(currentNode.getName());
        while (!killMessageReceived) {
            String step = this.simSt.getProblemAssessor().calcProblemStepString(currentNode.getProblemModel().getStartNode(), currentNode, this.simSt.getLastSkillOperand());
            this.simSt.setProblemStepString(step);
            this.logger.simStLog("SSGAME_CONTEST", "New Step Started", step, "", (Object)"", 0, this.contestant.rating);
            long startTime = new Date().getTime();
            ProblemNode nextCurrentNode = null;
            PriorityQueue<Answer> activationList = this.gatherActivationList(currentNode);
            nextCurrentNode = this.inspectAgendaRuleActivations(currentNode, activationList, solution);
            if (nextCurrentNode != null) {
                ProblemEdge edge;
                String input;
                ++solution.steps;
                currentNode = nextCurrentNode;
                try {
                    Vector<Instruction> instnVector = new Vector<Instruction>();
                    brController.setCurrentNode2(currentNode);
                    trace.out("miss", "setCurrentNode2 to " + currentNode + " suceeded");
                    Instruction instn = this.simSt.lookupInstructionWithNode(brController.getCurrentNode());
                    instnVector.clear();
                    instnVector.add(instn);
                    trace.out("ss", instn.toString());
                }
                catch (Exception e) {
                    trace.out("miss", "setCurrentNode2 to " + currentNode + " failed");
                }
                if (currentNode.getIncomingEdges().size() > 0 && EqFeaturePredicate.isValidSimpleSkill((input = (edge = currentNode.getIncomingEdges().get(0)).getInput()).split(" ")[0])) {
                    this.simSt.setLastSkillOperand(input);
                }
            } else {
                killMessageReceived = true;
                this.simSt.setIsInteractiveLearning(false);
                trace.out("ss", "killMessageReceived is true.");
            }
            long endTime = new Date().getTime();
            long duration = endTime - startTime;
            this.logger.simStLog("SSGAME_CONTEST", "Step Completed", step, "", (Object)"", (int)duration, this.contestant.rating);
            trace.out("ss", "Current Node at end of loop: " + currentNode + ":" + brController.getCurrentNode());
            if (!currentNode.getDoneState()) continue;
            this.simSt.setIsInteractiveLearning(false);
            return solution;
        }
        solution.correctness = false;
        return solution;
    }

    protected ProblemNode inspectAgendaRuleActivations(ProblemNode currentNode, PriorityQueue<Answer> activationList, Solution solution) {
        ProblemNode nextCurrentNode = null;
        RuleActivationNode backupRan = null;
        String listAssessment = "";
        AskHint hint = this.simSt.getCorrectSAI(brController, currentNode);
        for (Answer ans : activationList) {
            RuleActivationNode ran = ans.step;
            if (ran.getActualInput().equalsIgnoreCase("FALSE")) continue;
            if (nextCurrentNode != null) break;
            String result = "";
            try {
                result = this.simSt.builtInInquiryClTutor(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput(), currentNode, currentNode.getProblemModel().getProblemName().replace("_", "="));
            }
            catch (NullPointerException npe) {
                result = "Error";
            }
            Sai sai = new Sai(ran.getActualSelection(), ran.getActualAction(), ran.getActualInput());
            this.logger.simStLog("SSGAME_CONTEST", "Input for Step Attempted", this.simSt.getProblemStepString(), "", "", sai, result.equals("Correct Action"), hint.getSelection(), hint.getAction(), hint.getInput(), this.contestant.rating);
            if (result.startsWith("Correct")) {
                nextCurrentNode = this.advanceNode(currentNode, ran, true);
                solution.solutionPath = solution.solutionPath + " " + ran.getActualInput();
                this.updateCurrentSolution(solution, ran);
                continue;
            }
            String lastSkill = "";
            if (this.simSt.getLastSkillOperand() != null && this.simSt.getLastSkillOperand().indexOf(32) >= 0) {
                lastSkill = this.simSt.getLastSkillOperand().substring(0, this.simSt.getLastSkillOperand().indexOf(32));
            }
            if ((ran.getActualInput().contains("FALSE") || this.simSt.getLastSkillOperand() != null && ran.getName().contains(lastSkill)) && !ran.getName().contains("typein")) continue;
            listAssessment = listAssessment + "Backup: Input: " + ran.getActualInput() + " " + lastSkill + " (" + ran.getName() + ")\n";
            backupRan = ran;
        }
        if (nextCurrentNode == null && backupRan != null) {
            listAssessment = listAssessment + "Backup used: " + backupRan.getName() + " " + backupRan.getActualInput() + "\n";
            solution.solutionPath = solution.solutionPath + " " + backupRan.getActualInput();
            this.updateCurrentSolution(solution, backupRan);
            solution.correctness = false;
            ++solution.incorrectSteps;
            nextCurrentNode = this.advanceNode(currentNode, backupRan, false);
        } else {
            listAssessment = listAssessment + "Not backup used\n";
        }
        return nextCurrentNode;
    }

    private void updateCurrentSolution(Solution solution, RuleActivationNode ran) {
        if (!ran.getName().contains("-typein") && !ran.getName().contains("done")) {
            solution.answer = "";
        } else if (!ran.getName().contains("done")) {
            solution.answer = solution.answer.length() == 0 ? ran.getActualInput() + "=" : solution.answer + ran.getActualInput();
        }
    }

    class Solution {
        String solutionPath = "";
        String answer = "";
        int steps = 0;
        int incorrectSteps = 0;
        boolean correctness = true;

        Solution() {
        }
    }

    class Answer
    implements Comparable<Object> {
        RuleActivationNode step;
        int ranking;
        String student;

        Answer(String stud, int rank, RuleActivationNode ran) {
            this.step = ran;
            this.ranking = rank;
            this.student = stud;
        }

        public String toString() {
            return this.student + "-" + this.ranking + "-" + this.step.getActualInput();
        }

        @Override
        public int compareTo(Object arg0) {
            Integer otherRank = ((Answer)arg0).ranking;
            return new Integer(this.ranking).compareTo(otherRank);
        }
    }
}

