/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.Utilities.TextOutput;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.model.ProblemSummary;
import edu.cmu.pact.ctat.model.Skill;
import edu.cmu.pact.ctat.model.Skills;
import edu.cmu.pact.jess.MTRete;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jess.Deftemplate;
import jess.Fact;
import jess.Funcall;
import jess.JessException;
import jess.LongValue;
import jess.QueryResult;
import jess.RU;
import jess.Rete;
import jess.Value;
import jess.ValueVector;

class ProblemSummaryAccess
implements Serializable {
    private static final long serialVersionUID = 201309271200L;
    private static final String PROBLEM_SUMMARY = "ProblemSummary";
    static final String SKILL = "Skill";
    public static final String GET_PROBLEM_SUMMARY = "get-problem-summary";
    public static final String GET_SKILL = "get-skill";
    static final String SKILLS = "skills";
    private static final String script = "(deftemplate Skill\n    (slot name)\n    (slot category)\n    (slot description)\n    (slot label)\n    (slot opportunityCount)\n    (slot pGuess)\n    (slot pKnown)\n    (slot pLearn)\n    (slot pSlip))\n(deftemplate ProblemSummary\n    (slot ProblemName)\n    (slot CompletionStatus)\n    (slot Correct)\n    (slot UniqueCorrect)\n    (slot UniqueCorrectUnassisted)\n    (slot Hints)\n    (slot UniqueHints)\n    (slot HintsOnly)\n    (slot Errors)\n    (slot UniqueErrors)\n    (slot ErrorsOnly)\n    (slot UniqueSteps)\n    (slot TimeElapsed)\n    (multislot skills))\n(defquery get-problem-summary\n    \"Find the single ProblemSummary fact\"\n    ?ps <- (ProblemSummary))\n(defquery get-skill\n    \"Find the Skill fact with the given name and category\"\n    (declare (variables ?skill-name ?skill-category))\n    ?sk <- (Skill (name ?n&:(= ?n ?skill-name))\n\t       (category ?c&:(= ?c ?skill-category))))";
    private static Map<String, Method> skillGetMethods = null;
    private static Map<String, Method> problemSummaryGetMethods = null;

    ProblemSummaryAccess() {
    }

    Fact updateProblemSummaryFacts(ProblemSummary ps, Rete rete, TextOutput textOutput) {
        if (textOutput == null) {
            textOutput = rete instanceof MTRete ? ((MTRete)rete).getTextOutput() : TextOutput.getTextOutput(System.out);
        }
        if (!this.createTemplates(rete, textOutput)) {
            return null;
        }
        this.retractProblemSummary(rete, textOutput);
        if (ps == null) {
            return null;
        }
        ValueVector skillsVV = this.updateSkills(ps == null ? null : ps.getSkills(), rete, textOutput);
        return this.assertProblemSummary(ps, skillsVV, rete, textOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int retractProblemSummary(Rete rete, TextOutput textOutput) {
        int result = 0;
        try (QueryResult qr = null;){
            qr = rete.runQueryStar(GET_PROBLEM_SUMMARY, new ValueVector(0));
            while (qr.next()) {
                Value v = qr.get("ps");
                Fact f = v.factValue(rete.getGlobalContext());
                if (trace.getDebugCode("ps")) {
                    trace.out("ps", String.format("retractProblemSummary() to retract fact-id %d %s", f.getFactId(), f.toString()));
                }
                rete.retract(f);
                ++result;
            }
        }
        if (trace.getDebugCode("ps")) {
            trace.out("ps", "retractProblemSummary() returning count " + result);
        }
        return result;
    }

    private Fact assertProblemSummary(ProblemSummary ps, ValueVector skills, Rete rete, TextOutput textOutput) {
        try {
            Deftemplate problemSummaryDT = rete.findDeftemplate(PROBLEM_SUMMARY);
            Fact fact = new Fact(problemSummaryDT);
            ArrayList<String> slotNames = new ArrayList<String>(Arrays.asList(problemSummaryDT.getSlotNames()));
            List<Value> slotValues = this.createSlotValues(ps, skills, slotNames);
            for (int i = 0; i < slotNames.size(); ++i) {
                fact.setSlotValue((String)slotNames.get(i), slotValues.get(i));
            }
            if (trace.getDebugCode("ps")) {
                trace.out("ps", String.format("assertProblemSummary() problemName %s, fact %s", ps == null ? null : ps.getProblemName(), fact.toString()));
            }
            return rete.assertFact(fact, rete.getGlobalContext());
        }
        catch (JessException je) {
            String errorMessage = "Error asserting new problem summary: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail();
            trace.errStack(errorMessage, je);
            textOutput.append("\n").append(errorMessage).append("\n");
        }
        catch (Exception e) {
            String errorMessage = "Error asserting new problem summary: " + e + "; cause " + e.getCause();
            trace.errStack(errorMessage, e);
            textOutput.append("\n").append(errorMessage).append("\n");
        }
        return null;
    }

    private List<Value> createSlotValues(ProblemSummary ps, ValueVector skills, List<String> slotNames) throws Exception {
        ArrayList<Value> result = new ArrayList<Value>();
        Map<String, Method> problemSummaryGetMethods = this.findProblemSummaryGetMethods(slotNames, null);
        ListIterator<String> it = slotNames.listIterator();
        while (it.hasNext()) {
            String slot = it.next();
            if (SKILLS.equals(slot)) {
                if (skills != null) {
                    result.add(new Value(skills, 512));
                    continue;
                }
                it.remove();
                continue;
            }
            Method m = problemSummaryGetMethods.get(slot);
            result.add(this.invokeGetMethod(ps, m, slot));
        }
        if (trace.getDebugCode("ps")) {
            trace.out("ps", String.format("createSlotValues() slotNames %s,\n  result %s", slotNames.toString(), ((Object)result).toString()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValueVector updateSkills(Skills skills, Rete rete, TextOutput textOutput) {
        ValueVector result = new ValueVector();
        if (trace.getDebugCode("ps")) {
            trace.out("ps", String.format("updateSkills() given %d skills", skills == null ? -1 : skills.getAllSkills().size()));
        }
        if (skills == null) {
            return result;
        }
        LinkedList<Skill> skillsToAssert = new LinkedList<Skill>();
        for (Skill sk : skills.getAllSkills()) {
            QueryResult qr = null;
            try {
                ValueVector queryArgs = new ValueVector(2);
                queryArgs.add(sk.getName());
                queryArgs.add(sk.getCategory());
                qr = rete.runQueryStar(GET_SKILL, queryArgs);
                boolean qResult = qr.next();
                if (trace.getDebugCode("ps")) {
                    trace.out("ps", String.format("updateSkills() query result %b for skill %s, category %s", qResult, sk.getName(), sk.getCategory()));
                }
                if (qResult) {
                    result.add((Object)this.modifySkill(sk, qr.get("sk"), rete, textOutput));
                    continue;
                }
                skillsToAssert.add(sk);
            }
            catch (JessException je) {
                String errorMessage = "Error running defquery get-skill: " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail();
                trace.errStack(errorMessage, je);
                textOutput.append("\n").append(errorMessage).append("\n");
            }
            finally {
                if (qr == null) continue;
                qr.close();
            }
        }
        for (Skill sk : skillsToAssert) {
            String errorMessage;
            try {
                result.add((Object)this.assertSkill(sk, rete));
            }
            catch (JessException je) {
                errorMessage = "Error asserting new skill " + sk.getName() + ": " + (Object)((Object)je) + "; cause " + je.getCause() + ".\n  " + je.getProgramText() + "\n  " + je.getDetail();
                trace.errStack(errorMessage, je);
                textOutput.append("\n").append(errorMessage).append("\n");
            }
            catch (Exception e) {
                errorMessage = "Error asserting new skill " + sk.getName() + ": " + e + "; cause " + e.getCause();
                trace.errStack(errorMessage, e);
                textOutput.append("\n").append(errorMessage).append("\n");
            }
        }
        return result;
    }

    private Fact assertSkill(Skill sk, Rete rete) throws Exception {
        Deftemplate skillDT = rete.findDeftemplate(SKILL);
        Fact fact = new Fact(skillDT);
        String[] slotNames = skillDT.getSlotNames();
        Value[] slotValues = this.createSlotValues(sk, slotNames);
        for (int i = 0; i < slotNames.length; ++i) {
            fact.setSlotValue(slotNames[i], slotValues[i]);
        }
        if (trace.getDebugCode("ps")) {
            trace.out("ps", String.format("assertSkill() name %s, fact %s", sk.getName(), fact.toString()));
        }
        return rete.assertFact(fact, rete.getGlobalContext());
    }

    private Fact modifySkill(Skill sk, Value factV, Rete rete, TextOutput textOutput) {
        if (trace.getDebugCode("ps")) {
            trace.out("ps", String.format("modifySkill() sk %s, factV %s", sk.getName(), factV.toString()));
        }
        try {
            if (factV.type() != 16) {
                throw new IllegalArgumentException("Value argument " + factV + " has wrong type " + RU.getTypeName((int)factV.type()));
            }
            Fact fact = factV.factValue(rete.getGlobalContext());
            Deftemplate dt = fact.getDeftemplate();
            if (!dt.getName().endsWith(SKILL)) {
                throw new IllegalArgumentException("Fact argument " + factV + " has wrong deftemplate " + dt.toString() + "; should be " + SKILL);
            }
            String[] slotNames = dt.getSlotNames();
            return rete.modify(fact, slotNames, this.createSlotValues(sk, slotNames), rete.getGlobalContext());
        }
        catch (Exception e) {
            String errorMessage = String.format("%s.modifySkill() error on skill %s, category %s: %s", this.getClass().getSimpleName(), sk.getName(), sk.getCategory(), e.toString());
            trace.errStack(errorMessage, e);
            textOutput.append("\n").append(errorMessage).append("\n");
            return null;
        }
    }

    private Value[] createSlotValues(Skill sk, String[] slotNames) throws Exception {
        Object[] result = new Value[slotNames.length];
        Map<String, Method> skillGetMethods = this.findSkillGetMethods(slotNames, null);
        for (int i = 0; i < slotNames.length; ++i) {
            Method m = skillGetMethods.get(slotNames[i]);
            result[i] = this.invokeGetMethod(sk, m, slotNames[i]);
        }
        if (trace.getDebugCode("ps")) {
            trace.out("ps", String.format("createSlotValues() slotNames %s,\n  result %s", Arrays.toString(slotNames), Arrays.toString(result)));
        }
        return result;
    }

    private Value invokeGetMethod(Object that, Method m, String slot) throws Exception {
        Object result = null;
        if (that == null) {
            return result;
        }
        if (m == null) {
            throw new IllegalArgumentException("No getX() method found for slot " + slot);
        }
        Object value = m.invoke(that, (Object[])null);
        result = value instanceof Float ? new Value(((Float)value).doubleValue(), 32) : (value instanceof Integer ? new Value(((Integer)value).intValue(), 4) : (value instanceof Long ? new LongValue(((Long)value).longValue()) : (value == null ? new Value(Funcall.NIL) : new Value(value.toString(), 2))));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Method> findProblemSummaryGetMethods(List<String> slotNames, TextOutput textOutput) {
        if (problemSummaryGetMethods != null) {
            return problemSummaryGetMethods;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (problemSummaryGetMethods != null) {
                return problemSummaryGetMethods;
            }
            problemSummaryGetMethods = new HashMap<String, Method>();
            int nMethods = ProblemSummaryAccess.findGetMethods(ProblemSummary.class, slotNames.toArray(new String[slotNames.size()]), problemSummaryGetMethods, textOutput);
            if (nMethods < slotNames.size() && textOutput != null) {
                textOutput.append("\nWarning: will update only ").append(Integer.toString(nMethods)).append(" of ").append(Integer.toString(slotNames.size())).append(" ProblemSummary slots.\n");
            }
        }
        return problemSummaryGetMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Method> findSkillGetMethods(String[] slotNames, TextOutput textOutput) {
        if (skillGetMethods != null) {
            return skillGetMethods;
        }
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (skillGetMethods != null) {
                return skillGetMethods;
            }
            skillGetMethods = new HashMap<String, Method>();
            int nMethods = ProblemSummaryAccess.findGetMethods(Skill.class, slotNames, skillGetMethods, textOutput);
            if (nMethods < slotNames.length && textOutput != null) {
                textOutput.append("\nWarning: will update only ").append(Integer.toString(nMethods)).append(" of ").append(Integer.toString(slotNames.length)).append(" Skill slots.\n");
            }
        }
        return skillGetMethods;
    }

    private static int findGetMethods(Class cls, String[] propertyNames, Map<String, Method> getMethodsMap, TextOutput textOutput) {
        StringBuilder errorMessage = null;
        String lastError = null;
        int count = 0;
        for (String property : propertyNames) {
            try {
                StringBuilder fn = new StringBuilder("get");
                fn.append(Character.toUpperCase(property.charAt(0))).append(property.substring(1));
                if (trace.getDebugCode("ps")) {
                    trace.out("ps", "findGetMethods(" + cls.getName() + ") to look up method for name \"" + fn + "\"");
                }
                Method m = cls.getDeclaredMethod(fn.toString(), null);
                getMethodsMap.put(property, m);
                ++count;
            }
            catch (Exception e) {
                if (errorMessage == null) {
                    errorMessage = new StringBuilder("Error finding " + cls.getName() + " get method for property(ies)");
                }
                errorMessage.append(' ').append(property);
                lastError = e.toString() + (e.getCause() == null ? "" : "; cause " + e.getCause().toString());
                trace.err(errorMessage.append(": last error ").append(lastError).toString());
                getMethodsMap.put(property, null);
            }
        }
        if (errorMessage != null && textOutput != null) {
            textOutput.append("\n").append(errorMessage.append(": last error ").append(lastError).toString()).append("\n");
        }
        return count;
    }

    boolean createTemplates(Rete rete, TextOutput textOutput) {
        String errorMessage;
        try {
            Deftemplate psdt = rete.findDeftemplate(PROBLEM_SUMMARY);
            if (trace.getDebugCode("ps")) {
                trace.out("ps", String.format("createTemplate() found %s deftemplate\n  %.50s ...", PROBLEM_SUMMARY, psdt == null ? "null" : psdt.toString()));
            }
            if (psdt != null) {
                return true;
            }
        }
        catch (JessException je) {
            errorMessage = "Error finding deftemplate ProblemSummary: " + (Object)((Object)je);
            textOutput.append("\n").append(errorMessage).append("\n");
            trace.errStack(errorMessage, je);
        }
        try {
            Value result = rete.eval(script);
            if (Funcall.TRUE.equals(result)) {
                return true;
            }
            errorMessage = "Unexpected return value " + result + " from script to create " + PROBLEM_SUMMARY + " template";
            textOutput.append("\n").append(errorMessage).append("\n");
            trace.err(errorMessage);
        }
        catch (JessException je) {
            errorMessage = "Error finding running script to define ProblemSummary template at line " + je.getLineNumber() + ":\n" + (je.getDetail() == null ? "" : je.getDetail() + ". ") + (je.getData() == null ? "" : je.getData());
            trace.errStack(errorMessage, je);
            textOutput.append("\n").append(errorMessage).append("\n");
        }
        return false;
    }
}

