/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.old_pact.dormin.DorminException;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public final class XMLConverter {
    private static XMLOutputter outputter = new XMLOutputter(Format.getCompactFormat().setOmitDeclaration(true).setLineSeparator("").setIndent(""));

    private static String cleanse(String rawMsg) {
        return rawMsg.replaceAll("\n", "");
    }

    public static String xmlToString(Element msgElt) {
        return outputter.outputString(msgElt);
    }

    public static String xmlToComm(String rawMsg) {
        return XMLConverter.xmlToCommObject(rawMsg).toString();
    }

    public static edu.cmu.old_pact.dormin.MessageObject xmlObjectToCommObject(MessageObject xmo) {
        String verb = xmo.getVerb();
        if (verb == null || verb.length() < 1) {
            trace.err("verb null or \"\" in XML MessageObject; using default SendNoteProperty; message:\n  " + xmo);
            verb = "SendNoteProperty";
        }
        edu.cmu.old_pact.dormin.MessageObject mo = new edu.cmu.old_pact.dormin.MessageObject(verb);
        Vector<String> pNames = new Vector<String>(xmo.getPropertyNames());
        Vector pValues = new Vector(xmo.getPropertyValues());
        mo.addParameter("PROPERTYNAMES", pNames);
        mo.addParameter("PROPERTYVALUES", pValues);
        return mo;
    }

    public static edu.cmu.old_pact.dormin.MessageObject xmlToCommObject(String rawMsg) {
        Document msgDoc;
        if (rawMsg == null) {
            throw new NullPointerException("'rawMsg' cannot be null");
        }
        try {
            StringReader strIn = new StringReader(XMLConverter.cleanse(rawMsg));
            SAXBuilder builder = new SAXBuilder(false);
            msgDoc = builder.build((Reader)strIn);
        }
        catch (Exception e) {
            throw new RuntimeException("error parsing XML message", e);
        }
        Element rootElmnt = msgDoc.getRootElement();
        Element verbElmnt = rootElmnt.getChild("verb");
        String verb = verbElmnt.getTextNormalize();
        edu.cmu.old_pact.dormin.MessageObject mo = new edu.cmu.old_pact.dormin.MessageObject(verb);
        Element propsElmnt = rootElmnt.getChild("properties");
        Vector<String> pNames = new Vector<String>();
        Vector<Object> pValues = new Vector<Object>();
        for (Element pElement : propsElmnt.getChildren()) {
            String pName = pElement.getName();
            pNames.add(pName);
            List valueElts = pElement.getChildren("value");
            if (valueElts == null || valueElts.isEmpty()) {
                Object v = null;
                List otherElts = pElement.getChildren();
                v = otherElts != null && otherElts.size() > 0 ? XMLConverter.buildValueFromElements(pName, otherElts) : XMLConverter.buildValue(pName, pElement.getTextNormalize());
                pValues.add(v);
                if (v == null || !"transaction_id".equalsIgnoreCase(pName)) continue;
                mo.setTransactionId(v.toString());
                continue;
            }
            Vector<Object> values = new Vector<Object>();
            for (Element valueElement : valueElts) {
                String valStr = valueElement.getTextNormalize();
                values.add(XMLConverter.buildValue(pName, valStr));
            }
            pValues.add(values);
        }
        mo.addParameter("PROPERTYNAMES", pNames);
        mo.addParameter("PROPERTYVALUES", pValues);
        return mo;
    }

    private static Object buildValueFromElements(String pName, List otherElts) {
        if (otherElts.size() == 1) {
            return otherElts.get(0);
        }
        return otherElts;
    }

    public static MessageObject commToNewMO(edu.cmu.old_pact.dormin.MessageObject mo) {
        MessageObject result;
        block3: {
            result = MessageObject.parse(XMLConverter.commToXml(mo));
            Object object = null;
            try {
                object = mo.getParameter("OBJECT");
                if (object != null) {
                    result.setProperty("OBJECT", object, true);
                }
            }
            catch (DorminException e) {
                if (!trace.getDebugCode("sp")) break block3;
                trace.out("sp", "can't find object for message\n  " + mo);
            }
        }
        return result;
    }

    public static String commToXml(edu.cmu.old_pact.dormin.MessageObject mo) {
        if (mo == null) {
            throw new NullPointerException("'mo' cannot be null");
        }
        StringBuffer strBfr = new StringBuffer();
        strBfr.append("<message>");
        strBfr.append("<verb>");
        strBfr.append(XMLConverter.escapeXMLChars(mo.extractVerb()));
        strBfr.append("</verb>");
        strBfr.append("<properties>");
        try {
            Vector iValues = mo.extractListValue("PROPERTYNAMES");
            Vector jValues = mo.extractListValue("PROPERTYVALUES");
            if (!iValues.isEmpty() && !jValues.isEmpty()) {
                Iterator i = iValues.iterator();
                Iterator j = jValues.iterator();
                while (i.hasNext() && j.hasNext()) {
                    String rawName = i.next().toString();
                    Object rawValue = j.next();
                    String xmlName = XMLConverter.escapeElementName(rawName);
                    strBfr.append("<").append(xmlName).append(">");
                    if (rawValue instanceof Vector) {
                        Vector v = (Vector)rawValue;
                        Iterator k = v.iterator();
                        while (k.hasNext()) {
                            strBfr.append("<value>");
                            strBfr.append(XMLConverter.escapeXMLChars(k.next().toString()));
                            strBfr.append("</value>");
                        }
                    } else {
                        strBfr.append(XMLConverter.escapeXMLChars(rawValue.toString()));
                    }
                    strBfr.append("</").append(xmlName).append(">");
                }
            }
        }
        catch (DorminException e) {
            throw new RuntimeException("invalid comm message", e);
        }
        String trId = mo.getTransactionId();
        if (trId != null && trId.length() > 0) {
            strBfr.append("<").append("transaction_id").append(">");
            strBfr.append(trId);
            strBfr.append("</").append("transaction_id").append(">");
        }
        strBfr.append("</properties>").append("</message>");
        return strBfr.toString();
    }

    private static Object buildValue(String name, String valStr) {
        if ("Rows".equals(name) || "Columns".equals(name)) {
            return new Integer(valStr);
        }
        if ("Number".equals(name)) {
            return new Integer(valStr);
        }
        if ("true".equals(valStr) || "false".equals(valStr)) {
            return new Boolean(valStr);
        }
        return valStr;
    }

    private static String escapeXMLChars(String str) {
        if (str == null) {
            throw new NullPointerException("'str' cannot be null");
        }
        StringBuffer rslt = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '&') {
                rslt.append("&amp;");
                continue;
            }
            if (str.charAt(i) == '<') {
                rslt.append("&lt;");
                continue;
            }
            if (str.charAt(i) == '>') {
                rslt.append("&gt;");
                continue;
            }
            rslt.append(str.charAt(i));
        }
        return rslt.toString();
    }

    private static String escapeElementName(String str) {
        String rslt = XMLConverter.escapeXMLChars(str);
        rslt = rslt.replace('[', '_');
        rslt = rslt.replace(']', '_');
        rslt = rslt.replace(',', '_');
        rslt = rslt.replace(' ', '_');
        return rslt;
    }
}

