/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.SingleSessionLauncher;
import edu.cmu.pact.BehaviorRecorder.Tab.CTATTab;
import edu.cmu.pact.Log.DataShopMessageObject;
import edu.cmu.pact.SocketProxy.ActionHandler;
import edu.cmu.pact.SocketProxy.LogServlet;
import edu.cmu.pact.SocketProxy.SocketToolProxy;
import edu.cmu.pact.TutoringService.Collaborators;
import edu.cmu.pact.TutoringService.TSLauncherServer;
import edu.cmu.pact.Utilities.SocketReader;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import pact.CommWidgets.RemoteProxy;
import pact.CommWidgets.RemoteToolProxy;
import pact.CommWidgets.StudentInterfaceConnectionStatus;
import pact.CommWidgets.UniversalToolProxy;

public class SocketProxy
extends Thread
implements RemoteProxy {
    private static long MAX_IDLE_TIME = 0x200B20L;
    private int serverPort = 1500;
    private String clientHost = "localhost";
    private boolean gotQuitMsg;
    private int clientPort = 1501;
    private boolean logOnly = false;
    private int msgFormat = 1;
    private int eom = 0;
    private boolean useSingleSocket = true;
    private boolean connectFirst = false;
    private boolean oneMsgPerSocket = false;
    protected Socket sock = null;
    private BufferedReader in = null;
    private BR_Controller controller;
    protected SocketToolProxy utp;
    private ActionHandler actionHandler;
    private LogServlet logServlet = null;
    private boolean quitOnConnectionBreak = false;
    public static final String usageMsg = "Usage:\n  java -classpath ... [-DBehaviorRecorderVisible={true|false}]\\\n      [-DBehaviorRecorderMode={Pseudo-Tutor|Tutor|Demonstrate}]\\\n    SocketProxy [-h clientHost] [-c clientPort] [-d [debugCode,...]] [-e eom] [-b] [-m]\\\n      [-i] [-p] [-L] [-s serverPort] [-X|-M]\nwhere--\n  -DBehaviorRecorderVisible=... controls whether the BR is displayed (default true);\n  -DBehaviorRecorderMode=... controls the initial BR (default Demonstrate);\n  clientHost is the host on which to listen; default     localhost;\n  clientPort is the port number on which to listen; default     1501;\n  -d means turn on debugging; if debugCode(s) are present, uses them; default code is \"sp\";\n  eom is an end-of-message character, expressed as a hex integer;\n    e.g., 0A for line-feed, 00 for ASCII NUL;\n  -b means use a single socket for bidirectional communication;\n  -m means send multiple messages per connection;\n  -i means to connect first; default with -m is to listen first;\n  -L means log messages only: do not pass to Behavior Recorder;\n  serverPort is the port number on which to listen; default\n    1500;\n  -X means to expect messages in OLI XML format (default is native Comm);\n  -M means to expect messages in XML-ized Comm format.\n";
    private static final String SP_MSG_FORMAT = "spMsgFormat";
    private static final String policyFileRequest = "<policy-file-request/>";
    private static final String socketPolicyContent = "<cross-domain-policy>\n<site-control permitted-cross-domain-policies=\"master-only\"/>\n<allow-access-from domain=\"*\" to-ports=\"*\" />\n</cross-domain-policy>\u0000";

    public static long getMaxIdleTime() {
        return MAX_IDLE_TIME;
    }

    public static void setMaxIdleTime(long maxValue) {
        MAX_IDLE_TIME = maxValue;
    }

    public static String getControllerProperty(BR_Controller controller, String property) {
        if (controller == null) {
            return null;
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "SocketProxy.getControllerProperty != null\nBR_Controller =" + controller + "\nproperty=" + property);
        }
        if (trace.getDebugCode("log")) {
            trace.out("log", "SocketProxy.getControllerProperty returns " + (String)controller.getProperties().getProperty(property));
        }
        return (String)controller.getProperties().getProperty(property);
    }

    String getGuid() {
        return SocketProxy.getGuid(this.controller);
    }

    public static String getGuid(BR_Controller controller) {
        return controller.getSessionId();
    }

    private boolean isOnline() {
        return this.controller != null;
    }

    public void setController(BR_Controller controller) {
        this.setController(controller, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setController(BR_Controller controller, BufferedReader br) {
        this.controller = controller;
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "SocketProxy.setController(" + controller + ") isOnline() " + this.isOnline() + ", utp " + this.utp);
        }
        if (controller != null) {
            controller.setRemoteProxy(this);
            if (this.isOnline()) {
                String string = controller.getProperties().listenerMutex;
                synchronized (string) {
                    if (this.utp == null) {
                        this.utp = this.createSocketToolProxy(this.sock, controller);
                    }
                    this.setupSocket(this.sock);
                    if (br == null) {
                        try {
                            InputStream is = this.sock.getInputStream();
                            this.in = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                            if (trace.getDebugCode("sp")) {
                                trace.out("sp", "\nSocketProxy.setController() sock=" + (this.sock == null ? null : this.sock.getRemoteSocketAddress()) + ", in=" + this.in + " to read...");
                            }
                        }
                        catch (IOException ioe) {
                            trace.err("Error getting input stream from sock " + (this.sock == null ? null : this.sock.getRemoteSocketAddress()));
                            ioe.printStackTrace();
                        }
                    } else {
                        if (trace.getDebugCode("sp")) {
                            trace.out("sp", "Reusing the old bufferedReader. Lets hope for success.");
                        }
                        this.in = br;
                    }
                }
            }
        }
    }

    public SocketProxy() {
        this(1500, "localhost", 1501, false, 0, null);
    }

    public SocketProxy(int serverPort, String clientHost, int clientPort, boolean logOnly, int msgFormat, BR_Controller controller) {
        if (trace.getDebugCode("sp")) {
            trace.printStack("sp", String.format("SocketProxy(%d, %s, %d, %b, %d, %s): isOnline = #%b#", serverPort, clientHost, clientPort, logOnly, msgFormat, controller == null ? "null" : controller.toString(), this.isOnline()));
        }
        this.serverPort = serverPort;
        this.clientHost = clientHost;
        this.clientPort = clientPort;
        this.logOnly = logOnly;
        this.msgFormat = msgFormat;
        this.controller = controller;
        this.sock = null;
        this.in = null;
    }

    public SocketProxy(Socket sock, String msgFormat) {
        this(sock, msgFormat == null ? 1 : SocketProxy.interpretMsgFormat(msgFormat));
    }

    public SocketProxy(Socket sock, int msgFormat) {
        if (trace.getDebugCode("sp")) {
            trace.printStack("sp", String.format("SocketProxy(%s, %d) isOnline = #%b#", sock == null ? "null" : sock.toString(), msgFormat, this.isOnline()));
        }
        String remoteAddress = sock.getRemoteSocketAddress().toString();
        String clientHost = remoteAddress.split(":")[0];
        int clientPort = new Integer(remoteAddress.split(":")[1]);
        this.serverPort = sock.getLocalPort();
        this.clientHost = clientHost;
        this.clientPort = clientPort;
        this.logOnly = false;
        this.msgFormat = msgFormat;
        this.controller = null;
        this.sock = sock;
        this.quitOnConnectionBreak = true;
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "SocketProxy(" + remoteAddress + ")");
        }
    }

    @Override
    public void setupLogServlet(MessageObject setPrefsMsg) {
        Object guidObj;
        String guid = this.getGuid();
        Object object = guidObj = setPrefsMsg == null ? null : setPrefsMsg.getProperty("session_id");
        if (guidObj instanceof String) {
            guid = (String)guidObj;
        }
        LogServlet logServlet = new LogServlet(this.controller.getPreferencesModel(), setPrefsMsg, this.controller.inTutoringServiceMode(), guid);
        if (trace.getDebugCode("log")) {
            trace.out("log", "SocketProxy.setLogServlet(" + logServlet + ")");
        }
        this.setLogServlet(logServlet);
        TSLauncherServer ls = this.getController().getLauncher().getLauncherServer();
        if (trace.getDebugCode("log")) {
            trace.out("log", "SocketProxy TSLaunchServer ls = " + trace.nh(ls) + ";\n  guid = " + guid + "; getGuid() = " + this.getGuid() + ";\n  BR_Controller =" + this.controller + " (" + trace.nh(this.controller) + ")");
        }
        if (ls != null) {
            logServlet.setLogInfo(ls.getLogInfo(guid));
        }
        new Thread(logServlet).start();
    }

    public int getEom() {
        return this.eom;
    }

    public void setEom(int eom) {
        this.eom = eom;
        if (this.utp != null) {
            this.utp.setEom(eom);
        }
    }

    public void setEom(String eomStr) {
        if (eomStr == null) {
            return;
        }
        try {
            int eom = Integer.parseInt(eomStr, 16);
            this.setEom(eom);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid character '" + eomStr + "' for end-of-message: " + e);
        }
    }

    public boolean getUseSingleSocket() {
        return this.useSingleSocket;
    }

    public void setUseSingleSocket(boolean useSingleSocket) {
        this.useSingleSocket = useSingleSocket;
    }

    public void setUseSingleSocket(String useSingleSocket) {
        if (useSingleSocket == null) {
            return;
        }
        this.useSingleSocket = Boolean.parseBoolean(useSingleSocket);
    }

    private void controllerStart() {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "SP.controllerStart() ctlr " + this.controller + ", isOnline " + this.isOnline() + ", isAcceptingSSMsgs " + (this.controller == null ? null : Boolean.valueOf(this.controller.isAcceptingStartStateMessages())));
        }
        if (this.controller == null) {
            return;
        }
        if (this.isOnline()) {
            return;
        }
        if (this.controller.isAcceptingStartStateMessages()) {
            this.controller.interfaceConnected();
            this.controller.startNewProblem();
        }
    }

    protected Socket setupSocket(Socket sock) {
        if (this.useSingleSocket && !this.connectFirst) {
            this.setToolProxySocket(sock);
        }
        if (this.useSingleSocket && this.connectFirst) {
            sock = (Socket)this.utp.getSocket();
        }
        return sock;
    }

    protected SocketToolProxy createSocketToolProxy(Socket sock, BR_Controller ctlr) {
        SocketToolProxy stp = new SocketToolProxy(ctlr);
        stp.setConnectFirst(this.connectFirst);
        if (this.useSingleSocket && !this.connectFirst) {
            stp.init(sock, this.msgFormat, this.eom, this.controller);
        } else {
            stp.init(this.clientHost, this.clientPort, this.msgFormat, this.eom, this.oneMsgPerSocket, this.controller);
        }
        return stp;
    }

    @Override
    public void run() {
        try {
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "Controller = " + this.controller);
            }
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "SocketProxy.listen(): isOnline = #" + this.isOnline() + "#");
            }
            this.gotQuitMsg = false;
            this.createActionHandler();
            while (!this.gotQuitMsg) {
                MessageObject mo;
                Socket oldSock = this.sock;
                if (trace.getDebugCode("sp")) {
                    trace.out("sp", "SocketProxy.run() sock " + this.sock + ", in " + this.in);
                }
                if (this.sock == null) break;
                if (trace.getDebugCode("sp")) {
                    trace.out("sp", "\nSocketProxy.listen(in=" + this.in + ") to read...");
                }
                String msg = null;
                Timer timer = null;
                if (this.isOnline() && MAX_IDLE_TIME < Long.MAX_VALUE) {
                    timer = new Timer();
                    timer.schedule((TimerTask)new disconnect(false, true), MAX_IDLE_TIME);
                }
                try {
                    String string = msg = this.eom >= 0 ? SocketProxy.readToEom(this.in, this.eom) : SocketProxy.readAll(this.in);
                    if (timer != null) {
                        timer.cancel();
                        timer = null;
                    }
                }
                catch (Exception e) {
                    if (timer != null) {
                        timer.cancel();
                        timer = null;
                    }
                    trace.err("\nSocketProxy.listen() read exception: " + e + "\n");
                }
                this.setLastReceiptTime(System.currentTimeMillis());
                if (trace.getDebugCode("tsltsp")) {
                    trace.outNT("tsltsp", "" + this.getGuid() + " " + msg);
                }
                if (SocketProxy.handlePolicyFileRequest(msg, this.sock)) {
                    this.sock = null;
                    oldSock = null;
                    this.in = null;
                    continue;
                }
                if (this.handleLogRecord(msg, this.sock)) continue;
                if (this.sock != oldSock) {
                    this.sock = this.setupSocket(this.sock);
                    this.controllerStart();
                }
                if (msg == null || msg.length() <= 0) {
                    if (this.isOnline() || this.quitOnConnectionBreak) {
                        Collaborators.abort(this.controller, this.getGuid(), "A participant has left. Please close the tutor.");
                        if (trace.getDebugCode("sp")) {
                            trace.outln("sp", "SocketProxy.listen() running disconnect function; controller " + this.controller);
                        }
                        disconnect dc = new disconnect(true, true);
                        dc.run();
                        if (this.getToolProxy() instanceof RemoteToolProxy) {
                            ((RemoteToolProxy)this.getToolProxy()).prepareForDisconnect();
                        }
                        if (this.controller != null) {
                            this.controller.setRemoteProxy(null);
                        }
                        return;
                    }
                    this.closeConnection();
                    continue;
                }
                if ("q".equals(msg.trim())) {
                    this.gotQuitMsg = true;
                } else if (!this.logOnly && (mo = this.convertMsg(msg)) != null) {
                    TSLauncherServer ls = this.getController().getLauncher().getLauncherServer();
                    if (trace.getDebugCode("collab")) {
                        trace.out("collab", "SP.run(): ls " + trace.nh(ls) + "; guid " + this.getGuid());
                    }
                    String guid = null;
                    if (ls != null) {
                        guid = this.getGuid();
                        ls.updateTimeStamp(guid);
                        mo.setTransactionInfo(ls.createTransactionInfo(guid));
                    }
                    if (ls == null || ls.enqueueToCollaborators(guid, mo) < 1) {
                        if (trace.getDebugCode("sp")) {
                            trace.out("sp", "guid " + guid + " enqueue to ActionHandler: " + msg);
                        }
                        this.getActionHandler().enqueue(mo);
                    }
                }
                if (!this.oneMsgPerSocket) continue;
                this.closeConnection();
            }
            this.closeConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private long getLastReceiptTime() {
        TSLauncherServer.Session sess;
        TSLauncherServer ls;
        SingleSessionLauncher ssl;
        BR_Controller ctlr = this.getController();
        if (null != ctlr && null != (ssl = ctlr.getLauncher()) && null != (ls = ssl.getLauncherServer()) && null != (sess = ls.getSession(this.getGuid()))) {
            return sess.getLastReceiptTime();
        }
        return 1L;
    }

    private void setLastReceiptTime(long currentTimeMillis) {
        TSLauncherServer.Session sess;
        TSLauncherServer ls;
        SingleSessionLauncher ssl;
        BR_Controller ctlr = this.getController();
        if (null != ctlr && null != (ssl = ctlr.getLauncher()) && null != (ls = ssl.getLauncherServer()) && null != (sess = ls.getSession(this.getGuid()))) {
            sess.setLastReceiptTime(System.currentTimeMillis());
        }
    }

    private boolean handleLogRecord(String msg, Socket sock) {
        return LogServlet.handleLogRecord(msg, this.logServlet, sock);
    }

    private void closeConnection() {
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "CloseConnect(): closing connection");
        }
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (Exception e) {
            trace.err("closeConnection(): Exception closing reader " + e);
        }
        try {
            if (this.sock != null) {
                this.sock.close();
            }
        }
        catch (Exception e) {
            trace.err("closeConnection(): Exception closing socket " + e);
        }
        this.in = null;
        this.sock = null;
        if (this.useSingleSocket) {
            this.setToolProxySocket(this.sock);
        }
        if (this.controller != null) {
            this.controller.interfaceDisconnected();
        }
    }

    protected void setToolProxySocket(Socket sock) {
        this.utp.setSocket(sock);
        if (sock == null || sock.isClosed()) {
            this.utp.setStudentInterfaceConnectionStatus(StudentInterfaceConnectionStatus.Disconnected);
        }
    }

    @Override
    public void extCloseConnection(boolean preserveSession) {
        CTATTab tab;
        if (trace.getDebugCode("sp")) {
            trace.out("sp", "extCloseConnection(): closing connection");
        }
        if (!Utils.isRuntime() && this.controller != null && (tab = this.controller.getLauncher().getTabManager().getTabByNumber(this.controller.getTabNumber())) != null) {
            tab.setSwfName(null);
        }
        disconnect disc = new disconnect(preserveSession);
        disc.run();
        if (this.controller != null) {
            this.controller.setRemoteProxy(null);
        }
    }

    private ServerSocket openServerSocket() {
        try {
            ServerSocket ss = new ServerSocket(this.serverPort);
            return ss;
        }
        catch (Exception e) {
            String errMsg = "opening server port " + this.serverPort + ": " + e;
            trace.errStack("FATAL ERROR, exiting JVM: " + errMsg, e);
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "FATAL ERROR, exiting JVM: " + errMsg);
            }
            this.reportFatalError(errMsg);
            return null;
        }
    }

    protected void reportFatalError(String errMsg) {
        if (!this.isOnline() && this.controller != null) {
            JOptionPane.showMessageDialog(this.controller.getActiveWindow(), "Fatal error " + errMsg + "\nProgram will exit.", "Error Opening Port", 0);
        }
        System.exit(11);
    }

    public static String readAll(Reader rdr) throws IOException {
        return SocketReader.readAll(rdr);
    }

    public static String readToEom(Reader rdr, int eom) throws IOException {
        return SocketReader.readToEom(rdr, eom);
    }

    public boolean isLogOnly() {
        return this.logOnly;
    }

    public void setLogOnly(boolean logOnly) {
        this.logOnly = logOnly;
    }

    public void setLogOnly(String logOnly) {
        if (logOnly == null) {
            return;
        }
        this.logOnly = Boolean.parseBoolean(logOnly);
    }

    public String getClientHost() {
        return this.clientHost;
    }

    public void setClientHost(String clientHost) {
        if (clientHost == null || clientHost.length() < 1) {
            return;
        }
        this.clientHost = clientHost;
    }

    public boolean isConnectFirst() {
        return this.connectFirst;
    }

    public void setConnectFirst(boolean connectFirst) {
        this.connectFirst = connectFirst;
    }

    public void setConnectFirst(String connectFirst) {
        if (connectFirst == null) {
            return;
        }
        this.connectFirst = Boolean.parseBoolean(connectFirst);
    }

    public boolean isOneMsgPerSocket() {
        return this.oneMsgPerSocket;
    }

    public void setOneMsgPerSocket(boolean oneMsgPerSocket) {
        this.oneMsgPerSocket = oneMsgPerSocket;
    }

    public void setOneMsgPerSocket(String oneMsgPerSocket) {
        if (oneMsgPerSocket == null) {
            return;
        }
        this.oneMsgPerSocket = Boolean.parseBoolean(oneMsgPerSocket);
    }

    public int getClientPort() {
        return this.clientPort;
    }

    public void setClientPort(int clientPort) {
        this.clientPort = clientPort;
    }

    public void setClientPort(String clientPort) {
        if (clientPort == null) {
            return;
        }
        this.clientPort = Integer.parseInt(clientPort);
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public void setMsgFormat(String fmt) {
        try {
            int newMsgFormat;
            this.msgFormat = newMsgFormat = SocketProxy.interpretMsgFormat(fmt);
            if (this.utp != null) {
                this.utp.setFormat(newMsgFormat);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int interpretMsgFormat(String fmt) {
        try {
            int i = Integer.parseInt(fmt);
            if (i < 0 || 2 < i) {
                throw new IllegalArgumentException("invalid message format value " + fmt);
            }
            return i;
        }
        catch (NumberFormatException nfe) {
            if (fmt == null) {
                throw new IllegalArgumentException("missing message format value");
            }
            if (fmt.startsWith("x") || fmt.startsWith("X")) {
                return 2;
            }
            if (fmt.startsWith("m") || fmt.startsWith("M")) {
                return 1;
            }
            if (fmt.startsWith("d") || fmt.startsWith("D")) {
                return 0;
            }
            throw new IllegalArgumentException("invalid message format value " + fmt);
        }
    }

    Socket getSocket() {
        return this.sock;
    }

    void setSocket(Socket sock) {
        this.sock = sock;
    }

    private void sendHousekeepingMessage() {
        try {
            InetAddress addr = InetAddress.getByName("localhost");
            Socket commSock = new Socket(addr, 1503);
            PrintWriter pw = new PrintWriter(commSock.getOutputStream());
            pw.write(this.getGuid());
            pw.close();
            commSock.close();
            pw = null;
            Object var2_3 = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getMsgFormat() {
        return this.msgFormat;
    }

    protected BR_Controller getController() {
        return this.controller;
    }

    @Override
    public UniversalToolProxy getToolProxy() {
        return this.utp;
    }

    protected void createActionHandler() {
        this.setActionHandler(new ActionHandler(this.getController()));
        new Thread(this.getActionHandler()).start();
    }

    @Override
    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    protected void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    private MessageObject convertMsg(String msg) {
        return SocketProxy.convertMsg(msg, this.getMsgFormat());
    }

    public static MessageObject convertMsg(String msg, int msgFmt) {
        try {
            MessageObject mo = null;
            if (msgFmt == 2) {
                mo = DataShopMessageObject.parse(msg);
            } else if (msgFmt == 1) {
                mo = MessageObject.parse(msg);
            } else {
                throw new IllegalArgumentException("SocketProxy.convertMsg() unknown message format " + msgFmt);
            }
            if (trace.getDebugCode("sp")) {
                trace.out("sp", "SocketProxy.convertMsg() msgFormat " + msgFmt + ", messageType " + (mo == null ? "[null mo]" : mo.getMessageType()));
            }
            return mo;
        }
        catch (Exception e) {
            trace.err("Error converting message \"" + (msg == null ? null : (msg.length() < 40 ? msg : msg.substring(0, 40))) + "\": " + e);
            e.printStackTrace();
            return null;
        }
    }

    public static int argvToMsgFormat(String[] argv) {
        int defaultResult = 1;
        if (argv == null) {
            return defaultResult;
        }
        try {
            for (int i = 0; i < argv.length; ++i) {
                String arg;
                int s;
                if (argv[i] == null || (s = (arg = argv[i].toLowerCase()).indexOf(SP_MSG_FORMAT.toLowerCase())) < 0) continue;
                int e = s + SP_MSG_FORMAT.length();
                if (arg.length() >= e + 2 && arg.charAt(e) == '=') {
                    return SocketProxy.interpretMsgFormat(arg.substring(e + 1, e + 2));
                }
                if (++i >= argv.length) continue;
                return SocketProxy.interpretMsgFormat(argv[i].substring(0, 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultResult;
    }

    public static boolean handlePolicyFileRequest(String msg, Socket pSock) {
        try {
            if (msg == null) {
                throw new IOException("null message from socket");
            }
            if (!msg.regionMatches(0, policyFileRequest, 0, policyFileRequest.length())) {
                return false;
            }
            if (trace.getDebugCode("ls")) {
                trace.outNT("ls", "SocketProxy.handlePolicyFileRequest()\nReceived a policy request on local " + pSock.getLocalPort() + ", remote " + pSock.getPort() + "\n");
            }
            PrintWriter pw = new PrintWriter(pSock.getOutputStream());
            pw.write(socketPolicyContent);
            pw.close();
            pSock.close();
        }
        catch (IOException ioe) {
            StringBuffer errMsg = new StringBuffer("Error in security handshake with Flash");
            errMsg.append(".\nMore info: exception sending policy file response: ").append(ioe);
            if (ioe.getCause() != null) {
                errMsg.append("\n cause: ").append(ioe.getCause());
            }
            trace.errStack(errMsg.toString(), ioe);
            try {
                if (pSock != null) {
                    pSock.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static String getSocketPolicyContent() {
        return socketPolicyContent;
    }

    public synchronized LogServlet getLogServlet() {
        return this.logServlet;
    }

    public synchronized void setLogServlet(LogServlet logServlet) {
        this.logServlet = logServlet;
    }

    private class disconnect
    extends TimerTask {
        private boolean preserveSession;
        private boolean checkLastReceived = false;

        public disconnect(boolean preserveSession) {
            this(preserveSession, false);
        }

        public disconnect(boolean preserveSession, boolean checkLastReceived) {
            this.preserveSession = preserveSession;
            this.checkLastReceived = checkLastReceived;
        }

        @Override
        public void run() {
            long now = System.currentTimeMillis();
            long lastReceived = SocketProxy.this.getLastReceiptTime();
            if (this.checkLastReceived && now - lastReceived < MAX_IDLE_TIME) {
                trace.err("SocketProxy.disconnect.run(): preserveSession was " + this.preserveSession + ", now true at " + new Date(now) + ", lastReceived " + new Date(lastReceived));
                this.preserveSession = true;
            }
            if (SocketProxy.this.logServlet != null) {
                SocketProxy.this.logServlet.exit();
            }
            if (SocketProxy.this.getActionHandler() != null) {
                SocketProxy.this.getActionHandler().enqueue(MessageObject.makeQuitMessage());
            }
            if (SocketProxy.this.controller != null && !this.preserveSession) {
                SocketProxy.this.getController().getLauncher().getLauncherServer().removeSession(SocketProxy.this.getGuid());
            }
            if (SocketProxy.this.utp != null) {
                SocketProxy.this.setToolProxySocket(null);
            }
            try {
                if (SocketProxy.this.sock != null) {
                    SocketProxy.this.sock.close();
                }
            }
            catch (Exception e) {
                trace.err("disconnect(): Exception closing socket " + e);
            }
            SocketProxy.this.in = null;
            SocketProxy.this.sock = null;
        }
    }
}

