/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log;

import edu.cmu.pact.Log.DataShopSampleSplitter.DataShopSampleSplitter;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Text;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class LogFormatUtils {
    private static final String OLI_PROLOGUE = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>";
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static final String XML_PROLOGUE_REGEX = "<\\?xml version=\"1\\.0\" encoding=\"[-A-Z0-9][-A-Z0-9]*\"\\?>";
    private static final Pattern XML_PROLOGUE_REGEX_PATTERN = Pattern.compile("<\\?xml version=\"1\\.0\" encoding=\"[-A-Z0-9][-A-Z0-9]*\"\\?>", 10);
    private static final SAXBuilder saxBuilder = new SAXBuilder();
    private static final SimpleDateFormat yyyyMMddHHmmssSSSSSFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSSS");
    private static final SimpleDateFormat yyyyMMddHHmmssSSSFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
    private static final Pattern numericEntityFmt = Pattern.compile("&#([0-9][0-9]*);");
    private static final Pattern hexNumericEntityFmt = Pattern.compile("&#[xX]([0-9A-Fa-f][0-9A-Fa-f]*);");
    private static final String[] predefinedEntities = new String[]{"<", "&lt;", ">", "&gt;", "&", "&amp;", "'", "&apos;", "\"", "&quot;"};
    private static final String nonAmpersandEntities;
    private Skills skills;
    private static Charset charset;
    private static String encoding;

    public static void main(String[] args) {
        String s;
        BufferedReader rdr;
        List elts;
        Element[] getRoot;
        trace.out("authorLog", "user.dir is " + System.getProperty("user.dir"));
        int i = 0;
        String encoding = DEFAULT_ENCODING;
        if (args.length > i && "-encoding".equals(args[i])) {
            encoding = args.length > i + 1 ? args[++i] : DEFAULT_ENCODING;
            LogFormatUtils.setEncoding(encoding);
        }
        if (args.length < i + 1) {
            LogFormatUtils.usageExit(1);
        }
        if ("-readElements".equals(args[i])) {
            try {
                getRoot = new Element[1];
                elts = LogFormatUtils.readLogFile(args[++i], getRoot);
                LogFormatUtils.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\r\n", System.out);
                LogFormatUtils.write("<root>\r\n", System.out);
                XMLOutputter xmlo = new XMLOutputter(Format.getPrettyFormat().setIndent("  ").setEncoding(encoding).setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator("\r\n"));
                for (Element elt : elts) {
                    LogFormatUtils.write("\r\n", System.out);
                    xmlo.output(elt, (OutputStream)System.out);
                    LogFormatUtils.write("\r\n", System.out);
                }
                LogFormatUtils.write("\r\n</root>\r\n", System.out);
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        } else if ("-unescape".equals(args[i])) {
            ++i;
            while (i < args.length) {
                try {
                    File convertedFile = LogFormatUtils.parseConvertUnescape(new File(args[i]));
                    rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(convertedFile), encoding));
                    s = rdr.readLine();
                    while (s != null) {
                        LogFormatUtils.write(s, System.out);
                        LogFormatUtils.write("\r\n", System.out);
                        s = rdr.readLine();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                ++i;
            }
            System.exit(0);
        } else if ("-decode".equals(args[i])) {
            ++i;
            while (i < args.length) {
                try {
                    File f = new File(args[i]);
                    rdr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), encoding));
                    s = rdr.readLine();
                    while (s != null) {
                        s = LogFormatUtils.unescape(s);
                        LogFormatUtils.write(s, System.out);
                        LogFormatUtils.write("\r\n", System.out);
                        s = rdr.readLine();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.exit(1);
                }
                ++i;
            }
            System.exit(0);
        } else if ("-addCustomFieldMilliSecond".equals(args[i])) {
            try {
                getRoot = new Element[1];
                elts = LogFormatUtils.readLogFile(args[++i], getRoot);
                FileOutputStream os = new FileOutputStream(new File(args[++i]));
                LogFormatUtils.write("<?xml version=\"1.0\" encoding=\"" + encoding + "\"?>\r\n", os);
                LogFormatUtils.write("<tutor_related_message_sequence\r\n  xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'\r\n  xsi:noNamespaceSchemaLocation=\"http://learnlab.web.cmu.edu/dtd/tutor_message_v4.xsd\"\r\n  version_number=\"4\">\r\n", os);
                XMLOutputter xmlo = new XMLOutputter(Format.getPrettyFormat().setIndent("  ").setEncoding(encoding).setOmitEncoding(true).setOmitDeclaration(true).setLineSeparator("\r\n"));
                for (Element elt : elts) {
                    LogFormatUtils.write("\r\n", os);
                    Element newElt = LogFormatUtils.formatForMilliSecond(elt);
                    if (newElt != null) {
                        xmlo.output(newElt, (OutputStream)os);
                    }
                    os.flush();
                }
                LogFormatUtils.write("\r\n</tutor_related_message_sequence>\r\n", os);
                os.flush();
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
                LogFormatUtils.usageExit(1);
            }
        }
        if (args.length < 4) {
            LogFormatUtils.usageExit(1);
        }
        try {
            File log = new File(args[0]);
            File preferences = args.length < 5 ? new File("logformatprefs.xml") : new File(args[4]);
            File tempLog = LogFormatUtils.convertLogFile(log);
            LogFormatUtils.mergeLogs(tempLog, new File(args[1]), new File(args[2]));
            LogFormatUtils.formatForHumanReading(new File(args[2]), new File(args[3]), preferences);
        }
        catch (Exception e) {
            e.printStackTrace();
            LogFormatUtils.usageExit(2);
        }
    }

    private static int usageExit(int exitStatus) {
        System.err.println("\nCorrect usage: java LogFormatUtils c s m hr [p]\n           or: java LogFormatUtils [-encoding e] -unescape o...\n           or: java LogFormatUtils [-encoding e] -decode u...\n           or: java LogFormatUtils [-encoding e] -readElements c...\n           or: java LogFormatUtils [-encoding e] -addCustomFieldMilliSecond i o\nwhere\n   c = ctat log file(s) (use dummy name if none),\n   i = ctat log file\n   o = OLI  DISK log file(s)\n   u = file(s) encoded with URL encoding (\"%2C\" for comma, e.g.)\n   e = output character encoding (\"ISO-8859-1\", default \"UTF-8\")\n   s = Slogger (Firefox extension) log file (use dummy name if none),\n   m = merged and unescaped output file,\n   hr = output file for human reading,\n   p = preferences file (default logformatprefs.xml)");
        System.exit(exitStatus);
        return exitStatus;
    }

    static String tzDateFormat(String time, String timeZone) {
        SimpleDateFormat dfin = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSSS");
        SimpleDateFormat dfout = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            dfout.setTimeZone(TimeZone.getTimeZone(timeZone));
            Date d = dfin.parse(time);
            return dfout.format(d).toString();
        }
        catch (ParseException parseException) {
            return time;
        }
    }

    static String utcDateFormat(String time, String timeZone) {
        TimeZone tzout = TimeZone.getTimeZone("UTC");
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS");
        SimpleDateFormat dfout = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
        dfout.setTimeZone(tzout);
        try {
            df.setTimeZone(TimeZone.getTimeZone(timeZone));
            Date d = df.parse(time);
            return dfout.format(d).toString();
        }
        catch (ParseException parseException) {
            return time;
        }
    }

    static Element formatForMilliSecond(Element logActionElem) {
        if (!logActionElem.getName().equals("log_action")) {
            return null;
        }
        Element trmsElt = logActionElem.getChild("tutor_related_message_sequence");
        if (trmsElt == null) {
            return logActionElem;
        }
        Element tm = null;
        tm = trmsElt.getChild("context_message");
        if (tm == null && (tm = trmsElt.getChild("tutor_message")) == null && (tm = trmsElt.getChild("tool_message")) == null) {
            return null;
        }
        Element metaElement = new Element("meta");
        metaElement.addContent((Content)new Element("user_id"));
        metaElement.getChild("user_id").addContent(logActionElem.getAttributeValue("user_guid"));
        metaElement.addContent((Content)new Element("session_id"));
        metaElement.getChild("session_id").addContent(logActionElem.getAttributeValue("session_id"));
        metaElement.addContent((Content)new Element("time"));
        metaElement.getChild("time").addContent(LogFormatUtils.tzDateFormat(logActionElem.getAttributeValue("date_time"), logActionElem.getAttributeValue("timezone")));
        metaElement.addContent((Content)new Element("time_zone"));
        metaElement.getChild("time_zone").addContent(logActionElem.getAttributeValue("timezone"));
        Element custom_field_Element = new Element("custom_field");
        custom_field_Element.addContent((Content)new Element("name"));
        if (tm.getName().equals("tool_message")) {
            custom_field_Element.getChild("name").addContent("tool_event_time");
        } else if (tm.getName().equals("tutor_message")) {
            custom_field_Element.getChild("name").addContent("tutor_event_time");
        } else if (tm.getName().equals("context_message")) {
            custom_field_Element.getChild("name").addContent("context_event_time");
        }
        custom_field_Element.addContent((Content)new Element("value"));
        custom_field_Element.getChild("value").addContent(LogFormatUtils.utcDateFormat(logActionElem.getAttributeValue("date_time"), logActionElem.getAttributeValue("timezone")));
        List removeElement = tm.removeContent();
        tm.addContent((Content)metaElement);
        tm.addContent((Collection)removeElement);
        tm.addContent((Content)custom_field_Element);
        return tm;
    }

    static void formatForHumanReading(File inFile, File outFile, File prefs) throws JDOMException, IOException {
        SAXBuilder saxb = new SAXBuilder();
        Document doc = saxb.build(inFile);
        List allLogActions = doc.getRootElement().getChildren();
        Document doc2 = saxb.build(prefs);
        Element allPrefs = doc2.getRootElement();
        String currentWindow = "";
        FileWriter fw = new FileWriter(outFile);
        fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n");
        fw.write("<root>\r\n");
        XMLOutputter xmlo = new XMLOutputter(Format.getPrettyFormat().setIndent("  ").setOmitEncoding(false).setOmitDeclaration(false).setLineSeparator("\r\n"));
        Date lastDate = null;
        for (Element logActionElem : allLogActions) {
            if (!logActionElem.getName().equals("log_action")) continue;
            String actionId = logActionElem.getAttributeValue("action_id");
            String action = null;
            String argument = null;
            String result = null;
            String cycle = null;
            Skills skills = null;
            if (actionId.equals("tool_message")) continue;
            if (actionId.equals("tutor_message")) {
                if (!logActionElem.getAttributeValue("source_id").equals("PACT_CTAT")) continue;
                if (currentWindow.equals("Student Interface")) {
                    logActionElem.setAttribute("source_id", "STUDENT_INTERFACE");
                }
            } else {
                if (actionId.equals("message") || actionId.equals("ATTEMPT") || actionId.equals("RESULT")) continue;
                if (actionId.equals("START_TUTOR")) {
                    action = "START_TUTOR";
                } else if (actionId.equals("author_action_message") && logActionElem.getChild("tutor_related_message_sequence").getChild("author_action_message").getChildText("action_type").equals("TEST_MODEL_ALL_STEPS")) continue;
            }
            if (action == null) {
                action = LogFormatUtils.findActionName(logActionElem);
            }
            if (argument == null) {
                argument = LogFormatUtils.findArgumentName(logActionElem);
            }
            if (result == null) {
                result = LogFormatUtils.findResultName(logActionElem);
            }
            if (cycle == null) {
                cycle = LogFormatUtils.findCycleName(logActionElem, action);
            }
            if (skills == null) {
                skills = LogFormatUtils.findSkills(logActionElem);
            }
            String fullDate = null;
            Date dateInXmlFile = null;
            try {
                dateInXmlFile = yyyyMMddHHmmssSSSSSFormat.parse(logActionElem.getAttributeValue("date_time"));
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
            fullDate = yyyyMMddHHmmssSSSFormat.format(dateInXmlFile);
            logActionElem.setAttribute("date_time", fullDate);
            Attribute dateTimeAttr = logActionElem.getAttribute("date_time");
            logActionElem.removeAttribute(dateTimeAttr);
            logActionElem.setAttribute(dateTimeAttr);
            String timeElapsed = LogFormatUtils.getTimeElapsed(lastDate, dateInXmlFile);
            logActionElem.setAttribute("time_elapsed", timeElapsed);
            lastDate = dateInXmlFile;
            if (action.equals("FOCUS_GAINED")) {
                currentWindow = argument;
            } else if (action.equals("FOCUS_LOST") && currentWindow.equals(argument)) {
                currentWindow = "";
            }
            logActionElem.removeContent();
            logActionElem.addContent((Content)new Element("action"));
            logActionElem.getChild("action").addContent((Content)new Text(action));
            logActionElem.addContent((Content)new Element("argument"));
            logActionElem.getChild("argument").addContent((Content)new Text(argument));
            logActionElem.addContent((Content)new Element("result"));
            logActionElem.getChild("result").addContent((Content)new Text(result));
            logActionElem.addContent((Content)new Element("cycle"));
            logActionElem.getChild("cycle").addContent((Content)new Text(cycle));
            logActionElem.addContent((Content)new Element("skills"));
            logActionElem.getChild("skills").addContent((Content)new Text(skills.toString()));
            LogFormatUtils.hideColumns(logActionElem, prefs);
            if ((action.equals("SHOW") || action.equals("HIDE") || action.equals("FOCUS_GAINED") || action.equals("FOCUS_LOST")) && !allPrefs.getChildText("show_focus_entries").equals("true")) continue;
            xmlo.output(logActionElem, (Writer)fw);
            fw.write("\r\n");
        }
        fw.write("</root>\r\n");
        fw.close();
    }

    private static Skills findSkills(Element logActionElem) {
        Element tmElt;
        Element trmsElt = logActionElem.getChild("tutor_related_message_sequence");
        if (null != trmsElt && null != (tmElt = trmsElt.getChild("tutor_message"))) {
            List skillElts = tmElt.getChildren("skill");
            return new Skills(skillElts);
        }
        return new Skills(null);
    }

    private static String findCycleName(Element logActionElem, String action) {
        if (action == null) {
            return "";
        }
        String sourceId = logActionElem.getAttributeValue("source_id");
        if (sourceId.equals("EXTERNAL_EDITOR")) {
            return "edit";
        }
        if (sourceId.equals("WHY_NOT_WINDOW")) {
            return "debug";
        }
        if (sourceId.equals("CONFLICT_TREE")) {
            return "debug";
        }
        if (sourceId.equals("WORKING_MEMORY_EDITOR")) {
            return "debug";
        }
        if (sourceId.equals("BEHAVIOR_RECORDER")) {
            if (action.equals("TEST_MODEL_ALL_STEPS_RESULT")) {
                return "test";
            }
            if (action.equals("TEST_MODEL_1_STEP_RESULT")) {
                return "test";
            }
        } else if (sourceId.equals("STUDENT_INTERFACE")) {
            return "test";
        }
        return "";
    }

    private static void hideColumns(Element logActionElem, File prefs) throws JDOMException, IOException {
        SAXBuilder s = new SAXBuilder();
        Document d = s.build(prefs);
        Element allPrefs = d.getRootElement().getChild("columns");
        List allAttrs = logActionElem.getAttributes();
        for (int i = allAttrs.size() - 1; i >= 0; --i) {
            Attribute attr = (Attribute)allAttrs.get(i);
            if (allPrefs.getChildText(attr.getName()).trim().equals("true")) continue;
            logActionElem.removeAttribute(attr);
        }
    }

    private static String findArgumentName(Element logActionElem) {
        String actionId = logActionElem.getAttributeValue("action_id");
        if (actionId == null) {
            return "";
        }
        if (actionId.equals("author_action_message")) {
            Element authorActionMessageElem = logActionElem.getChild("tutor_related_message_sequence").getChild("author_action_message");
            return authorActionMessageElem.getChildText("argument");
        }
        if (actionId.equals("curriculum_message")) {
            Element curriculumElem = logActionElem.getChild("tutor_related_message_sequence").getChild("curriculum_message");
            return curriculumElem.getChildText("course_name") + ":" + curriculumElem.getChildText("unit_name") + ":" + curriculumElem.getChildText("section_name") + ":" + curriculumElem.getChildText("problem_name");
        }
        if (logActionElem.getAttributeValue("action_id").equals("program_action_message")) {
            Element programActionMessageElem = logActionElem.getChild("tutor_related_message_sequence").getChild("program_action_message");
            return programActionMessageElem.getChildText("argument");
        }
        if (actionId.equals("tutor_message") && LogFormatUtils.isTutorResult(logActionElem)) {
            Element eventDescriptorElem = logActionElem.getChild("tutor_related_message_sequence").getChild("tutor_message").getChild("event_descriptor");
            if (eventDescriptorElem != null) {
                return "Input: " + eventDescriptorElem.getChildText("input");
            }
            return "";
        }
        return "";
    }

    private static String findResultName(Element logActionElem) {
        String actionId = logActionElem.getAttributeValue("action_id");
        if (actionId == null) {
            return "";
        }
        if (actionId.equals("author_action_message")) {
            Element authorActionMessageElem = logActionElem.getChild("tutor_related_message_sequence").getChild("author_action_message");
            return authorActionMessageElem.getChildText("result") + "" + authorActionMessageElem.getChildText("result_details");
        }
        if (logActionElem.getAttributeValue("action_id").equals("program_action_message")) {
            Element programActionMessageElem = logActionElem.getChild("tutor_related_message_sequence").getChild("program_action_message");
            return programActionMessageElem.getChildText("result") + programActionMessageElem.getChildText("result_details");
        }
        if (actionId.equals("tutor_message") && logActionElem.getChild("tutor_related_message_sequence").getChild("tutor_message").getChild("semantic_event").getAttributeValue("name").equals("RESULT")) {
            Element tutorMessageElem = logActionElem.getChild("tutor_related_message_sequence").getChild("tutor_message");
            return tutorMessageElem.getChildText("action_evaluation");
        }
        return "";
    }

    private static String findActionName(Element logActionElem) {
        Element eventDescriptorElem;
        if (logActionElem.getAttributeValue("action_id") == null) {
            return "";
        }
        if (logActionElem.getAttributeValue("action_id").equals("author_action_message")) {
            Element authorActionMessageElem = logActionElem.getChild("tutor_related_message_sequence").getChild("author_action_message");
            return authorActionMessageElem.getChildText("action_type");
        }
        if (logActionElem.getAttributeValue("action_id").equals("program_action_message")) {
            Element programActionMessageElem = logActionElem.getChild("tutor_related_message_sequence").getChild("program_action_message");
            return programActionMessageElem.getChildText("action_type");
        }
        if (logActionElem.getAttributeValue("action_id").equals("tutor_message") && LogFormatUtils.isTutorResult(logActionElem) && (eventDescriptorElem = logActionElem.getChild("tutor_related_message_sequence").getChild("tutor_message").getChild("event_descriptor")) != null) {
            return "Selection: " + eventDescriptorElem.getChildText("selection") + "Action: " + eventDescriptorElem.getChildText("action");
        }
        return "";
    }

    private static boolean isTutorResult(Element logActionElem) {
        Element trms = logActionElem.getChild("tutor_related_message_sequence");
        if (trms == null) {
            return false;
        }
        Element tm = trms.getChild("tutor_message");
        if (tm == null) {
            return false;
        }
        Element se = tm.getChild("semantic_event");
        if (se == null) {
            return false;
        }
        trace.out("log", "semantic_event transaction_id " + se.getAttributeValue("transaction_id"));
        String name = se.getAttributeValue("name");
        return "RESULT".equals(name);
    }

    public static void makeValidXML(File f) throws IOException {
        LogFormatUtils.makeValidXML(f, f);
    }

    public static void makeValidXML(File inf, File outf) throws IOException {
        FileInputStream is = new FileInputStream(inf);
        InputStreamReader isr = new InputStreamReader((InputStream)is, "ISO-8859-1");
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        while (br.ready()) {
            sb.append(br.readLine());
        }
        br.close();
        isr.close();
        is.close();
        String[] eltTexts = LogFormatUtils.docTextsToElementTexts(sb.toString());
        if (trace.getDebugCode("log")) {
            trace.out("log", "file " + inf.getName() + ": nMsgs " + eltTexts.length);
        }
        String s0 = eltTexts.length > 0 ? eltTexts[0] : "";
        FileOutputStream os = new FileOutputStream(outf);
        if (s0.length() < 1) {
            trace.err("Found no valid XML in file " + inf.getCanonicalPath());
            LogFormatUtils.write("", os);
        } else {
            boolean needsRoot;
            boolean bl = needsRoot = s0.startsWith("<log_action") || s0.startsWith("<log_session");
            if (needsRoot) {
                LogFormatUtils.write("<root>", os);
            }
            for (String s : eltTexts) {
                LogFormatUtils.write(s, os);
            }
            if (needsRoot) {
                LogFormatUtils.write("</root>", os);
            }
        }
        ((OutputStream)os).close();
    }

    private static String[] docTextsToElementTexts(String s) {
        String s0;
        Matcher m = XML_PROLOGUE_REGEX_PATTERN.matcher(s);
        if (!m.find()) {
            trace.err("Found no instances of XML prolog pattern " + XML_PROLOGUE_REGEX_PATTERN.toString() + "\nSplitting to try returning an array of individual XML documents");
            String[] result = s.split("(?<=>)");
            if (trace.getDebugCode("logconsole")) {
                for (int i = 0; i < result.length; ++i) {
                    trace.out("logconsole", result[i]);
                }
            }
            return result;
        }
        ArrayList<String> result = new ArrayList<String>();
        int b0 = m.start();
        int b1 = 0;
        if (b0 > 0 && (s0 = s.substring(0, b0).trim()).length() > 0) {
            trace.err("Warning: data (length ) found before first XML prologue: " + (s0.length() > 30 ? s0.substring(0, 30) + "..." : s0));
            if (LogFormatUtils.validXML(s, 0, b0)) {
                result.add(s0);
            }
        }
        do {
            int e = m.end();
            int n = b1 = m.find() ? m.start() : s.length();
            if (LogFormatUtils.validXML(s, b0, b1)) {
                result.add(s.substring(e, b1));
            }
            b0 = b1;
        } while (b1 < s.length());
        int n = result.size();
        trace.out("log", "docTextsToElementTexts found " + n + " valid documents");
        return result.toArray(new String[n]);
    }

    private static boolean validXML(String s, int b, int e) {
        try {
            String fragment = s.substring(b, e);
            StringReader rdr = new StringReader(fragment);
            Document d = saxBuilder.build((Reader)rdr);
            return true;
        }
        catch (JDOMException je) {
            trace.err("invalid XML between chars " + b + " & " + e + ": " + (Object)((Object)je));
            return false;
        }
        catch (IOException ioe) {
            trace.err("i/o error between chars " + b + " & " + e + ": " + ioe);
            return false;
        }
    }

    public static String unescape(String s) {
        try {
            return URLDecoder.decode(s, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException uee) {
            trace.err("should not happen on UTF-8:" + uee);
            return s;
        }
    }

    public static String escape(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        s = LogFormatUtils.fixAmpersands(s);
        StringTokenizer tkzr = new StringTokenizer(s, nonAmpersandEntities, true);
        StringBuffer sb = new StringBuffer();
        while (tkzr.hasMoreTokens()) {
            String tkn = tkzr.nextToken();
            if (tkn.length() == 1) {
                for (int i = 0; i < predefinedEntities.length; i += 2) {
                    if (!predefinedEntities[i].equals(tkn)) continue;
                    tkn = predefinedEntities[i + 1];
                    break;
                }
            }
            sb.append(tkn);
        }
        return sb.toString();
    }

    public static String fixAmpersands(String s) {
        int a0 = s.indexOf(38);
        if (a0 < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.substring(0, a0));
        int a = a0;
        int a1 = s.indexOf(38, a + 1);
        while (a >= 0) {
            String seg = a1 < 0 ? s.substring(a) : s.substring(a, a1);
            String escSeq = LogFormatUtils.startingEscapeSequence(seg);
            if (escSeq == null) {
                sb.append("&amp;").append(seg.substring(1));
            } else {
                sb.append(escSeq).append(seg.substring(escSeq.length()));
            }
            a = a1;
            a1 = s.indexOf(38, a + 1);
        }
        return sb.toString();
    }

    public static String startingEscapeSequence(String s) {
        if (s == null || s.length() < 2) {
            return null;
        }
        int semicolonPos = s.indexOf(59);
        if (s.charAt(0) != '&' || semicolonPos < 1) {
            return null;
        }
        String escSeq = s.substring(0, semicolonPos + 1);
        String unescChar = LogFormatUtils.unescapeEntity(escSeq);
        return unescChar == null ? null : escSeq;
    }

    public static String unescapeString(String s) {
        if (s == null) {
            return null;
        }
        int a0 = s.indexOf(38);
        if (a0 < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.substring(0, a0));
        int a = a0;
        int a1 = s.indexOf(38, a + 1);
        while (a >= 0) {
            String seg = a1 < 0 ? s.substring(a) : s.substring(a, a1);
            String escSeq = LogFormatUtils.startingEscapeSequence(seg);
            if (escSeq == null) {
                sb.append("&").append(seg.substring(1));
            } else {
                sb.append(LogFormatUtils.unescapeEntity(escSeq));
                sb.append(seg.substring(escSeq.length(), seg.length()));
            }
            a = a1;
            a1 = s.indexOf(38, a + 1);
        }
        return sb.toString();
    }

    public static String unescapeEntity(String seq) {
        if (seq == null || seq.length() < 2) {
            return null;
        }
        int semicolonPos = seq.indexOf(59);
        if (seq.charAt(0) != '&' || semicolonPos < 1) {
            return null;
        }
        Matcher m = numericEntityFmt.matcher(seq);
        if (m.matches()) {
            return String.valueOf((char)Integer.parseInt(m.group(1)));
        }
        m = hexNumericEntityFmt.matcher(seq);
        if (m.matches()) {
            return String.valueOf((char)Integer.parseInt(m.group(1), 16));
        }
        for (int i = 1; i < predefinedEntities.length; i += 2) {
            if (!predefinedEntities[i].equals(seq)) continue;
            return predefinedEntities[i - 1];
        }
        return null;
    }

    public static void unescapeAll(File f) throws IOException {
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        StringBuffer sb = new StringBuffer();
        while (br.ready()) {
            sb.append(br.readLine());
        }
        String s = sb.toString();
        s = LogFormatUtils.unescapeAll(s, true);
        FileWriter fw = new FileWriter(f);
        fw.write(s);
        fw.close();
        br.close();
        fr.close();
    }

    static String unescapeAll(String s, boolean escAmperands) {
        if (s == null) {
            return s;
        }
        s = LogFormatUtils.unescape(s);
        if (escAmperands) {
            s = LogFormatUtils.fixAmpersands(s);
        }
        s = s.replaceAll(XML_PROLOGUE_REGEX, "");
        return s;
    }

    static String getTimeElapsed(Date oldTime, Date newTime) {
        Date d = null;
        String timeElapsed = "";
        long msSinceLastLog = 0L;
        SimpleDateFormat SSSSSInput = new SimpleDateFormat("SSSSS");
        SimpleDateFormat HHmmssSSSOutput = new SimpleDateFormat("HH:mm:ss.SSS");
        if (oldTime == null) {
            oldTime = newTime;
        }
        msSinceLastLog = newTime.getTime() - oldTime.getTime();
        try {
            d = SSSSSInput.parse(new Long(msSinceLastLog).toString());
            timeElapsed = HHmmssSSSOutput.format(d);
        }
        catch (ParseException pe) {
            pe.printStackTrace();
        }
        return timeElapsed;
    }

    public static void mergeLogs(File log1, File log2, File outFile) throws JDOMException, IOException, ParseException {
        FileOutputStream fos = new FileOutputStream(outFile);
        LogFormatUtils.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>", fos);
        LogFormatUtils.write("<root>", fos);
        XMLOutputter xmlout = new XMLOutputter();
        xmlout.getFormat().setEncoding(DEFAULT_ENCODING);
        SAXBuilder saxb = new SAXBuilder();
        Document log1doc = log1.exists() ? saxb.build(log1) : new Document(new Element("root"));
        Document log2doc = log2.exists() ? saxb.build(log2) : new Document(new Element("root"));
        List log1nodes = log1doc.getRootElement().getChildren();
        List log2nodes = log2doc.getRootElement().getChildren();
        int i = 0;
        while (!log1nodes.isEmpty() && !log2nodes.isEmpty()) {
            Element e1 = (Element)log1nodes.get(0);
            Element e2 = (Element)log2nodes.get(0);
            String dateStr1 = e1.getAttributeValue("date_time");
            String dateStr2 = e2.getAttributeValue("date_time");
            if (dateStr1 == null) {
                log1nodes.remove(0);
            } else if (dateStr2 == null) {
                log2nodes.remove(0);
            } else {
                Date date2;
                Date date1 = yyyyMMddHHmmssSSSFormat.parse(dateStr1);
                if (date1.before(date2 = yyyyMMddHHmmssSSSFormat.parse(dateStr2))) {
                    xmlout.output((Element)log1nodes.remove(0), (OutputStream)fos);
                } else {
                    xmlout.output((Element)log2nodes.remove(0), (OutputStream)fos);
                }
            }
            ++i;
        }
        while (!log1nodes.isEmpty()) {
            xmlout.output((Element)log1nodes.remove(0), (OutputStream)fos);
        }
        while (!log2nodes.isEmpty()) {
            xmlout.output((Element)log2nodes.remove(0), (OutputStream)fos);
        }
        LogFormatUtils.write("</root>", fos);
        fos.close();
    }

    public static File convertLogFile(File inf) throws IOException {
        File infTemp = inf;
        if (trace.getDebugCode("log")) {
            trace.out("log", "convertLogFile file name: " + infTemp);
        }
        try {
            if (DataShopSampleSplitter.isTabDelimited(inf)) {
                infTemp = File.createTempFile(inf.getName(), ".tmp");
                infTemp.deleteOnExit();
                DataShopSampleSplitter.convertTabDelimitedToXML(inf, infTemp);
            }
            return LogFormatUtils.parseConvertUnescape(infTemp);
        }
        catch (Exception e) {
            String errMsg = "Error converting log file " + inf.getName();
            trace.err(errMsg + ": " + e);
            IOException ioe2 = new IOException(errMsg);
            ioe2.initCause(e);
            throw ioe2;
        }
    }

    public static List readLogFile(String inFileName, Element[] returnRoot) throws Exception {
        return LogFormatUtils.readLogFile(inFileName, true, returnRoot);
    }

    public static List<Element> readLogFile(String inFileName, boolean convert, Element[] returnRoot) throws Exception {
        File inf;
        File file = inf = inFileName == null ? null : new File(inFileName);
        if (inf == null || !inf.isFile()) {
            FileNotFoundException e = new FileNotFoundException("cannot read file \"" + inFileName + "\"");
            trace.err(e.toString());
            throw e;
        }
        Document doc = LogFormatUtils.parseLog(inf, convert);
        if (trace.getDebugCode("log")) {
            System.out.println("doc.getRootElement().toString() " + doc.getRootElement().toString());
            System.out.println("entire document " + new XMLOutputter().outputString(doc.getRootElement()));
            int i = 0;
            for (Object elt : doc.getRootElement().getChildren("log_action")) {
                Element e = (Element)elt;
                System.out.printf("%s[%3d] has %d children\n", e.getName(), i++, e.getChildren().size());
            }
        }
        Element root = doc.getRootElement();
        List logEntries = root.getChildren();
        if (returnRoot != null && returnRoot.length > 0) {
            returnRoot[0] = root;
        }
        trace.out("log", "readLogFile: logEntries is " + logEntries);
        trace.out("log", "readLogFile: logEntries.size() " + logEntries.size());
        trace.out("log", "doc = " + new XMLOutputter(Format.getPrettyFormat()).outputString(doc));
        return logEntries;
    }

    public static Document parseLog(File inf, boolean convertLog) throws Exception {
        File infTemp;
        File file = infTemp = convertLog ? LogFormatUtils.convertLogFile(inf) : inf;
        if (trace.getDebugCode("log")) {
            trace.out("log", "parseLog pretty printing " + convertLog);
        }
        try {
            SAXBuilder saxb = new SAXBuilder();
            Document doc = saxb.build(infTemp);
            if (infTemp != inf) {
                infTemp.delete();
            }
            return doc;
        }
        catch (JDOMException je) {
            Exception e = new Exception("Error parsing log file " + infTemp.getName() + ": " + (Object)((Object)je) + (je.getCause() == null ? "" : "; cause: " + je.getCause().toString()), je);
            trace.err(e.toString());
            throw e;
        }
        catch (IOException ioe) {
            Exception e = new Exception("Error parsing log file " + infTemp.getName() + ": " + ioe, ioe);
            trace.err(e.toString());
            throw e;
        }
    }

    public static File parseConvertUnescape(File inf) throws Exception {
        Document doc;
        File infTemp = File.createTempFile(inf.getName(), ".tmp");
        infTemp.deleteOnExit();
        try {
            LogFormatUtils.makeValidXML(inf, infTemp);
            SAXBuilder saxb = new SAXBuilder();
            doc = saxb.build(infTemp);
        }
        catch (JDOMException je) {
            Exception e = new Exception("Error parsing log file " + infTemp.getName() + ": " + (Object)((Object)je) + (je.getCause() == null ? "" : ";\n cause: " + je.getCause().toString()), je);
            trace.err(e.toString());
            throw e;
        }
        catch (IOException ioe) {
            Exception e = new Exception("Error reading log file " + inf.getName() + ": " + ioe + (ioe.getCause() == null ? "" : ";\n cause: " + ioe.getCause().toString()), ioe);
            trace.err(e.toString());
            throw e;
        }
        StringWriter sw = new StringWriter();
        sw.write("<?xml version=\"1.0\" encoding=\"" + LogFormatUtils.getEncoding() + "\"?>\n");
        sw.write("<root>\n");
        XMLOutputter xmlo = new XMLOutputter(Format.getPrettyFormat().setIndent("  ").setEncoding(LogFormatUtils.getEncoding()).setOmitEncoding(true).setOmitDeclaration(true).setLineSeparator("\r\n"));
        Element root = doc.getRootElement();
        List children = root.getChildren();
        Iterator childrenIt = children.iterator();
        int i = 1;
        while (childrenIt.hasNext()) {
            Element child = (Element)childrenIt.next();
            String escText = child.getTextTrim();
            String text = LogFormatUtils.unescapeAll(escText, false);
            child.setText("");
            StringBuffer tag = new StringBuffer(xmlo.outputString(child));
            tag.deleteCharAt(tag.lastIndexOf("/"));
            sw.append(tag);
            sw.append(text);
            sw.append("</").append(child.getName()).append(">\n");
            ++i;
        }
        sw.write("</root>\n");
        sw.close();
        File outfTemp = File.createTempFile(inf.getName(), ".tmp2");
        outfTemp.deleteOnExit();
        FileOutputStream os = new FileOutputStream(outfTemp);
        LogFormatUtils.write(sw.toString(), os);
        ((OutputStream)os).close();
        return outfTemp;
    }

    public static String getEncoding() {
        return encoding;
    }

    static void setEncoding(String encoding) {
        if ((encoding = encoding == null ? DEFAULT_ENCODING : encoding.toUpperCase()).equals(LogFormatUtils.encoding)) {
            return;
        }
        LogFormatUtils.encoding = encoding;
        charset = Charset.forName(LogFormatUtils.encoding);
    }

    public static void write(String s, OutputStream os) throws IOException {
        ByteBuffer bytes = charset.encode(s);
        os.write(bytes.array(), 0, bytes.limit());
    }

    static {
        StringBuffer escapeUs = new StringBuffer();
        for (int i = 0; i < predefinedEntities.length; i += 2) {
            if ("&".equals(predefinedEntities[i])) continue;
            escapeUs.append(predefinedEntities[i]);
        }
        nonAmpersandEntities = escapeUs.toString();
        charset = Charset.forName(DEFAULT_ENCODING);
        encoding = DEFAULT_ENCODING;
    }

    static class Skills {
        private StringBuffer sb = null;
        private int nSkills = 0;

        Skills(List skillElts) {
            if (skillElts == null) {
                return;
            }
            Iterator it = skillElts.iterator();
            while (it.hasNext()) {
                this.add((Element)it.next());
                ++this.nSkills;
            }
        }

        void add(Element skillElt) {
            Element name;
            if (this.sb == null) {
                this.sb = new StringBuffer();
            } else {
                this.sb.append("\n");
            }
            String s = null;
            Element category = skillElt.getChild("category");
            if (category != null && (s = category.getTextNormalize()).length() > 0) {
                this.sb.append(s).append(" ");
            }
            if ((name = skillElt.getChild("name")) != null && (s = name.getTextNormalize()).length() > 0) {
                this.sb.append(s);
            }
            if ((s = skillElt.getAttributeValue("buggy")) != null) {
                this.sb.append(" buggy=").append(s);
            }
            if ((s = skillElt.getAttributeValue("probability")) != null) {
                this.sb.append(" probability=").append(s);
            }
        }

        public String toString() {
            return this.sb == null ? "" : this.sb.toString();
        }
    }
}

