/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.Log.LogDifferences;

import edu.cmu.pact.Log.LogDifferences.BasicRow;
import edu.cmu.pact.Log.LogDifferences.Column;
import edu.cmu.pact.Log.LogDifferences.Content.ContentCell;
import edu.cmu.pact.Log.LogDifferences.Contents;
import edu.cmu.pact.Log.LogDifferences.DifferencesCounter;
import edu.cmu.pact.Log.LogDifferences.Row;

public class ComparisonRow
implements Row {
    private final Contents content;
    private final Row originalRow;
    private final Column column;
    private final String[] row;
    private final DifferencesCounter diffs = new DifferencesCounter();
    private static final String ditto = "\"\"\"\"";

    public ComparisonRow(Contents content, Row originalRow, Column column) {
        this.content = content;
        this.originalRow = originalRow;
        this.column = column;
        this.row = this.makeRowFromContents();
        this.addLeadingData();
        ((BasicRow)originalRow).setDiffsColumns(this.diffs);
    }

    @Override
    public String[] toArray() {
        return this.row;
    }

    private String[] makeRowFromContents() {
        String[] tempRow = new String[this.column.getNumColumns()];
        for (ContentCell cell : this.content) {
            String columnName = cell.getColumnName();
            int index = this.column.getIndex(columnName);
            this.addCellIfDifferent(index, cell, tempRow);
        }
        return tempRow;
    }

    private void addCellIfDifferent(int index, ContentCell comparisonCell, String[] tempRow) {
        String newContent = comparisonCell.getContent();
        String oldContent = this.originalRow.toArray()[index];
        if (newContent == null && oldContent == null) {
            return;
        }
        if (newContent == null && oldContent != null) {
            this.diffs.increment();
            return;
        }
        if (newContent != null && oldContent == null) {
            this.diffs.increment();
            tempRow[index] = comparisonCell.getContent();
            return;
        }
        if (newContent.equalsIgnoreCase(oldContent) || comparisonCell.getPropertyName() != null && comparisonCell.getPropertyName().equals("tutor_event_time")) {
            tempRow[index] = ditto;
            return;
        }
        tempRow[index] = comparisonCell.getContent();
        this.diffs.increment();
    }

    private void addLeadingData() {
        this.row[this.column.getIndex((String)"Has differences").intValue()] = this.diffs.hasDiffs();
        this.row[this.column.getIndex((String)"# of differences").intValue()] = this.diffs.getNumDiffs();
        this.row[this.column.getIndex((String)"transaction_id").intValue()] = this.content.getTransactionId();
        this.row[this.column.getIndex((String)"old/new").intValue()] = "new";
    }
}

