/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.BehaviorRecorder.View.ActionLabel;
import edu.cmu.pact.BehaviorRecorder.View.NodeView;
import edu.cmu.pact.BehaviorRecorder.jgraphwindow.MarathonElement;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JLabel;
import org.jdom.Element;

public class CheckLispLabel
extends JLabel
implements MarathonElement {
    private static final long serialVersionUID = -8627795754670483665L;
    public String preCheckedStatus = "No-Applicable";
    private BR_Controller controller;
    private EdgeData edgeData;

    public void restoreTransients(BR_Controller controller) {
        this.controller = controller;
    }

    public CheckLispLabel(EdgeData edge, BR_Controller controller) {
        this.controller = controller;
        this.edgeData = edge;
        this.setVisible(true);
        this.setSize(new Dimension(60, 30));
    }

    public void resetText(int arcID) {
        if (this.preCheckedStatus.equalsIgnoreCase("SUCCESS")) {
            this.setText(arcID + "C");
        } else if (this.preCheckedStatus.equalsIgnoreCase("NO-MODEL")) {
            this.setText(arcID + "U");
        } else if (this.preCheckedStatus.equalsIgnoreCase("BUG")) {
            this.setText(arcID + "B");
        } else if (this.preCheckedStatus.equalsIgnoreCase("FIREABLE-BUG")) {
            this.setText(arcID + "F");
        } else if (this.preCheckedStatus.equalsIgnoreCase("No-Applicable") || this.preCheckedStatus.equalsIgnoreCase("Never Checked")) {
            this.setText(arcID + "N");
        }
    }

    public void resetForeground() {
        if (this.preCheckedStatus.equalsIgnoreCase("SUCCESS")) {
            this.setForeground(ActionLabel.correctColor);
        } else if (this.preCheckedStatus.equalsIgnoreCase("NO-MODEL")) {
            this.setForeground(ActionLabel.untacebleColor);
        } else if (this.preCheckedStatus.equalsIgnoreCase("BUG")) {
            this.setForeground(ActionLabel.buggyColor);
        } else if (this.preCheckedStatus.equalsIgnoreCase("FIREABLE-BUG")) {
            this.setForeground(ActionLabel.fireableBuggyColor);
        } else if (this.preCheckedStatus.equalsIgnoreCase("No-Applicable") || this.preCheckedStatus.equalsIgnoreCase("Never Checked")) {
            this.setForeground(ActionLabel.unknownColor);
        }
    }

    public void resetCheckedStatus(String chekedStatus) {
        this.preCheckedStatus = chekedStatus;
    }

    public String getCheckedStatus() {
        return this.preCheckedStatus;
    }

    public void resetAll(int arcID, String chekedStatus) {
        this.resetCheckedStatus(chekedStatus);
        this.resetText(arcID);
        this.resetForeground();
    }

    public void update(int uniqueID, ProblemNode startNode, ProblemNode endNode) {
        NodeView startVertex = startNode.getNodeView();
        if (startVertex == null) {
            return;
        }
        NodeView endVertex = endNode.getNodeView();
        Point LabelLocation = new Point();
        Point NodeStartLocation = startVertex.getLocation();
        Dimension NodeStartSize = startVertex.getSize();
        int EdgeStartX = NodeStartLocation.x + NodeStartSize.width / 3;
        int EdgeStartY = NodeStartLocation.y + NodeStartSize.height / 2;
        Point NodeEndLocation = endVertex.getLocation();
        Dimension NodeEndSize = endVertex.getSize();
        int EdgeEndX = NodeEndLocation.x + NodeEndSize.width / 3;
        int EdgeEndY = NodeEndLocation.y + NodeEndSize.height / 2;
        Dimension LabelSize = this.getSize();
        LabelLocation = new Point();
        LabelLocation.x = EdgeStartX + (EdgeEndX - EdgeStartX) / 5 + 15;
        LabelLocation.y = EdgeStartY + (EdgeEndY - EdgeStartY) / 5 - LabelSize.height / 2;
        this.setLocation(LabelLocation);
        this.setSize(LabelSize);
        this.resetText(uniqueID);
        this.resetForeground();
        this.setVisible(this.controller.isPreCheckLISPLabelsFlag());
        this.setHorizontalAlignment(2);
    }

    @Override
    public String getMarathonIdentifier() {
        return "Edge" + this.edgeData.getEdge().getUniqueID() + "::CheckLabel";
    }

    @Override
    public int getTextStyle() {
        return this.getFont().getStyle();
    }

    @Override
    public String getToolTipText() {
        return "";
    }

    public Element toElement() {
        if (this.preCheckedStatus == null) {
            return null;
        }
        return new Element("preCheckedStatus").setText(this.preCheckedStatus);
    }
}

