/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher;

import cl.common.SolverActionType;
import cl.common.SolverOperation;
import cl.tutors.solver.SolverTutor;
import cl.tutors.solver.SolverTutorProblem;
import cl.tutors.solver.rule.SolverGoal;
import cl.tutors.solver.test.Test;
import cl.utilities.Logging.Logger;
import cl.utilities.TestableTutor.InitializationException;
import cl.utilities.TestableTutor.InvalidParamException;
import cl.utilities.TestableTutor.InvalidStepException;
import cl.utilities.sm.SMParserSettings;
import cl.utilities.sm.SymbolManipulator;
import cl.utilities.sm.query.Queryable;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.Matcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Matcher.VectorMatcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.VariableTable;
import edu.cmu.pact.Utilities.trace;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.jdom.Element;

public class SolverMatcher
extends VectorMatcher {
    private static SymbolManipulator sm = new SymbolManipulator(SMParserSettings.HS_DEFAULT);
    private static final SolverTutorAction[] flashComponent2SolverTutorAction = new SolverTutorAction[]{new SolverTutorAction("Solver_requestaddtobothsides", "request", "Add [input] to both sides."), new SolverTutorAction("Solver_requestsubtractfrombothsides", "request", "Subtract [input] from both sides."), new SolverTutorAction("Solver_requestmultiplybothsides", "request", "Multiply both sides by [input]."), new SolverTutorAction("Solver_requestdividebothsides", "request", "Divide both sides by [input]."), new SolverTutorAction("Solver_addtobothsides", "add"), new SolverTutorAction("Solver_subtractfrombothsides", "subtract"), new SolverTutorAction("Solver_multiplybothsides", "multiply"), new SolverTutorAction("Solver_dividebothsides", "divide"), new SolverTutorAction("Solver_requestaddorsubtractterms", "clt", "Add/subtract terms in which subexpression?"), new SolverTutorAction("Solver_requestperformmultiplication", "mt", "Perform multiplication in which subexpression?"), new SolverTutorAction("Solver_requestsimplifyfractions", "rf", "Simplify which fraction?"), new SolverTutorAction("Solver_requestsimplifysigns", "simp", "Simplify signs in which subexpression?"), new SolverTutorAction("Solver_requestdistribute", "distribute", "Distribute factor in which subexpression?"), new SolverTutorAction("Solver_addorsubtractterms", "clt", "Add/subtract terms in which subexpression?"), new SolverTutorAction("Solver_performmultiplication", "mt", "Perform multiplication in which subexpression?"), new SolverTutorAction("Solver_simplifyfractions", "rf", "Simplify which fraction?"), new SolverTutorAction("Solver_simplifysigns", "simp"), new SolverTutorAction("Solver_distribute", "distribute"), new SolverTutorAction("Solver_factornumerator", "factors of numerator"), new SolverTutorAction("Solver_factordenominator", "factors of denominator"), new SolverTutorAction("Solver_restart", "Solver_restart"), new SolverTutorAction("Solver_finished", "done")};
    private static Map<String, SolverTutorAction> flashComponent2SolverTutorActionMap = new LinkedHashMap<String, SolverTutorAction>();
    private List<String> selection;
    private String origProblemSpec;
    private String problemSpec;
    private SolverTutor solverTutor;
    private boolean autoSimplify;
    private boolean typeinMode;
    private SolverGoal goal;
    private String goalName;
    protected double problemDescriptionMaxColumnWidth = 0.0;
    private static Pattern whichSubex;

    public static String[] getAllGoalNames() {
        SolverGoal[] goals = SolverGoal.getAllGoals();
        String[] result = new String[goals.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = goals[i].getName();
        }
        return result;
    }

    public SolverMatcher(boolean concat2, List<Matcher> sMatchers, List<Matcher> aMatchers, List<Matcher> iMatchers, String actor, String autoSimplify, String typeinMode, String goalName) throws IllegalArgumentException, InitializationException {
        super(concat2, sMatchers, aMatchers, iMatchers, actor);
        if (sMatchers == null || sMatchers.size() < 1) {
            throw new IllegalArgumentException("selection matchers null or empty");
        }
        if (iMatchers == null || iMatchers.size() < 1) {
            throw new IllegalArgumentException("input matchers null or empty");
        }
        Matcher iMatcher = iMatchers.get(0);
        this.origProblemSpec = this.problemSpec = iMatcher.getSingle();
        this.autoSimplify = Boolean.parseBoolean(autoSimplify);
        this.typeinMode = Boolean.parseBoolean(typeinMode);
        this.goalName = goalName;
        this.goal = goalName == null ? SolverGoal.DEFAULT_GOAL : SolverGoal.getGoalByName((String)goalName);
        this.init();
    }

    private void init() {
        if (trace.getDebugCode("solver")) {
            trace.out("solver", "autoSimplify " + this.autoSimplify + ", typeinMode " + this.typeinMode + ", problemSpec: " + this.problemSpec);
        }
        this.solverTutor = new SolverTutor();
        try {
            this.solverTutor.startProblem(this.problemSpec, null);
        }
        catch (Exception e) {
            trace.err("Error from SolverTutor.startProblem(\"" + this.problemSpec + "\"): " + e + (e.getCause() == null ? "" : ";\n  cause " + e.getCause()));
            throw new IllegalArgumentException("Bad algebraic expression \"" + this.problemSpec + "\": " + e);
        }
        try {
            this.solverTutor.setParameter("Solver", "AutoSimplify", Boolean.toString(this.autoSimplify));
            this.solverTutor.setParameter("Solver", "TypeinMode", Boolean.toString(this.typeinMode));
        }
        catch (InvalidParamException ipe) {
            trace.err("Programming error in SolverMatcher constructor: " + (Object)((Object)ipe));
        }
    }

    private SolverGoal getGoal() {
        SolverGoal result = this.goal;
        if (result == null) {
            result = this.solverTutor.getCurrentProblem().isSimpExpression() ? SolverGoal.SIMPLIFY_EXPRESSION : SolverGoal.DEFAULT_GOAL;
        }
        if (trace.getDebugCode("solverdebug")) {
            trace.outNT("solverdebug", "SolverMatcher.getGoal() returning " + result);
        }
        return result;
    }

    public boolean doStep(Vector<String> s, Vector<String> a, Vector<String> i, ExampleTracerEvent result) {
        if (trace.getDebugCode("solverdebug")) {
            trace.out("solverdebug", "doStep(" + s + "," + a + "," + i + ")");
        }
        try {
            String action = a.get(0);
            SolverTutorAction sta = flashComponent2SolverTutorActionMap.get(action);
            String opcode = sta != null ? sta.opcode : (action.length() >= 7 && action.substring(0, 7).equalsIgnoreCase("Solver_") ? action.substring(7) : action);
            boolean rtn = false;
            if ("Solver_restart".equalsIgnoreCase(action)) {
                rtn = this.restart(s, a, i, result);
            } else if ("done".equalsIgnoreCase(opcode)) {
                rtn = this.done(s, opcode, result);
            } else if ("request".equals(opcode)) {
                rtn = this.requestTransformationOperand(action, sta.prompt, result);
            } else {
                String[] subExs = this.needScratchpadSubExs(opcode, i.get(0));
                if (subExs != null && subExs.length > 1) {
                    rtn = this.scratchpadTool(s, opcode, subExs, sta.prompt, result);
                } else {
                    String promptInput;
                    String string = promptInput = subExs != null && subExs.length > 0 ? subExs[0] : i.get(0);
                    if (action.contains("request")) {
                        String newPrompt = this.editPrompt(sta.prompt, promptInput);
                        result.addIaMessage("promptLabel", ExampleTracerEvent.s2v(promptInput), newPrompt, false);
                    }
                    rtn = this.solverTutor.doStep(s.get(0), opcode, promptInput, result);
                }
            }
            result.setFromSolver(true);
            return rtn;
        }
        catch (InvalidStepException ise) {
            trace.err("Error on step (" + s + "," + a + "," + i + ": " + (Object)((Object)ise));
            ise.printStackTrace();
            return false;
        }
    }

    private void addDefaultIaMessage(ExampleTracerEvent result) {
        String iaAction = this.solverTutor.getCurrentProblem().isSimpExpression() ? "nextExpression" : "nextEquation";
        String iaInput = this.solverTutor.getCurrentProblem().getStringValue();
        result.addIaMessage(iaAction, iaInput, "");
    }

    private String editPrompt(String prompt, String promptInput) {
        java.util.regex.Matcher m = whichSubex.matcher(prompt);
        StringBuffer result = new StringBuffer();
        int s = 0;
        while (m.find(s)) {
            int e = m.start();
            result.append(prompt.substring(s, e));
            result.append(promptInput);
            s = m.end();
        }
        result.append(prompt.substring(s, prompt.length()));
        return result.toString();
    }

    private boolean requestTransformationOperand(String action, String prompt, ExampleTracerEvent result) {
        SolverTutorProblem currentProblem = this.getSolverTutor().getCurrentProblem();
        if (currentProblem.isSimpExpression()) {
            String currentExpression = currentProblem.getExpression().toString();
            int nHints = this.requestHint(result);
            result.addIaMessage("promptLabel", currentExpression, prompt);
            result.setTutorAdvice((String)null);
            result.setResult("NO-MODEL");
            result.setIncorrectMsg("Transformation actions are not applicable when no equation is present.");
            result.addIaMessage("nextExpression", currentExpression, currentExpression, false);
            return false;
        }
        result.addIaMessage("promptOperand", null, prompt);
        result.setResult("NotATransaction");
        return true;
    }

    private String[] needScratchpadSubExs(String opcode, String input) throws InvalidStepException {
        SolverOperation op = SolverMatcher.getOpByCode(opcode);
        if (!op.getActionType().getIsScratchpadAction()) {
            return null;
        }
        if (this.typeinMode && (op.getActionType() == SolverActionType.AT_SIMP_EXPR_SUBEX || op.getActionType() == SolverActionType.AT_SIMP_SUBEX)) {
            return null;
        }
        String subcompProp = op.getSubcomponentBooleanProp();
        if (subcompProp == null) {
            trace.err("SolverMenuItem.actionPerformed: ERROR: could not find subcomponent prop for action: " + op);
            return null;
        }
        try {
            String[] subExStrs;
            Queryable[] subExs = sm.runArrayScript("components with property " + subcompProp, input);
            if (subExs == null || subExs.length == 0) {
                if (trace.getDebugCode("solverdebug")) {
                    trace.outNT("solverdebug", "SolverMatcher.actionPerformed: no subcomps suitable for action: " + op);
                }
                subExStrs = null;
            } else if (subExs.length == 1) {
                subExStrs = new String[]{subExs[0].toString()};
            } else if (op == SolverOperation.SIMP) {
                subExStrs = new String[]{subExs[0].toString()};
            } else {
                subExStrs = new String[subExs.length];
                for (int i = 0; i < subExs.length; ++i) {
                    subExStrs[i] = subExs[i].getStringValue();
                }
            }
            return subExStrs;
        }
        catch (Exception e) {
            throw new InvalidStepException("Error analyzing action \"" + opcode + "\", input \"" + input + "\": " + e);
        }
    }

    private static SolverOperation getOpByCode(String opcode) throws InvalidStepException {
        SolverOperation op = SolverOperation.getOpByCode((String)opcode);
        if (op == null) {
            throw new InvalidStepException("solver operation \"" + opcode + "\" undefined");
        }
        return op;
    }

    private boolean done(Vector<String> s, String a, ExampleTracerEvent result) throws InvalidStepException {
        boolean rtn = this.solverTutor.doStep(s.get(0), a, null, result);
        Vector<String> tutorAdvice = result.getTutorAdvice();
        if (!"Correct Action".equalsIgnoreCase(result.getResult()) && (tutorAdvice == null || tutorAdvice.isEmpty())) {
            result.setTutorAdvice("You have not finished yet.");
        }
        return rtn;
    }

    private boolean restart(Vector<String> s, Vector<String> a, Vector<String> i, ExampleTracerEvent result) {
        this.problemSpec = i.get(0);
        result.setResult("Correct Action");
        result.makeTutorSAI(s.get(0), a.get(0), i.get(0));
        this.init();
        return true;
    }

    public int requestHint(ExampleTracerEvent result) {
        int nHints;
        this.solverTutor.requestHint(result);
        result.setFromSolver(true);
        result.makeTutorSAI(this.getSelection(), null, null);
        Vector<String> hints = result.getTutorAdvice();
        int n = nHints = hints == null ? 0 : hints.size();
        if (trace.getDebugCode("solverdebug")) {
            trace.out("solverdebug", "nHints " + nHints + ": " + hints);
        }
        return nHints;
    }

    @Override
    public boolean match(Vector selection, Vector action, Vector input, String actor, VariableTable vt) {
        boolean matched = this.match(selection, null, actor, vt);
        if (trace.getDebugCode("et")) {
            trace.out("et", this.getClass().getSimpleName() + ".match(" + selection + "," + selection + "," + action + "," + input + "," + vt + ") returns " + matched);
        }
        return matched;
    }

    public SolverTutor getSolverTutor() {
        return this.solverTutor;
    }

    @Override
    public void reset() {
        this.init();
    }

    private boolean scratchpadTool(Vector<String> s, String action, String[] subExs, String prompt, ExampleTracerEvent result) {
        result.addIaMessage("chooseSubexpression", new Vector<String>(Arrays.asList(subExs)), prompt);
        result.setResult("NotATransaction");
        return true;
    }

    private int determineTheNumberOfTerms(String problemAsText, String action) {
        int result = -1;
        action = action.toLowerCase();
        try {
            boolean opIsDivision;
            if (action.contains("add") || action.contains("subtract")) {
                result = Integer.parseInt(sm.runScript("length of terms", problemAsText));
            } else if ((action.contains("multiply") || action.contains("divide")) && (result = Integer.parseInt(sm.runScript("length of factors", problemAsText))) == 1 && (opIsDivision = new Boolean(sm.runScript("isRatio", problemAsText)).booleanValue())) {
                result = 2;
            }
        }
        catch (Exception e) {
            Logger.log((Object)e);
            result = -1;
        }
        return result;
    }

    private String determineOperationOfTerms(String problemAsText) {
        String secondTermOp = "";
        try {
            secondTermOp = sm.runScript("operator of term 2", problemAsText);
        }
        catch (Exception e) {
            Logger.log((Object)e);
            return null;
        }
        return secondTermOp;
    }

    public boolean isDone() {
        return this.solverTutor.isDone("dummy");
    }

    @Override
    public int getTraversalIncrement() {
        return this.isDone() ? 1 : 0;
    }

    public boolean getAutoSimplify() {
        return this.autoSimplify;
    }

    public boolean getTypeinMode() {
        return this.typeinMode;
    }

    public String getGoalName() {
        return this.goalName;
    }

    public String getProblemSpec() {
        return this.problemSpec;
    }

    @Override
    protected void setXMLAttributes(Element elt) {
        elt.setAttribute("AutoSimplify", Boolean.toString(this.getAutoSimplify()));
        elt.setAttribute("TypeinMode", Boolean.toString(this.getTypeinMode()));
        if (this.getGoalName() != null) {
            elt.setAttribute("Goal", this.getGoalName());
        }
    }

    static {
        for (int i = 0; i < flashComponent2SolverTutorAction.length; ++i) {
            String key = flashComponent2SolverTutorAction[i].getKey();
            SolverTutorAction value = flashComponent2SolverTutorAction[i];
            flashComponent2SolverTutorActionMap.put(key, value);
        }
        Test.disableCache();
        whichSubex = Pattern.compile("which ([a-z]+)");
    }

    private static class SolverTutorAction {
        private final String studentAction;
        private final String opcode;
        private final String prompt;

        SolverTutorAction(String studentAction, String opcode) {
            this(studentAction, opcode, null);
        }

        SolverTutorAction(String studentAction, String opcode, String prompt) {
            this.studentAction = studentAction;
            this.opcode = opcode;
            this.prompt = prompt;
        }

        String getKey() {
            return this.studentAction;
        }
    }
}

