/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups;

import com.megginson.sax.DataWriter;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.DefaultLinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupChangeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemStateWriter;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class DefaultGroupModel
extends GroupModel {
    private static final String MAIN_ELEMENT_NAME = "EdgesGroups";
    private static final String OUT_OF_ORDER_MESSAGE = "outOfOrderMessage";
    private static final String ORDERED_ATTR = "ordered";
    private static final String REENTERABLE_ATTR = "reenterable";
    private static final String LEGACY_UNORDERED_ATTR = "unordered";
    private static final String NAME_ATTR = "name";
    private static final String LINK_ELEMENT_NAME = "link";
    private static final String GROUP_ELEMENT_NAME = "group";
    private static final String LINK_ID_ATTR = "id";
    DefaultLinkGroup TopLevel;
    boolean isDefaultReenterable;

    public DefaultGroupModel() {
        this.clear();
    }

    @Override
    public String addGroup(String name, boolean isOrdered, Set<ExampleTracerLink> links) {
        LinkGroup naturalContainingGroup;
        try {
            naturalContainingGroup = this.getNaturalContainingGroup(this.getTopLevelGroup(), links);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        DefaultLinkGroup newGroup = new DefaultLinkGroup(name, isOrdered, this.isDefaultReenterable, links);
        this.addSubgroupPreserveSanity(naturalContainingGroup, newGroup);
        this.notifyListeners(new GroupChangeEvent(newGroup, 6));
        return "";
    }

    @Override
    public String isLinkSetAddableAsGroup(Set<ExampleTracerLink> links) {
        try {
            this.getNaturalContainingGroup(this.getTopLevelGroup(), links);
        }
        catch (Exception e) {
            return e.getMessage();
        }
        return "";
    }

    private LinkGroup getNaturalContainingGroup(LinkGroup group, Set<ExampleTracerLink> links) throws Exception {
        if (links.size() == this.getGroupLinks(group).size()) {
            for (ExampleTracerLink link : this.getGroupLinks(group)) {
                if (links.contains(link)) continue;
                throw new Exception("Invalid link selection: Partial overlap with existing group: " + group);
            }
            throw new Exception("Group containing this set of links already exists: " + group);
        }
        if (links.size() >= this.getGroupLinks(group).size()) {
            throw new Exception("Invalid link selection: Partial overlap with existing group: " + group);
        }
        for (ExampleTracerLink link : links) {
            if (!this.isLinkInGroup(group, link)) {
                throw new Exception("Invalid link selection: Partial overlap with existing group: " + group);
            }
            for (LinkGroup subgroup : this.getGroupSubgroups(group)) {
                if (!this.isLinkInGroup(subgroup, link)) continue;
                if (this.getGroupLinkCount(subgroup) >= links.size()) {
                    return this.getNaturalContainingGroup(subgroup, links);
                }
                for (ExampleTracerLink subgroupLink : this.getGroupLinks(subgroup)) {
                    if (links.contains(subgroupLink)) continue;
                    throw new Exception("Invalid link selection: Partial overlap with existing group: " + group);
                }
            }
        }
        return group;
    }

    private void addSubgroupPreserveSanity(LinkGroup parent, LinkGroup child) {
        Iterator<LinkGroup> iter = this.getGroupSubgroups(parent).iterator();
        while (iter.hasNext()) {
            LinkGroup parentSubgroup = iter.next();
            Set<ExampleTracerLink> parentSubgroupLinks = this.getGroupLinks(parentSubgroup);
            if (parentSubgroupLinks.size() == 0) {
                iter.remove();
                this.addSubgroup(child, parentSubgroup);
                continue;
            }
            if (!this.isLinkInGroup(child, parentSubgroupLinks.iterator().next())) continue;
            iter.remove();
            this.addSubgroup(child, parentSubgroup);
        }
        this.addSubgroup(parent, child);
    }

    private void addSubgroup(LinkGroup parent, LinkGroup child) {
        DefaultLinkGroup group = (DefaultLinkGroup)parent;
        group.addSubgroup(child);
        ((DefaultLinkGroup)child).setParent(group);
    }

    @Override
    public void addLinkToGroup(LinkGroup group, ExampleTracerLink link) {
        this.removeLinkFromGroup(this.getTopLevelGroup(), link);
        while (group != null) {
            this.internalAddLinkToGroup(group, link);
            group = this.getGroupParent(group);
        }
        this.notifyListeners(new GroupChangeEvent());
    }

    @Override
    public void addLinksForLoadingBRD(ArrayList<ExampleTracerLink> links) {
        int i = 0;
        for (i = 0; i < links.size(); ++i) {
            this.TopLevel.addLink(links.get(i));
        }
        this.notifyListeners(new GroupChangeEvent());
    }

    private void internalAddLinkToGroup(LinkGroup grp, ExampleTracerLink link) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        group.addLink(link);
    }

    private boolean internalRemoveLinkFromGroup(LinkGroup grp, ExampleTracerLink link) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.removeLink(link);
    }

    @Override
    public Set<String> getAllGroupNames() {
        LinkedHashSet<String> groupNames = new LinkedHashSet<String>();
        for (LinkGroup group : this) {
            groupNames.add(this.getGroupName(group));
        }
        return groupNames;
    }

    @Override
    public Set<ExampleTracerLink> getGroupLinks(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.getLinks();
    }

    @Override
    public String getGroupName(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.getName();
    }

    @Override
    public LinkGroup getGroupParent(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.getParent();
    }

    @Override
    public Set<LinkGroup> getGroupSubgroups(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group != null ? group.getSubgroups() : null;
    }

    @Override
    public LinkGroup getTopLevelGroup() {
        return this.TopLevel;
    }

    @Override
    public LinkGroup getUniqueContainingGroup(ExampleTracerLink link) {
        for (LinkGroup group : this) {
            if (!this.getUniqueLinks(group).contains(link)) continue;
            return group;
        }
        return null;
    }

    @Override
    public Set<ExampleTracerLink> getUniqueLinks(LinkGroup group) {
        LinkedHashSet<ExampleTracerLink> uniqueLinks = new LinkedHashSet<ExampleTracerLink>(this.getGroupLinks(group));
        for (LinkGroup subgroup : this.getGroupSubgroups(group)) {
            for (ExampleTracerLink link : this.getGroupLinks(subgroup)) {
                uniqueLinks.remove(link);
            }
        }
        return uniqueLinks;
    }

    @Override
    public boolean isGroupOrdered(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.isOrdered();
    }

    @Override
    public boolean isLinkAddable(LinkGroup group, ExampleTracerLink link) {
        if (this.isLinkInGroup(group, link)) {
            return false;
        }
        LinkedHashSet<LinkGroup> parents = new LinkedHashSet<LinkGroup>();
        LinkGroup currentGroup = this.getGroupParent(group);
        while (currentGroup != null) {
            parents.add(currentGroup);
            currentGroup = this.getGroupParent(currentGroup);
        }
        for (LinkGroup linkGroup : this) {
            if (!this.isLinkInGroup(linkGroup, link) || parents.contains(linkGroup)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isLinkInGroup(LinkGroup grp, ExampleTracerLink link) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.containsLink(link);
    }

    @Override
    public Iterator<LinkGroup> iterator() {
        return new GroupIterator(this.getTopLevelGroup());
    }

    public void removeSubgroup(LinkGroup grp, LinkGroup subgroup) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        group.removeSubgroup(subgroup);
        this.notifyListeners(new GroupChangeEvent(subgroup, 1));
    }

    @Override
    public void removeAllGroupSubgroups(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        if (trace.getDebugCode("groups")) {
            trace.outNT("groups", "removeAllGroupSubgroups(" + group.getName() + ") nSubgroups " + group.getSubgroups().size());
        }
        GroupIterator iter = new GroupIterator(group);
        ArrayList subgroups = new ArrayList();
        iter.next();
        while (iter.hasNext()) {
            subgroups.add(iter.next());
        }
        group.removeAllSubGroups();
        for (LinkGroup subgroup : subgroups) {
            this.notifyListeners(new GroupChangeEvent(subgroup, 1));
        }
    }

    @Override
    public void removeGroupKeepSubgroups(LinkGroup group) {
        LinkGroup parent = this.getGroupParent(group);
        Set<LinkGroup> subgroups = this.getGroupSubgroups(group);
        if (trace.getDebugCode("groups")) {
            trace.outNT("groups", "removeGroupKeepSubgroups(" + ((DefaultLinkGroup)group).getName() + ") nSubgroups " + subgroups.size());
        }
        for (LinkGroup subgroup : subgroups) {
            this.addSubgroup(parent, subgroup);
        }
        this.removeSubgroup(parent, group);
        this.notifyListeners(new GroupChangeEvent(group, 1));
    }

    @Override
    public void setGroupName(LinkGroup grp, String name) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        group.setName(name);
        this.notifyListeners(new GroupChangeEvent());
    }

    @Override
    public void setGroupOrdered(LinkGroup grp, boolean isOrdered) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        if (trace.getDebugCode("pm")) {
            trace.printStack("pm", "isOrdered " + isOrdered + " group " + group);
        }
        group.setOrdered(isOrdered);
        this.notifyListeners(new GroupChangeEvent());
    }

    @Override
    public LinkGroup getGroupByName(String name) {
        for (LinkGroup group : this) {
            if (!this.getGroupName(group).equals(name)) continue;
            return group;
        }
        return null;
    }

    @Override
    public LinkGroup getLowestLevelGroupOfLink(ExampleTracerLink link) {
        LinkGroup temp = this.getImmediateGroupOfLink(link, this.getTopLevelGroup());
        if (temp != null) {
            return temp;
        }
        if (this.isLinkInGroup(this.getTopLevelGroup(), link)) {
            return this.getTopLevelGroup();
        }
        return null;
    }

    private LinkGroup getImmediateGroupOfLink(ExampleTracerLink link, LinkGroup group) {
        LinkGroup temp = null;
        for (LinkGroup subGroup : this.getGroupSubgroups(group)) {
            if (!this.isLinkInGroup(subGroup, link)) continue;
            temp = this.getImmediateGroupOfLink(link, subGroup);
            if (temp != null) {
                return temp;
            }
            return subGroup;
        }
        return null;
    }

    @Override
    public Set<LinkGroup> getGroupsContainingLink(ExampleTracerLink link) {
        LinkedHashSet<LinkGroup> groups = new LinkedHashSet<LinkGroup>();
        for (LinkGroup group : this) {
            if (!this.isLinkInGroup(group, link)) continue;
            groups.add(group);
        }
        return groups;
    }

    @Override
    public int getHeight() {
        return this.height(this.getTopLevelGroup());
    }

    private int height(LinkGroup group) {
        int max = 0;
        for (LinkGroup subgroup : this.getGroupSubgroups(group)) {
            int height = this.height(subgroup);
            if (height <= max) continue;
            max = height;
        }
        return max + 1;
    }

    @Override
    public boolean isGroupNameValid(String name) {
        if (name == null || name.length() < 1) {
            return false;
        }
        for (LinkGroup group : this) {
            if (!this.getGroupName(group).equals(name)) continue;
            return false;
        }
        return true;
    }

    public String toXMLString() {
        return ProblemStateWriter.multiLineOutputter.outputString(this.toElement());
    }

    public Element toElement() {
        Element elt = new Element(MAIN_ELEMENT_NAME);
        elt.setAttribute(ORDERED_ATTR, Boolean.toString(this.isGroupOrdered(this.getTopLevelGroup())));
        for (LinkGroup group : this.getGroupSubgroups(this.getTopLevelGroup())) {
            elt.addContent((Content)this.makeGroupElement(group));
        }
        return elt;
    }

    private Element makeGroupElement(LinkGroup group) {
        Element elt = new Element(GROUP_ELEMENT_NAME);
        elt.setAttribute(NAME_ATTR, this.getGroupName(group));
        elt.setAttribute(ORDERED_ATTR, Boolean.toString(this.isGroupOrdered(group)));
        elt.setAttribute(REENTERABLE_ATTR, Boolean.toString(this.isGroupReenterable(group)));
        for (ExampleTracerLink link : this.getUniqueLinks(group)) {
            Element child = new Element(LINK_ELEMENT_NAME);
            child.setAttribute(LINK_ID_ATTR, Integer.toString(link.getID()));
            elt.addContent((Content)child);
        }
        for (LinkGroup subgroup : this.getGroupSubgroups(group)) {
            elt.addContent((Content)this.makeGroupElement(subgroup));
        }
        return elt;
    }

    @Override
    public void printXML(DataWriter w) throws SAXException {
        String defaultBuggyMsg;
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", ORDERED_ATTR, "", "Boolean", Boolean.toString(this.isGroupOrdered(this.getTopLevelGroup())));
        w.startElement("", MAIN_ELEMENT_NAME, "", (Attributes)atts);
        if (this.getTopLevelGroup() instanceof DefaultLinkGroup && (defaultBuggyMsg = ((DefaultLinkGroup)this.getTopLevelGroup()).getDefaultBuggyMsg()) != null && defaultBuggyMsg.length() > 0) {
            w.dataElement(OUT_OF_ORDER_MESSAGE, defaultBuggyMsg);
        }
        for (LinkGroup group : this.getGroupSubgroups(this.getTopLevelGroup())) {
            this.printGroupXML(w, group);
        }
        w.endElement(MAIN_ELEMENT_NAME);
    }

    public void printGroupXML(DataWriter w, LinkGroup group) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", NAME_ATTR, "", "String", this.getGroupName(group));
        atts.addAttribute("", ORDERED_ATTR, "", "Boolean", Boolean.toString(this.isGroupOrdered(group)));
        atts.addAttribute("", REENTERABLE_ATTR, "", "Boolean", Boolean.toString(this.isGroupReenterable(group)));
        w.startElement("", GROUP_ELEMENT_NAME, "", (Attributes)atts);
        for (ExampleTracerLink link : this.getUniqueLinks(group)) {
            atts.clear();
            atts.addAttribute("", LINK_ID_ATTR, "", "Integer", Integer.toString(link.getID()));
            w.emptyElement("", LINK_ELEMENT_NAME, "", (Attributes)atts);
        }
        for (LinkGroup subgroup : this.getGroupSubgroups(group)) {
            this.printGroupXML(w, subgroup);
        }
        w.endElement(GROUP_ELEMENT_NAME);
    }

    @Override
    public void readFromXML(Element element2, boolean topLevelUnordered) {
        Map<Integer, ExampleTracerLink> idToEdgeMap = this.createIdToLinkMap();
        if (element2.getAttributeValue(ORDERED_ATTR) == null) {
            for (Element groupElement : element2.getChildren()) {
                this.legacyReadFromXML(groupElement, idToEdgeMap);
            }
            this.setGroupOrdered(this.getTopLevelGroup(), !topLevelUnordered);
            return;
        }
        this.setGroupOrdered(this.getTopLevelGroup(), Boolean.valueOf(element2.getAttributeValue(ORDERED_ATTR)));
        for (Element childElement : element2.getChildren()) {
            if (childElement.getName() == OUT_OF_ORDER_MESSAGE && this.getTopLevelGroup() instanceof DefaultLinkGroup) {
                ((DefaultLinkGroup)this.getTopLevelGroup()).setDefaultBuggyMsg(childElement.getText());
                continue;
            }
            this.readFromXML(childElement, idToEdgeMap);
        }
    }

    private Set<ExampleTracerLink> readFromXML(Element element2, Map<Integer, ExampleTracerLink> idToEdgeMap) {
        LinkedHashSet<ExampleTracerLink> links = new LinkedHashSet<ExampleTracerLink>();
        if (!element2.getName().equals(GROUP_ELEMENT_NAME)) {
            trace.err("Undefined element <" + element2.getName() + "> in edge groups");
            return links;
        }
        String name = element2.getAttributeValue(NAME_ATTR);
        if (!this.isGroupNameValid(name)) {
            return links;
        }
        Boolean isOrdered = Boolean.valueOf(element2.getAttributeValue(ORDERED_ATTR));
        Boolean isReenterable = Boolean.valueOf(element2.getAttributeValue(REENTERABLE_ATTR));
        for (Element subelement : element2.getChildren()) {
            if (subelement.getName().equals(LINK_ELEMENT_NAME)) {
                String edgeIdStr = subelement.getAttributeValue(LINK_ID_ATTR);
                try {
                    Integer edgeId = Integer.valueOf(edgeIdStr);
                    ExampleTracerLink link = idToEdgeMap.get(edgeId);
                    if (link == null) {
                        throw new RuntimeException("undefined <id> number: " + edgeId);
                    }
                    links.add(link);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("undefined <id> value: " + nfe);
                }
            }
            links.addAll(this.readFromXML(subelement, idToEdgeMap));
        }
        this.addGroup(name, isOrdered, links);
        this.setGroupReenterable(this.getGroupByName(name), isReenterable);
        return links;
    }

    private void legacyReadFromXML(Element element2, Map<Integer, ExampleTracerLink> idToEdgeMap) {
        if (!element2.getName().equals(GROUP_ELEMENT_NAME)) {
            trace.err("Undefined element <" + element2.getName() + "> in edge groups");
            return;
        }
        String name = element2.getAttributeValue(NAME_ATTR);
        if (!this.isGroupNameValid(name)) {
            return;
        }
        Boolean isUnordered = Boolean.valueOf(element2.getAttributeValue(LEGACY_UNORDERED_ATTR));
        LinkedHashSet<ExampleTracerLink> links = new LinkedHashSet<ExampleTracerLink>();
        for (Element subelement : element2.getChildren()) {
            if (subelement.getName().equals(LINK_ELEMENT_NAME)) {
                String edgeIdStr = subelement.getAttributeValue(LINK_ID_ATTR);
                try {
                    Integer edgeId = Integer.valueOf(edgeIdStr);
                    ExampleTracerLink link = idToEdgeMap.get(edgeId);
                    if (link == null) {
                        throw new RuntimeException("undefined <id> number: " + edgeId);
                    }
                    links.add(link);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new RuntimeException("undefined <id> value: " + nfe);
                }
            }
            this.legacyReadFromXML(subelement, idToEdgeMap);
        }
        this.addGroup(name, isUnordered == false, links);
    }

    private Map<Integer, ExampleTracerLink> createIdToLinkMap() {
        HashMap<Integer, ExampleTracerLink> map = new HashMap<Integer, ExampleTracerLink>();
        for (ExampleTracerLink link : this.getGroupLinks(this.getTopLevelGroup())) {
            map.put(link.getID(), link);
        }
        return map;
    }

    @Override
    public void removeLinkFromGroup(LinkGroup group, ExampleTracerLink link) {
        if (trace.getDebugCode("groups")) {
            trace.out("groups", "DGM.removeLinkFromGroup(L=" + link.getUniqueID() + ", G=" + group + ")");
        }
        this.internalRemoveLinkFromGroupRecursive(group, link, false);
        this.notifyListeners(new GroupChangeEvent());
    }

    private void internalRemoveLinkFromGroupRecursive(LinkGroup grp, ExampleTracerLink link, boolean canRemoveFromTopLevel) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        if (group.containsLink(link)) {
            for (LinkGroup subgroup : this.getGroupSubgroups(grp)) {
                this.removeLinkFromGroup(subgroup, link);
            }
            if (!group.equals(this.getTopLevelGroup()) || canRemoveFromTopLevel) {
                if (trace.getDebugCode("groups")) {
                    trace.out("groups", "DGM.internalRemoveLinkFromGroup(L=" + link.getUniqueID() + ", G=" + group + ")");
                }
                this.internalRemoveLinkFromGroup(group, link);
            }
        }
    }

    @Override
    public void removeLinkFromModel(ExampleTracerLink link) {
        LinkGroup topG = this.getTopLevelGroup();
        ArrayList<LinkGroup> subgroupsToDelete = new ArrayList<LinkGroup>();
        for (LinkGroup subgroup : this.getGroupSubgroups(topG)) {
            if (((DefaultLinkGroup)subgroup).containsLink(link)) {
                subgroupsToDelete.add(subgroup);
            }
            this.removeLinkUpdateGroups((DefaultLinkGroup)subgroup, link);
        }
        if (trace.getDebugCode("groups")) {
            trace.out("groups", "removeLinkFromModel(L=" + link.getUniqueID() + "): top-level containing groups: " + subgroupsToDelete);
        }
        for (LinkGroup subgroup : subgroupsToDelete) {
            if (((DefaultLinkGroup)subgroup).getLinks().size() >= 1) continue;
            this.removeGroupKeepSubgroups(subgroup);
        }
        this.internalRemoveLinkFromGroup(topG, link);
        this.notifyListeners(new GroupChangeEvent());
    }

    private void mergeOnDuplicateGroups(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        Set<LinkGroup> subGroups = group.getSubgroups();
        if (subGroups.size() == 1) {
            DefaultLinkGroup temp = (DefaultLinkGroup)subGroups.iterator().next();
            if (temp.getLinks().size() == group.getLinks().size()) {
                this.removeGroupKeepSubgroups(temp);
                this.mergeOnDuplicateGroups(grp);
            }
        } else {
            for (LinkGroup subgroup : subGroups) {
                this.mergeOnDuplicateGroups(subgroup);
            }
        }
    }

    private void removeLinkUpdateGroups(DefaultLinkGroup group, ExampleTracerLink link) {
        boolean hasLink = group.containsLink(link);
        if (trace.getDebugCode("groups")) {
            trace.outNT("groups", "removeLinkUpdateGroups(G=" + group.getName() + ",L=" + link.getUniqueID() + ") hasLink " + hasLink);
        }
        if (!hasLink) {
            return;
        }
        ArrayList<LinkGroup> subgroupsToDelete = new ArrayList<LinkGroup>();
        for (LinkGroup subgroup : this.getGroupSubgroups(group)) {
            this.removeLinkUpdateGroups((DefaultLinkGroup)subgroup, link);
            if (((DefaultLinkGroup)subgroup).getLinks().size() != 0) continue;
            subgroupsToDelete.add(subgroup);
        }
        for (LinkGroup subgroup : subgroupsToDelete) {
            this.removeGroupKeepSubgroups(subgroup);
        }
        boolean wasRemoved = this.internalRemoveLinkFromGroup(group, link);
        if (!wasRemoved) {
            trace.err("removeLinkUpdateGroups(G=" + group.getName() + ",L=" + link.getUniqueID() + ") link not found on delete");
        }
        if (group.getLinks().size() == 0) {
            this.removeAllGroupSubgroups(group);
        }
    }

    @Override
    public void clear() {
        this.TopLevel = new DefaultLinkGroup("defaultName", true, this.isDefaultReenterable);
        this.notifyListeners(new GroupChangeEvent(7));
    }

    @Override
    public boolean isGroupReenterable(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.isReenterable();
    }

    @Override
    public void setGroupReenterable(LinkGroup grp, boolean isReenterable) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        group.setReenterable(isReenterable);
    }

    @Override
    public boolean isDefaultReenterable() {
        return this.isDefaultReenterable;
    }

    @Override
    public void setDefaultReenterable(boolean isDefaultReenterable) {
        this.isDefaultReenterable = isDefaultReenterable;
    }

    @Override
    public String getTreeText(LinkGroup grp) {
        DefaultLinkGroup group = (DefaultLinkGroup)grp;
        return group.getTreeDisp();
    }

    class GroupIterator
    implements Iterator<LinkGroup> {
        LinkGroup currentGroup;
        Iterator<LinkGroup> currentSubIterator;
        Iterator<LinkGroup> iteratorIterator;

        public GroupIterator(LinkGroup group) {
            this.currentGroup = group;
            this.iteratorIterator = DefaultGroupModel.this.getGroupSubgroups(group).iterator();
            if (this.iteratorIterator.hasNext()) {
                this.currentSubIterator = new GroupIterator(this.iteratorIterator.next());
            }
        }

        @Override
        public boolean hasNext() {
            return this.currentGroup != null;
        }

        @Override
        public LinkGroup next() {
            if (this.currentGroup == null) {
                throw new NoSuchElementException();
            }
            LinkGroup temp = this.currentGroup;
            if (this.currentSubIterator == null) {
                this.currentGroup = null;
            } else if (this.currentSubIterator.hasNext()) {
                this.currentGroup = this.currentSubIterator.next();
            } else if (this.iteratorIterator.hasNext()) {
                this.currentSubIterator = new GroupIterator(this.iteratorIterator.next());
                this.currentGroup = this.currentSubIterator.next();
            } else {
                this.currentGroup = null;
            }
            return temp;
        }

        @Override
        public void remove() {
        }
    }
}

