/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.Dialogs;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Dialogs.AwaitCancel;
import edu.cmu.pact.BehaviorRecorder.Dialogs.ImmovableColumnColumnModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModel;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import edu.cmu.pact.ctat.model.StartStateModel;
import edu.cmu.pact.ctat.view.AbstractCtatWindow;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import pact.CommWidgets.UniversalToolProxy;
import sun.plugin.dom.exception.InvalidStateException;

public class EditComponentStartStateSettingsDialog
extends JDialog
implements ActionListener,
ChangeListener,
PropertyChangeListener,
StartStateModel.Listener {
    public static final String START_STATE_COMPONENT_SETTINGS = "Edit Start State Component Settings";
    protected static final String NO_STUDENT_INTERFACE_CONNECTED = "No Student Interface Connected";
    protected static final String MUST_HAVE_INTERFACE_CONNECTED_TO_USE_FEATURE = "<html>You must have a student interface connected<br/>to this graph panel to use this dialogue.</html>";
    private static final long serialVersionUID = 201401231830L;
    private static final String OMIT_ALL_FROM_GRAPH = "Omit All from Graph";
    private static final String OMIT_ALL_FROM_GRAPH_TOOLTIP = "Discard any existing graph settings and use only settings already in the interface.";
    private static final String RETAIN_ALL_FROM_GRAPH = "Retain All from Graph";
    private static final String RETAIN_ALL_FROM_GRAPH_TOOLTIP = "Retain all existing graph settings, overriding settings already in the interface.";
    private static final String RETAIN_ALL_FROM_INTERFACE = "Retain All from Interface";
    private static final String RETAIN_ALL_FROM_INTERFACE_TOOLTIP = "Copy all settings in the interface into the graph, discarding any existing graph settings.";
    private static final String OMIT_ALL_FROM_INTERFACE = "Omit All from Interface";
    private static final String OMIT_ALL_FROM_INTERFACE_TOOLTIP = "Do not copy or retain any settings from the interface in the graph.";
    private JButton omitAllGraphIDMsgs;
    private JButton retainAllGraphIDMsgs;
    private JButton omitAllInterfaceIDMsgs;
    private JButton retainAllInterfaceIDMsgs;
    private JButton okButton;
    private JButton cancelButton;
    private StartStateModel model;
    private List<StartStateModel.CompareInterfaceDescriptions> cidList;
    private final ProblemModel problemModel;
    private static final int TYPE_COL = 0;
    private static final int MATCH_COL = 1;
    private static final int PM_NAME_COL = 2;
    private static final int SI_NAME_COL = 3;
    private static final String[] columnLabels;
    private static ImageIcon settingsSameIcon;
    private static ImageIcon settingsDifferIcon;
    private static final Border noFocusBorder;
    private InstanceNameCheckBoxRenderer incbRenderer = new InstanceNameCheckBoxRenderer();
    private CIDTableModel cidTableModel;
    private JTable cidTable = null;

    public void sendToInterface(MessageObject msg) {
        if (msg == null) {
            return;
        }
        if (this.problemModel == null) {
            return;
        }
        if (this.problemModel.getController() == null) {
            return;
        }
        this.problemModel.getController().handleMessageUTP(msg);
    }

    public StartStateModel.CompareInterfaceDescriptions updateCBFromCID(int row, int col, JCheckBox cb) {
        StartStateModel.CompareInterfaceDescriptions cid = this.cidList.get(row);
        if (col == 2) {
            cb.setText(cid.getPmCommName());
            if (cid.getAlert() != null) {
                cb.setForeground(Color.red);
            }
            cb.setSelected(cid.getChoice() == StartStateModel.Choice.keepPM);
        } else if (col == 3) {
            cb.setText(cid.getSiCommName());
            if (cid.getAlert() != null) {
                cb.setForeground(Color.red);
            }
            cb.setSelected(cid.getChoice() == StartStateModel.Choice.saveSI);
        } else {
            throw new IllegalArgumentException("Invalid column " + col + " in " + this.getClass().getSimpleName() + ".udpateCBFromCID(); should be " + 2 + " or " + 3);
        }
        return cid;
    }

    private StartStateModel.CompareInterfaceDescriptions updateCID(int row, int col, boolean newState) {
        StartStateModel.Choice previous = null;
        StartStateModel.CompareInterfaceDescriptions cid = this.cidList.get(row);
        if (col == 2) {
            previous = newState ? cid.setChoice(StartStateModel.Choice.keepPM) : cid.setChoice(StartStateModel.Choice.omit);
        } else if (col == 3) {
            previous = newState ? cid.setChoice(StartStateModel.Choice.saveSI) : cid.setChoice(StartStateModel.Choice.omit);
        } else {
            throw new InvalidStateException("Invalid column " + col + " in InstanceNameCheckBox.itemStateChanged(); should be " + 2 + " or " + 3);
        }
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "CCSD.updateCID(" + row + "," + col + "," + newState + ") now " + cid + "; previous choice " + previous.toChar());
        }
        if (previous != cid.getChoice()) {
            int ok = 0;
            if (previous == StartStateModel.Choice.keepPM && ProblemModel.interpolatable(cid.getPmMsg()) && (cid.getChoice() == StartStateModel.Choice.omit || !ProblemModel.interpolatable(cid.getSiMsg()))) {
                String name = cid.getPmCommName() == null ? cid.getSiCommName() : cid.getPmCommName();
                ok = JOptionPane.showConfirmDialog(this.getParent(), "Warning: about to discard settings in " + name + " configured for Mass Production", "Mass Production Warning", 2, 2);
            }
            if (ok != 0) {
                cid.setChoice(previous);
            }
            this.cidTableModel.fireTableCellUpdated(row, col == 2 ? 3 : 2);
        }
        return cid;
    }

    public static void create(final BR_Controller controller, final AbstractCtatWindow activeWindow) {
        if (controller == null) {
            return;
        }
        final UniversalToolProxy utp = controller.getUniversalToolProxy();
        if (utp == null) {
            return;
        }
        Thread interfaceRebooter = new Thread(new Runnable(){

            @Override
            public void run() {
                StartStateModel model = utp.getStartStateModel();
                if (trace.getDebugCode("startstate")) {
                    trace.out("startstate", "CCSD interfaceRebooter: nIntDescFrInt " + model.nInterfaceDescriptionsFromInterface());
                }
                if (model.nInterfaceDescriptionsFromInterface() < 1) {
                    boolean proceed = false;
                    proceed = controller.isStudentInterfaceLocal() ? utp.rebootInterface(new AwaitCancel(Thread.currentThread(), activeWindow)) : utp.getAllInterfaceDescriptions();
                    if (!proceed) {
                        Utils.showExceptionOccuredDialog(null, EditComponentStartStateSettingsDialog.MUST_HAVE_INTERFACE_CONNECTED_TO_USE_FEATURE, EditComponentStartStateSettingsDialog.NO_STUDENT_INTERFACE_CONNECTED);
                        return;
                    }
                }
                if (trace.getDebugCode("startstate")) {
                    trace.printStack("startstate", "***about to display***");
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EditComponentStartStateSettingsDialog ccsd = new EditComponentStartStateSettingsDialog(controller, activeWindow);
                        ccsd.setVisible(true);
                    }
                });
            }
        }, "interfaceRebooter");
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "CCSD.create(): about to start interfaceRebooter");
        }
        interfaceRebooter.start();
    }

    private EditComponentStartStateSettingsDialog(BR_Controller controller, AbstractCtatWindow activeWindow) {
        super((Frame)activeWindow, START_STATE_COMPONENT_SETTINGS);
        Point p = activeWindow.getLocation();
        p.move(p.x + 100, p.y + 100);
        this.setLocation(p);
        controller.addChangeListener(this);
        this.problemModel = controller.getProblemModel();
        this.init(controller.getUniversalToolProxy().getStartStateModel(), "CCSD.<init>");
        this.cidTable = new CIDTable(this.cidTableModel);
        JEditorPane msgLabel = new JEditorPane();
        msgLabel.setFont(new Font("SansSerif", 0, 11));
        msgLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        msgLabel.setBackground(new Color(245, 245, 245));
        msgLabel.setEditable(false);
        msgLabel.setContentType("text/html");
        msgLabel.setText("<html><h3 font-family=\"sans-serif\">Tool for controlling component parameters from graph (.brd) files</h3><p font-family=\"sans-serif\">This display lists components in the student interface and shows whether the graph (.brd file) includes settings for them. The Match column tells whether existing settings in the graph are identical to those in the interface. Check a box to save those settings in the graph; uncheck a box to revert to the original settings in the interface.</p><p>Use this tool when you need to select interface components whose settings may be controlled from the graph. For example, if you want to set the choices in a CommComboBox using Mass Production, you will need to copy the settings for that CommComboBox instance to the graph, where the Mass Production %(variables)% can be replaced in each distinct problem.</p><p>This tool can be useful also when you have changed the student interface and need to revise component settings in a previously-built graph. For example, if you remove a component from the student interface whose settings were controlled in the graph, you can omit those settings from the graph here.</p></html>");
        msgLabel.setCaretPosition(0);
        JScrollPane explPanel = new JScrollPane(msgLabel);
        explPanel.setPreferredSize(new Dimension(600, 200));
        explPanel.setMinimumSize(new Dimension(600, 200));
        this.retainAllGraphIDMsgs = new JButton(RETAIN_ALL_FROM_GRAPH);
        this.retainAllGraphIDMsgs.setToolTipText(RETAIN_ALL_FROM_GRAPH_TOOLTIP);
        this.retainAllGraphIDMsgs.addActionListener(this);
        this.omitAllGraphIDMsgs = new JButton(OMIT_ALL_FROM_GRAPH);
        this.omitAllGraphIDMsgs.setToolTipText(OMIT_ALL_FROM_GRAPH_TOOLTIP);
        this.omitAllGraphIDMsgs.addActionListener(this);
        this.retainAllInterfaceIDMsgs = new JButton(RETAIN_ALL_FROM_INTERFACE);
        this.retainAllInterfaceIDMsgs.setToolTipText(RETAIN_ALL_FROM_INTERFACE_TOOLTIP);
        this.retainAllInterfaceIDMsgs.addActionListener(this);
        this.omitAllInterfaceIDMsgs = new JButton(OMIT_ALL_FROM_INTERFACE);
        this.omitAllInterfaceIDMsgs.setToolTipText(OMIT_ALL_FROM_INTERFACE_TOOLTIP);
        this.omitAllInterfaceIDMsgs.addActionListener(this);
        JPanel doAllButtonPanel = new JPanel(new GridLayout(1, 4));
        doAllButtonPanel.add(this.retainAllGraphIDMsgs);
        doAllButtonPanel.add(this.omitAllGraphIDMsgs);
        doAllButtonPanel.add(this.retainAllInterfaceIDMsgs);
        doAllButtonPanel.add(this.omitAllInterfaceIDMsgs);
        JScrollPane pane = new JScrollPane(this.cidTable);
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setPreferredSize(new Dimension(600, Math.max(this.cidList.size(), 25) * this.cidTable.getRowHeight()));
        tablePanel.setMinimumSize(new Dimension(600, Math.max(this.cidList.size(), 2) * this.cidTable.getRowHeight()));
        tablePanel.add((Component)pane, "Center");
        this.okButton = new JButton("OK");
        this.okButton.setToolTipText("Copy the changes indicated above to the graph and close this dialog.");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Discard any changes made here and close this dialog.");
        this.cancelButton.addActionListener(this);
        JPanel okButtonPanel = new JPanel(new FlowLayout(2));
        okButtonPanel.add(this.okButton);
        okButtonPanel.add(this.cancelButton);
        JPanel topLevelPanel = new JPanel(new BorderLayout());
        topLevelPanel.add((Component)doAllButtonPanel, "North");
        topLevelPanel.add((Component)tablePanel, "Center");
        topLevelPanel.add((Component)okButtonPanel, "South");
        JSplitPane splitPane = new JSplitPane(0, explPanel, topLevelPanel);
        splitPane.setResizeWeight(0.25);
        splitPane.setOpaque(true);
        this.setContentPane(splitPane);
        this.setModalityType(DEFAULT_MODALITY_TYPE);
        this.setDefaultCloseOperation(2);
        this.pack();
    }

    private void init(StartStateModel startStateModel, String caller) {
        this.model = startStateModel;
        this.cidList = this.model.compareInterfaceDescriptionMessages(this.problemModel);
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "CCSD.init() from " + caller + " cidList.size() " + (this.cidList == null ? -1 : this.cidList.size()));
        }
        if (this.cidList == null || this.cidList.size() < 1) {
            Utils.showExceptionOccuredDialog(null, "<html><p>No component settings are available for comparison. You need to have an open graph and a connected student interface.</p></html>", "No component settings");
            this.dispose();
            return;
        }
        this.model.addPropertyChangeListener(this);
        this.cidTableModel = new CIDTableModel();
    }

    @Override
    public void dispose() {
        if (this.problemModel != null && this.problemModel.getController() != null) {
            this.problemModel.getController().removeChangeListener(this);
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.retainAllGraphIDMsgs) {
            this.cidTableModel.retainAllGraphDescriptions();
        } else if (e.getSource() == this.omitAllGraphIDMsgs) {
            this.cidTableModel.omitAllGraphDescriptions();
        } else if (e.getSource() == this.retainAllInterfaceIDMsgs) {
            this.cidTableModel.retainAllInterfaceDescriptions();
        } else if (e.getSource() == this.omitAllInterfaceIDMsgs) {
            this.cidTableModel.omitAllInterfaceDescriptions();
        } else {
            if (e.getSource() == this.okButton) {
                this.model.applyEditsToProblemModel(this.problemModel, this.cidList, "Revised Component Settings");
            }
            if (this.model != null) {
                this.model.removePropertyChangeListener(this);
            }
            this.dispose();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "CCSD.propertyChange(" + evt + ")");
        }
        this.cidList = this.model.compareInterfaceDescriptionMessages(this.problemModel);
        this.cidTableModel.fireTableDataChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        UniversalToolProxy utp = (UniversalToolProxy)e.getSource();
        if (trace.getDebugCode("startstate")) {
            trace.out("startstate", "STATE CHANGED: " + trace.nh(e.getSource()) + " " + (Object)((Object)utp.getStudentInterfaceConnectionStatus()));
        }
        if (utp.getStudentInterfaceConnectionStatus().isConnected()) {
            utp.addStartStateListener(this);
        }
        utp.getAllInterfaceDescriptions();
    }

    @Override
    public void startStateReceived(EventObject e) {
        this.init((StartStateModel)e.getSource(), "CCSD.startStateReceived()");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditComponentStartStateSettingsDialog.this.cidTable.setModel(EditComponentStartStateSettingsDialog.this.cidTableModel);
            }
        });
    }

    static {
        String[] baseNames;
        columnLabels = new String[]{"Type", "Match", "Keep in Graph As Is", "Copy from Interface to Graph"};
        settingsSameIcon = null;
        settingsDifferIcon = null;
        String path = "/" + EditComponentStartStateSettingsDialog.class.getPackage().getName().replace('.', '/');
        for (String baseName : baseNames = new String[]{"checkmark.png", "xmark.png"}) {
            URL url = null;
            ImageIcon icon = null;
            String fileName = path + "/" + baseName;
            try {
                url = EditComponentStartStateSettingsDialog.class.getResource(fileName);
                if (url != null) {
                    icon = new ImageIcon(url);
                }
                if (trace.getDebugCode("startstate")) {
                    trace.out("startstate", "CCSDialog: image \"" + fileName + "\"; url " + url + ", icon " + icon);
                }
                if ("checkmark.png".equals(baseName)) {
                    settingsSameIcon = icon;
                    continue;
                }
                settingsDifferIcon = icon;
            }
            catch (Exception e) {
                trace.errStack("Error loading image \"" + fileName + "\"; url " + url + ", icon " + icon, e);
            }
        }
        noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    }

    class CIDTable
    extends JTable {
        private static final long serialVersionUID = 201402211705L;

        CIDTable(TableModel model) {
            super(model, new ImmovableColumnColumnModel());
            this.setAutoCreateColumnsFromModel(true);
            TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(model);
            sorter.setComparator(0, String.CASE_INSENSITIVE_ORDER);
            sorter.setComparator(1, new MatchComparator());
            sorter.setComparator(2, new CheckBoxComparator(2));
            sorter.setComparator(3, new CheckBoxComparator(3));
            this.setRowSorter(sorter);
            FontMetrics fm = this.getFontMetrics(this.getTableHeader().getFont());
            int matchWidth = fm.stringWidth(model.getColumnName(1)) + 12;
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("CCSD.CIDTable<> matchWidth %d=%d(%s)+2*%d renderer %s", matchWidth, fm.stringWidth(model.getColumnName(1)), model.getColumnName(1), 6, this.getTableHeader().getColumnModel().getColumn(1).getHeaderRenderer()));
            }
            this.getColumnModel().getColumn(1).setPreferredWidth(matchWidth);
            this.getColumnModel().getColumn(1).setMaxWidth(matchWidth);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }

        @Override
        public TableCellRenderer getCellRenderer(int row, int col) {
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("CIDTable.getCellRenderer(%d,%d) toModel(%d,%d)=>cid %s", row, col, EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row), EditComponentStartStateSettingsDialog.this.cidTable.convertColumnIndexToModel(col), EditComponentStartStateSettingsDialog.this.cidList.get(EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row))));
            }
            row = EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row);
            col = EditComponentStartStateSettingsDialog.this.cidTable.convertColumnIndexToModel(col);
            String instanceName = null;
            if (col == 2) {
                instanceName = ((StartStateModel.CompareInterfaceDescriptions)EditComponentStartStateSettingsDialog.this.cidList.get(row)).getPmCommName();
            } else if (col == 3) {
                instanceName = ((StartStateModel.CompareInterfaceDescriptions)EditComponentStartStateSettingsDialog.this.cidList.get(row)).getSiCommName();
            }
            if (instanceName == null || instanceName.length() < 1) {
                return super.getCellRenderer(row, col);
            }
            return EditComponentStartStateSettingsDialog.this.incbRenderer;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("CIDTable.getCellEditor(%d,%d) toModel(%d,%d)=>cid %s", row, col, EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row), EditComponentStartStateSettingsDialog.this.cidTable.convertColumnIndexToModel(col), EditComponentStartStateSettingsDialog.this.cidList.get(EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row))));
            }
            row = EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row);
            col = EditComponentStartStateSettingsDialog.this.cidTable.convertColumnIndexToModel(col);
            String instanceName = null;
            if (col == 2) {
                instanceName = ((StartStateModel.CompareInterfaceDescriptions)EditComponentStartStateSettingsDialog.this.cidList.get(row)).getPmCommName();
            } else if (col == 3) {
                instanceName = ((StartStateModel.CompareInterfaceDescriptions)EditComponentStartStateSettingsDialog.this.cidList.get(row)).getSiCommName();
            }
            if (instanceName == null || instanceName.length() < 1) {
                return super.getCellEditor(row, col);
            }
            return new InstanceNameCheckBox(row, col);
        }
    }

    class MatchComparator
    implements Comparator<ImageIcon> {
        MatchComparator() {
        }

        @Override
        public int compare(ImageIcon o1, ImageIcon o2) {
            if (o1 == o2) {
                return 0;
            }
            return o1 == settingsSameIcon ? 1 : -1;
        }
    }

    class CheckBoxComparator
    implements Comparator<Object> {
        private final int column;

        CheckBoxComparator(int column) {
            this.column = column;
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (trace.getDebugCode("startstatell")) {
                trace.out("startstatell", "CheckBoxComparator.compare(" + trace.nh(o1) + ", " + trace.nh(o2) + ")");
            }
            if (o1 instanceof JCheckBox && o2 instanceof JCheckBox) {
                return String.CASE_INSENSITIVE_ORDER.compare(((JCheckBox)o1).getText(), ((JCheckBox)o2).getText());
            }
            return String.CASE_INSENSITIVE_ORDER.compare(o1.toString(), o2.toString());
        }
    }

    class InstanceNameCheckBox
    extends DefaultCellEditor
    implements TableCellEditor,
    ItemListener {
        private static final long serialVersionUID = 201401291905L;
        private final int row;
        private final int col;

        public InstanceNameCheckBox(int row, int col) {
            super(new JCheckBox());
            JCheckBox cb = (JCheckBox)this.getComponent();
            this.row = row;
            this.col = col;
            cb.addItemListener(this);
        }

        @Override
        public void itemStateChanged(ItemEvent evt) {
            boolean selected = evt.getStateChange() == 1;
            StartStateModel.CompareInterfaceDescriptions cid = EditComponentStartStateSettingsDialog.this.updateCID(this.row, this.col, selected);
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("CCSD.InstNameCB.itemStateChanged(%s,%s) at (%d,%d): cid[%d] now %s", trace.nh(evt.getItem()), selected ? "SELECTED" : "DESELECTED", this.row, this.col, this.row, cid));
            }
            if (cid.getChoice() == StartStateModel.Choice.keepPM) {
                EditComponentStartStateSettingsDialog.this.sendToInterface(cid.getPmMsg());
            } else {
                EditComponentStartStateSettingsDialog.this.sendToInterface(cid.getSiMsg());
            }
            this.fireEditingStopped();
        }

        @Override
        public Object getCellEditorValue() {
            JCheckBox cb = null;
            StartStateModel.CompareInterfaceDescriptions cid = null;
            String result = null;
            Component c = this.getComponent();
            if (c instanceof JCheckBox) {
                cb = (JCheckBox)c;
                cid = EditComponentStartStateSettingsDialog.this.updateCBFromCID(this.row, this.col, cb);
                result = cb.getText();
            }
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("CCSD.INCB.getCellEditorValue() at (%d,%d) cid %s  returning cb.isSelected() %s, component %s", this.row, this.col, cid, result, trace.nh(c)));
            }
            return result;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
            JCheckBox cb = null;
            StartStateModel.CompareInterfaceDescriptions cid = null;
            Component c = super.getTableCellEditorComponent(table, value, isSelected, row, col);
            int modelRow = EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row);
            if (c != this.getComponent()) {
                throw new IllegalArgumentException("CCSD.INCB.getTableCellEditorComponent()  component mismatch: c " + trace.nh(c) + " vs. getComponent() " + trace.nh(this.getComponent()));
            }
            if (modelRow != this.row) {
                throw new IllegalArgumentException("CCSD.INCB.getTableCellEditorComponent()  row mismatch: convert(" + row + ")=" + modelRow + " vs. this.row " + this.row);
            }
            if (col != this.col) {
                throw new IllegalArgumentException("CCSD.INCB.getTableCellEditorComponent()  col mismatch: col " + col + " vs. this.col " + this.col);
            }
            if (c instanceof JCheckBox) {
                cb = (JCheckBox)c;
                cid = EditComponentStartStateSettingsDialog.this.updateCBFromCID(modelRow, col, cb);
            }
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", "CCSD.INCB.getTableCellEditorComponent() value " + value + ", isSelected " + isSelected + " at (" + row + "," + col + "); cid[" + modelRow + "] " + cid + " returning cb.isSelected() " + (cb == null ? null : Boolean.valueOf(cb.isSelected())) + ", c " + trace.nh(c));
            }
            return c;
        }

        private JCheckBox cidToCheckBox(StartStateModel.CompareInterfaceDescriptions cid, int col) {
            boolean cbState;
            String instanceName;
            if (col == 2) {
                instanceName = cid.getPmCommName();
                cbState = cid.getChoice() == StartStateModel.Choice.keepPM;
            } else if (col == 3) {
                instanceName = cid.getSiCommName();
                cbState = cid.getChoice() == StartStateModel.Choice.saveSI;
            } else {
                throw new IllegalArgumentException("Invalid column " + col + " to InstanceNameCheckBox; should be " + 2 + " or " + 3);
            }
            if (instanceName == null || instanceName.length() < 1) {
                return null;
            }
            return new JCheckBox(instanceName, cbState);
        }
    }

    class InstanceNameCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 201401301030L;

        public InstanceNameCheckBoxRenderer() {
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            StartStateModel.CompareInterfaceDescriptions cid = EditComponentStartStateSettingsDialog.this.updateCBFromCID(EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row), col, this);
            this.setToolTipText(null);
            if (cid.getAlert() != null) {
                this.setToolTipText(cid.getAlert());
            }
            if (trace.getDebugCode("startstate")) {
                trace.out("startstate", String.format("CCSD.InstNameCBRend.getTableCellRendererComponent() value %s, isSelected %b, hasFocus %b at (%d,%d): cid[%d] now %s; cb.isSelected %b", value, isSelected, hasFocus, row, col, EditComponentStartStateSettingsDialog.this.cidTable.convertRowIndexToModel(row), cid, this.isSelected()));
            }
            if (hasFocus) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(noFocusBorder);
            }
            return this;
        }
    }

    class CIDTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 201401281200L;

        CIDTableModel() {
        }

        @Override
        public String getColumnName(int col) {
            return columnLabels[col];
        }

        @Override
        public int getRowCount() {
            return EditComponentStartStateSettingsDialog.this.cidList.size();
        }

        @Override
        public int getColumnCount() {
            return columnLabels.length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2 || col == 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            StartStateModel.CompareInterfaceDescriptions cid = (StartStateModel.CompareInterfaceDescriptions)EditComponentStartStateSettingsDialog.this.cidList.get(row);
            switch (col) {
                case 0: {
                    return cid.getWidgetType();
                }
                case 1: {
                    if ("differ".equals(cid.getMatch())) {
                        return settingsDifferIcon;
                    }
                    if ("same".equals(cid.getMatch())) {
                        return settingsSameIcon;
                    }
                    return null;
                }
                case 2: {
                    if (cid.getPmCommName() == null || cid.getPmCommName().length() < 1) {
                        return null;
                    }
                    return cid.getPmCommName();
                }
                case 3: {
                    if (cid.getSiCommName() == null || cid.getSiCommName().length() < 1) {
                        return null;
                    }
                    return cid.getSiCommName();
                }
            }
            throw new IllegalArgumentException("Invalid column " + col + " to CIDTableModel.getValueAt(); should be in range 0-" + (this.getColumnCount() - 1));
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return ImageIcon.class;
                }
                case 2: {
                    return String.class;
                }
                case 3: {
                    return String.class;
                }
            }
            throw new IllegalArgumentException("Invalid column " + col + " to CIDTableModel.getColumnClass(); should be in range 0-" + (this.getColumnCount() - 1));
        }

        public void retainAllGraphDescriptions() {
            int nChanged = 0;
            for (StartStateModel.CompareInterfaceDescriptions cid : EditComponentStartStateSettingsDialog.this.cidList) {
                if (cid.getPmCommName() == null || cid.getPmCommName().length() <= 0) continue;
                cid.setChoice(StartStateModel.Choice.keepPM);
                ++nChanged;
            }
            if (nChanged > 0) {
                this.fireTableDataChanged();
            }
        }

        public void omitAllGraphDescriptions() {
            int nChanged = 0;
            for (StartStateModel.CompareInterfaceDescriptions cid : EditComponentStartStateSettingsDialog.this.cidList) {
                if (cid.getChoice() != StartStateModel.Choice.keepPM) continue;
                cid.setChoice(StartStateModel.Choice.omit);
                ++nChanged;
            }
            if (nChanged > 0) {
                this.fireTableDataChanged();
            }
        }

        public void retainAllInterfaceDescriptions() {
            int nChanged = 0;
            for (StartStateModel.CompareInterfaceDescriptions cid : EditComponentStartStateSettingsDialog.this.cidList) {
                if (cid.getSiCommName() == null || cid.getSiCommName().length() <= 0) continue;
                cid.setChoice(StartStateModel.Choice.saveSI);
                ++nChanged;
            }
            if (nChanged > 0) {
                this.fireTableDataChanged();
            }
        }

        public void omitAllInterfaceDescriptions() {
            int nChanged = 0;
            for (StartStateModel.CompareInterfaceDescriptions cid : EditComponentStartStateSettingsDialog.this.cidList) {
                if (cid.getChoice() != StartStateModel.Choice.saveSI) continue;
                cid.setChoice(StartStateModel.Choice.omit);
                ++nChanged;
            }
            if (nChanged > 0) {
                this.fireTableDataChanged();
            }
        }
    }
}

