/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.monitor;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.collections.StoredSortedMap;
import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDB;
import edu.cmu.hcii.ctat.monitor.CTATBerkeleyDBInstance;
import edu.cmu.hcii.ctat.monitor.CTATClientEntry;
import edu.cmu.hcii.ctat.monitor.CTATMessageReceiver;
import edu.cmu.hcii.ctat.monitor.CTATStreamedSocket;
import edu.cmu.hcii.ctat.monitor.CTATTSMemory;
import edu.cmu.hcii.ctat.monitor.CTATTSSession;
import edu.cmu.hcii.ctat.monitor.CTATXMLBase;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import org.joda.time.DateTime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CTATTSEntry
extends CTATClientEntry
implements CTATMessageReceiver {
    private long memtotal = 0L;
    private long memmax = 0L;
    private long memfree = 0L;
    private int sCount = 0;
    private ArrayList<CTATTSSession> sessions = null;
    private String releaseName = "";
    private String version = "";
    private String buildDate = "";
    private CTATStreamedSocket checker = null;
    private Boolean shouldUpdate = false;
    private Boolean updating = false;
    private CTATBerkeleyDBInstance sessionDB = null;
    private CTATBerkeleyDBInstance memoryDB = null;
    private CTATBerkeleyDBInstance dailySessionDB = null;
    private CTATBerkeleyDBInstance hourlySessionDB = null;
    private CTATBerkeleyDBInstance weeklySessionDB = null;
    private CTATBerkeleyDBInstance monthlySessionDB = null;
    private CTATBerkeleyDBInstance hourlyMemoryDB = null;
    private CTATBerkeleyDBInstance dailyMemoryDB = null;
    private CTATBerkeleyDBInstance weeklyMemoryDB = null;
    private CTATBerkeleyDBInstance monthlyMemoryDB = null;
    private StoredSortedMap<Long, CTATTSSession> sessionMap = null;
    private StoredSortedMap<Long, CTATTSMemory> memoryMap = null;
    private StoredSortedMap<Long, CTATTSSession> hourlySessionMap = null;
    private StoredSortedMap<Long, CTATTSSession> dailySessionMap = null;
    private StoredSortedMap<Long, CTATTSSession> weeklySessionMap = null;
    private StoredSortedMap<Long, CTATTSSession> monthlySessionMap = null;
    private StoredSortedMap<Long, CTATTSMemory> hourlyMemoryMap = null;
    private StoredSortedMap<Long, CTATTSMemory> dailyMemoryMap = null;
    private StoredSortedMap<Long, CTATTSMemory> weeklyMemoryMap = null;
    private StoredSortedMap<Long, CTATTSMemory> monthlyMemoryMap = null;
    Long hourStart = 0L;
    Long hourEnd = 0L;
    Long dayStart = 0L;
    Long dayEnd = 0L;
    Long weekStart = 0L;
    Long weekEnd = 0L;
    Long monthStart = 0L;
    Long monthEnd = 0L;
    private SortedMap<Long, CTATTSSession> sessionMapRanged = null;
    private SortedMap<Long, CTATTSMemory> memoryMapRanged = null;
    private Object[] sessionObjectMap = null;
    private Object[] memoryObjectMap = null;

    public CTATTSEntry() {
        this.setClassName("CTATTSEntry");
        this.debug("CTATTSEntry ()");
        this.setClientType("tutoringservice");
        this.setPort(1503);
        this.setAccess("HTTP");
        this.sessions = new ArrayList();
        DateTime currentTime = new DateTime();
        int year = currentTime.getYear();
        int month = currentTime.getMonthOfYear();
        int day = currentTime.getDayOfMonth();
        int hour = currentTime.getHourOfDay();
        DateTime hourTime = new DateTime(year, month, day, hour, 0, 0);
        this.hourStart = hourTime.toInstant().getMillis();
        this.hourEnd = hourTime.plusHours(1).getMillis();
        DateTime dayTime = new DateTime(year, month, day, 0, 0, 0);
        this.dayStart = dayTime.getMillis();
        this.dayEnd = dayTime.plusDays(1).getMillis();
        DateTime weekTime = new DateTime(year, month, day, 0, 0, 0);
        this.weekStart = weekTime.getMillis();
        this.weekEnd = weekTime.plusWeeks(1).getMillis();
        DateTime monthTime = new DateTime(year, month, 1, 0, 0, 0);
        this.monthStart = monthTime.getMillis();
        this.monthEnd = monthTime.plusMonths(1).getMillis();
    }

    private void setupDB() {
        LongBinding keyBinding;
        this.debug("setupDB ()");
        CTATBerkeleyDB dbDriver = this.getDbDriver();
        if (dbDriver == null) {
            this.debug("No database driver available, chances are this class is used purely for administrative purposes");
            return;
        }
        if (this.sessionDB == null) {
            try {
                this.sessionDB = dbDriver.accessDB(this.getGuid() + "-TSSession/All");
                this.hourlySessionDB = dbDriver.accessDB(this.getGuid() + "-TSSession/Hour");
                this.dailySessionDB = dbDriver.accessDB(this.getGuid() + "-TSSession/Day");
                this.weeklySessionDB = dbDriver.accessDB(this.getGuid() + "-TSSession/Week");
                this.monthlySessionDB = dbDriver.accessDB(this.getGuid() + "-TSSession/Month");
            }
            catch (Exception e) {
                this.debug("Error: unable to access or create db: " + this.getGuid() + "-TSSession");
                e.printStackTrace();
            }
            if (this.sessionDB != null) {
                keyBinding = new LongBinding();
                SerialBinding sessionBinding = new SerialBinding((ClassCatalog)dbDriver.getClassCatalog(), CTATTSSession.class);
                this.sessionMap = new StoredSortedMap(this.sessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.hourlySessionMap = new StoredSortedMap(this.hourlySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.dailySessionMap = new StoredSortedMap(this.dailySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.weeklySessionMap = new StoredSortedMap(this.weeklySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
                this.monthlySessionMap = new StoredSortedMap(this.monthlySessionDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)sessionBinding, true);
            }
        }
        if (this.memoryDB == null) {
            try {
                this.memoryDB = dbDriver.accessDB(this.getGuid() + "-TSSession/All");
                this.hourlyMemoryDB = dbDriver.accessDB(this.getGuid() + "-TSMemory/Hour");
                this.dailyMemoryDB = dbDriver.accessDB(this.getGuid() + "-TSMemory/Day");
                this.weeklyMemoryDB = dbDriver.accessDB(this.getGuid() + "-TSMemory/Week");
                this.monthlyMemoryDB = dbDriver.accessDB(this.getGuid() + "-TSMemory/Month");
            }
            catch (Exception e) {
                this.debug("Error: unable to access or create db: " + this.getGuid() + "-TSMemory");
                e.printStackTrace();
            }
            if (this.memoryDB != null) {
                keyBinding = new LongBinding();
                SerialBinding memoryBinding = new SerialBinding((ClassCatalog)dbDriver.getClassCatalog(), CTATTSMemory.class);
                this.memoryMap = new StoredSortedMap(this.memoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.hourlyMemoryMap = new StoredSortedMap(this.hourlyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.dailyMemoryMap = new StoredSortedMap(this.dailyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.weeklyMemoryMap = new StoredSortedMap(this.weeklyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
                this.monthlyMemoryMap = new StoredSortedMap(this.monthlyMemoryDB.getDB(), (EntryBinding)keyBinding, (EntryBinding)memoryBinding, true);
            }
        }
    }

    public String getSessionBlock(Long startDate, Long endDate) {
        this.debug("getSessionBlock ()");
        try {
            this.sessionMapRanged = this.sessionMap.subMap((Object)startDate, (Object)endDate);
        }
        catch (IllegalArgumentException e) {
            this.debug("One of the range indexes is out of bounds");
            return "Out of Range";
        }
        StringBuffer formatted = new StringBuffer();
        for (Map.Entry<Long, CTATTSSession> entry : this.sessionMapRanged.entrySet()) {
            if (entry != null) {
                formatted.append(entry.getKey().toString() + "," + entry.getValue().toCSV() + "\n");
                continue;
            }
            this.debug("Error getting session from map");
        }
        return formatted.toString();
    }

    public String getMemoryBlock(Long startDate, Long endDate) {
        this.debug("getMemoryBlock ()");
        try {
            this.memoryMapRanged = this.memoryMap.subMap((Object)startDate, (Object)endDate);
        }
        catch (IllegalArgumentException e) {
            this.debug("One of the range indexes is out of bounds");
            return "Out of Range";
        }
        StringBuffer formatted = new StringBuffer();
        for (Map.Entry<Long, CTATTSMemory> entry : this.memoryMapRanged.entrySet()) {
            if (entry != null) {
                formatted.append(entry.getKey().toString() + "," + entry.getValue().toCSV() + "\n");
                continue;
            }
            this.debug("Error getting session from map");
        }
        return formatted.toString();
    }

    public Boolean isUpdating() {
        return this.updating;
    }

    public String getReleaseName() {
        return this.releaseName;
    }

    public void setReleaseName(String releaseName) {
        this.releaseName = releaseName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBuildDate() {
        return this.buildDate;
    }

    public void setBuildDate(String buildDate) {
        this.buildDate = buildDate;
    }

    @Override
    public void setStatus(String status) {
        super.setStatus(status);
        if (this.getShouldLog().booleanValue()) {
            StringBuffer formatter = new StringBuffer();
            Date stamp = new Date();
            Integer currentTimeStamp = (int)stamp.getTime();
            formatter.append(String.format("%d", stamp.getTime()));
            formatter.append(",");
            formatter.append(status);
            formatter.append(",");
            formatter.append(String.format("%d", currentTimeStamp - this.getLastTimestamp()));
            this.setLastTimestamp(currentTimeStamp);
            if (this.logger != null) {
                this.logger.addLine(formatter.toString());
            }
        }
        if (!status.toLowerCase().equals("ok") && !status.toLowerCase().equals("up")) {
            this.debug("Removing all sessions ..");
            this.setsCount(0);
            this.sessions.clear();
        } else {
            this.resetReport();
        }
    }

    @Override
    public Boolean checkService() {
        this.debug("checkService ()");
        Boolean prevUpdate = this.shouldUpdate;
        this.debug("prevUpdate is " + prevUpdate);
        if (this.checker == null) {
            this.debug("checker is null");
            this.checker = new CTATStreamedSocket();
        }
        this.checker.sendAndKeepOpen(this.getHostname(), this.getPort(), "<service cmd=\"all\" keepalive=\"true\" />", this);
        this.shouldUpdate = false;
        return prevUpdate;
    }

    @Override
    public void handleIncomingData(String text) {
        this.updating = true;
        this.debug("handleIncomingData ()");
        String oldStatus = this.getStatus();
        this.resetReport();
        this.shouldUpdate = true;
        if (text == null) {
            if (!oldStatus.equals("DOWN")) {
                this.setStatus("DOWN");
            }
            if (!oldStatus.equals(this.getStatus())) {
                this.appendReport("Unable to receive status from server, marking service tutoring service at " + this.getHostname() + " as down");
            }
            this.updating = false;
            return;
        }
        if (text.isEmpty() || text.equals("")) {
            if (!oldStatus.equals("DOWN")) {
                this.setStatus("DOWN");
            }
            if (!oldStatus.equals(this.getStatus())) {
                this.appendReport("Unable to receive status from server, marking service tutoring service at " + this.getHostname() + " as down");
            }
            this.updating = false;
            return;
        }
        this.debug("Received " + text.length() + " characters");
        this.debug(text);
        CTATXMLBase helper = new CTATXMLBase();
        Document document = helper.loadXMLFromString(text);
        if (document != null) {
            this.debug("ts document is not null");
            this.debug("oldstatus is: " + oldStatus);
            if (!oldStatus.equals("UP")) {
                this.setStatus("UP");
            }
            Element root = document.getDocumentElement();
            this.fromTSXML(root);
            this.setUpdated(true);
        }
        this.updating = false;
    }

    @Override
    public void handleConnectionClosed() {
        this.debug("handleConnectionClose ()");
        if (!this.getStatus().equals("DOWN")) {
            this.setStatus("DOWN");
        }
        this.appendReport("Connection closed by foreign host for: " + this.getHostname());
        this.shouldUpdate = true;
    }

    @Override
    public void startLogging() {
        this.debug("startLogging ()");
        if (this.getShouldLog().booleanValue()) {
            this.logger.setFileID("TS-" + this.getGuid() + "-" + this.getHostname());
        } else {
            this.debug("Logging is disabled for this entry");
        }
    }

    public int getsCount() {
        return this.sCount;
    }

    public void setsCount(int aCount) {
        if (this.sCount != aCount) {
            this.cleanup();
        }
        this.sCount = aCount;
    }

    public long getMemtotal() {
        return this.memtotal;
    }

    public void setMemtotal(long memtotal) {
        this.memtotal = memtotal;
    }

    public long getMemmax() {
        return this.memmax;
    }

    public void setMemmax(long memmax) {
        this.memmax = memmax;
    }

    public long getMemfree() {
        return this.memfree;
    }

    public void debugStatus() {
        this.debug("Sessions reported: " + this.getsCount() + ", stored: " + this.sessions.size() + " Mem Total: " + this.getMemtotal() + " Mem Free: " + this.getMemfree() + " Mem Max: " + this.getMemmax());
    }

    public void setMemfree(long memfree) {
        this.memfree = memfree;
    }

    private void addSession(CTATTSSession aSession) {
        this.debug("addSession (CTATTSSession)");
        this.sessions.add(aSession);
    }

    private CTATTSSession getSession(String aSession) {
        this.debug("getSession (" + aSession + ") -> " + this.sessions.size());
        for (int i = 0; i < this.sessions.size(); ++i) {
            CTATTSSession test = this.sessions.get(i);
            this.debug("Comparing " + test.getInstanceName() + " to " + aSession);
            if (!test.getInstanceName().equals(aSession)) continue;
            this.debug("Found");
            return test;
        }
        return null;
    }

    private void removeSession(String aSession) {
        this.debug("removeSession (" + aSession + ")");
        for (int i = 0; i < this.sessions.size(); ++i) {
            CTATTSSession test = this.sessions.get(i);
            if (!test.getInstanceName().equals(aSession)) continue;
            this.debug("Removing: " + test.getInstanceName());
            this.sessions.remove(test);
        }
    }

    @Override
    public String toXML() {
        this.debug("toXML ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toXMLOpen());
        buffer.append("<version releaseName=\"" + this.getReleaseName() + "\" versionNumber=\"" + this.getVersion() + "\" buildDate=\"" + this.getBuildDate() + "\" ></version>");
        buffer.append("<sessions>");
        for (int i = 0; i < this.sessions.size(); ++i) {
            CTATTSSession sess = this.sessions.get(i);
            buffer.append("<session guid=\"" + sess.getInstanceName() + "\" lastMessage=\"" + sess.getLastMessage() + "\" totalTransactionMs=\"" + sess.getTotalTransactionMs() + "\" transactionCount=\"" + sess.getTransactionCount() + "\" firstTransactionTime=\"" + sess.getFirstTransactionTime() + "\" longestTransactionMs=\"" + sess.getLongestTransactionMs() + "\" longestTransactionStartTime=\"" + sess.getLongestTransactionStartTime() + "\" />");
        }
        buffer.append("</sessions>");
        buffer.append("<memory total=\"" + this.getMemtotal() + "\" max=\"" + this.getMemmax() + "\" free=\"" + this.getMemfree() + "\" />");
        buffer.append(this.toXMLClose());
        return buffer.toString();
    }

    @Override
    public String toXMLUpdated() {
        this.debug("toXMLUpdated ()");
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.toXMLOpen());
        buffer.append("<version releaseName=\"" + this.getReleaseName() + "\" versionNumber=\"" + this.getVersion() + "\" buildDate=\"" + this.getBuildDate() + "\" ></version>");
        buffer.append("<sessions>");
        for (int i = 0; i < this.sessions.size(); ++i) {
            CTATTSSession sess = this.sessions.get(i);
            buffer.append("<session guid=\"" + sess.getInstanceName() + "\" lastMessage=\"" + sess.getLastMessage() + "\" totalTransactionMs=\"" + sess.getTotalTransactionMs() + "\" transactionCount=\"" + sess.getTransactionCount() + "\" firstTransactionTime=\"" + sess.getFirstTransactionTime() + "\" longestTransactionMs=\"" + sess.getLongestTransactionMs() + "\" longestTransactionStartTime=\"" + sess.getLongestTransactionStartTime() + "\" />");
        }
        buffer.append("</sessions>");
        buffer.append("<memory total=\"" + this.getMemtotal() + "\" max=\"" + this.getMemmax() + "\" free=\"" + this.getMemfree() + "\" />");
        buffer.append(this.toXMLClose());
        return buffer.toString();
    }

    public Boolean fromTSXML(Element root) {
        this.debug("fromTSXML ()");
        if (root.getNodeName().equals("service")) {
            NodeList children = root.getChildNodes();
            if (children == null) {
                this.debug("Internal error: children list is null");
                return false;
            }
            if (children.getLength() > 0) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node node = children.item(i);
                    if (node.getNodeType() != 1) continue;
                    Element transformer = (Element)node;
                    if (node.getNodeName().equals("version")) {
                        this.setReleaseName(transformer.getAttribute("releaseName"));
                        this.setVersion(transformer.getAttribute("versionNumber"));
                        this.setBuildDate(transformer.getAttribute("buildDate"));
                    }
                    if (node.getNodeName().equals("memory")) {
                        this.setMemtotal(Long.parseLong(transformer.getAttribute("total")));
                        this.setMemmax(Long.parseLong(transformer.getAttribute("max")));
                        this.setMemfree(Long.parseLong(transformer.getAttribute("free")));
                    }
                    if (!node.getNodeName().equals("sessions")) continue;
                    this.debug("Found sessions node");
                    this.makeAllInactive();
                    NodeList sess = node.getChildNodes();
                    if (sess == null) continue;
                    for (int j = 0; j < sess.getLength(); ++j) {
                        Node sessNode = sess.item(j);
                        if (sessNode.getNodeType() != 1) continue;
                        Element sessEntry = (Element)sessNode;
                        if (sessEntry.getNodeName().equals("session")) {
                            CTATTSSession aSession = this.createSessionInfo(sessEntry.getAttribute("guid"), sessEntry.getAttribute("lastMessage"), sessEntry.getAttribute("result"), sessEntry.getAttribute("totalTransactionMs"), sessEntry.getAttribute("transactionCount"), sessEntry.getAttribute("firstTransactionTime"), sessEntry.getAttribute("longestTransactionMs"), sessEntry.getAttribute("longestTransactionStartTime"), sessEntry.getAttribute("diskLogEntries"), sessEntry.getAttribute("forwardLogEntries"), sessEntry.getAttribute("diskLogErrors"), sessEntry.getAttribute("forwardLogErrors"));
                            this.logState(aSession, this.getMemtotal(), this.getMemmax(), this.getMemfree());
                            this.removeSession(aSession.getInstanceName());
                            aSession.setUpdated(true);
                            this.addSession(aSession);
                            continue;
                        }
                        this.debug("Error: element does not represent a session: " + sessEntry.toString());
                    }
                }
            }
        } else {
            this.debug("Properties tag not found in node, instead got: " + root.getNodeName());
            return false;
        }
        return true;
    }

    private CTATTSSession createSessionInfo(String aSession, String lastMessage, String result, String totalTransactionMs, String transactionCount, String firstTransactionTime, String longestTransactionMs, String longestTransactionStartTime, String diskLogEntries, String forwardLogEntries, String diskLogErrors, String forwardLogErrors) {
        this.debug("setSessionInfo (" + aSession + "," + lastMessage + ",...)");
        CTATTSSession test = new CTATTSSession();
        this.debug("Setting basic session data ..");
        test.setInstanceName(aSession);
        test.setActive(true);
        test.setLastMessage(lastMessage);
        test.setResult(result);
        test.setTotalTransactionMs(Long.parseLong(totalTransactionMs));
        test.setTransactionCount(Long.parseLong(transactionCount));
        test.setFirstTransactionTime(Long.parseLong(firstTransactionTime));
        test.setLongestTransactionMs(Long.parseLong(longestTransactionMs));
        test.setLongestTransactionStartTime(Long.parseLong(longestTransactionStartTime));
        this.debug("Setting extended session data ..");
        test.setDiskLogEntries(Long.parseLong(diskLogEntries));
        test.setForwardLogEntries(Long.parseLong(forwardLogEntries));
        test.setDiskLogErrors(Long.parseLong(diskLogErrors));
        test.setForwardLogErrors(Long.parseLong(forwardLogErrors));
        return test;
    }

    private void logState(CTATTSSession aSession, long aTotal, long aMax, long aFree) {
        this.debug("logState ()");
        if (!this.getShouldLog().booleanValue()) {
            return;
        }
        if (!aSession.getUpdated().booleanValue()) {
            return;
        }
        if (this.logger == null) {
            this.debug("Internal error: no logger available!");
            return;
        }
        CTATTSSession prevSession = this.getSession(aSession.getInstanceName());
        if (prevSession != null) {
            this.debug("We have a previous session, checking ...");
            aSession.setActive(prevSession.getActive());
            if (prevSession.getInstanceName().equals(aSession.getInstanceName()) && prevSession.getTransactionCount().equals(aSession.getTransactionCount()) && prevSession.getDiskLogEntries().equals(aSession.getDiskLogEntries()) && prevSession.getForwardLogEntries().equals(aSession.getForwardLogEntries()) && prevSession.getDiskLogErrors().equals(aSession.getDiskLogErrors()) && prevSession.getForwardLogErrors().equals(aSession.getForwardLogErrors())) {
                this.debug("No important changes detected");
                prevSession.addrepeats(1);
                return;
            }
            this.debug("Previous session is different, logging ...");
        } else {
            this.debug("No previous session found for: " + aSession.getInstanceName());
        }
        StringBuffer tabber = new StringBuffer();
        tabber.append(aSession.getInstanceName());
        tabber.append("\t");
        tabber.append(aSession.getLastMessage());
        tabber.append("\t");
        tabber.append(aSession.getTotalTransactionMs());
        tabber.append("\t");
        tabber.append(aSession.getTransactionCount());
        tabber.append("\t");
        tabber.append(aSession.getFirstTransactionTime());
        tabber.append("\t");
        tabber.append(aSession.getLongestTransactionMs());
        tabber.append("\t");
        tabber.append(aSession.getLongestTransactionStartTime());
        tabber.append("\t");
        tabber.append(aSession.getDiskLogEntries());
        tabber.append("\t");
        tabber.append(aSession.getForwardLogEntries());
        tabber.append("\t");
        tabber.append(aSession.getDiskLogErrors());
        tabber.append("\t");
        tabber.append(aSession.getForwardLogErrors());
        tabber.append("\t");
        tabber.append(String.format("%d", aTotal));
        tabber.append("\t");
        tabber.append(String.format("%d", aMax));
        tabber.append("\t");
        tabber.append(String.format("%d", aFree));
        this.logger.addLine(tabber.toString());
        Date generator = new Date();
        long time = generator.getTime();
        this.setupDB();
        if (this.sessionDB != null) {
            this.sessionMap.put((Object)time, (Object)aSession);
        }
        CTATTSMemory memCompactor = new CTATTSMemory();
        memCompactor.setMemUsed(aTotal - aFree);
        memCompactor.setMemTotal(aTotal);
        memCompactor.setMemMax(aMax);
        if (this.memoryDB != null) {
            this.memoryMap.put((Object)time, (Object)memCompactor);
        }
        this.checkResolutions(time);
        aSession.setUpdated(false);
    }

    private void checkResolutions(long time) {
        this.debug("checkResolutions(" + time + ")");
        if (time >= this.hourEnd) {
            this.debug("the difference is: " + (this.hourStart - this.hourEnd));
            this.hourlyMemoryMap.put((Object)this.hourStart, (Object)this.avgMemory(this.memoryMap.subMap((Object)this.hourStart, (Object)this.hourEnd)));
            this.hourlySessionMap.put((Object)this.hourStart, (Object)this.avgSession(this.sessionMap.subMap((Object)this.hourStart, (Object)this.hourEnd)));
            this.hourStart = this.hourEnd;
            DateTime dtHourEnd = new DateTime((Object)this.hourEnd);
            this.hourEnd = dtHourEnd.plusHours(1).toInstant().getMillis();
        }
        if (time >= this.dayEnd) {
            this.dailyMemoryMap.put((Object)this.dayStart, (Object)this.avgMemory(this.hourlyMemoryMap.subMap((Object)this.dayStart, (Object)this.dayEnd)));
            this.dailySessionMap.put((Object)this.dayStart, (Object)this.avgSession(this.hourlySessionMap.subMap((Object)this.dayStart, (Object)this.dayEnd)));
            this.hourlyMemoryMap.put((Object)this.hourStart, (Object)this.avgMemory(this.memoryMap.subMap((Object)this.hourStart, (Object)this.hourEnd)));
            this.dayStart = this.dayEnd;
            DateTime dtDayEnd = new DateTime((Object)this.dayEnd);
            this.dayEnd = dtDayEnd.plusDays(1).toInstant().getMillis();
        }
        if (time >= this.weekEnd) {
            this.weeklyMemoryMap.put((Object)this.weekStart, (Object)this.avgMemory(this.weeklyMemoryMap.subMap((Object)this.weekStart, (Object)this.weekEnd)));
            this.weeklySessionMap.put((Object)this.weekStart, (Object)this.avgSession(this.weeklySessionMap.subMap((Object)this.weekStart, (Object)this.weekEnd)));
            this.weekStart = this.weekEnd;
            DateTime dtWeekEnd = new DateTime((Object)this.weekEnd);
            this.weekEnd = dtWeekEnd.plusWeeks(1).toInstant().getMillis();
        }
        if (time >= this.monthEnd) {
            this.monthlyMemoryMap.put((Object)this.monthStart, (Object)this.avgMemory(this.monthlyMemoryMap.subMap((Object)this.monthStart, (Object)this.monthEnd)));
            this.monthlySessionMap.put((Object)this.monthStart, (Object)this.avgSession(this.monthlySessionMap.subMap((Object)this.monthStart, (Object)this.monthEnd)));
            this.monthStart = this.monthEnd;
            DateTime dtMonthEnd = new DateTime((Object)this.monthEnd);
            this.dayEnd = dtMonthEnd.plusMonths(1).toInstant().getMillis();
        }
    }

    private CTATTSSession findFirstInactive() {
        for (int i = 0; i < this.sessions.size(); ++i) {
            CTATTSSession test = this.sessions.get(i);
            if (test.getActive().booleanValue()) continue;
            return test;
        }
        return null;
    }

    private CTATTSSession findFirstActive() {
        for (int i = 0; i < this.sessions.size(); ++i) {
            CTATTSSession test = this.sessions.get(i);
            if (test.getActive().booleanValue()) continue;
            return test;
        }
        return null;
    }

    private void makeAllInactive() {
        for (int i = 0; i < this.sessions.size(); ++i) {
            CTATTSSession test = this.sessions.get(i);
            test.setActive(false);
        }
    }

    @Override
    public void cleanup() {
        this.debug("cleanup ()");
        CTATTSSession activeSession = this.findFirstInactive();
        while (activeSession != null) {
            this.removeSession(activeSession.getInstanceName());
            activeSession = this.findFirstInactive();
        }
    }

    private CTATTSSession avgSession(Map<Long, CTATTSSession> aMap) {
        this.debug("avgMemory (" + aMap.entrySet().size() + ")");
        Iterator<Map.Entry<Long, CTATTSSession>> iter = aMap.entrySet().iterator();
        Long counter = 0L;
        Long totalTransactionMs = 0L;
        Long transactionCount = 0L;
        Long firstTransactionTime = 0L;
        Long longestTransactionMs = 0L;
        Long longestTransactionStartTime = 0L;
        Long diskLogEntries = 0L;
        Long forwardLogEntries = 0L;
        Long diskLogErrors = 0L;
        Long forwardLogErrors = 0L;
        while (iter.hasNext()) {
            Map.Entry<Long, CTATTSSession> entry = iter.next();
            if (entry != null) {
                int repeats = entry.getValue().getRepeats();
                totalTransactionMs = totalTransactionMs + entry.getValue().getTotalTransactionMs();
                transactionCount = transactionCount + entry.getValue().getTransactionCount();
                firstTransactionTime = firstTransactionTime + entry.getValue().getFirstTransactionTime();
                longestTransactionMs = longestTransactionMs + entry.getValue().getLongestTransactionMs();
                longestTransactionStartTime = longestTransactionStartTime + entry.getValue().getLongestTransactionStartTime();
                diskLogEntries = diskLogEntries + entry.getValue().getDiskLogEntries();
                forwardLogEntries = forwardLogEntries + entry.getValue().getForwardLogEntries();
                diskLogErrors = diskLogErrors + entry.getValue().getDiskLogErrors();
                forwardLogErrors = forwardLogErrors + entry.getValue().getForwardLogErrors();
                counter = counter + (long)repeats;
            } else {
                this.debug("Error, unable to get memory entry from map");
            }
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        CTATTSSession thisSession = new CTATTSSession();
        if (counter > 0L) {
            thisSession.setActive(true);
            thisSession.setTotalTransactionMs(totalTransactionMs / counter);
            thisSession.setTransactionCount(transactionCount / counter);
            thisSession.setFirstTransactionTime(firstTransactionTime / counter);
            thisSession.setLongestTransactionMs(longestTransactionMs / counter);
            thisSession.setLongestTransactionStartTime(longestTransactionStartTime / counter);
        }
        return thisSession;
    }

    private CTATTSMemory avgMemory(Map<Long, CTATTSMemory> aMap) {
        this.debug("avgMemory (" + aMap.entrySet().size() + ")");
        Iterator<Map.Entry<Long, CTATTSMemory>> iter = aMap.entrySet().iterator();
        Long counter = 0L;
        Long memUsed = 0L;
        Long memMax = 0L;
        Long memTotal = 0L;
        while (iter.hasNext()) {
            Map.Entry<Long, CTATTSMemory> entry = iter.next();
            if (entry != null) {
                int repeats = entry.getValue().getRepeats();
                memUsed = memUsed + entry.getValue().getMemUsed() * (long)(repeats + 1);
                memMax = memMax + entry.getValue().getMemMax() * (long)(repeats + 1);
                memTotal = memTotal + entry.getValue().getMemTotal() * (long)(repeats + 1);
                counter = counter + (long)repeats;
            } else {
                this.debug("Error, unable to get memory entry from map");
            }
            Long l = counter;
            Long l2 = counter = Long.valueOf(counter + 1L);
        }
        CTATTSMemory thisMemory = new CTATTSMemory();
        if (counter > 0L) {
            thisMemory.setMemUsed(memUsed / counter);
            thisMemory.setMemMax(memMax / counter);
            thisMemory.setMemTotal(memTotal / counter);
        }
        return thisMemory;
    }
}

