/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATAppletFileManager;
import edu.cmu.hcii.ctat.CTATCurriculum;
import edu.cmu.hcii.ctat.CTATFlashTutorShop;
import edu.cmu.hcii.ctat.CTATHTTPLocalHandler;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.ProblemEndHandler;
import edu.cmu.hcii.ctat.ProblemSetEndHandler;
import edu.cmu.hcii.ctat.UserProgressDatabase;
import java.awt.EventQueue;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;

public class CTATCLBridge
extends CTATFlashTutorShop
implements Runnable,
ProblemSetEndHandler,
ProblemEndHandler {
    private static final DateFormat dateFmt = new SimpleDateFormat("yyyy-MM-dd.HH.mm.SS");
    private CTATCurriculum curriculum = null;

    public CTATCLBridge() {
        this.setClassName("CTATCLBridge");
        this.debug("CTATCLBridge ()");
    }

    public void runBridge(String aUsername, String contentJar) {
        this.debug("runBridge (" + aUsername + "," + contentJar + ")");
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
        CTATLink link = new CTATLink(new CTATAppletFileManager());
        if (contentJar != null && !contentJar.isEmpty()) {
            CTATLink.mountJar(contentJar);
        }
        CTATLink.userID = aUsername;
        CTATLink.allowWriting = false;
        CTATLink.printDebugMessages = true;
        CTATLink.remoteHost = "local";
        CTATLink.hostName = "localhost";
        CTATLink.wwwPort = 8080;
        CTATLink.fManager.configureCTATLink();
        if (CTATLink.fManager.doesFileExist(CTATLink.htdocs + "/curriculum.xml")) {
            // empty if block
        }
        this.debug("Curriculum file exists, loading ...");
        String currContents = CTATLink.fManager.getContents(CTATLink.htdocs + "/curriculum.xml");
        try {
            this.curriculum = new CTATCurriculum(currContents);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            JOptionPane.showMessageDialog(null, "An error occurred when reading the curriculum description (" + CTATLink.htdocs + "curriculum.xml):\n" + e.getMessage());
            this.curriculum = null;
        }
        if (this.curriculum != null) {
            this.debug("Curriculum check: " + this.curriculum.toString());
            this.curriculum.problemSetsPath = CTATLink.htdocs + "/FlashTutors/";
            this.curriculum.loadAllProblemSets();
        }
        this.debug("Configuring the locall offline code some more ...");
        this.setProblemSetEndHandler(this);
        this.setProblemEndHandler(this);
        this.setUseTray(false);
        this.debug("Starting thread ...");
        try {
            String accessLogName = "access" + dateFmt.format(new Date()) + ".log";
            CTATHTTPLocalHandler handler = new CTATHTTPLocalHandler(CTATLink.logdir + accessLogName, new UserProgressDatabase());
            this.debug("Assigning local handler ...");
            this.setHandler(handler);
        }
        catch (IOException e1) {
            this.debug("Error: unable to installe HTTP handler");
            e1.printStackTrace(System.out);
            System.exit(1);
        }
        EventQueue.invokeLater(this);
    }

    @Override
    public void run() {
        this.debug("run ()");
        this.runBarebones();
    }

    @Override
    public boolean problemSetEnd(List<String> problemSummaries) {
        return false;
    }

    @Override
    public boolean problemEnd(String problemSummary) {
        return false;
    }

    public static void main(String[] args) {
        System.out.println("main (CTATCLBridge) ()");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].compareTo("-config") != 0) continue;
            CTATLink link = new CTATLink();
            CTATCLBridge.makeConfigFile();
            return;
        }
        System.out.println("Starting thread (CTATCLBridge) ...");
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("run (CTATCLBridge)()");
                CTATCLBridge service = new CTATCLBridge();
                System.out.println("run (CTATCLBridge) Executing bridge call ()");
                service.runBridge("dummy", "jb.jar");
            }
        });
    }
}

