/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.jess;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemNode;
import edu.cmu.pact.Utilities.Utils;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.jess.JessConsole;
import edu.cmu.pact.jess.JessParser;
import edu.cmu.pact.jess.MT;
import edu.cmu.pact.jess.RuleActivationTree;
import edu.cmu.pact.jess.SimStRete;
import edu.cmu.pact.miss.SimSt;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import jess.Activation;
import jess.Defrule;
import jess.Fact;
import jess.FactIDValue;
import jess.JessException;
import jess.Rete;
import jess.Strategy;
import jess.Value;

public class JessOracleRete
extends SimStRete
implements Serializable,
JessParser {
    private static final long serialVersionUID = 1L;
    public static final String JESS_ORACLE_PRODUCTION_RULES_FILE = "productionRulesJessOracle.pr";
    private MT mt;
    private boolean bloadSuccessful = false;
    private boolean wmeTypesFromFile = false;
    private boolean prRulesFromFile = false;
    private boolean wmeInstancesFromFile = false;
    private transient JessConsole console;
    private transient BR_Controller controller;

    @Override
    public MT getMt() {
        return this.mt;
    }

    private void setMt(MT mt) {
        this.mt = mt;
    }

    public JessOracleRete(BR_Controller brController) {
        super(brController);
        this.controller = brController;
        this.mt = this.controller.getModelTracer();
        this.setJmt(this.mt.getModelTracing());
        MT.loadDefaultUserfunctions(this.controller.getModelTracer(), this, null);
        ConflictResolutionStrategy.setStrategy(this);
    }

    @Override
    public boolean isBloadSuccessful() {
        return this.bloadSuccessful;
    }

    @Override
    public void setBloadSuccessful(boolean bloadSuccessful) {
        this.bloadSuccessful = bloadSuccessful;
    }

    @Override
    public boolean isWmeTypesFromFile() {
        return this.wmeTypesFromFile;
    }

    @Override
    public void setWmeTypesFromFile(boolean wmeTypesFromFile) {
        this.wmeTypesFromFile = wmeTypesFromFile;
    }

    @Override
    public boolean isPrRulesFromFile() {
        return this.prRulesFromFile;
    }

    @Override
    public void setPrRulesFromFile(boolean prRulesFromFile) {
        this.prRulesFromFile = prRulesFromFile;
    }

    @Override
    public boolean isWmeInstancesFromFile() {
        return this.wmeInstancesFromFile;
    }

    @Override
    public void setWmeInstancesFromFile(boolean wmeInstancesFromFile) {
        this.wmeInstancesFromFile = wmeInstancesFromFile;
    }

    @Override
    public JessConsole getConsole() {
        return this.console;
    }

    @Override
    public void setConsole(JessConsole console) {
        this.console = console;
    }

    @Override
    public void initWMUsingJessFiles(String problemName, boolean useBinary) {
        this.loadJessFiles(problemName, useBinary);
        try {
            if (!this.bloadSuccessful) {
                this.eval("(defglobal ?*sSelection* = NotSpecified)");
                this.eval("(defglobal ?*sAction* = NotSpecified)");
                this.eval("(defglobal ?*sInput* = NotSpecified)");
            }
        }
        catch (HeadlessException e1) {
            e1.printStackTrace();
        }
        catch (JessException je) {
            String errMsg = "Error defining selection-action-input globals";
            this.console.getTextOutput().append("\n" + errMsg + ":\n" + (Object)((Object)je));
            if (trace.getDebugCode("mt")) {
                trace.out("mt", "ERROR CREATING S/A/I GLOBALS: " + (Object)((Object)je));
            }
            JOptionPane.showMessageDialog(null, errMsg + ":\n" + je.getDetail(), "Jess Warning", 2);
        }
        if (!this.wmeInstancesFromFile) {
            try {
                if (this.findDeftemplate("problem") != null) {
                    Fact problemFact = new Fact(this.findDeftemplate("problem"));
                    problemFact.setSlotValue("name", new Value(problemName, 1));
                    this.assertFact(problemFact);
                    if (trace.getDebugCode("mt")) {
                        trace.out("mt", "StartStateEnd: new problem fact id: " + new FactIDValue(problemFact));
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.clearRuleActivationTree();
        this.showActivations("StartStateEnd");
    }

    private void clearRuleActivationTree() {
        if (this.controller.getModelTracer().getModelTracing() == null) {
            return;
        }
        RuleActivationTree tree = this.controller.getModelTracer().getModelTracing().getRuleActivationTree();
        if (tree != null) {
            tree.clearTree(null);
        }
    }

    @Override
    public void restoreInitialWMState(ProblemNode startNode, boolean loadJessFiles) {
        try {
            this.init(startNode.getName(), loadJessFiles);
        }
        catch (JessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadJessFiles(String problemName, boolean useBinary) {
        this.bloadSuccessful = false;
        this.wmeTypesFromFile = false;
        this.prRulesFromFile = false;
        this.wmeInstancesFromFile = false;
        String[] filenames = new String[]{problemName + ".bload", "wmeTypes.clp", JESS_ORACLE_PRODUCTION_RULES_FILE, "init.wme", problemName + ".wme"};
        boolean[] results = null;
        for (int i = 0; i < filenames.length; ++i) {
            filenames[i] = this.getDirectory(filenames[i]) + filenames[i];
        }
        if (!useBinary) {
            filenames[0] = null;
        }
        try {
            this.clear();
            results = this.loadJessFiles(filenames[0], filenames[1], filenames[2], filenames[3], filenames[4], null);
        }
        catch (Exception e) {
            trace.err("Error " + e + " trying to load Jess files");
            return;
        }
        this.bloadSuccessful = results[0];
        this.wmeTypesFromFile = results[1] || results[0];
        this.prRulesFromFile = results[2] || results[0];
        this.wmeInstancesFromFile = results[4] || results[0];
    }

    @Override
    public BR_Controller getController() {
        return this.controller;
    }

    private String getDirectory(String origFilename) {
        Object f = null;
        String dirname = this.getProblemDirectory();
        boolean validFilename = this.checkFilenameValid(dirname + origFilename);
        if (trace.getDebugCode("rr")) {
            trace.out("rr", "MT.getDirectory(): getProblemDirectory() result " + dirname + "+" + origFilename + " valid? " + validFilename);
        }
        if (!validFilename && !this.checkFilenameValid((dirname = this.controller.getPreferencesModel().getStringValue("workspace") + "/") + origFilename)) {
            dirname = null;
        }
        return dirname;
    }

    private boolean checkFilenameValid(String filename) {
        if (filename == null || filename.length() <= 0) {
            return false;
        }
        File f = new File(filename);
        if (f == null || !f.isAbsolute() || !f.exists()) {
            File result = Utils.getFileAsResource(filename, this);
            if (trace.getDebugCode("rr")) {
                trace.out("rr", "rr.checkFilenameValid(" + filename + ") file result " + result);
            }
            if (null == result || !result.exists()) {
                URL url = Utils.getURL(filename, this);
                if (trace.getDebugCode("rr")) {
                    trace.out("rr", "rr.checkFilenameValid(" + filename + ") URL result " + url);
                }
                return url != null;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(String problemName, boolean loadJessFiles) throws Exception {
        String[] problem;
        ArrayList<String> startElements = null;
        if (this.getController().getMissController() != null && this.getController().getMissController().getSimStPLE() != null) {
            startElements = this.getController().getMissController().getSimStPLE().getStartStateElements();
        } else if (this.getController().getMissController() != null && this.getController().getMissController().getSimSt().isValidationMode()) {
            startElements = new ArrayList();
            String file = this.getController().getMissController().getSimSt().getPackageName() + "/" + "simSt-config.txt";
            ClassLoader cl = this.getClass().getClassLoader();
            InputStream is = cl.getResourceAsStream(file);
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(isr);
                String line = reader.readLine();
                while (line != null) {
                    if (line.equals("startStateElements")) {
                        line = reader.readLine();
                        while (line != null && line.length() > 0) {
                            startElements.add(line);
                            line = reader.readLine();
                        }
                    }
                    if (line == null) continue;
                    line = reader.readLine();
                }
            }
            catch (Exception e) {
                if (trace.getDebugCode("miss")) {
                    trace.out("miss", "Unable to read config file: " + e.getMessage());
                }
                e.printStackTrace();
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        } else {
            throw new Exception("Need to initialize the working memory with start state elements.");
        }
        SimStRete.PROBLEM_NAME = SimSt.convertFromSafeProblemName(problemName);
        if (loadJessFiles) {
            MT.loadDefaultUserfunctions(this.controller.getModelTracer(), this, null);
            this.initWMUsingJessFiles(problemName, false);
        }
        if ((problem = SimStRete.PROBLEM_NAME.split(this.controller.getMissController().getSimSt().getProblemDelimiter()))[0].contains("=")) {
            problem = SimStRete.PROBLEM_NAME.split("=");
        }
        if (problem[0].isEmpty()) {
            return;
        }
        for (int i = 0; i < startElements.size(); ++i) {
            this.setSAIDirectly(startElements.get(i), "UpdateTable", problem[i]);
        }
    }

    public static class ConflictResolutionStrategy
    implements Strategy,
    Serializable {
        private static final long serialVersionUID = 1L;
        private Strategy oldStrategy = null;
        private Activation actToFire = null;
        private Activation cachedActToFire = null;
        private int cacheUse;

        private void setActToFire(Activation act, Rete r) {
            this.actToFire = act;
            this.cachedActToFire = null;
            this.cacheUse = 0;
        }

        private static Strategy setStrategy(Rete r) {
            Strategy oldStrategy = null;
            try {
                oldStrategy = r.getStrategy();
                ConflictResolutionStrategy crs = new ConflictResolutionStrategy();
                crs.oldStrategy = oldStrategy;
                r.setStrategy((Strategy)crs);
                return oldStrategy;
            }
            catch (JessException e) {
                e.printStackTrace();
                return oldStrategy;
            }
        }

        public int compare(Activation arg0, Activation arg1) {
            int result = 0;
            Defrule r0 = arg0.getRule();
            Defrule r1 = arg1.getRule();
            if (this.cachedActToFire != null) {
                ++this.cacheUse;
                if (arg0 == this.cachedActToFire) {
                    result = -1;
                } else if (arg1 == this.cachedActToFire) {
                    result = 1;
                }
            } else if (this.actToFire != null) {
                if (arg0.equals((Object)this.actToFire)) {
                    this.cachedActToFire = arg0;
                    result = -1;
                } else if (arg1 == this.actToFire) {
                    this.cachedActToFire = arg1;
                    result = 1;
                }
            }
            if (result == 0) {
                result = this.oldStrategy.compare(arg0, arg1);
            }
            return result;
        }

        public String getName() {
            return "conflict-resolution-strategy";
        }
    }
}

