/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.SocketProxy;

import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.Utilities.trace;
import edu.cmu.pact.ctat.MessageObject;
import java.io.IOException;
import java.io.PrintWriter;
import org.json.XML;
import pact.CommWidgets.RemoteToolProxy;

public class HTTPToolProxy
extends RemoteToolProxy {
    public static final String CTAT_RESPONSE_MESSAGES = "CTATResponseMessages";
    private boolean outputJSON = false;
    private CTATHTTPExchange exchange;
    private String sessionId;
    private static final String policyFileRequest = "<policy-file-request/>";
    private static final String socketPolicyContent = "<cross-domain-policy>\n<site-control permitted-cross-domain-policies=\"master-only\"/>\n<allow-access-from domain=\"*\" to-ports=\"*\" />\n</cross-domain-policy>\u0000";
    private static final String encoding = "UTF-8";

    public HTTPToolProxy(CTATHTTPExchange exchange, int format, BR_Controller controller) {
        this.controller = controller;
        this.exchange = exchange;
        this.setFormat(format);
    }

    public boolean getOutputJSON() {
        return this.outputJSON;
    }

    public void setOutputJSON(boolean outputJSON) {
        this.outputJSON = outputJSON;
    }

    @Override
    public Boolean clientSupports(String msgType, String commShellVersion) {
        return Boolean.TRUE;
    }

    @Override
    public boolean clientRestarts(String msgType, String commShellVersion) {
        return "InterfaceReboot".equalsIgnoreCase(msgType);
    }

    @Override
    public synchronized void sendXMLString(String str) {
        str = this.formatMsgString(str);
        try {
            if (this.exchange.isWS()) {
                if (trace.getDebugCode("tsltstp")) {
                    trace.outNT("tsltstp", this.sessionId + " " + str);
                }
                this.exchange.WSSend(str);
                return;
            }
            if (trace.getDebugCode("tsltstp")) {
                trace.outNT("tsltstp", this.exchange.getRequestHeaderConcatenated("ctatsession") + " " + str);
            }
            byte[] bytes = str.getBytes(encoding);
            this.exchange.addResponseHeader("Server", "CTATTutoringService");
            this.exchange.addResponseHeader("Access-Control-Allow-Origin", "*");
            if (this.getOutputJSON()) {
                this.exchange.addResponseHeader("Content-Type", "text/plain");
            } else {
                this.exchange.addResponseHeader("Content-Type", "text/xml");
            }
            this.exchange.sendResponseHeaders(200, bytes.length);
            this.exchange.writeBytesString(str, false, encoding);
            this.exchange.close();
        }
        catch (Exception e) {
            trace.err("SocketToolProxy failed to connect outgoing socket to Tutor Interface: " + e.toString());
        }
    }

    String formatMsgString(String str) {
        String result = this.getOutputJSON() ? XML.toJSONObject(str).toString(2) : (!str.startsWith("<?") ? "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + str : str);
        return result;
    }

    public static boolean handlePolicyFileRequest(String msg, CTATHTTPExchange exchange) {
        try {
            if (msg == null) {
                throw new IOException("null message from socket");
            }
            if (!msg.regionMatches(0, policyFileRequest, 0, policyFileRequest.length())) {
                return false;
            }
            if (trace.getDebugCode("ls")) {
                trace.outNT("ls", "SocketProxy.handlePolicyFileRequest()\nReceived a policy request on local " + exchange.getLocalPort() + ", remote " + exchange.getRemotePort() + "\n");
            }
            PrintWriter pw = new PrintWriter(exchange.getResponseTank());
            pw.write(socketPolicyContent);
            pw.close();
            exchange.close();
        }
        catch (IOException ioe) {
            StringBuffer errMsg = new StringBuffer("Error in security handshake with Flash");
            errMsg.append(".\nMore info: exception sending policy file response: ").append(ioe);
            if (ioe.getCause() != null) {
                errMsg.append("\n cause: ").append(ioe.getCause());
            }
            trace.errStack(errMsg.toString(), ioe);
            try {
                if (exchange != null) {
                    exchange.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public CTATHTTPExchange getHttpExchange() {
        return this.exchange;
    }

    public void setHttpExchange(CTATHTTPExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public void bundleMessage(MessageObject o, String bundleName, boolean flush) {
        if (this.exchange != null && this.exchange.isWS()) {
            super.bundleMessage(o, null, true);
        } else {
            super.bundleMessage(o, bundleName, flush);
        }
    }

    @Override
    public boolean processUpdateAfterDelay(MessageObject mo) {
        return false;
    }

    public void flushResponses(String bundleName) {
        this.flushBundle(null, bundleName == null ? CTAT_RESPONSE_MESSAGES : bundleName);
    }

    public void bundleResponse(MessageObject newMessage, String bundleName, boolean flush) {
        this.bundleMessage(newMessage, bundleName == null ? CTAT_RESPONSE_MESSAGES : bundleName, flush);
    }

    @Override
    protected Object getSocket() {
        return this.exchange.getSocket();
    }

    public void setSessionId(String guid) {
        this.sessionId = guid;
    }

    @Override
    public String getSessionId() {
        String result = super.getSessionId();
        return result == null ? this.sessionId : result;
    }
}

