/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.View.GraphInspector;

import edu.cmu.pact.BehaviorRecorder.Controller.BR_Controller;
import edu.cmu.pact.BehaviorRecorder.Controller.CTAT_Launcher;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditContextEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.EditorContextListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupChangeEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupChangeListener;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupEditorContext;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.View.GraphInspector.AddGroupPopup;
import edu.cmu.pact.BehaviorRecorder.View.GraphInspector.GroupNameEditor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class AddGroupUI
extends JPanel
implements ActionListener,
GroupChangeListener,
EditorContextListener {
    private static final long serialVersionUID = -503524705341597865L;
    static final String CREATE_GROUP = "Create Group";
    protected JButton createGroupButton;
    protected JButton addRemoveLinksButton;
    protected JTextArea errorMessageField;
    protected JDialog createGroupDialog;
    protected GroupNameEditor groupNameEditor;
    protected JRadioButton ordered;
    protected JButton okButton;
    protected GroupEditorContext editContext;
    protected GroupModel groupModel;
    protected Frame mainWindow;
    private CTAT_Launcher server;
    private Map<Integer, GroupModel> groupMap;

    public AddGroupUI(CTAT_Launcher server) {
        this.server = server;
        this.mainWindow = server.getActiveWindow();
        this.groupMap = new HashMap<Integer, GroupModel>();
        this.refresh();
    }

    public void refresh() {
        Integer currentKey;
        this.removeAll();
        BR_Controller controller = this.server.getFocusedController();
        this.editContext = controller.getProblemModel().getEditContext();
        this.editContext.addEditorContextListener(this);
        if (this.groupModel != null) {
            this.groupModel.removeGroupChangeListener(this);
        }
        if (this.groupMap.containsKey(currentKey = Integer.valueOf(controller.getTabNumber()))) {
            this.groupModel = this.groupMap.get(currentKey);
        } else {
            this.groupModel = this.editContext.getGroupModel();
            this.groupMap.put(currentKey, this.groupModel);
        }
        this.groupModel.addGroupChangeListener(this);
        this.createGroupButton = new JButton(CREATE_GROUP);
        this.createGroupButton.addActionListener(this);
        this.createGroupButton.setEnabled(false);
        this.addRemoveLinksButton = new JButton("Add/Remove Links");
        this.addRemoveLinksButton.addActionListener(this);
        this.addRemoveLinksButton.setEnabled(false);
        this.errorMessageField = new JTextArea();
        this.errorMessageField.setEditable(false);
        this.errorMessageField.setLineWrap(true);
        this.testCurrentSelection();
        JPanel buttonLayout = new JPanel();
        buttonLayout.setLayout(new BoxLayout(buttonLayout, 0));
        buttonLayout.add(this.createGroupButton);
        buttonLayout.add(this.addRemoveLinksButton);
        this.setLayout(new BoxLayout(this, 1));
        this.add(buttonLayout);
        this.add(this.errorMessageField);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BR_Controller controller = this.server.getFocusedController();
        if (e.getSource().equals(this.createGroupButton)) {
            new AddGroupPopup(this.mainWindow, CREATE_GROUP, true, this.editContext, this.createGroupButton.getLocationOnScreen(), controller);
        } else if (e.getSource().equals(this.addRemoveLinksButton)) {
            LinkGroup group = this.getSelectedGroup();
            String actionDesc = null;
            for (ExampleTracerLink link : this.getSelectedLinks()) {
                if (this.groupModel.isLinkInGroup(group, link)) {
                    this.groupModel.removeLinkFromGroup(group, link);
                } else {
                    this.groupModel.addLinkToGroup(group, link);
                }
                actionDesc = "Add or remove links in group";
            }
            if (actionDesc != null) {
                ActionEvent ae = new ActionEvent(this, 0, actionDesc);
                controller.getUndoPacket().getCheckpointAction().actionPerformed(ae);
            }
        }
    }

    @Override
    public void groupChanged(GroupChangeEvent e) {
        this.testCurrentSelection();
    }

    @Override
    public void editorContextChanged(EditContextEvent e) {
        this.testCurrentSelection();
    }

    public boolean isGroupSelected() {
        return this.getSelectedGroup() != null;
    }

    public LinkGroup getSelectedGroup() {
        return this.editContext.getSelectedGroup();
    }

    public boolean isLinkSelectionNonEmpty() {
        return this.getSelectedLinks().size() != 0;
    }

    public void testCurrentSelection() {
        Set<ExampleTracerLink> links = this.getSelectedLinks();
        if (links.size() == 0) {
            this.disableGroupCreation("No Links Selected");
            return;
        }
        String validMessage = this.groupModel.isLinkSetAddableAsGroup(links);
        boolean isValid = validMessage.equals("");
        if (validMessage.equals("")) {
            validMessage = "Correct Link selection";
        }
        validMessage = validMessage + "\n\nSelected Links:";
        for (ExampleTracerLink link : links) {
            validMessage = validMessage + "\n" + link;
        }
        if (isValid) {
            this.enableGroupCreation(validMessage);
        } else {
            this.disableGroupCreation(validMessage);
        }
        if (links.size() == 0 || this.editContext.getSelectedGroup() == null || this.editContext.getSelectedGroup().equals(this.groupModel.getTopLevelGroup())) {
            this.addRemoveLinksButton.setEnabled(false);
        } else {
            this.addRemoveLinksButton.setEnabled(true);
        }
    }

    private Set<ExampleTracerLink> getSelectedLinks() {
        return this.editContext.getSelectedLinks();
    }

    private void disableGroupCreation(String message) {
        this.errorMessageField.setText(message);
        this.createGroupButton.setEnabled(false);
    }

    private void enableGroupCreation(String message) {
        this.errorMessageField.setText(message);
        this.createGroupButton.setEnabled(true);
    }
}

