/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.StartStateEditor;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATArgument;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATArgumentEditor;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATColorUtil;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSAI;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializable;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSerializableTableEntry;
import edu.cmu.pact.BehaviorRecorder.StartStateEditor.CTATSheetCellNumber;
import edu.cmu.pact.BehaviorRecorder.View.JUndo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class CTATSheetCellEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private static final long serialVersionUID = 1L;
    private CTATSerializableTableEntry entry = null;
    private CTATSerializable obj = null;
    private CTATSAI sai = null;
    private CTATArgument arg = null;
    private JTextField textComponent = null;
    private JComboBox booleanComponent = null;
    private JComboBox fontComponent = null;
    private CTATSheetCellNumber numberComponent = null;
    private JButton colorDelegate = new JButton();
    private JButton arrayDelegate = new JButton();
    String[] booleanStrings = new String[]{"TRUE", "FALSE"};
    String[] fontStrings = new String[]{"Arial", "Helvetica", "Verdana", "Times", "Times New Roman"};

    public CTATSheetCellEditor() {
        this.debug("CTATSheetCellEditor ()");
        this.textComponent = new JTextField();
        JUndo.JTextUndoPacket jTextUndoPacket = JUndo.makeTextUndoable(this.textComponent);
        this.textComponent.setMinimumSize(new Dimension(10, 10));
        this.textComponent.setMaximumSize(new Dimension(5000, 5000));
        this.textComponent.setFont(new Font("Dialog", 1, 10));
        this.booleanComponent = new JComboBox<String>(this.booleanStrings);
        this.booleanComponent.setMinimumSize(new Dimension(10, 10));
        this.booleanComponent.setMaximumSize(new Dimension(5000, 5000));
        this.booleanComponent.setFont(new Font("Dialog", 1, 10));
        this.fontComponent = new JComboBox<String>(this.fontStrings);
        this.fontComponent.setMinimumSize(new Dimension(10, 10));
        this.fontComponent.setMaximumSize(new Dimension(5000, 5000));
        this.fontComponent.setFont(new Font("Dialog", 1, 10));
        this.numberComponent = new CTATSheetCellNumber();
        this.numberComponent.setMinimumSize(new Dimension(10, 10));
        this.numberComponent.setMaximumSize(new Dimension(5000, 5000));
        this.numberComponent.setFont(new Font("Dialog", 1, 10));
        this.colorDelegate.addActionListener(this);
        this.arrayDelegate.addActionListener(this);
    }

    private void debug(String aMessage) {
        CTATBase.debug("CTATSheetCellEditor", aMessage);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.debug("actionPerformed ()");
        if (actionEvent.getSource() == this.colorDelegate) {
            this.debug("Showing color chooser ...");
            Color newColor = CTATColorUtil.parse(this.obj.getValue());
            Color color = JColorChooser.showDialog(this.colorDelegate, "Color Chooser", newColor);
            if (this.obj != null) {
                this.obj.setValue(CTATColorUtil.toHex(color));
            }
            if (this.arg != null) {
                this.arg.setValue(CTATColorUtil.toHex(color));
            }
        }
        if (actionEvent.getSource() == this.arrayDelegate) {
            this.debug("Showing argument editor ...");
            CTATArgumentEditor d = new CTATArgumentEditor(null, "Argument Editor");
            d.setSize(200, 400);
            d.setSAI(this.sai);
            d.setVisible(true);
        }
        this.fireEditingStopped();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object anObject, boolean isSelected, int rowIndex, int vColIndex) {
        this.debug("getTableCellEditorComponent ()");
        if (anObject == null) {
            this.debug("Error: table entry obj is null");
            return null;
        }
        this.entry = (CTATSerializableTableEntry)anObject;
        if (this.entry.getEntry() != null) {
            this.obj = this.entry.getEntry();
        }
        if (this.entry.getArgument() != null) {
            this.arg = this.entry.getArgument();
        }
        if (this.entry.getSAI() != null) {
            this.sai = this.entry.getSAI();
        }
        if (isSelected) {
            // empty if block
        }
        if (this.obj != null) {
            if (this.obj.getType().equals("String")) {
                this.textComponent.setText(this.obj.getValue());
            }
            if (this.obj.getType().equals("Boolean")) {
                return this.booleanComponent;
            }
            if (this.obj.getType().equals("Font")) {
                return this.fontComponent;
            }
            if (this.obj.getType().equals("Color")) {
                return this.colorDelegate;
            }
            this.textComponent.setText(this.obj.getValue());
        }
        if (this.arg != null) {
            if (this.arg.getType().equals("String")) {
                this.textComponent.setText(this.arg.getValue());
            }
            if (this.arg.getType().equals("Boolean")) {
                return this.booleanComponent;
            }
            if (this.arg.getType().equals("Font")) {
                return this.fontComponent;
            }
            if (this.arg.getType().equals("Color")) {
                return this.colorDelegate;
            }
            this.textComponent.setText(this.arg.getValue());
        }
        if (this.sai != null) {
            if (this.sai.getArgumentSize() > 1) {
                this.arrayDelegate.setText(this.sai.toArgumentString());
                return this.arrayDelegate;
            }
            if (this.sai.getType().equals("String")) {
                this.textComponent.setText(this.sai.getValue());
            }
            if (this.sai.getType().equals("Boolean")) {
                return this.booleanComponent;
            }
            if (this.sai.getType().equals("Font")) {
                return this.fontComponent;
            }
            if (this.sai.getType().equals("Color")) {
                return this.colorDelegate;
            }
            this.textComponent.setText(this.sai.getValue());
        }
        return this.textComponent;
    }

    @Override
    public Object getCellEditorValue() {
        this.debug("getCellEditorValue ()");
        if (this.obj != null) {
            this.debug("Setting direct value ...");
            if (this.obj.getType().equals("Boolean")) {
                this.debug("Returning ComboBox selection ...");
                this.obj.setValue((String)this.booleanComponent.getSelectedItem());
                this.textComponent.setText(this.obj.getValue());
            }
            if (this.obj.getType().equals("Font")) {
                this.debug("Returning Font selection ...");
                this.obj.setValue((String)this.fontComponent.getSelectedItem());
                this.textComponent.setText(this.obj.getValue());
            }
            if (this.obj.getType().equals("Color")) {
                this.debug("Returning Color string [" + this.obj.getValue() + "]->[" + this.textComponent.getText() + "]...");
                this.textComponent.setText(this.obj.getValue());
            }
            if (this.obj.getType().equals("Number")) {
                this.debug("Returning Number ...");
                this.obj.setValue(this.numberComponent.getText());
                this.textComponent.setText(this.obj.getValue());
            }
            if (this.obj.getType().equals("Enum")) {
                this.debug("Returning Enumeration ...");
                this.obj.setValue(this.textComponent.getText());
            }
            if (this.obj.getType().equals("String")) {
                this.debug("Returning String ...");
                this.obj.setValue(this.textComponent.getText());
            }
        }
        if (this.arg != null) {
            this.debug("Setting direct value ...");
            if (this.arg.getType().equals("Boolean")) {
                this.debug("Returning ComboBox selection ...");
                this.arg.setValue((String)this.booleanComponent.getSelectedItem());
            }
            if (this.arg.getType().equals("Font")) {
                this.debug("Returning Font selection ...");
                this.arg.setValue((String)this.fontComponent.getSelectedItem());
            }
            if (this.arg.getType().equals("Color")) {
                this.debug("Returning Color string [" + this.arg.getValue() + "]->[" + this.textComponent.getText() + "]...");
                this.arg.setValue(this.textComponent.getText());
            }
            if (this.arg.getType().equals("Number")) {
                this.debug("Returning Number ...");
                this.arg.setValue(this.numberComponent.getText());
            }
            if (this.arg.getType().equals("Enum")) {
                this.debug("Returning Enumeration ...");
                this.arg.setValue(this.textComponent.getText());
            }
            if (this.arg.getType().equals("String")) {
                this.debug("Returning String ...");
                this.arg.setValue(this.textComponent.getText());
            }
        }
        if (this.sai != null) {
            this.debug("Setting sai value(s) ...");
            if (this.sai.getArgumentSize() > 1) {
                this.debug("BUILD THIS!!!");
            } else {
                if (this.sai.getType().equals("Boolean")) {
                    this.debug("Returning ComboBox selection ...");
                    this.sai.setValue((String)this.booleanComponent.getSelectedItem());
                }
                if (this.sai.getType().equals("Font")) {
                    this.debug("Returning Font selection ...");
                    this.sai.setValue((String)this.fontComponent.getSelectedItem());
                }
                if (this.sai.getType().equals("Color")) {
                    this.debug("Returning Color string [" + this.sai.getValue() + "]->[" + this.textComponent.getText() + "]...");
                    this.sai.setValue(this.textComponent.getText());
                }
                if (this.sai.getType().equals("Number")) {
                    this.debug("Returning Number ...");
                    this.sai.setValue(this.numberComponent.getText());
                }
                if (this.sai.getType().equals("Enum")) {
                    this.debug("Returning Enumeration ...");
                    this.sai.setValue(this.textComponent.getText());
                }
                if (this.sai.getType().equals("String")) {
                    this.debug("Returning String ...");
                    this.sai.setValue(this.textComponent.getText());
                }
            }
        }
        return this.entry;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= 2;
        }
        return true;
    }
}

