/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph;

import edu.cmu.pact.BehaviorRecorder.ProblemModel.BRDLoadedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeRewiredEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.EdgeUpdatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.FeedbackEnum;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.EdgeData;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerInterpretation;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerLink;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerNode;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerPath;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracer;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ExampleTracerTracerChangedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.DefaultGroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.GroupModel;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.Groups.LinkGroup;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.Graph.ProblemEdge;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NewProblemEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeCreatedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.NodeDeletedEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelEvent;
import edu.cmu.pact.BehaviorRecorder.ProblemModel.ProblemModelListener;
import edu.cmu.pact.Utilities.trace;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class ExampleTracerGraph
implements ProblemModelListener {
    private static final String TOP_LEVEL = "Top Level";
    private FeedbackEnum feedback = FeedbackEnum.DEFAULT;
    private ExampleTracerTracer exampleTracerTracer;
    private ArrayList<ExampleTracerNode> nodes;
    private ArrayList<ExampleTracerLink> links;
    private LinkedHashMap<Integer, ExampleTracerNode> nodeMap;
    private GroupModel groupModel;
    private Set<ExampleTracerLink> doneLinks;
    private boolean resetFlag;
    private boolean extendPathsFlag;

    public ExampleTracerGraph() {
        this(false, false);
    }

    ExampleTracerGraph(boolean youStartYouFinish) {
        this(false, youStartYouFinish);
    }

    public ExampleTracerGraph(boolean isUnordered, boolean youStartYouFinish) {
        this.initGraph(!isUnordered, youStartYouFinish);
    }

    public void initGraph(boolean isOrdered, boolean youStartYouFinish) {
        if (trace.getDebugCode("et")) {
            trace.out("et", "ETG: initgraph(" + isOrdered + "," + youStartYouFinish + ")");
        }
        this.links = new ArrayList();
        this.nodes = new ArrayList();
        this.nodeMap = new LinkedHashMap();
        this.doneLinks = new HashSet<ExampleTracerLink>();
        if (this.groupModel == null) {
            this.groupModel = new DefaultGroupModel();
        }
        if (trace.getDebugCode("et")) {
            trace.printStack("et", "ETG.initGraph: groupModel " + this.groupModel);
        }
        this.groupModel.clear();
        this.groupModel.setDefaultReenterable(!youStartYouFinish);
        this.groupModel.setGroupOrdered(this.groupModel.getTopLevelGroup(), isOrdered);
        this.groupModel.setGroupName(this.groupModel.getTopLevelGroup(), TOP_LEVEL);
        ExampleTracerTracer newTracer = new ExampleTracerTracer(this);
        if (this.exampleTracerTracer != null) {
            this.exampleTracerTracer.fireExampleTracerEvent(new ExampleTracerTracerChangedEvent(this, this.exampleTracerTracer, newTracer));
        }
        this.exampleTracerTracer = newTracer;
    }

    public ExampleTracerTracer getExampleTracer() {
        return this.exampleTracerTracer;
    }

    public GroupModel getGroupModel() {
        return this.groupModel;
    }

    public FeedbackEnum getFeedback() {
        return this.feedback;
    }

    public void setFeedback(FeedbackEnum feedback) {
        this.feedback = feedback;
    }

    public ArrayList<ExampleTracerLink> getLinks() {
        return this.links;
    }

    public void addLink(ExampleTracerLink link, LinkGroup groupToAddTo) {
        this.links.add(link);
        if (link.isDoneLink()) {
            this.doneLinks.add(link);
        } else {
            this.doneLinks.remove(link);
        }
        this.groupModel.addLinkToGroup(groupToAddTo, link);
    }

    public void addLink(ExampleTracerLink link) {
        this.links.add(link);
        if (link.isDoneLink()) {
            this.doneLinks.add(link);
        } else {
            this.doneLinks.remove(link);
        }
        this.groupModel.addLinkToGroup(this.groupModel.getTopLevelGroup(), link);
    }

    LinkedHashMap<Integer, ExampleTracerNode> getNodeMap() {
        return this.nodeMap;
    }

    public void addNode(ExampleTracerNode node) {
        this.nodes.add(node);
        this.nodeMap.put(new Integer(node.getNodeID()), node);
    }

    boolean removeNode(int nodeID) {
        ExampleTracerNode node = (ExampleTracerNode)this.nodeMap.remove(new Integer(nodeID));
        if (node == null) {
            return false;
        }
        ListIterator<ExampleTracerNode> it = this.nodes.listIterator();
        while (it.hasNext()) {
            if (it.next() != node) continue;
            it.remove();
            break;
        }
        return true;
    }

    public ExampleTracerNode getNode(int nodeID) {
        return this.nodeMap.get(new Integer(nodeID));
    }

    boolean observesOrderingConstraints(List<ExampleTracerLink> traversedLinks, ExampleTracerLink newLink, Set<ExampleTracerLink> path, ExampleTracerEvent result) {
        if (path == null || path.size() == 0 || newLink == null) {
            if (result != null) {
                result.setOutOfOrder(false);
            }
            return true;
        }
        if (path.contains(newLink) && this.isOrderOK(traversedLinks, newLink, path) && this.isReenteringOK(traversedLinks, newLink, path)) {
            if (result != null) {
                result.setOutOfOrder(false);
            }
            return true;
        }
        if (result != null) {
            result.setOutOfOrder(true);
        }
        return false;
    }

    private boolean isReenteringOK(List<ExampleTracerLink> traversedLinks, ExampleTracerLink newLink, Set<ExampleTracerLink> path) {
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "isReenteringOK(" + newLink + ")");
        }
        if (this.getFeedback().relaxOrderConstraints()) {
            return true;
        }
        ArrayList<LinkGroup> groups = this.findGroupsOfLink(newLink);
        boolean entered = true;
        for (LinkGroup linkGroup : groups) {
            if (entered && !this.groupModel.isGroupReenterable(linkGroup)) {
                entered = false;
                for (ExampleTracerLink link : traversedLinks) {
                    if (this.groupModel.isLinkInGroup(linkGroup, link)) {
                        entered = true;
                        continue;
                    }
                    if (!entered) continue;
                    return false;
                }
                continue;
            }
            if (entered) continue;
            break;
        }
        if (traversedLinks.size() != 0) {
            ArrayList<LinkGroup> exitedGroups = this.findGroupsOfLink(traversedLinks.get(traversedLinks.size() - 1));
            for (LinkGroup group : groups) {
                exitedGroups.remove(group);
            }
            Iterator iterator = exitedGroups.iterator();
            while (iterator.hasNext()) {
                LinkGroup group;
                group = (LinkGroup)iterator.next();
                if (!this.groupModel.isGroupReenterable(group)) continue;
                iterator.remove();
            }
            for (LinkGroup group : exitedGroups) {
                for (ExampleTracerLink link : path) {
                    if (this.getTraversalCount(traversedLinks, link) >= link.getEdge().getMinTraversals() || !this.groupModel.isLinkInGroup(group, link)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean isOrderOK(List<ExampleTracerLink> visitedLinks, ExampleTracerLink newLink, Set<ExampleTracerLink> path) {
        if (this.getFeedback().relaxOrderConstraints()) {
            return true;
        }
        ArrayList<LinkGroup> groups = this.findGroupsOfLink(newLink);
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "isOrderOK() newLink " + newLink + ", visited " + visitedLinks + "\n in path" + path);
        }
        for (int i = 0; i < groups.size(); ++i) {
            LinkGroup currentGroup = groups.get(i);
            if (!this.groupModel.isGroupOrdered(currentGroup) || !(i != groups.size() - 1 ? !this.checkOrderedGroup(currentGroup, this.getFirstLinkOnPath(groups.get(i + 1), path), visitedLinks, path) : !this.checkOrderedGroup(currentGroup, newLink, visitedLinks, path))) continue;
            return false;
        }
        return true;
    }

    private boolean checkOrderedGroup(LinkGroup orderedParent, ExampleTracerLink link, List<ExampleTracerLink> traversedLinks, Set<ExampleTracerLink> path) {
        LinkGroup prevGroup;
        ExampleTracerLink prevLink;
        int prevPos = -1;
        Object prev = null;
        int nextPos = Integer.MAX_VALUE;
        Object next = null;
        for (LinkGroup group : this.groupModel.getGroupSubgroups(orderedParent)) {
            ExampleTracerLink temp;
            if (this.groupModel.isLinkInGroup(group, link) || this.groupModel.getGroupLinkCount(group) == 0 || (temp = this.getFirstLinkOnPath(group, path)) == null) continue;
            int groupPos = temp.getDepth();
            if (groupPos < link.getDepth() && groupPos > prevPos && (!this.isGroupOptional(group) || this.isGroupStarted(group, traversedLinks))) {
                prevPos = groupPos;
                prev = group;
            }
            if (groupPos <= link.getDepth() || groupPos >= nextPos || this.isGroupOptional(group) && !this.isGroupStarted(group, traversedLinks)) continue;
            nextPos = groupPos;
            next = group;
        }
        for (ExampleTracerLink parentLink : this.groupModel.getUniqueLinks(orderedParent)) {
            if (!path.contains(parentLink)) continue;
            int linkPos = parentLink.getDepth();
            if (linkPos < link.getDepth() && linkPos > prevPos && (parentLink.getEdge().getMinTraversals() > 0 || traversedLinks.contains(parentLink))) {
                prevPos = linkPos;
                prev = parentLink;
            }
            if (linkPos <= link.getDepth() || linkPos >= nextPos || parentLink.getEdge().getMinTraversals() <= 0 && !traversedLinks.contains(parentLink)) continue;
            nextPos = linkPos;
            next = parentLink;
        }
        if (prev != null && (prev instanceof ExampleTracerLink ? this.getTraversalCount(traversedLinks, prevLink = (ExampleTracerLink)prev) < prevLink.getEdge().getMinTraversals() : prev instanceof LinkGroup && !this.isGroupFinished(prevGroup = (LinkGroup)prev, traversedLinks, path))) {
            return false;
        }
        if (next != null) {
            LinkGroup nextGroup;
            if (next instanceof ExampleTracerLink && traversedLinks.contains((ExampleTracerLink)next)) {
                return false;
            }
            if (next instanceof LinkGroup && this.isGroupStarted(nextGroup = (LinkGroup)next, traversedLinks)) {
                return false;
            }
        }
        return true;
    }

    public boolean isGroupStarted(LinkGroup group, List<ExampleTracerLink> traversedLinks) {
        for (ExampleTracerLink link : traversedLinks) {
            if (!this.groupModel.isLinkInGroup(group, link)) continue;
            return true;
        }
        return false;
    }

    public boolean isGroupOptional(LinkGroup group) {
        for (ExampleTracerLink link : this.groupModel.getGroupLinks(group)) {
            if (link.getEdge().getMinTraversals() == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isGroupMaxedOnPath(LinkGroup smallestGroup, Set<ExampleTracerLink> path, ExampleTracerInterpretation interp) {
        ExampleTracerPath orderedPath = new ExampleTracerPath(path);
        Iterator<ExampleTracerLink> orderedIterator = orderedPath.iterator();
        boolean inGroup = false;
        while (orderedIterator.hasNext()) {
            ExampleTracerLink path_link = orderedIterator.next();
            if (!inGroup) {
                if (this.groupModel.isLinkInGroup(smallestGroup, path_link)) {
                    inGroup = true;
                }
            } else if (!this.groupModel.isLinkInGroup(smallestGroup, path_link)) {
                return true;
            }
            if (interp.getTraversalCount(path_link) >= path_link.getEdge().getMaxTraversals()) continue;
            return false;
        }
        return true;
    }

    public boolean isIncorrectLinkOK(ArrayList<ExampleTracerLink> traversedLinks, ExampleTracerLink incLink, Set<ExampleTracerLink> path, ExampleTracerInterpretation interp) {
        LinkGroup incSmallestGroup;
        boolean siblingOnPath = false;
        ExampleTracerLink sibLink = null;
        ArrayList<ExampleTracerLink> outLinks = this.getNode(incLink.getPrevNode()).getOutLinks();
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "isIncorrectLinkOK() sibling links " + outLinks + "\n in path " + path + "\n in interp " + interp);
        }
        for (ExampleTracerLink link : outLinks) {
            if (link.getType().equals("Buggy Action") || !path.contains(link)) continue;
            siblingOnPath = true;
            boolean siblingOrderOk = this.isOrderOK(traversedLinks, link, path);
            if (trace.getDebugCode("ET")) {
                trace.out("ET", "isIncorrectLinkOK() siblingOrderOk " + siblingOrderOk + " on sib " + link);
            }
            if (!siblingOrderOk) {
                return false;
            }
            sibLink = link;
            break;
        }
        if (sibLink == null) {
            return false;
        }
        if (!siblingOnPath) {
            if (trace.getDebugCode("ET")) {
                trace.out("ET", "isIncorrectLinkOK(): no siblings of link " + incLink + " in path " + path);
            }
            return false;
        }
        for (LinkGroup group : this.groupModel) {
            if (!this.groupModel.isGroupOrdered(group)) continue;
            boolean orderedGroupIncLink = this.isOrderedGroupIncLinkOK(group, traversedLinks, incLink, path);
            if (trace.getDebugCode("ET")) {
                trace.out("ET", "isIncorrectLinkOK(): orderedGroupIncLink " + orderedGroupIncLink);
            }
            if (orderedGroupIncLink) continue;
            return false;
        }
        return !siblingOnPath || !this.groupModel.isLinkInGroup(incSmallestGroup = this.getSmallestContainingGroup(incLink), sibLink) || this.groupModel.isGroupOrdered(incSmallestGroup) || !this.isGroupMaxedOnPath(incSmallestGroup, path, interp);
    }

    private boolean isOrderedGroupIncLinkOK(LinkGroup group, ArrayList<ExampleTracerLink> traversedLinks, ExampleTracerLink incLink, Set<ExampleTracerLink> path) {
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "isOrderedGroupIncLinkOK(): group " + group + ", incLink " + incLink + ", path " + path);
        }
        for (LinkGroup subgroup : this.groupModel.getGroupSubgroups(group)) {
            ExampleTracerLink link = this.getFirstLinkOnPath(subgroup, path);
            if (link == null || link.getPrevNode() != incLink.getPrevNode()) continue;
            boolean subgroupFinished = this.isGroupFinished(subgroup, traversedLinks, path);
            if (trace.getDebugCode("ET")) {
                trace.out("ET", "isOrderedGroupIncLinkOK(): subgroupFinished " + subgroupFinished + " in subgroup " + subgroup);
            }
            if (!subgroupFinished) continue;
            return false;
        }
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "incLink " + incLink + " ok for isGroupFinished()");
        }
        for (ExampleTracerLink subLink : this.groupModel.getUniqueLinks(group)) {
            LinkGroup smallestContainingGroup;
            if (!(subLink.getPrevNode() == incLink.getPrevNode() ? this.getTraversalCount(traversedLinks, subLink) >= subLink.getEdge().getMaxTraversals() : subLink.getNextNode() == incLink.getPrevNode() && path.contains(subLink) && !this.groupModel.isLinkInGroup(smallestContainingGroup = this.getSmallestContainingGroup(subLink), incLink) && this.getTraversalCount(traversedLinks, subLink) < subLink.getEdge().getMinTraversals())) continue;
            return false;
        }
        if (trace.getDebugCode("ET")) {
            trace.out("ET", "isOrderedGroupIncLinkOK() returns true");
        }
        return true;
    }

    private ExampleTracerLink getFirstLinkOnPath(LinkGroup group, Set<ExampleTracerLink> path) {
        int minDepth = Integer.MAX_VALUE;
        ExampleTracerLink firstLink = null;
        for (ExampleTracerLink link : this.groupModel.getGroupLinks(group)) {
            if (link.getDepth() >= minDepth || !path.contains(link)) continue;
            minDepth = link.getDepth();
            firstLink = link;
        }
        return firstLink;
    }

    public boolean isGroupFinished(LinkGroup group, List<ExampleTracerLink> traversedLinks, Set<ExampleTracerLink> path) {
        for (ExampleTracerLink link : this.groupModel.getGroupLinks(group)) {
            if (!path.contains(link) || this.getTraversalCount(traversedLinks, link) >= link.getEdge().getMinTraversals()) continue;
            return false;
        }
        return true;
    }

    private int getTraversalCount(List<ExampleTracerLink> traversedLinks, ExampleTracerLink target) {
        int traversals = 0;
        for (ExampleTracerLink link : traversedLinks) {
            if (!target.equals(link)) continue;
            ++traversals;
        }
        return traversals;
    }

    public void redoLinkDepths() {
        this.buildInLinks();
        for (ExampleTracerLink link : this.getLinks()) {
            link.setDepth(-1);
        }
        for (ExampleTracerLink link : this.getLinks()) {
            if (link.getDepth() != -1) continue;
            this.redoLinkDepths(link);
        }
    }

    private void redoLinkDepths(ExampleTracerLink link) {
        ExampleTracerNode prevNode = this.getNode(link.getPrevNode());
        if (prevNode == null) {
            return;
        }
        int max = -1;
        for (ExampleTracerLink prevLink : prevNode.getInLinks()) {
            if (prevLink.getDepth() == -1) {
                this.redoLinkDepths(prevLink);
            }
            if (prevLink.getDepth() <= max) continue;
            max = prevLink.getDepth();
        }
        link.setDepth(max + 1);
    }

    public Set<ExampleTracerPath> findAllPaths() {
        return this.findPathsFromNode(this.getStartNode());
    }

    public boolean isNodeConnected(int nodeId) {
        ExampleTracerNode reachMe = this.nodeMap.get(nodeId);
        HashSet<ExampleTracerNode> reachables = new HashSet<ExampleTracerNode>();
        if (reachMe == null) {
            return false;
        }
        this.getNodesReachableFrom(this.getStartNode(), reachables);
        return reachables.contains(reachMe);
    }

    public void getNodesReachableIgnoringX(ExampleTracerNode fromNode, ExampleTracerNode xNode, Set<ExampleTracerNode> reachables) {
        ArrayList<ExampleTracerLink> outLinks = fromNode.getOutLinks();
        for (int i = 0; i < outLinks.size(); ++i) {
            ExampleTracerNode curr = this.nodeMap.get(outLinks.get(i).getNextNode());
            if (curr == null || curr == xNode) continue;
            boolean added = reachables.add(curr);
            this.getNodesReachableIgnoringX(curr, xNode, reachables);
        }
    }

    public void getNodesReachableFrom(ExampleTracerNode fromNode, Set<ExampleTracerNode> reachables) {
        ArrayList<ExampleTracerLink> outLinks = fromNode.getOutLinks();
        for (int i = 0; i < outLinks.size(); ++i) {
            ExampleTracerNode curr = this.nodeMap.get(outLinks.get(i).getNextNode());
            if (curr == null) continue;
            boolean added = reachables.add(curr);
            this.getNodesReachableFrom(curr, reachables);
        }
    }

    public Set<ExampleTracerPath> findPathsFromNode(ExampleTracerNode node) {
        HashSet<ExampleTracerPath> paths = new HashSet<ExampleTracerPath>();
        if (node == null || node.getOutLinks().size() == 0) {
            paths.add(new ExampleTracerPath());
            return paths;
        }
        for (ExampleTracerLink outLink : node.getOutLinks()) {
            if (outLink.getType().equals("Buggy Action")) continue;
            Set<ExampleTracerPath> childPaths = this.findPathsFromNode(this.getNode(outLink.getNextNode()));
            for (ExampleTracerPath childPath : childPaths) {
                childPath.addLink(outLink);
            }
            paths.addAll(childPaths);
        }
        if (paths.size() == 0) {
            paths.add(new ExampleTracerPath());
        }
        return paths;
    }

    public LinkGroup getSmallestContainingGroup(ExampleTracerLink link) {
        return ((DefaultGroupModel)this.groupModel).getLowestLevelGroupOfLink(link);
    }

    public ArrayList<LinkGroup> findGroupsOfLink(ExampleTracerLink link) {
        Set<LinkGroup> groupsSet = this.groupModel.getGroupsContainingLink(link);
        ArrayList<LinkGroup> groups = new ArrayList<LinkGroup>(groupsSet);
        Collections.sort(groups, new LinkGroupSizeComparator());
        return groups;
    }

    ExampleTracerLink findLinkByID(int id) {
        for (ExampleTracerLink link : this.getLinks()) {
            if (link.getID() != id) continue;
            return link;
        }
        return null;
    }

    @Override
    public void problemModelEventOccurred(ProblemModelEvent event) {
        this.handleProblemModelEvent(event);
    }

    public boolean handleProblemModelEvent(ProblemModelEvent event) {
        this.resetFlag = false;
        this.extendPathsFlag = false;
        this.handlePMEventRecursive(event);
        if (trace.getDebugCode("pmevt")) {
            trace.out("pmevt", "ETGraph.handlePMEvent(" + event + ") resetFlag " + this.resetFlag + ", extendPathsFlag " + this.extendPathsFlag + ", demonstrateMode " + this.exampleTracerTracer.isDemonstrateMode());
        }
        if (this.resetFlag) {
            this.exampleTracerTracer.resetTracer();
            this.redoLinkDepths();
        } else if (this.extendPathsFlag) {
            this.redoLinkDepths();
            if (this.exampleTracerTracer.isDemonstrateMode()) {
                this.exampleTracerTracer.extendPaths();
            } else {
                return (2 & event.getFlags()) != 0;
            }
        }
        return this.resetFlag;
    }

    private void handlePMEventRecursive(ProblemModelEvent event) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "problem model event: " + event);
        }
        if (event instanceof BRDLoadedEvent) {
            ArrayList<ProblemModelEvent> nodeCreatedEvents = new ArrayList<ProblemModelEvent>(event.collectTypeSubevents(NodeCreatedEvent.class, true, true, true));
            this.handleLoadedBRDNodes(nodeCreatedEvents);
            ArrayList<ProblemModelEvent> edgeCreatedEvents = new ArrayList<ProblemModelEvent>(event.collectTypeSubevents(EdgeCreatedEvent.class, true, true, true));
            this.handleLoadedBRDEdges(edgeCreatedEvents);
            this.redoLinkDepths();
            return;
        }
        if (event instanceof NodeCreatedEvent) {
            this.extendPathsFlag = true;
            this.handleNodeCreatedEvent((NodeCreatedEvent)event);
        }
        if (event instanceof NodeDeletedEvent) {
            boolean bl = this.resetFlag = this.handleNodeDeletedEvent((NodeDeletedEvent)event) || this.resetFlag;
        }
        if (event instanceof NewProblemEvent) {
            this.handleNewProblemEvent((NewProblemEvent)event);
        }
        if (event instanceof EdgeRewiredEvent) {
            EdgeRewiredEvent ere = (EdgeRewiredEvent)event;
            this.extendPathsFlag = true;
            this.resetFlag = true;
            this.handleEdgeDeletedEvent(ere.getEdgeDeletedEvent());
            this.handleEdgeCreatedEvent(ere.getEdgeCreatedEvent());
        }
        if (event instanceof EdgeCreatedEvent) {
            this.extendPathsFlag = true;
            this.handleEdgeCreatedEvent((EdgeCreatedEvent)event);
        }
        if (event instanceof EdgeUpdatedEvent) {
            this.handleEdgeUpdatedEvent((EdgeUpdatedEvent)event);
        }
        if (event instanceof EdgeDeletedEvent) {
            boolean bl = this.resetFlag = this.handleEdgeDeletedEvent((EdgeDeletedEvent)event) || this.resetFlag;
        }
        if (event.isCompoundEventP()) {
            for (ProblemModelEvent E : event.getSubevents()) {
                this.handlePMEventRecursive(E);
            }
        }
    }

    private void buildInLinks() {
        Iterator<ExampleTracerNode> it = this.nodes.iterator();
        while (it.hasNext()) {
            it.next().clearInLinks();
        }
        ExampleTracerNode startNode = this.getStartNode();
        if (startNode == null || startNode.getOutLinks() == null) {
            return;
        }
        Iterator<ExampleTracerLink> it2 = startNode.getOutLinks().iterator();
        while (it2.hasNext()) {
            this.updateInLinkSubGraph(it2.next());
        }
    }

    private void updateInLinkSubGraph(ExampleTracerLink link) {
        ExampleTracerNode dest = this.getNode(link.getNextNode());
        if (dest == null) {
            return;
        }
        dest.addInLink(link);
        Iterator<ExampleTracerLink> it = dest.getOutLinks().iterator();
        while (it.hasNext()) {
            this.updateInLinkSubGraph(it.next());
        }
    }

    private void removeLink(ExampleTracerLink link, boolean updateGroups) {
        if (updateGroups) {
            this.groupModel.removeLinkFromModel(link);
        } else {
            this.groupModel.removeLinkFromGroup(this.groupModel.getTopLevelGroup(), link);
        }
        this.doneLinks.remove(link);
        this.links.remove(link);
    }

    private void handleEdgeUpdatedEvent(EdgeUpdatedEvent event) {
        int linkID;
        ExampleTracerLink link;
        if (trace.getDebugCode("et")) {
            trace.out("et", "ExampleTracerGraph.handleEdgeUpdatedEvent(" + event + ")");
        }
        if ((link = this.getLink(linkID = event.getEdge().getUniqueID())) == null) {
            trace.err("ExampleTracerGraph.handleEdgeUpdatedEvent(" + event + ") link with ID " + linkID + " not found by getLink()");
        } else if (link.isDoneLink()) {
            this.doneLinks.add(link);
        } else {
            this.doneLinks.remove(link);
        }
    }

    private void handleEdgeCreatedEvent(EdgeCreatedEvent event) {
        int sourceID = event.getEdge().source.getUniqueID();
        int targetID = event.getEdge().dest.getUniqueID();
        LinkGroup groupToAddTo = event.getGroupToAddTo();
        if (groupToAddTo == null) {
            groupToAddTo = this.groupModel.getTopLevelGroup();
        }
        ExampleTracerLink link = new ExampleTracerLink(event.getEdge().getEdgeData(), sourceID, targetID);
        this.addLink(link, groupToAddTo);
        ExampleTracerNode source = this.getNode(sourceID);
        ExampleTracerNode dest = this.getNode(targetID);
        source.addOutLink(link);
        dest.addInLink(link);
    }

    private void handleLoadedBRDEdges(ArrayList<ProblemModelEvent> edgeCreatedEvents) {
        for (int i = 0; i < edgeCreatedEvents.size(); ++i) {
            ProblemEdge edge = ((EdgeCreatedEvent)edgeCreatedEvents.get(i)).getEdge();
            int sourceID = edge.source.getUniqueID();
            int targetID = edge.dest.getUniqueID();
            ExampleTracerLink link = new ExampleTracerLink(edge.getEdgeData(), sourceID, targetID);
            this.links.add(link);
            if (link.isDoneLink()) {
                this.doneLinks.add(link);
            } else {
                this.doneLinks.remove(link);
            }
            ExampleTracerNode source = this.getNode(sourceID);
            ExampleTracerNode dest = this.getNode(targetID);
            source.addOutLink(link);
            dest.addInLink(link);
        }
        this.groupModel.addLinksForLoadingBRD(this.links);
    }

    private boolean handleEdgeDeletedEvent(EdgeDeletedEvent event) {
        ExampleTracerNode dest;
        if (trace.getDebugCode("et")) {
            trace.outNT("et", "ExampleTracerGraph.handleSingleEdgeDeletedEvent(" + event + ")");
        }
        if (event.getEdge() == null) {
            return false;
        }
        EdgeData edgeData = event.getEdge().getEdgeData();
        if (edgeData == null) {
            return false;
        }
        int id = edgeData.getUniqueID();
        ExampleTracerLink link = this.findLinkByID(id);
        if (link == null) {
            return false;
        }
        this.removeLink(link, true);
        ExampleTracerNode source = this.getNode(link.getPrevNode());
        if (source != null) {
            ListIterator<ExampleTracerLink> it = source.getOutLinks().listIterator();
            while (it.hasNext()) {
                if (it.next() != link) continue;
                it.remove();
                break;
            }
        }
        if ((dest = this.getNode(link.getNextNode())) != null) {
            dest.getInLinks().remove(link);
        }
        return true;
    }

    private void handleNewProblemEvent(NewProblemEvent event) {
        boolean isOrdered = !event.isUnordered();
        this.initGraph(isOrdered, false);
    }

    private boolean handleNodeDeletedEvent(NodeDeletedEvent event) {
        return this.removeNode(event.getNode().getUniqueID());
    }

    private void handleLoadedBRDNodes(ArrayList<ProblemModelEvent> nodeCreatedEvents) {
        if (trace.getDebugCode("br")) {
            trace.out("br", "Loading the nodes of a BRD");
        }
        for (int i = 0; i < nodeCreatedEvents.size(); ++i) {
            ExampleTracerNode node = new ExampleTracerNode(((NodeCreatedEvent)nodeCreatedEvents.get(i)).getNode());
            this.addNode(node);
            if (!trace.getDebugCode("br")) continue;
            trace.out("br", "NodeID: " + node.getNodeID());
        }
        if (trace.getDebugCode("br")) {
            trace.out("br", "End Loading nodes of a BRD");
        }
    }

    private void handleNodeCreatedEvent(NodeCreatedEvent event) {
        ExampleTracerNode node = new ExampleTracerNode(event.getNode());
        this.addNode(node);
        if (trace.getDebugCode("br")) {
            trace.out("br", "NodeID: " + node.getNodeID());
        }
    }

    public ExampleTracerNode getStartNode() {
        return this.getNode(1);
    }

    public ExampleTracerLink getLink(ProblemEdge edge) {
        for (ExampleTracerLink link : this.links) {
            if (!link.getEdge().getEdge().equals(edge)) continue;
            return link;
        }
        return null;
    }

    public ExampleTracerLink getLink(int linkID) {
        for (ExampleTracerLink link : this.links) {
            if (link.getID() != linkID) continue;
            return link;
        }
        return null;
    }

    public ExampleTracerPath getBestSubpath(int fromNodeID, int toNodeID) {
        ExampleTracerNode fromNode = this.getNode(fromNodeID);
        ExampleTracerNode toNode = this.getNode(toNodeID);
        if (fromNode == null || toNode == null) {
            return null;
        }
        Set<ExampleTracerPath> pathsFromNode = this.findPathsFromNode(fromNode);
        HashSet<ExampleTracerPath> pathsFromNodeToNode = new HashSet<ExampleTracerPath>();
        for (ExampleTracerPath path : pathsFromNode) {
            ExampleTracerPath subpath = path.subpath(toNodeID);
            if (subpath == null) continue;
            pathsFromNodeToNode.add(subpath);
        }
        if (pathsFromNodeToNode.size() < 1) {
            return null;
        }
        return ExampleTracerPath.getBestPath(pathsFromNodeToNode);
    }

    public boolean pathToLinkIsSubset(ExampleTracerLink link, Set<ExampleTracerLink> links) {
        ExampleTracerNode linkSource = this.getNode(link.getPrevNode());
        if (trace.getDebugCode("feedback")) {
            trace.out("feedback", "pathToLinkIsSubset(" + link + ") sourceNode " + linkSource.getNodeID());
        }
        if (link.isRequired() && !links.contains(link)) {
            return false;
        }
        if (linkSource.isStartNode(true) || linkSource.isBeforeStartState()) {
            return true;
        }
        Iterator<ExampleTracerLink> iterator = linkSource.getInLinks().iterator();
        if (iterator.hasNext()) {
            ExampleTracerLink prevLink = iterator.next();
            return this.pathToLinkIsSubset(prevLink, links);
        }
        return false;
    }

    public Set<ExampleTracerLink> getDoneLinks() {
        return this.doneLinks;
    }

    public Set<Integer> getDoneStates() {
        HashSet<Integer> nodeIDs = new HashSet<Integer>();
        if (this.doneLinks != null) {
            for (ExampleTracerLink link : this.doneLinks) {
                nodeIDs.add(link.getNextNode());
            }
        }
        return nodeIDs;
    }

    public ExampleTracerPath getBestSubpath(ExampleTracerNode fromNode, Integer toNodeID, ArrayList<ExampleTracerLink> viaLinks) {
        if (fromNode == null || toNodeID == null) {
            return null;
        }
        Set<ExampleTracerPath> pathsFromNode = this.findPathsFromNode(fromNode);
        HashSet<ExampleTracerPath> pathsFromNodeToNode = new HashSet<ExampleTracerPath>();
        for (ExampleTracerPath path : pathsFromNode) {
            ExampleTracerPath spath = path.subpath(toNodeID);
            if (spath == null || viaLinks != null && !spath.containsAll(viaLinks)) continue;
            pathsFromNodeToNode.add(spath);
        }
        if (trace.getDebugCode("requiredSteps")) {
            trace.out("requiredSteps", "ExampleTracerGraph.getBestSubpath(" + fromNode + ", " + toNodeID + ", [" + (viaLinks != null ? viaLinks.size() : -1) + "]) pathsFrom " + pathsFromNode.size() + ", pathsFromTo " + pathsFromNodeToNode.size());
        }
        if (pathsFromNodeToNode.size() < 1) {
            return null;
        }
        return ExampleTracerPath.getBestPath(pathsFromNodeToNode);
    }

    class LinkGroupSizeComparator
    implements Comparator<LinkGroup> {
        LinkGroupSizeComparator() {
        }

        @Override
        public int compare(LinkGroup arg0, LinkGroup arg1) {
            return ExampleTracerGraph.this.groupModel.getGroupLinkCount(arg1) - ExampleTracerGraph.this.groupModel.getGroupLinkCount(arg0);
        }
    }
}

