/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.oli.log.client;

import edu.cmu.oli.log.client.ActionLog;
import edu.cmu.oli.log.client.DiskLogger;
import edu.cmu.oli.log.client.Log;
import edu.cmu.oli.log.client.SessionLog;
import edu.cmu.oli.log.client.StreamLogger;
import edu.cmu.pact.Utilities.trace;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.xml.sax.SAXException;

public class AsyncStreamLogger
extends StreamLogger
implements Runnable {
    private LinkedList queue = null;
    private DiskLogger diskLogger = null;
    private String diskLoggerFile = null;
    private static final String FILE_PREFIX = "tutorlog_";
    private static final String FILE_SUFFIX = ".xml";
    private Set listeners = Collections.synchronizedSet(new HashSet());

    public AsyncStreamLogger(Listener listener) {
        this.queue = new LinkedList();
        Thread thread = new Thread(this);
        thread.start();
    }

    @Override
    public void run() {
        Log msg = null;
        while (null != (msg = this.dequeue())) {
            Boolean result = new Boolean(false);
            System.out.println("" + Thread.currentThread().getName() + " dequeued:\n" + msg + "\n");
            if (msg instanceof ActionLog) {
                result = this.logActionLog((ActionLog)msg);
            } else if (msg instanceof SessionLog) {
                result = this.logSessionLog((SessionLog)msg);
            } else {
                System.err.println(this.getClass().getName() + "run(): Unsupported Log class " + msg.getClass());
            }
            if (!result.booleanValue()) {
                this.logToDisk(msg);
                continue;
            }
            this.sendQueuedMessages();
        }
    }

    private Boolean logToDisk(Log msg) {
        Boolean result = new Boolean(false);
        if (this.diskLoggerFile == null) {
            trace.printStack("log", "start logging");
            this.diskLoggerFile = FILE_PREFIX + String.valueOf(System.currentTimeMillis()) + FILE_SUFFIX;
            this.diskLogger = new DiskLogger();
            this.diskLogger.setOutfile(this.diskLoggerFile);
        }
        if (msg instanceof ActionLog) {
            result = this.diskLogger.logActionLog((ActionLog)msg);
        } else if (msg instanceof SessionLog) {
            try {
                result = this.diskLogger.logSessionLog((SessionLog)msg);
            }
            catch (SAXException se) {
                System.err.println("Error logging to disk:\n\"" + msg + "\"");
                se.printStackTrace();
            }
            catch (UnsupportedEncodingException uee) {
                System.err.println("Error logging to disk:\n\"" + msg + "\"");
                uee.printStackTrace();
            }
        } else {
            System.err.println(this.getClass().getName() + "logToDisk(): Unsupported Log class " + msg.getClass());
        }
        return result;
    }

    private int sendQueuedMessages() {
        int result = 0;
        if (this.diskLoggerFile == null) {
            return result;
        }
        return result;
    }

    private synchronized Log dequeue() {
        while (this.queue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        return (Log)this.queue.removeFirst();
    }

    private synchronized int enqueue(Log msg) {
        this.queue.addLast(msg);
        int result = this.queue.size();
        this.notifyAll();
        return result;
    }

    public Boolean logSessionLog(SessionLog msg) {
        this.enqueue((Log)msg);
        return new Boolean(true);
    }

    public Boolean logActionLog(ActionLog msg) {
        this.enqueue((Log)msg);
        return new Boolean(true);
    }

    public synchronized void removeListener(Listener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public static interface Listener {
        public void notifyError(String var1);
    }
}

