/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.utilities;

import edu.cmu.pact.Utilities.trace;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpToolEmulator {
    public static final String DEFAULT_URL = "http://localhost:8888/sendToTutor";
    private final String url;

    public HttpToolEmulator() {
        this(DEFAULT_URL);
    }

    public HttpToolEmulator(String url) {
        this.url = url == null ? DEFAULT_URL : url;
    }

    public static void main(String[] args) {
        String url = DEFAULT_URL;
        int i = 0;
        try {
            block7: for (i = 0; i < args.length && '-' == args[i].charAt(0); ++i) {
                char c = args[i].charAt(1);
                switch (Character.toLowerCase(c)) {
                    case 'u': {
                        url = args[++i];
                        continue block7;
                    }
                    default: {
                        throw new IllegalArgumentException("Command-line option '-" + c + "' undefined");
                    }
                }
            }
        }
        catch (Exception e) {
            HttpToolEmulator.usageExit("Error processing argument[" + i + "]", e);
        }
        HttpToolEmulator hte = new HttpToolEmulator(url);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            String line = null;
            try {
                line = br.readLine();
                if (line == null) {
                    return;
                }
                String reply = hte.sendAndWait(line);
                System.out.printf("Response, length %d:\n%s\n", reply == null ? -1 : reply.length(), reply);
                continue;
            }
            catch (Exception e) {
                System.err.printf("Error %s (cause %s) on this line:\n  %s\n", e, e.getCause(), line);
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public String sendAndWait(String msg) throws Exception {
        if (trace.getDebugCode("http")) {
            trace.out("http", "send " + msg);
        }
        URL addr = new URL(new URL("http://"), this.url);
        HttpURLConnection conn = (HttpURLConnection)addr.openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.getOutputStream().write(msg.getBytes("UTF-8"));
        conn.getOutputStream().close();
        conn.connect();
        if (conn.getResponseCode() != 200) {
            throw new Exception("Error from HTTP : response code " + conn.getResponseCode() + " \"" + conn.getResponseMessage() + "\" after this line:\n  " + msg);
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        try (BufferedReader reader = null;){
            String thisLine;
            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            ++i;
            while ((thisLine = reader.readLine()) != null) {
                sb.append(thisLine).append('\n');
                ++i;
            }
            if (trace.getDebugCode("http")) {
                trace.out("http", "recv " + sb);
            }
            String string = sb.toString();
            return string;
        }
    }

    private static void usageExit(String errMsg, Throwable e) {
        if (e != null) {
            e.printStackTrace(System.err);
        }
        Object[] objectArray = new Object[4];
        Object object = objectArray[0] = errMsg == null ? "" : errMsg;
        objectArray[1] = errMsg == null ? "" : (e == null ? ". " : ": " + e + ".");
        objectArray[2] = HttpToolEmulator.class.getName();
        objectArray[3] = DEFAULT_URL;
        System.err.printf("\n%s%sUsage:\n    java -cp ... %s [-u url]\nwhere--\n    url is the tutor engine address; default %s.\n", objectArray);
        System.exit(2);
    }
}

