/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat.wizard;

import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.env.CTATFileEntry;
import edu.cmu.hcii.ctat.wizard.CTATLMSConfiguration;
import edu.cmu.hcii.ctat.wizard.CTATPackageGeneratorBase;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class CTATOLIPackageGenerator
extends CTATPackageGeneratorBase {
    private CTATLMSConfiguration LMSConfiguration = null;

    public CTATOLIPackageGenerator(CTATLMSConfiguration aConfiguration) {
        super(aConfiguration);
        this.setClassName("CTATOLIPackageGenerator");
        this.debug("CTATOLIPackageGenerator ()");
        this.LMSConfiguration = aConfiguration;
    }

    @Override
    public CTATLMSConfiguration getLMSConfiguration() {
        return this.LMSConfiguration;
    }

    @Override
    public void setLMSConfiguration(CTATLMSConfiguration lMSConfiguration) {
        this.LMSConfiguration = lMSConfiguration;
    }

    @Override
    public Boolean generatePackage(File outputZip) {
        File copyTarget;
        File copySource;
        int i;
        String packageStripped = outputZip.getName().replaceFirst("[.][^.]+$", "");
        String packageNameFull = outputZip.getName().replaceFirst("[.][^.]+$", "").replaceAll(" ", "_").toLowerCase();
        String packageName = packageNameFull.toLowerCase();
        String packageClass = packageNameFull.toLowerCase() + "_class";
        this.LMSConfiguration.setName(packageNameFull);
        String[] HTMLFiles = this.LMSConfiguration.getInterfaceFiles();
        String[] BRDs = this.LMSConfiguration.getBrdFiles();
        File renamer = null;
        this.debug("generatePackage (" + packageName + ")");
        String outputPath = outputZip.getParent();
        this.debug("Generating OLI content package in: " + outputPath + " ...");
        File outPath = new File(outputPath);
        if (!outPath.exists()) {
            outPath.mkdir();
        }
        File pathTestTarget = new File(outputPath + File.separator + packageNameFull + File.separator);
        this.debug("Checking path: " + pathTestTarget.getAbsolutePath());
        if (!pathTestTarget.exists()) {
            this.debug("Path does not exist, creating: " + pathTestTarget.getAbsolutePath());
            pathTestTarget.mkdir();
        } else {
            this.debug("Path already exists: " + pathTestTarget.getAbsolutePath());
        }
        pathTestTarget = new File(outputPath + File.separator + packageNameFull + File.separator + "content");
        this.debug("Checking path: " + pathTestTarget.getAbsolutePath());
        if (!pathTestTarget.exists()) {
            this.debug("Path does not exist, creating: " + pathTestTarget.getAbsolutePath());
            pathTestTarget.mkdir();
        } else {
            this.debug("Path already exists: " + pathTestTarget.getAbsolutePath());
        }
        this.debug("Checking path: " + pathTestTarget.getAbsolutePath());
        pathTestTarget = new File(outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + "webcontent");
        if (!pathTestTarget.exists()) {
            this.debug("Path does not exist, creating: " + pathTestTarget.getAbsolutePath());
            pathTestTarget.mkdir();
        } else {
            this.debug("Path already exists: " + pathTestTarget.getAbsolutePath());
        }
        try {
            this.unZipIt("Templates/PackagingWizard/OLI/OLICTATTemplate.zip", outputPath + "/" + packageNameFull + "/");
        }
        catch (IOException e) {
            this.debug("Error unzipping template archive!");
            e.printStackTrace();
        }
        this.debug("Processing: " + outputPath + File.separator + packageNameFull + File.separator + "organizations" + File.separator + "default" + File.separator + "organization.xml");
        String orgFormatted = CTATLink.fManager.getContents(outputPath + File.separator + packageNameFull + File.separator + "organizations" + File.separator + "default" + File.separator + "organization.xml");
        orgFormatted = orgFormatted.replaceAll("<PACKAGENAME>", packageStripped);
        orgFormatted = orgFormatted.replaceAll("<PACKAGENAMEFULL>", packageNameFull);
        orgFormatted = orgFormatted.replaceAll("<DESCRIPTION>", this.LMSConfiguration.getDescription());
        orgFormatted = orgFormatted.replaceAll("<PACKAGECLASS>", packageClass);
        CTATLink.fManager.setContents(outputPath + File.separator + packageNameFull + File.separator + "organizations" + File.separator + "default" + File.separator + "organization.xml", orgFormatted);
        this.debug("Processing: " + outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + "x-oli-workbook_page" + File.separator + "welcome.xml");
        String workbookFormatted = CTATLink.fManager.getContents(outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + "x-oli-workbook_page" + File.separator + "welcome.xml");
        workbookFormatted = workbookFormatted.replaceAll("<PACKAGENAME>", packageName + "_page");
        workbookFormatted = workbookFormatted.replaceAll("<PACKAGENAMEFULL>", packageNameFull);
        workbookFormatted = workbookFormatted.replaceAll("<DESCRIPTION>", this.LMSConfiguration.getDescription());
        workbookFormatted = workbookFormatted.replaceAll("<PACKAGECLASS>", packageClass);
        CTATLink.fManager.setContents(outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + "x-oli-workbook_page" + File.separator + "welcome.xml", workbookFormatted);
        renamer = new File(outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + "x-oli-workbook_page" + File.separator + "welcome.xml");
        if (!renamer.exists()) {
            this.debug("Error, template file (" + renamer.getAbsolutePath() + ") does not exist");
            return false;
        }
        this.debug("Renaming to: " + outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + "x-oli-workbook_page" + File.separator + packageName + "_page.xml");
        File tTarget = new File(outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + "x-oli-workbook_page" + File.separator + packageName + "_page.xml");
        if (!renamer.renameTo(tTarget)) {
            this.debug("Error: can't rename file to: " + tTarget.getAbsolutePath());
            return false;
        }
        this.debug("Processing: " + outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + File.separator + "x-cmu-ctat-tutor2" + File.separator + "ctat2_template.xml");
        renamer = new File(outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + File.separator + "x-cmu-ctat-tutor2" + File.separator + "ctat2_template.xml");
        if (!renamer.exists()) {
            this.debug("Error, template file (" + renamer.getAbsolutePath() + ") does not exist");
            return false;
        }
        this.debug("Renaming to: " + outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + File.separator + "x-cmu-ctat-tutor2" + File.separator + packageClass + ".xml");
        tTarget = new File(outputPath + File.separator + packageNameFull + File.separator + "content" + File.separator + File.separator + "x-cmu-ctat-tutor2" + File.separator + packageClass + ".xml");
        if (!renamer.renameTo(tTarget)) {
            this.debug("Error: can't rename file to: " + tTarget.getAbsolutePath());
            return false;
        }
        this.debug("Using contents of: " + tTarget.getAbsolutePath());
        String templateFormatted = CTATLink.fManager.getContents(tTarget.getAbsolutePath());
        File tempInterfaceLocation = new File(this.LMSConfiguration.getSwfLocationString());
        File tempBRDLocation = new File(this.LMSConfiguration.getBrdLocationString());
        templateFormatted = templateFormatted.replaceAll("<PACKAGENAME>", packageStripped);
        templateFormatted = templateFormatted.replaceAll("<PACKAGENAMEFULL>", packageNameFull);
        templateFormatted = templateFormatted.replaceAll("<DESCRIPTION>", this.LMSConfiguration.getDescription());
        templateFormatted = templateFormatted.replaceAll("<PACKAGECLASS>", packageClass);
        templateFormatted = templateFormatted.replaceAll("<BRD>", "webcontent/" + tempBRDLocation.getName());
        templateFormatted = templateFormatted.replaceAll("<INTERFACE>", "webcontent/" + tempInterfaceLocation.getName());
        CTATLink.fManager.setContents(tTarget.getAbsolutePath(), templateFormatted);
        this.debug("Copying BRDs ...");
        for (i = 0; i < BRDs.length; ++i) {
            String aBRDFile = BRDs[i];
            this.debug("Placing BRD file: " + aBRDFile + " ...");
            copySource = new File(aBRDFile);
            copyTarget = new File(outputPath + "/" + packageNameFull + "/content/webcontent/" + copySource.getName());
            try {
                CTATLink.fManager.copy(copySource, copyTarget);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (i != 0) continue;
            templateFormatted = templateFormatted.replaceAll("<BRD>", packageNameFull + "/content/webcontent/" + copySource.getName());
        }
        this.debug("Copying Interfaces ...");
        for (i = 0; i < HTMLFiles.length; ++i) {
            String aHTMLFile = HTMLFiles[i];
            this.debug("Placing HTML file: " + aHTMLFile + " ...");
            copySource = new File(aHTMLFile);
            copyTarget = new File(outputPath + "/" + packageNameFull + "/content/webcontent/" + copySource.getName());
            try {
                CTATLink.fManager.copy(copySource, copyTarget);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (i != 0) continue;
            templateFormatted = templateFormatted.replaceAll("<INTERFACE>", packageNameFull + "/content/webcontent/" + copySource.getName());
        }
        this.debug("Using contents of: " + tTarget.getAbsolutePath());
        String packageFormatted = CTATLink.fManager.getContents(outputPath + "/" + packageNameFull + "/content/package.xml");
        packageFormatted = packageFormatted.replaceAll("<PACKAGENAME>", packageClass);
        packageFormatted = packageFormatted.replaceAll("<PACKAGENAMEFULL>", packageNameFull);
        packageFormatted = packageFormatted.replaceAll("<DESCRIPTION>", this.LMSConfiguration.getDescription());
        packageFormatted = packageFormatted.replaceAll("<PACKAGECLASS>", packageClass);
        packageFormatted = packageFormatted.replaceAll("<BRD>", "webcontent/" + tempBRDLocation.getName());
        packageFormatted = packageFormatted.replaceAll("<INTERFACE>", "webcontent/" + tempInterfaceLocation.getName());
        CTATLink.fManager.setContents(outputPath + "/" + packageNameFull + "/content/package.xml", packageFormatted);
        this.debug("Prepping assets (" + this.LMSConfiguration.getAssetValues().size() + ") ...");
        for (int i2 = 0; i2 < this.LMSConfiguration.getAssetValues().size(); ++i2) {
            copySource = this.LMSConfiguration.getAssetValues().get(i2);
            if (copySource.isDirectory()) {
                this.debug("Warning: file entry " + copySource.getName() + " is a directory and needs to be created first");
            }
            this.addFileEntry(copySource, this.LMSConfiguration.getAssetBasePath());
        }
        ArrayList<CTATFileEntry> tempList = this.LMSConfiguration.getFileList();
        this.debug("Copying assets (" + tempList.size() + ") ...");
        for (int j = 0; j < tempList.size(); ++j) {
            CTATFileEntry entry = tempList.get(j);
            this.debug("basePath: " + entry.basePath);
            this.debug("relativePath: " + entry.relativePath);
            this.debug("filePath: " + entry.filePath);
            this.debug("fullPath: " + entry.fullPath);
            File copySource2 = new File(entry.basePath + File.separator + entry.filePath);
            File testTarget = new File(outputPath + "/" + packageNameFull + "/content/webcontent/" + entry.relativePath + File.separator);
            File copyTarget2 = new File(outputPath + "/" + packageNameFull + "/content/webcontent/" + entry.relativePath + File.separator + entry.filePath);
            this.debug("Checking path: " + testTarget.getAbsolutePath());
            if (!testTarget.exists()) {
                this.debug("Path does not exist, creating: " + testTarget.getAbsolutePath());
                testTarget.mkdir();
            }
            try {
                CTATLink.fManager.copy(copySource2, copyTarget2);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.internalList = new ArrayList();
        this.listFilesAndFilesSubDirectories(outputPath + "/" + packageNameFull + "/");
        this.LMSConfiguration.reset();
        this.debug("Creating zip file with root path: " + outputPath + "/" + packageNameFull + "/");
        String subtractor = outputPath + "/" + packageNameFull + "/";
        for (int k = 0; k < this.internalList.size(); ++k) {
            File toZip = (File)this.internalList.get(k);
            this.debug("Adding to zip: " + toZip.getAbsolutePath() + " -> " + toZip.getAbsolutePath().substring(subtractor.length()));
            CTATFileEntry anEntry = this.addFileEntryAsIs(toZip, outputPath + "/" + packageNameFull + "/");
            String tempPath = toZip.getAbsolutePath().substring(subtractor.length());
            anEntry.setIsSystemEntry(true);
            anEntry.relativePath = tempPath.substring(0, tempPath.length() - toZip.getName().length());
            this.debug("Set relative path to: " + anEntry.relativePath);
        }
        this.zipIt(outputZip.getAbsolutePath());
        return true;
    }
}

