/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.hcii.ctat;

import edu.cmu.hcii.ctat.CTATBase;
import edu.cmu.hcii.ctat.CTATContentCache;
import edu.cmu.hcii.ctat.CTATHTTPExchange;
import edu.cmu.hcii.ctat.CTATHTTPHandlerInterface;
import edu.cmu.hcii.ctat.CTATLink;
import edu.cmu.hcii.ctat.CTATWebTools;
import edu.cmu.pact.MessageSource;
import edu.cmu.pact.Utilities.trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public abstract class CTATHTTPHandlerBase
extends CTATBase
implements CTATHTTPHandlerInterface {
    private boolean logging = false;
    private FileOutputStream logFile = null;
    private String logFileName;
    private MessageSource goToStateMessageSource = null;
    private FileOutputStream logTutorFile;
    private static boolean oldJavaVersion = false;
    private boolean outputJSON = false;

    @Override
    public void debug(String s) {
        if (trace.getDebugCode("http")) {
            trace.out("http", this.getClass().getSimpleName() + ": " + s);
        } else {
            super.debug(s);
        }
    }

    public CTATHTTPHandlerBase(String aFileName) {
        this.setClassName("CTATHTTPHandlerBase");
        this.debug("CTATHTTPHandlerBase (" + aFileName + ")");
        String version = System.getProperty("java.version");
        if (version == null) {
            oldJavaVersion = true;
        } else {
            String[] split = version.split("\\.");
            try {
                oldJavaVersion = split[0].equals("1") && Integer.valueOf(split[1]) < 6;
            }
            catch (IndexOutOfBoundsException e) {
                oldJavaVersion = true;
            }
        }
        if (aFileName != "" && CTATLink.allowWriting) {
            this.logFileName = aFileName;
            File pleaseWork = new File(this.logFileName);
            if (pleaseWork.getParentFile() != null && !pleaseWork.getParentFile().exists()) {
                pleaseWork.getParentFile().mkdirs();
            }
            try {
                pleaseWork.createNewFile();
                if (!oldJavaVersion) {
                    pleaseWork.setReadable(true);
                    pleaseWork.setWritable(true);
                }
                this.logFile = new FileOutputStream(pleaseWork, true);
                this.logging = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.logging = false;
            }
        } else {
            this.logging = false;
        }
        if (CTATLink.allowWriting) {
            String filename = CTATLink.datashopFile;
            if (filename == null || filename.trim().length() < 1) {
                filename = CTATLink.logdir + "datashop.log";
            }
            File sessionLog = new File(filename);
            try {
                sessionLog.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!oldJavaVersion) {
                sessionLog.setReadable(true);
                sessionLog.setWritable(true);
            }
            try {
                this.logTutorFile = new FileOutputStream(sessionLog, true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private String removeQueryString(String aString) {
        if (aString.indexOf("?") != -1) {
            return aString.substring(0, aString.indexOf("?"));
        }
        return aString;
    }

    protected Boolean getLogging() {
        return this.logging;
    }

    protected String getLogFile() {
        return this.logFileName;
    }

    public synchronized boolean writeToLog(String logXMLString) {
        this.debug("writeToLog ()");
        if (!this.logging) {
            return false;
        }
        String finalLogStream = logXMLString + "\n";
        try {
            for (int i = 0; i < finalLogStream.length(); ++i) {
                this.logTutorFile.write((byte)finalLogStream.charAt(i));
            }
            this.logTutorFile.flush();
        }
        catch (IOException e) {
            this.debug("IOexception trying to write to datashop logFile: " + this.logFileName);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public synchronized boolean writeToAccessLog(String aURI) {
        this.debug("writeToAccessLog ()");
        if (!this.logging) {
            return false;
        }
        StringBuffer formatted = new StringBuffer();
        formatted.append("[");
        formatted.append(this.getCurrentDate());
        formatted.append("] 127.0.0.1 ");
        formatted.append(aURI);
        formatted.append("\n");
        String converter = formatted.toString();
        try {
            for (int i = 0; i < converter.length(); ++i) {
                this.logFile.write((byte)converter.charAt(i));
            }
            this.logFile.flush();
        }
        catch (IOException e) {
            this.debug("IOexception trying to write to logFile: " + this.logFileName);
            e.printStackTrace();
            return false;
        }
        return true;
    }

    protected synchronized boolean handleViaRemoteServer(CTATHTTPExchange exchange, String fileURI, boolean addToCache) {
        this.debug("handleViaRemoteServer ()");
        return true;
    }

    protected boolean sendLocalFile(String preFileURI, String prePathToRoot, CTATHTTPExchange arg0) {
        long contentLength;
        this.debug("sendLocalFile (" + preFileURI + ", " + prePathToRoot + ")");
        InetAddress iAddr = arg0.getSocket().getInetAddress();
        if (trace.getDebugCode("http")) {
            trace.out("http", "CTATHTTPHandlerBase.sendLocalFile() root " + prePathToRoot + ", remote HostAddress() " + iAddr.getHostAddress() + ", .isLoopbackAddress() " + iAddr.isLoopbackAddress() + ", .isLinkLocalAddress() " + iAddr.isLinkLocalAddress());
        }
        if (!iAddr.isLoopbackAddress()) {
            trace.err("CTATHTTPServer.run() unauthorized access; sending HTTP 403 to host " + iAddr.getHostAddress());
            CTATHTTPHandlerBase.sendResponse(arg0, "Forbidden", 403);
            return true;
        }
        String fileURI = null;
        try {
            fileURI = URLDecoder.decode(preFileURI, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (fileURI == null) {
            fileURI = preFileURI;
        }
        String pathToRoot = null;
        try {
            pathToRoot = URLDecoder.decode(prePathToRoot, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        if (pathToRoot == null) {
            pathToRoot = prePathToRoot;
        }
        if (CTATLink.cache == null) {
            this.debug("No static cache object available yet, creating ...");
            CTATLink.cache = new CTATContentCache();
        }
        if (fileURI.contains(pathToRoot)) {
            fileURI = "/" + fileURI.substring(fileURI.indexOf(pathToRoot) + pathToRoot.length());
            this.debug("new fileURI: " + fileURI);
        }
        try {
            fileURI = URLDecoder.decode(fileURI, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            // empty catch block
        }
        if (fileURI.equalsIgnoreCase("/admin.html") && !CTATLink.adminLogin) {
            CTATLink.lastError = "403 - forbidden";
            arg0.sendResponseHeaders(403, 0L);
            return true;
        }
        String concat2 = pathToRoot + fileURI.substring(1);
        String cleaned = concat2.replace('\'', '/');
        String removed = this.removeQueryString(cleaned);
        this.debug("Trying to open: " + removed);
        BufferedInputStream bis = null;
        String[] lastModified = new String[1];
        try {
            if (removed.endsWith(".brd") && CTATLink.BRDsAreEncrypted) {
                String decrypted = CTATLink.fManager.getContentsEncrypted(removed);
                if (decrypted == null) {
                    throw new IOException();
                }
                bis = new BufferedInputStream(new ByteArrayInputStream(decrypted.getBytes("UTF-8")));
                contentLength = decrypted.getBytes("UTF-8").length;
            } else {
                CTATContentCache.Status cs = this.send304IfNotModified(fileURI, arg0);
                byte[] contentBytes = null;
                if (cs != CTATContentCache.Status.CACHE_INVALID) {
                    if (CTATContentCache.Status.NOT_MODIFIED.equals((Object)cs)) {
                        this.debug("return 304 Not Modified if caller's date recent enough");
                        CTATLink.lastError = "304 - Not Modified if caller's date recent enough";
                        return true;
                    }
                    if (CTATContentCache.Status.READ_FROM_CACHE.equals((Object)cs)) {
                        this.debug("We have the file in the cache, retrieving ...");
                        contentBytes = CTATLink.cache.getBytesFromCache(fileURI, lastModified, true);
                    } else {
                        this.debug("Requested file does not exist in the cache!");
                    }
                }
                if (contentBytes != null) {
                    this.debug("Content successfully retrieved from cache; last-modified " + lastModified[0] + " with size: " + contentBytes.length);
                    contentLength = contentBytes.length;
                    bis = new BufferedInputStream(new ByteArrayInputStream(contentBytes));
                } else {
                    this.debug("File was not found in the cache, attempting to load directly from disk ...");
                    File requestedFile = new File(removed);
                    if (!requestedFile.exists()) {
                        String withoutUID = CTATContentCache.stripOutUID(removed);
                        requestedFile = new File(withoutUID);
                        if (!requestedFile.exists()) {
                            throw new IOException();
                        }
                        this.debug("File " + withoutUID + " exists, sending to browser ...");
                    } else {
                        this.debug("File " + removed + " exists, sending to browser ...");
                    }
                    bis = new BufferedInputStream(new FileInputStream(requestedFile));
                    contentLength = requestedFile.length();
                    this.debug("Opened requested file successfully");
                }
            }
        }
        catch (IOException e) {
            boolean success;
            e.printStackTrace(System.out);
            this.debug("Exception: " + e + ", msg " + e.getMessage() + ", cause " + e.getCause());
            if (CTATLink.remoteHost.equals("") || CTATLink.remoteHost.equals("local")) {
                this.debug("The file still wasn't found, and there is no remote server. Sending 404...");
                CTATLink.lastError = "The file still wasn't found, and there is no remote server";
                arg0.send404(CTATLink.lastError);
                return true;
            }
            this.debug("The file still wasn't found, try connecting to the remote server ...");
            String URIpath = arg0.getRequestURI().getRawPath();
            boolean addToCache = true;
            if (URIpath.length() < 5 || !URIpath.substring(URIpath.length() - 5).contains(".")) {
                addToCache = false;
            }
            if (fileURI.contains("timestamp")) {
                addToCache = false;
            }
            if (success = this.handleViaRemoteServer(arg0, fileURI, addToCache)) {
                this.debug("GET request was satisfied via the remote server.");
            } else {
                CTATLink.lastError = "Error when attempting to satisfy GET request via remote server.";
                this.debug(CTATLink.lastError);
                arg0.sendResponseHeaders(500, 0L);
            }
            return true;
        }
        this.debug("Sending a response ...");
        Date now = new Date();
        Calendar expires = Calendar.getInstance();
        expires.add(10, 12);
        arg0.addResponseHeader("Date", CTATWebTools.headerDateFmt.format(now));
        arg0.addResponseHeader("Expires", CTATWebTools.headerDateFmt.format(expires.getTime()));
        if (lastModified[0] != null) {
            arg0.addResponseHeader("Last-Modified", lastModified[0]);
        }
        arg0.addMimeType();
        arg0.sendResponseHeaders(200, contentLength);
        this.debug("Obtaining buffered output stream for socket to start writing ...");
        BufferedOutputStream buf = arg0.getOutputStream();
        int count = 0;
        try {
            int res;
            while ((res = bis.read()) != -1) {
                buf.write(res);
                ++count;
            }
        }
        catch (IOException e) {
            this.debug("IO error writing bytes, at " + count + " bytes");
            e.printStackTrace();
            return false;
        }
        this.debug("Wrote " + count + " bytes");
        this.debug("Flushing socket ...");
        try {
            buf.flush();
        }
        catch (IOException e) {
            this.debug("Error flushing output buffer");
            e.printStackTrace();
            return false;
        }
        this.debug("Wrote back the entire file succesfully.");
        try {
            bis.close();
        }
        catch (IOException e) {
            this.debug("Error: unable to close bis");
            e.printStackTrace();
        }
        this.writeToAccessLog("<root>");
        return true;
    }

    protected CTATContentCache.Status send304IfNotModified(String fileURI, CTATHTTPExchange arg0) {
        this.debug("send304IfNotModified ()");
        String ifModifiedSince = arg0.getRequestHeaderConcatenated("If-Modified-Since");
        CTATContentCache.Status result = CTATLink.cache.isFileUpToDate(fileURI, ifModifiedSince, true);
        if (result == CTATContentCache.Status.NOT_MODIFIED) {
            arg0.addResponseHeader("Connection", "Close");
            CTATHTTPHandlerBase.sendResponse(arg0, "", 304);
        }
        return result;
    }

    public static void sendResponse(CTATHTTPExchange arg0, String responseBody, int statusCode) {
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", "CTATHTTPHandlerBase.sendResponse (\"" + responseBody + "\")");
        }
        if (arg0.isWS()) {
            arg0.WSSend(responseBody, statusCode);
            return;
        }
        arg0.setResponseHeader("Access-Control-Allow-Origin", "*");
        arg0.sendResponseHeaders(statusCode, responseBody.length());
        arg0.writeBytesString(responseBody, false);
        arg0.close();
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", "CTATHTTPHandlerBase.sendResponse() POST response written to client.");
        }
    }

    protected void sendHTMLResponse(CTATHTTPExchange arg0, String responseBody, int statusCode) {
        this.debug("sendHTMLResponse ()");
        arg0.addResponseHeader("Content-Type", "text/html");
        CTATHTTPHandlerBase.sendResponse(arg0, responseBody, statusCode);
    }

    protected boolean sendString(CTATHTTPExchange exchange, String message) {
        this.debug("sendString ()");
        boolean success = true;
        if (message == null) {
            message = "";
        }
        byte[] bytes = message.getBytes(Charset.forName("UTF-8"));
        exchange.sendResponseHeaders(200, bytes.length);
        exchange.writeBytes(bytes);
        exchange.close();
        return success;
    }

    protected boolean redirectTo(CTATHTTPExchange exchange, String path) {
        this.debug("redirectTo (" + path + ")");
        String fullPath = "http://" + CTATLink.hostName + ":" + CTATLink.wwwPort + path;
        exchange.addResponseHeader("Location", fullPath);
        exchange.sendResponseHeaders(302, 0L);
        return true;
    }

    public int getPOSTContentSize(CTATHTTPExchange arg0) {
        this.debug("getPOSTContent ()");
        List<String> contentLength = arg0.getRequestHeaders().get("Content-Length");
        if (contentLength != null) {
            int bodySize = Integer.parseInt(contentLength.get(0));
            return bodySize;
        }
        return 0;
    }

    public InputStream getPOSTContentRaw(CTATHTTPExchange arg0) {
        this.debug("getPOSTContentRaw ()");
        InputStream inStream = arg0.getRequestBody();
        return inStream;
    }

    public String getPOSTContent(CTATHTTPExchange arg0) {
        this.debug("getPOSTContent ()");
        String logMessage = "";
        try {
            logMessage = arg0.getRequestBodyAsString();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        return logMessage;
    }

    public void setOutputJSON(boolean b) {
        if (trace.getDebugCode("ll")) {
            trace.outNT("ll", trace.nh(this) + " .setOutputJSON() old " + this.outputJSON + ", new " + b);
        }
        this.outputJSON = b;
    }

    @Override
    public boolean getOutputJSON() {
        return this.outputJSON;
    }

    protected String retrieveGoToStateMessages() {
        return this.goToStateMessageSource != null ? this.goToStateMessageSource.getGoToStateMessages() : "";
    }

    public MessageSource getGoToStateMessageSource() {
        return this.goToStateMessageSource;
    }

    public void setGoToStateMessageSource(MessageSource goToStateMessageSource) {
        this.goToStateMessageSource = goToStateMessageSource;
    }

    @Override
    public abstract boolean handle(CTATHTTPExchange var1, String var2);
}

